/*
 * Decompiled with CFR 0.152.
 */
package com.misc;

import com.Audio.Sound;
import com.Gameplay.Map.Room;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshImage;
import com.Rendering.Meshes.Morphing;
import com.Rendering.MultyTexture;
import com.Rendering.RawImage;
import com.Rendering.Texture;
import com.misc.Main;
import java.util.Enumeration;
import java.util.Hashtable;

public class Asset {
    private static Hashtable table = new Hashtable();

    public static final void clear() {
        try {
            Enumeration elements = table.elements();
            while (elements.hasMoreElements()) {
                Object obj = elements.nextElement();
                if (obj instanceof Sound) {
                    ((Sound)obj).destroy();
                    continue;
                }
                if (obj instanceof Texture) {
                    ((Texture)obj).destroy();
                    continue;
                }
                if (obj instanceof MultyTexture) {
                    ((MultyTexture)obj).destroy();
                    continue;
                }
                if (obj instanceof Mesh) {
                    ((Mesh)obj).destroy();
                    continue;
                }
                if (!(obj instanceof Mesh[])) continue;
                Mesh[] meshes = (Mesh[])obj;
                for (int xx = 0; xx < meshes.length; ++xx) {
                    meshes[xx].destroy();
                }
            }
            table.clear();
            System.gc();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final Mesh[] getMeshes(String file, float scaleX, float scaleY, float scaleZ) {
        Mesh[] mesh = (Mesh[])table.get("MESH_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ);
        if (mesh == null) {
            mesh = Room.loadMeshes(file, scaleX, scaleY, scaleZ);
            table.put("MESH_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ, mesh);
        }
        return mesh;
    }

    public static final Mesh getMeshCloneDynamic(String file, float scaleX, float scaleY, float scaleZ) {
        Mesh mesh = Room.loadMeshes(file, scaleX, scaleY, scaleZ)[0];
        return mesh;
    }

    public static final Mesh getMeshClone(String file, float scaleX, float scaleY, float scaleZ) {
        Mesh mesh = (Mesh)table.get("MESHCLONE_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ);
        if (mesh == null) {
            mesh = Room.loadMeshes(file, scaleX, scaleY, scaleZ)[0];
            table.put("MESHCLONE_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ, mesh);
        }
        return mesh;
    }

    public static final short[][] getAnimation(String file, float scaleX, float scaleY, float scaleZ) {
        short[][] mesh = (short[][])table.get("ANIMATION_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ);
        if (mesh == null) {
            mesh = Morphing.create(Room.loadMeshes(file, scaleX, scaleY, scaleZ));
            table.put("ANIMATION_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ, mesh);
        }
        return mesh;
    }

    public static final Morphing getMorphing(String file, float scaleX, float scaleY, float scaleZ) {
        Morphing mesh = (Morphing)table.get("MORPHING_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ);
        if (mesh == null) {
            mesh = new Morphing(Asset.getAnimation(file, scaleX, scaleY, scaleZ), Asset.getMeshClone(file, scaleX, scaleY, scaleZ));
            table.put("MORPHING_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ, mesh);
        }
        return mesh;
    }

    public static final MeshImage getMeshImage(String file, float scaleX, float scaleY, float scaleZ) {
        MeshImage mesh = (MeshImage)table.get("MESHIMAGE_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ);
        if (mesh == null) {
            mesh = new MeshImage(Asset.getMeshCloneDynamic(file, scaleX, scaleY, scaleZ), Asset.getMorphing(file, scaleX, scaleY, scaleZ));
            table.put("MESHIMAGE_" + file + "_" + scaleX + "_" + scaleY + "_" + scaleZ, mesh);
        }
        return mesh;
    }

    public static final MeshImage getMeshImageDynamic(String file, float scaleX, float scaleY, float scaleZ) {
        MeshImage mesh = new MeshImage(Asset.getMeshClone(file, scaleX, scaleY, scaleZ), Asset.getMorphing(file, scaleX, scaleY, scaleZ));
        return mesh;
    }

    public static final Texture getTexture(String file) {
        Texture texture = (Texture)table.get("TEX_" + file);
        if (texture != null) {
            Texture oldtex = texture;
            texture = new Texture(oldtex.rImg, oldtex.perspectiveCorrection);
            texture.mip = oldtex.mip;
            texture.setDrawMode(oldtex.getDrawMode());
        }
        if (texture == null) {
            texture = Texture.createTexture(file);
            table.put("TEX_" + file, texture);
        }
        if (Main.mipMapping && texture.mip == null) {
            if (texture.rImg.w >= 2 && texture.rImg.h >= 2) {
                texture.mip = new Texture(new RawImage(Asset.cubic2XDesize(texture.getPixels(), texture.rImg.w, texture.rImg.h), texture.rImg.w / 2, texture.rImg.h / 2), texture.perspectiveCorrection);
            }
            if (texture.rImg.w >= 4 && texture.rImg.h >= 4) {
                texture.mip.mip = new Texture(new RawImage(Asset.cubic2XDesize(texture.mip.getPixels(), texture.mip.rImg.w, texture.mip.rImg.h), texture.mip.rImg.w / 2, texture.mip.rImg.h / 2), texture.perspectiveCorrection);
            }
        }
        return texture;
    }

    public static final Texture getTextureNM(String file) {
        Texture texture = (Texture)table.get("TEX_" + file);
        if (texture != null) {
            Texture oldtex = texture;
            texture = new Texture(oldtex.rImg, oldtex.perspectiveCorrection);
            texture.mip = oldtex.mip;
            texture.setDrawMode(oldtex.getDrawMode());
        } else {
            texture = Texture.createTexture(file);
            table.put("TEX_" + file, texture);
        }
        return texture;
    }

    public static int[] cubic2XDesize(int[] original, int w, int h) {
        int nw = w / 2;
        int nh = h / 2;
        int[] out = new int[nw * nh];
        for (int y = 0; y < nh; ++y) {
            for (int x = 0; x < nw; ++x) {
                int col = original[x * 2 + y * 2 * w];
                int aa = col >> 24 & 0xFF;
                int ar = col >> 16 & 0xFF;
                int ag = col >> 8 & 0xFF;
                int ab = col & 0xFF;
                col = original[x * 2 + y * 2 * w + 1 & original.length - 1];
                int br = col >> 16 & 0xFF;
                int bg = col >> 8 & 0xFF;
                int bb = col & 0xFF;
                col = original[x * 2 + y * 2 * w + 1 + w & original.length - 1];
                int cr = col >> 16 & 0xFF;
                int cg = col >> 8 & 0xFF;
                int cb = col & 0xFF;
                col = original[x * 2 + y * 2 * w + w & original.length - 1];
                int dr = col >> 16 & 0xFF;
                int dg = col >> 8 & 0xFF;
                int db = col & 0xFF;
                int or = (ar + br + cr + dr) / 4;
                int og = (ag + bg + cg + dg) / 4;
                int ob = (ab + bb + cb + db) / 4;
                out[x + y * nw] = aa << 24 | or << 16 | og << 8 | ob;
            }
        }
        return out;
    }

    public static final MultyTexture getMultyTexture(String file) {
        MultyTexture texturem = (MultyTexture)table.get("MTEX_" + file);
        if (texturem == null) {
            texturem = new MultyTexture(file, true);
            table.put("MTEX_" + file, texturem);
        }
        return texturem;
    }

    public static final MultyTexture getMultyTexture(String file, boolean iz) {
        MultyTexture texturem = (MultyTexture)table.get("MTEX_" + file);
        if (texturem == null) {
            texturem = new MultyTexture(file, iz);
            table.put("MTEX_" + file, texturem);
        }
        return texturem;
    }

    public static final Sound getSound(String file) {
        if (Main.sounds == 0 || !Main.isSounds) {
            return null;
        }
        try {
            Sound sound = (Sound)table.get("SND_" + file);
            if (sound == null) {
                sound = new Sound(file);
                table.put("SND_" + file, sound);
            }
            return sound;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final Sound getFootsteps(String file) {
        if (Main.footsteps == 0 || !Main.isFootsteps) {
            return null;
        }
        try {
            Sound sound = (Sound)table.get("SND_" + file);
            if (sound == null) {
                sound = new Sound(file);
                table.put("SND_" + file, sound);
            }
            return sound;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final Sound getMusic(String file) {
        if (Main.music == 0 || !Main.isMusic) {
            return null;
        }
        try {
            Sound sound = (Sound)table.get("SND_" + file);
            if (sound == null) {
                sound = new Sound(file);
                table.put("SND_" + file, sound);
            }
            return sound;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final void applyMeshEffects(Mesh[] var12, String effects) {
        Asset.applyMeshEffects(var12[0], effects);
    }

    public static final void applyMeshEffects(Mesh var12, String effects) {
        if (effects == null) {
            return;
        }
        String[] mods = Mesh.cutOnStrings(effects, ',', ';');
        Texture[] texs = var12.getTexture().textures;
        if (texs == null) {
            return;
        }
        int length = texs.length;
        if (mods.length < length) {
            length = mods.length;
        }
        for (int i = 0; i < length; ++i) {
            if (texs[i] == null || mods[i] == null) continue;
            texs[i].setDrawMode((byte)Integer.parseInt(mods[i]));
        }
    }
}

