/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay;

import code.Gameplay.GameScreen;
import code.Gameplay.Shop;
import code.Gameplay.Weapon;
import code.utils.WeaponCreator;
import javax.microedition.lcdui.Graphics;

public class Arsenal {
    public Weapon[] weapons;
    public int current;
    public boolean hasHand = false;

    public final void destroy() {
        for (int i = 0; i < this.weapons.length; ++i) {
            if (this.weapons[i] == null) continue;
            this.weapons[i].reset();
            this.weapons[i] = null;
        }
        this.weapons = null;
    }

    public final void removeAll() {
        int i;
        int n = i = this.hasHand ? 0 : 1;
        while (i < this.weapons.length) {
            if (this.weapons[i] != null) {
                this.weapons[i].reset();
                this.weapons[i] = null;
            }
            ++i;
        }
        this.current = this.hasHand ? -1 : 0;
    }

    public final Weapon currentWeapon() {
        if (this.current >= 0 && this.current < this.weapons.length) {
            return this.weapons[this.current];
        }
        return null;
    }

    public final Weapon[] getWeapons() {
        return this.weapons;
    }

    public final void next() {
        if (this.currentWeapon() != null) {
            this.currentWeapon().reset();
        }
        ++this.current;
        if (this.current >= this.weapons.length) {
            this.current = 0;
            if (this.hasHand) {
                this.current = -1;
            }
        }
        if (this.current != -1 && this.weapons[this.current] == null) {
            this.next();
        }
    }

    public final void previous() {
        if (this.currentWeapon() != null) {
            this.currentWeapon().reset();
        }
        --this.current;
        if (this.current < (this.hasHand ? -1 : 0)) {
            this.current = this.weapons.length - 1;
        }
        if (this.current != -1 && this.weapons[this.current] == null) {
            this.previous();
        }
    }

    public final void drawWeapon(Graphics g, int y, int width, int height, GameScreen gs) {
        Weapon weapon = this.currentWeapon();
        if (weapon == null) {
            return;
        }
        if (!gs.player.zoom || !weapon.hasZoom) {
            weapon.draw(g, 0, y, width, height);
        } else {
            weapon.drawSight(g, 0, y, width, height);
        }
    }

    public final void drawReloadAnimation(Graphics g, int y, int width, int height) {
        Weapon weapon = this.currentWeapon();
        if (weapon == null) {
            return;
        }
        if (weapon.isReloading()) {
            int maxY = Math.max(height / 50, 6);
            int x = (width /= 2) - width / 2;
            int y2 = height - maxY - 2 + y;
            int perc = weapon.reloadingPercentage();
            g.setColor(0xFFFFFF);
            g.drawRect(x, y2, width, maxY);
            g.fillRect(x, y2, width * perc / 100, maxY);
        }
    }

    public Arsenal(int width_g3d, int height_g3d) {
        this.current = -1;
        this.weapons = new Weapon[Shop.weaponCount];
        if (Shop.defaultArsenal != null) {
            for (int i = 0; i < Shop.defaultArsenal.length; ++i) {
                if (Shop.defaultArsenal[i] != -1) {
                    Weapon weapon;
                    if (this.current == -1) {
                        this.current = Shop.defaultArsenal[i];
                    }
                    this.weapons[Shop.defaultArsenal[i]] = weapon = WeaponCreator.createWeapon(Shop.defaultArsenal[i]);
                    weapon.reset();
                    if (Shop.defaultArsenalAmmo != null) {
                        weapon.setAmmo(Shop.defaultArsenalAmmo[i]);
                    } else {
                        weapon.setAmmo(weapon.isTwoHands() ? 400 : 200);
                    }
                }
                if (Shop.defaultArsenal[i] != -1) continue;
                this.hasHand = true;
            }
        } else {
            this.hasHand = true;
            this.current = -1;
        }
        if (this.currentWeapon() != null) {
            this.currentWeapon().createSprite(width_g3d, height_g3d);
        }
    }

    public Arsenal() {
    }
}

