/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay;

import code.AI.BigZombie;
import code.AI.Player;
import code.AI.Zombie;
import code.Gameplay.DialogScreen;
import code.Gameplay.InventoryScreen;
import code.Gameplay.LevelLoader;
import code.Gameplay.Map.Character;
import code.Gameplay.Map.House;
import code.Gameplay.Map.RoomObject;
import code.Gameplay.Map.Scene;
import code.Gameplay.Map.Skybox;
import code.Gameplay.Shop;
import code.Gameplay.Weapon;
import code.HUD.Base.Font;
import code.HUD.Base.GameKeyboard;
import code.HUD.DeveloperMenu;
import code.HUD.GUIScreen;
import code.HUD.GameHelp;
import code.HUD.Menu;
import code.HUD.PauseScreen;
import code.HUD.TitleScreen;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.Camera;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.utils.Asset;
import code.utils.DelayedDialog;
import code.utils.GameIni;
import code.utils.ImageResize;
import code.utils.IniFile;
import code.utils.Main;
import code.utils.QFPS;
import code.utils.StringTools;
import code.utils.WeatherGenerator;
import code.utils.canvas.MainCanvas;
import code.utils.canvas.MyCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameScreen
extends MyCanvas {
    public final Main main;
    public final Font font;
    public Player player;
    public Scene scene;
    public GameIni levelIni;
    public DialogScreen dialogScreen;
    public WeatherGenerator wg;
    public static long time;
    public boolean doubleBright = false;
    public static Vector lines;
    public static String mus;
    public static String levelFile;
    public static int width;
    public static int height;
    public static Vector delayDialogs;
    public static boolean bloom;
    private boolean finishDraw = true;
    private Object lookAtObj = null;
    public long musTime = 0L;
    public long usmem = 0L;
    public Vector3D newPos;
    public final int levelNumber;
    private final Object hudInfo;
    public int[] shopItems = null;
    private GameKeyboard keys;
    private int key;
    private int pointerX;
    private int pointerY;
    private int dirX;
    private int dirY;
    public boolean run;
    public boolean paused;
    private int msToEnd = 0;
    private int msToExit = 0;
    private int lastHP;
    private int lastAmmo;
    private int lastMoney;
    private int lastFrags;
    private Image imgSight;
    private Image imgLife;
    private Image imgPatron;
    private Image imgMoney;
    private Image imgSkull;
    private Image imgHand;
    private Image imgLifeLow;
    private Image imgPatronLow;
    private Image imgPatronNoWeapon;
    public String customMessage = null;
    public boolean customMessagePause = false;
    public long customMessageEndTime = 0L;
    public Image overlay;
    public long overlayStart = 0L;
    public long overlayTimeOut = 0L;
    public byte[] vignette;
    public boolean changed = true;
    public boolean firstUpdate = true;
    public boolean fullMoveLvl = false;

    public GameScreen(Main main, int levelNumber, Object hudInfo) {
        levelFile = "/level" + levelNumber + ".txt";
        this.levelNumber = levelNumber;
        this.main = main;
        this.hudInfo = hudInfo;
        this.font = Main.getFont();
        width = this.getWidth();
        height = this.getHeight();
        this.vignette = null;
        this.finishDraw = true;
        this.lookAtObj = null;
        delayDialogs.removeAllElements();
        this.musTime = 0L;
        bloom = false;
        this.keys = new GameKeyboard();
        try {
            this.imgLife = this.createImage2(Main.getGameText().getDef(Main.life_icon, Main.life_icon));
            this.imgPatron = this.createImage2(Main.getGameText().getDef(Main.patron_icon, Main.patron_icon));
            this.imgMoney = this.createImage2(Main.getGameText().getDef(Main.money_icon, Main.money_icon));
            this.imgPatronNoWeapon = this.createImage2(Main.getGameText().getDef(Main.patron_no_weapon_icon, Main.patron_no_weapon_icon));
            if (Main.low_life_icon != null) {
                this.imgLifeLow = this.createImage2(Main.getGameText().getDef(Main.low_life_icon, Main.low_life_icon));
            }
            if (Main.low_patron_icon != null) {
                this.imgPatronLow = this.createImage2(Main.getGameText().getDef(Main.low_patron_icon, Main.low_patron_icon));
            }
            this.imgSkull = this.createImage2(Main.getGameText().getDef(Main.skull_icon, Main.skull_icon));
            try {
                this.scene = LevelLoader.createScene(width, height * Main.getDisplaySize() / 100, levelFile, main, this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String path = Main.getGameText().getDef(Main.sight_icon, Main.sight_icon);
            this.imgSight = !Main.originalSight ? (!Main.fullScreenSight ? this.createImage2(path) : ImageResize.createImage(path, width, height * Main.displaySize / 100)) : Image.createImage((String)path);
            path = Main.getGameText().getDef(Main.hand_icon, Main.hand_icon);
            this.imgHand = Main.originalUseIcon ? Image.createImage((String)path) : this.createImage2(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.player = new Player(this.scene.getG3D().getWidth(), (int)((float)height * ((float)Main.getDisplaySize() / 100.0f)), this.scene.getStartPoint(), hudInfo, this.scene.camPose);
        if (!Main.isLastLevel(levelNumber)) {
            String st = new IniFile(StringTools.getStringFromResource("/level" + (levelNumber + 1) + ".txt"), false).get("START");
            if (st != null) {
                int[] ps = GameIni.createPos(st, ',');
                this.newPos = new Vector3D(ps[0], ps[1], ps[2]);
            } else {
                this.newPos = new Vector3D(0, 0, 0);
            }
        }
        Player.usedPoints.removeAllElements();
        LevelLoader.loadObjects(levelFile, this.levelIni, this.scene, this.player, false);
        this.scene.removeKilledBots();
        this.scene.getHouse().addObject(this.player);
        this.dialogScreen = new DialogScreen(this.font, this.scene.getG3D(), main, this);
        boolean hasPlayer = Main.musicPlayer.hasPlayer();
        this.init();
        if (!hasPlayer) {
            this.startMus(0L);
        }
        this.changed = true;
        time = 0L;
    }

    private Image createImage2(String file) {
        if (width < height) {
            return ImageResize.createImage(file, (float)width / 240.0f, (float)width / 240.0f);
        }
        return ImageResize.createImage(file, (float)height / 320.0f, (float)height / 320.0f);
    }

    private void drawMessageSimple(Graphics g, String str) {
        if (str == null) {
            return;
        }
        DirectX7 g3d = this.scene.getG3D();
        int y = height / 2;
        Main.drawBck(g, y - this.font.height() / 2, y + this.font.height() / 2);
        this.font.drawString(g, str, g3d.getWidth() / 2, y, 3);
    }

    public void destroy() {
        this.destroy(true);
    }

    public void destroy(boolean destroyMus) {
        try {
            this.newPos = null;
            this.lookAtObj = null;
            delayDialogs.removeAllElements();
            this.scene.destroy();
            this.scene = null;
            Asset.clear();
            this.player.destroy();
            this.player = null;
            BigZombie.model = null;
            Zombie.model = null;
            BigZombie.texture = null;
            Zombie.texture = null;
            this.dialogScreen = null;
            this.imgPatronNoWeapon = null;
            this.imgSkull = null;
            this.imgMoney = null;
            this.imgPatronLow = null;
            this.imgPatron = null;
            this.imgHand = null;
            this.imgLife = null;
            this.imgSight = null;
            if (destroyMus) {
                this.destroyMusic();
            }
            Mesh.resetBuffer();
            System.gc();
            time = 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawMessage(Graphics g, String str) {
        DirectX7 g3d = this.scene.getG3D();
        int y = height / 2 + height * Math.min(Main.getDisplaySize(), 80) / 100 / 2 - this.font.height() / 2;
        Main.drawBck(g, y - this.font.height() / 2, y + this.font.height() / 2);
        this.font.drawString(g, str, g3d.getWidth() / 2, y, 3);
    }

    private void drawMessageCustom(Graphics g) {
        DirectX7 g3d = this.scene.getG3D();
        int lsize = lines.size();
        int x = g3d.getWidth() / 2;
        int y = height / 2 + height * Math.min(Main.getDisplaySize(), 80) / 100 / 2 - this.font.height() / 2 - this.font.height() * (lsize - 1);
        Main.drawBck(g, y - this.font.height() / 2, y + lsize * this.font.height() - this.font.height() / 2);
        for (int i = 0; i < lsize; ++i) {
            String str = (String)lines.elementAt(i);
            this.font.drawString(g, str, x, y + i * this.font.height(), 3);
        }
    }

    private void applyVignette(int[] scr) {
        int c;
        int d;
        int size = Math.min(scr.length, this.vignette.length);
        int i = 0;
        while (size - i >= 8) {
            d = this.vignette[i] + 128;
            c = scr[i];
            scr[i] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            c = scr[i + 1];
            scr[i + 1] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            d = this.vignette[i + 2] + 128;
            c = scr[i + 2];
            scr[i + 2] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            c = scr[i + 3];
            scr[i + 3] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            d = this.vignette[i + 4] + 128;
            c = scr[i + 4];
            scr[i + 4] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            c = scr[i + 5];
            scr[i + 5] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            d = this.vignette[i + 6] + 128;
            c = scr[i + 6];
            scr[i + 6] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            c = scr[i + 7];
            scr[i + 7] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            i += 8;
        }
        while (i < size) {
            d = this.vignette[i] + 128;
            c = scr[i];
            scr[i] = ((c & 0xFF00FF) * d & 0xFF00FF00 | (c & 0xFF00) * d & 0xFF0000) >>> 8;
            ++i;
        }
    }

    public final void applySub(int[] scr) {
        int col;
        int i;
        int l = 255;
        for (i = scr.length - 1; i >= 5; i -= 6) {
            col = scr[i];
            col = ((col & 0xFF00FF) * l & 0xFE00FE00 | (col & 0xFF00) * l & 0xFE0000) >>> 7;
            scr[i] = col | (col >> 8 & 0x10101) * 255;
            col = scr[i - 1];
            col = ((col & 0xFF00FF) * l & 0xFE00FE00 | (col & 0xFF00) * l & 0xFE0000) >>> 7;
            scr[i - 1] = col | (col >> 8 & 0x10101) * 255;
            col = scr[i - 2];
            col = ((col & 0xFF00FF) * l & 0xFE00FE00 | (col & 0xFF00) * l & 0xFE0000) >>> 7;
            scr[i - 2] = col | (col >> 8 & 0x10101) * 255;
            col = scr[i - 3];
            col = ((col & 0xFF00FF) * l & 0xFE00FE00 | (col & 0xFF00) * l & 0xFE0000) >>> 7;
            scr[i - 3] = col | (col >> 8 & 0x10101) * 255;
            col = scr[i - 4];
            col = ((col & 0xFF00FF) * l & 0xFE00FE00 | (col & 0xFF00) * l & 0xFE0000) >>> 7;
            scr[i - 4] = col | (col >> 8 & 0x10101) * 255;
            col = scr[i - 5];
            col = ((col & 0xFF00FF) * l & 0xFE00FE00 | (col & 0xFF00) * l & 0xFE0000) >>> 7;
            scr[i - 5] = col | (col >> 8 & 0x10101) * 255;
        }
        while (i >= 0) {
            col = scr[i];
            col = ((col & 0xFF00FF) * l & 0xFE00FE00 | (col & 0xFF00) * l & 0xFE0000) >>> 7;
            scr[i] = col | (col >> 8 & 0x10101) * 255;
            --i;
        }
    }

    public final void paint(Graphics g) {
        int screenY;
        Weapon weapon;
        int partsCount;
        Matrix playerMat;
        boolean playerDied;
        long begintime;
        boolean redrawInfo;
        DirectX7 g3d;
        block96: {
            block95: {
                block94: {
                    if (this.paused || !this.run || !this.finishDraw) {
                        return;
                    }
                    this.finishDraw = false;
                    g3d = this.scene.getG3D();
                    redrawInfo = this.changed;
                    if (!redrawInfo) {
                        g.setClip(0, height / 2 - g3d.getHeight() / 2, width, g3d.getHeight());
                    }
                    this.changed = false;
                    begintime = System.currentTimeMillis();
                    if (MainCanvas.pstros && (MainCanvas.mouseX != MainCanvas.emulatorScreenWidth / 2 || MainCanvas.mouseY != MainCanvas.emulatorScreenHeight / 2)) {
                        float mouseSpeed = (!this.player.zoom ? 0.4f : 0.175f) * (float)Main.mouseSpeed / 50.0f;
                        float xRot = (float)(MainCanvas.mouseX - MainCanvas.emulatorScreenWidth / 2) * mouseSpeed;
                        float yRot = (float)(MainCanvas.mouseY - MainCanvas.emulatorScreenHeight / 2) * mouseSpeed;
                        if (this.player.canLookY()) {
                            this.player.rotYn(-xRot);
                        }
                        if (this.player.canLookX()) {
                            this.player.rotXn(-yRot);
                        }
                        if (this.wg != null) {
                            if (this.player.canLookY()) {
                                this.wg.moveY((int)(-yRot), QFPS.frameTime);
                            }
                            if (this.player.canLookX()) {
                                this.wg.moveX2((int)(-xRot), QFPS.frameTime);
                            }
                        }
                    }
                    g.setClip(0, 0, this.getWidth(), this.getHeight());
                    g.translate(0, 0);
                    playerDied = this.player.isDead();
                    int playerHeight = this.player.getEyesHeight();
                    playerMat = this.player.getCharacter().getTransform();
                    this.player.setCamera(g3d);
                    int renderFrom = this.player.getRenderPart(this.scene);
                    if (this.wg != null) {
                        this.wg.update(QFPS.frameTime, -(g3d.camera.m12 * 90 / 16384), this.player.character.underRoof);
                    }
                    partsCount = 1;
                    weapon = null;
                    if (this.player != null && this.player.arsenal != null) {
                        weapon = this.player.arsenal.currentWeapon();
                    }
                    try {
                        Skybox sky;
                        if (weapon != null) {
                            if (!weapon.hasZoom) {
                                this.player.zoom = false;
                            }
                            this.player.stdFov = weapon.stdFov;
                            this.player.zoomFov = weapon.zoomFov;
                        } else if (!Main.hasZoom) {
                            if (this.player.zoom) {
                                this.player.zoom = false;
                            }
                        } else {
                            this.player.stdFov = Main.stdFov;
                            this.player.zoomFov = Main.zoomFov;
                        }
                        if (this.player.zoom && this.player.fov != (float)this.player.zoomFov || this.player.fov != (float)this.player.stdFov && !this.player.zoom) {
                            int zoomStep = this.player.zoom ? this.player.zoomFov - this.player.stdFov : this.player.stdFov - this.player.zoomFov;
                            this.player.fov += (float)(((long)QFPS.currentTime - this.player.lastZoomAction) * (long)zoomStep / 150L);
                            int max = Math.max(this.player.zoomFov, this.player.stdFov);
                            int min = Math.min(this.player.zoomFov, this.player.stdFov);
                            if (this.player.fov > (float)max) {
                                this.player.fov = max;
                            } else if (this.player.fov < (float)min) {
                                this.player.fov = min;
                            }
                            this.scene.getG3D().updateFov((int)this.player.fov);
                        }
                        this.player.lastZoomAction = QFPS.currentTime;
                        boolean lighting = false;
                        if (this.wg != null && this.wg.lighting) {
                            boolean bl = lighting = System.currentTimeMillis() - this.wg.lastLighting < 135L;
                        }
                        if ((sky = this.scene.getHouse().getSkybox()) != null) {
                            Camera cam;
                            if (lighting) {
                                sky.lighting = true;
                                sky.lastLighting = this.wg.lastLighting;
                            }
                            if ((cam = this.player.getCamera()) != null) {
                                sky.rotateX = cam.currentRotX;
                                sky.rotateY = cam.currentRotY;
                            } else {
                                sky.rotateX = this.player.rotateX;
                                sky.rotateY = this.player.rotateY;
                            }
                        }
                        if (!House.l2dRoomRendering) {
                            int[] partsMass = House.getParts(this.scene.getHouse(), renderFrom, g3d.camera);
                            partsCount = partsMass.length;
                            this.scene.render(g, partsMass, this.player);
                        } else {
                            this.scene.render(g, renderFrom, this.player);
                        }
                        g3d.render();
                        g3d.shootIntensity -= QFPS.frameTime;
                        if (g3d.shootIntensity < 0) {
                            g3d.shootIntensity = 0;
                        }
                        if (lighting && !this.player.character.underRoof && this.wg != null) {
                            Camera cam = this.player.getCamera();
                            this.wg.lightingEffect(g3d, cam != null ? cam.currentRotX : this.player.rotateX);
                        }
                        if (this.vignette != null) {
                            this.applyVignette(g3d.getDisplay());
                        }
                    }
                    catch (Exception ext) {
                        if (!DeveloperMenu.debugMode) break block94;
                        ext.printStackTrace();
                    }
                }
                screenY = (height - g3d.getHeight()) / 2;
                try {
                    if (playerDied) {
                        this.deathScr(g3d.getDisplay());
                    }
                    if (this.player.isDamaged()) {
                        this.damageScr(g3d.getDisplay());
                    }
                    if (bloom) {
                        this.fastbloomScr(g3d);
                    }
                    if (this.doubleBright) {
                        this.applySub(this.scene.getG3D().display);
                    }
                }
                catch (Exception ext) {
                    if (!DeveloperMenu.debugMode) break block95;
                    ext.printStackTrace();
                }
            }
            try {
                this.scene.flush(g, 0, screenY);
            }
            catch (Exception ext) {
                if (!DeveloperMenu.debugMode) break block96;
                ext.printStackTrace();
            }
        }
        if (DeveloperMenu.drawPortals) {
            this.scene.house.drawPortals(g, 0, screenY);
        }
        if (this.wg != null) {
            g.clipRect(0, screenY, g3d.getWidth(), g3d.getHeight());
            this.wg.paint(g, screenY);
            g.clipRect(0, 0, width, height);
            if (!redrawInfo) {
                g.setClip(0, screenY, width, g3d.getHeight());
            }
        }
        if (this.overlay != null) {
            if (System.currentTimeMillis() - this.overlayStart < this.overlayTimeOut) {
                g.drawImage(this.overlay, this.getWidth() / 2, this.getHeight() / 2, 3);
            } else {
                this.overlay = null;
            }
        }
        if (!Main.hideHud) {
            RoomObject tmps;
            if (!playerDied && this.player.arsenal.current != -1) {
                g.setClip(0, screenY, g3d.getWidth(), g3d.getHeight());
                if (this.player.show2D()) {
                    this.player.arsenal.drawWeapon(g, screenY, g3d.getWidth(), g3d.getHeight(), this);
                }
                this.player.arsenal.drawReloadAnimation(g, screenY, g3d.getWidth(), g3d.getHeight());
                g.setClip(0, 0, width, height);
                if (!redrawInfo) {
                    g.setClip(0, screenY, width, g3d.getHeight());
                }
            }
            if (!(weapon == null && Main.hidesight || (weapon == null || this.player.zoom) && weapon != null && (!this.player.canAttack() || this.player.show2D()) || this.imgHand != null && this.lookAtObj != null && MainCanvas.pstros)) {
                g.drawImage(this.imgSight, g3d.getWidth() / 2, screenY + g3d.getHeight() / 2, 3);
            }
            boolean lowHP = false;
            boolean lowAmmo = false;
            String infoText = null;
            if (playerDied) {
                infoText = Main.getGameText().get("GAME_OVER");
            } else if (this.msToEnd > 0) {
                if (!this.scene.exitWithoutWait) {
                    infoText = Main.getGameText().get(Main.isLastLevel(this.levelNumber) ? "GAME_COMPLETE" : "LEVEL_COMPLETE");
                }
            } else if (this.msToExit > 0 && this.msToExit < 3000) {
                infoText = Main.getGameText().get("FIND_EXIT");
            }
            if (infoText != null) {
                this.drawMessageSimple(g, infoText);
            }
            if (this.player.getHp() <= 15 && (this.customMessage == null || this.imgLifeLow != null)) {
                lowHP = true;
                this.changed = true;
                redrawInfo = true;
            }
            if (weapon != null && weapon.patronbuy && weapon.getAmmo() <= weapon.lowPatronAmount && (this.customMessage == null || this.imgPatronLow != null || weapon.imgPatronLow != null)) {
                lowAmmo = true;
                this.changed = true;
                redrawInfo = true;
            }
            if (QFPS.frames == 0 && DeveloperMenu.debugMode) {
                this.usmem = Runtime.getRuntime().totalMemory() / 1024L - Runtime.getRuntime().freeMemory() / 1024L;
            }
            int screenH4Icons = Main.getDisplaySize() <= 80 ? (int)((float)height * ((float)Main.getDisplaySize() / 100.0f)) : height * 8 / 10;
            int iconY = (height - screenH4Icons) / 4;
            int iconYDown = height - iconY;
            if (redrawInfo || Main.getDisplaySize() > 80) {
                String text;
                g.setClip(0, 0, width, height);
                g.setColor(0);
                if (Main.getDisplaySize() < 100) {
                    g.fillRect(0, 0, width, screenY);
                    g.fillRect(0, screenY + g3d.getHeight(), width, height - (screenY + g3d.getHeight()));
                }
                if (this.imgMoney != null) {
                    g.drawImage(this.imgMoney, 4, iconY, 6);
                    this.font.drawString(g, " " + this.player.money, 4 + this.imgMoney.getWidth(), iconY, 6);
                }
                if (!this.scene.alwaysExit && this.imgSkull != null) {
                    g.drawImage(this.imgSkull, width - 4, iconY, 10);
                    this.font.drawString(g, this.player.frags + "/" + this.scene.getEnemyCount(), width - 4 - this.imgSkull.getWidth(), iconY, 10);
                }
                if (this.imgLife != null) {
                    if (this.imgHand != null && this.lookAtObj != null && !MainCanvas.pstros) {
                        if (Main.displaySize > 80) {
                            g.drawImage(this.imgHand, 4, iconYDown - this.imgLife.getHeight(), 6);
                        } else {
                            g.drawImage(this.imgHand, 4, (height + height * Main.displaySize / 100) / 2 - this.imgHand.getHeight() - 4, 20);
                        }
                    }
                    g.drawImage(lowHP && this.imgLifeLow != null ? this.imgLifeLow : this.imgLife, 4, iconYDown, 6);
                    this.font.drawString(g, " " + this.player.getHp(), this.imgLife.getWidth(), iconYDown, 6);
                } else if (this.imgHand != null && this.lookAtObj != null && !MainCanvas.pstros) {
                    g.drawImage(this.imgHand, 4, iconYDown, 6);
                }
                Image imgPatron2 = weapon == null ? this.imgPatronNoWeapon : this.imgPatron;
                Image imgPatronLow2 = this.imgPatronLow;
                if (weapon != null) {
                    if (weapon.imgPatron == null && weapon.filePatron != null) {
                        weapon.imgPatron = this.createImage2(weapon.filePatron);
                    }
                    if (weapon.imgPatronLow == null && weapon.filePatronLow != null) {
                        weapon.imgPatron = this.createImage2(weapon.filePatron);
                    }
                    if (weapon.imgPatron != null) {
                        imgPatron2 = weapon.imgPatron;
                    }
                    if (weapon.imgPatronLow != null) {
                        imgPatronLow2 = weapon.imgPatronLow;
                    }
                }
                if (imgPatron2 != null) {
                    g.drawImage(lowAmmo && imgPatronLow2 != null ? imgPatronLow2 : imgPatron2, width - 4, iconYDown, 10);
                    if (weapon != null && weapon.patronbuy) {
                        this.font.drawString(g, weapon.getRounds() + "/" + weapon.getAmmo() + " ", width - imgPatron2.getWidth(), iconYDown, 10);
                    }
                }
                if (this.imgLifeLow == null && lowHP && this.scene.getFrame() / 8 % 2 == 0 && (text = Main.getGameText().get("BUY_MEDICINE_CHEST")) != null) {
                    this.drawMessage(g, text);
                }
                if (imgPatronLow2 == null && lowAmmo && this.scene.getFrame() / 8 % 2 == 0 && (text = Main.getGameText().get("BUY_PATRONS")) != null) {
                    this.drawMessage(g, text);
                }
            }
            if (this.imgHand != null && this.lookAtObj != null && MainCanvas.pstros) {
                g.drawImage(this.imgHand, width / 2, height / 2, 3);
            }
            if ((tmps = this.scene.findObject(true, this.player, screenY, this)) != this.lookAtObj || tmps != null) {
                this.changed = true;
                this.lookAtObj = tmps;
            }
            if (!this.paused && DeveloperMenu.debugMode) {
                int moneyWidth = 0;
                if (this.imgMoney != null) {
                    moneyWidth = this.imgMoney.getWidth();
                }
                if (DeveloperMenu.showFps) {
                    this.font.drawString(g, ":" + QFPS.fps + ":", 44 + moneyWidth, iconY, 6);
                }
                if (DeveloperMenu.showRoomID) {
                    this.font.drawString(g, ":" + partsCount + ":", 94 + moneyWidth, iconY, 6);
                    this.font.drawString(g, ":" + this.player.getPart() + ":", 114 + moneyWidth, iconY, 6);
                }
                if (DeveloperMenu.showRam) {
                    this.font.drawString(g, ":" + Long.toString(this.usmem) + ":", 144 + moneyWidth, iconY, 6);
                }
                if (DeveloperMenu.showPlayerPos) {
                    String crds = playerMat.m03 + ", " + playerMat.m13 + ", " + playerMat.m23 + ";";
                    this.font.drawString(g, crds, width / 2, iconY + this.font.height() * 2, 3);
                }
                this.changed = true;
            }
            if (this.customMessage != null) {
                this.drawMessageCustom(g);
                this.changed = true;
                if (this.customMessagePause) {
                    try {
                        Thread.sleep(this.customMessageEndTime);
                        QFPS.miniReset();
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    this.customMessagePause = false;
                    this.customMessage = null;
                }
                if (System.currentTimeMillis() > this.customMessageEndTime) {
                    this.customMessage = null;
                }
            }
            if (DeveloperMenu.drawLevelPoints && DeveloperMenu.debugMode) {
                this.scene.drawPoints(g, screenY, this.player);
            }
        }
        this.run(begintime);
        this.finishDraw = true;
        QFPS.frame();
        this.repaint();
    }

    protected final void pointerPressed(int x, int y) {
        if (this.paused) {
            return;
        }
        if (MainCanvas.pstros) {
            this.keys.keyPressed(this.keys.FIRE);
            return;
        }
        this.pointerX = x;
        this.pointerY = y;
        if (GUIScreen.isLeftSoft(x, y, this.getWidth(), this.getHeight())) {
            this.keyPressed(this.keys.SOFT_LEFT);
        } else if (GUIScreen.isRightSoft(x, y, this.getWidth(), this.getHeight())) {
            this.keyPressed(this.keys.SOFT_RIGHT);
        }
    }

    protected final void mouseScrollUp() {
        this.player.nextWeapon();
        this.changed = true;
    }

    protected final void mouseScrollDown() {
        this.player.previousWeapon();
        this.changed = true;
    }

    private void fastbloomScr(DirectX7 g3d) {
        int[] scr = g3d.getDisplay();
        int[] rgb2 = new int[g3d.getHeight() / 10 * g3d.getWidth() / 10];
        ImageResize.bilinearResizeRGBnA_toLow(scr, rgb2, g3d.getWidth(), g3d.getHeight(), g3d.getWidth() / 10, g3d.getHeight() / 10);
        for (int i = 0; i < rgb2.length; ++i) {
            int col = rgb2[i];
            rgb2[i] = ((col & 0xFF00FF) * 127 + 0 & 0xFF00FF00 | (col & 0xFF00) * 127 + 0 & 0xFF0000) >>> 8;
        }
        int[] rgb3 = new int[scr.length];
        ImageResize.bilinearResizeRGBnA(rgb2, rgb3, g3d.getWidth() / 10, g3d.getHeight() / 10, g3d.getWidth(), g3d.getHeight());
        rgb2 = null;
        for (int i = 0; i < scr.length; ++i) {
            int col = (scr[i] & 0xFEFEFE) + (rgb3[i] & 0xFEFEFE);
            scr[i] = col | (col >> 8 & 0x10101) * 255;
        }
        rgb3 = null;
    }

    private void damageScr(int[] scr) {
        for (int i = 0; i < scr.length; ++i) {
            scr[i] = scr[i] & 0xFFFF0000;
        }
    }

    private void deathScr(int[] scr) {
        for (int i = 0; i < scr.length; ++i) {
            int col = scr[i];
            int r = col >> 16 & 0xFF;
            int g = col >> 8 & 0xFF;
            col &= 0xFF;
            col = (r + g + col) / 3;
            scr[i] = col << 16 | col << 8 | col;
        }
    }

    protected final void pointerDragged(int x, int y) {
        if (this.paused || MainCanvas.pstros) {
            return;
        }
        this.dirX += (x - this.pointerX) * 200;
        this.dirY += (y - this.pointerY) * 200;
        this.pointerX = x;
        this.pointerY = y;
    }

    protected final void pointerReleased(int x, int y) {
        if (this.paused) {
            return;
        }
        if (MainCanvas.pstros) {
            this.keys.keyReleased(this.keys.FIRE);
            return;
        }
        this.pointerX = x;
        this.pointerY = y;
        this.dirY = 0;
        this.dirX = 0;
    }

    protected final void keyPressed(int key) {
        if (this.paused || this.firstUpdate || this.player == null) {
            return;
        }
        this.key = key;
        this.keys.keyPressed(key);
        if (this.paused) {
            QFPS.miniReset();
        } else {
            if (GameKeyboard.isSightKey(key)) {
                this.player.zoom = !this.player.zoom;
                this.player.lastZoomAction = System.currentTimeMillis();
                return;
            }
            if (key == this.keys.SOFT_RIGHT) {
                Weapon weapon = this.player.arsenal.currentWeapon();
                if (!this.player.isDead() && !this.player.canAttackNoSight() && this.player.canAttackSight() && weapon != null && weapon.hasZoom && this.player.zoom) {
                    this.player.zoom = false;
                    this.player.lastZoomAction = System.currentTimeMillis();
                } else {
                    this.openPause();
                }
            }
        }
        if (GameKeyboard.isUseKey(key) && !this.player.isDead()) {
            Matrix var4 = this.player.getCharacter().getTransform();
            this.scene.getG3D().lx = var4.m03;
            this.scene.getG3D().ly = var4.m13;
            this.scene.getG3D().lz = var4.m23;
            System.out.println(var4.m03 + "," + var4.m13 + "," + var4.m23 + ";");
            RoomObject ro = this.scene.activateObject(true, this.player, height / 2 - this.scene.getG3D().getHeight() / 2, this);
            if (ro != null) {
                return;
            }
        }
        if (GameKeyboard.isInventoryKey(key) && !this.player.isDead()) {
            if (Main.playerHasInventory) {
                this.openInventory();
            } else if (this.shopItems != null) {
                this.openShop(this.shopItems, null, null);
            }
        }
    }

    protected final void keyReleased(int key) {
        if (this.paused || this.firstUpdate || this.player == null) {
            return;
        }
        this.key = 0;
        this.keys.keyReleased(key);
    }

    public final void run(long frameStart) {
        if (this.paused || this.player == null) {
            return;
        }
        if (this.firstUpdate) {
            this.firstUpdate = false;
            return;
        }
        if (this.run) {
            this.scene.activateObject(false, this.player, height / 2 - this.scene.getG3D().getHeight() / 2, this);
            time += (long)QFPS.frameTime;
            try {
                long sleepTime;
                Character playeChar = this.player.getCharacter();
                DirectX7 g3d = this.scene.getG3D();
                if (!playeChar.onFloor && this.wg != null) {
                    this.wg.moveY2(playeChar.getSpeed().y, QFPS.frameTime);
                }
                if (!this.player.isDead()) {
                    int forward = 0;
                    int right = 0;
                    if (this.keys.isWalkForward(this.player.zoom)) {
                        ++forward;
                        if (this.player.canWalk() && this.wg != null && !playeChar.underRoof) {
                            this.wg.move(5, QFPS.frameTime, -(g3d.camera.m12 * 90 / 16384));
                        }
                    }
                    if (this.keys.isWalkBackward(this.player.zoom)) {
                        --forward;
                        if (this.player.canWalk() && this.wg != null && !playeChar.underRoof) {
                            this.wg.moveB(5, QFPS.frameTime, -(g3d.camera.m12 * 90 / 16384));
                        }
                    }
                    if (this.player.isSwapStrafeLook() && this.keys.isWalkLeft(this.player.zoom) || !this.player.isSwapStrafeLook() && this.keys.isLookLeft(this.player.zoom)) {
                        this.player.rotLeft();
                        if (this.player.canLookY() && this.wg != null) {
                            this.wg.moveX2((!this.player.zoom ? 5 : 1) * Main.mouseSpeed / 50, QFPS.frameTime);
                        }
                    }
                    if (this.player.isSwapStrafeLook() && this.keys.isWalkRight(this.player.zoom) || !this.player.isSwapStrafeLook() && this.keys.isLookRight(this.player.zoom)) {
                        this.player.rotRight();
                        if (this.player.canLookY() && this.wg != null) {
                            this.wg.moveX2(-(!this.player.zoom ? 5 : 1) * Main.mouseSpeed / 50, QFPS.frameTime);
                        }
                    }
                    if (!this.player.isSwapStrafeLook() && this.keys.isWalkLeft(this.player.zoom) || this.player.isSwapStrafeLook() && this.keys.isLookLeft(this.player.zoom)) {
                        --right;
                        if (this.player.canWalk() && this.wg != null) {
                            this.wg.moveX(5, QFPS.frameTime);
                        }
                    }
                    if (!this.player.isSwapStrafeLook() && this.keys.isWalkRight(this.player.zoom) || this.player.isSwapStrafeLook() && this.keys.isLookRight(this.player.zoom)) {
                        ++right;
                        if (this.player.canWalk() && this.wg != null) {
                            this.wg.moveX(-5, QFPS.frameTime);
                        }
                    }
                    if (right != 0 || forward != 0) {
                        this.player.walk(right, forward);
                    }
                    Weapon weapon = this.player.arsenal.currentWeapon();
                    if (this.keys.isPlayerShooting()) {
                        if (!this.player.canAttackNoSight() && this.player.canAttackSight() && weapon != null && weapon.hasZoom && !this.player.zoom) {
                            this.player.zoom = true;
                            this.player.lastZoomAction = System.currentTimeMillis();
                            this.keys.releasePlayerShoot();
                        } else {
                            this.player.fire(g3d);
                        }
                    }
                    if (this.keys.isLookDown(this.player.zoom)) {
                        this.player.rotDown();
                        if (this.player.canLookX() && this.wg != null) {
                            this.wg.moveY(-(!this.player.zoom ? 4 : 3) * Main.mouseSpeed / 50, QFPS.frameTime);
                        }
                    }
                    if (this.keys.isLookUp(this.player.zoom)) {
                        this.player.rotUp();
                        if (this.player.canLookX() && this.wg != null) {
                            this.wg.moveY((!this.player.zoom ? 4 : 3) * Main.mouseSpeed / 50, QFPS.frameTime);
                        }
                    }
                    if (GameKeyboard.isJumpKey(this.key)) {
                        this.player.jump();
                    }
                    if (GameKeyboard.isNextWeaponKey(this.key)) {
                        this.key = 0;
                        this.player.nextWeapon();
                        this.changed = true;
                    }
                    if (GameKeyboard.isPreviousWeaponKey(this.key)) {
                        this.key = 0;
                        this.player.previousWeapon();
                        this.changed = true;
                    }
                    if (this.dirX != 0 || this.dirY != 0) {
                        int rotSpeed;
                        if (this.dirY != 0) {
                            rotSpeed = this.dirY * -(!this.player.zoom ? 2 : 1) * Main.mouseSpeed / 50 / height;
                            this.player.rotXn(rotSpeed);
                            if (this.wg != null) {
                                this.wg.moveY(rotSpeed, QFPS.frameTime);
                            }
                            if (this.dirY == 1) {
                                this.dirY = 0;
                            }
                            this.dirY /= 2;
                        }
                        if (this.dirX != 0) {
                            rotSpeed = this.dirX * -(!this.player.zoom ? 4 : 2) * Main.mouseSpeed / 50 / height;
                            this.player.rotYn(rotSpeed);
                            if (this.wg != null) {
                                this.wg.moveX2(rotSpeed, QFPS.frameTime);
                            }
                            if (this.dirX == 1) {
                                this.dirX = 0;
                            }
                            this.dirX /= 2;
                        }
                    }
                }
                if (this.player.isTimeToRenew()) {
                    this.paused = true;
                    this.restartGame();
                    return;
                }
                if (!delayDialogs.isEmpty()) {
                    for (int i = 0; i < delayDialogs.size(); ++i) {
                        if (!((DelayedDialog)delayDialogs.elementAt(i)).update(this)) continue;
                        delayDialogs.removeElementAt(i);
                    }
                }
                this.scene.update(this.player, this);
                if (this.scene.getFrame() % 2 == 0) {
                    if (this.msToEnd == 0 && this.scene.isLevelCompleted(this.player)) {
                        this.msToEnd = 1;
                    }
                    if (this.msToExit == 0 && this.scene.isWinner(this.player)) {
                        this.msToExit = 1;
                    }
                }
                if (this.msToEnd > 0) {
                    this.msToEnd += QFPS.frameTime;
                    if (this.scene.exitWithoutWait) {
                        this.msToEnd = Integer.MAX_VALUE;
                    }
                }
                if (this.msToExit > 0) {
                    this.msToExit += QFPS.frameTime;
                    if (this.scene.exitWithoutWait) {
                        this.msToExit = Integer.MAX_VALUE;
                    }
                }
                if (this.msToEnd > 3000) {
                    this.changed = true;
                    if (!Main.isLastLevel(this.levelNumber)) {
                        if (this.scene.getFinishPoint() != null) {
                            this.loadLevel(this.levelNumber + 1, this.scene.getFinishPoint(), true, this.fullMoveLvl, true);
                        }
                    } else {
                        this.gameEnd();
                    }
                    return;
                }
                if (!this.changed) {
                    Weapon weapon = this.player.arsenal.currentWeapon();
                    boolean bl = this.changed = this.player.getHp() != this.lastHP || this.player.money != this.lastMoney || this.player.frags != this.lastFrags;
                    if (weapon != null) {
                        this.changed |= weapon.getRounds() != this.lastAmmo;
                    }
                    if (this.changed) {
                        this.lastHP = this.player.getHp();
                        if (weapon != null) {
                            this.lastAmmo = weapon.getRounds();
                        }
                        this.lastMoney = this.player.money;
                        this.lastFrags = this.player.frags;
                    }
                }
                if ((sleepTime = 15L - (System.currentTimeMillis() - frameStart)) < 1L) {
                    sleepTime = 1L;
                }
                if (Main.frameskip || QFPS.frameTime < 15) {
                    Thread.sleep(sleepTime);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public final void start() {
        this.changed = true;
        this.run = true;
        QFPS.reset();
    }

    public void startMus(long t) {
        try {
            if (Main.musicPlayer.hasPlayer()) {
                Main.musicPlayer.setVolume(Main.music);
                Main.musicPlayer.start(t);
            }
            QFPS.miniReset();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void stop() {
        this.run = false;
    }

    private void stopMus() {
        if (Main.musicPlayer.hasPlayer()) {
            Main.musicPlayer.stop();
        }
    }

    public void destroyMusic() {
        if (Main.musicPlayer.hasPlayer()) {
            Main.musicPlayer.destroy();
        }
    }

    public void init() {
        try {
            if (Main.isMusic && Main.music != 0) {
                if (!Main.musicPlayer.hasPlayer()) {
                    Main.musicPlayer.loadFile(mus);
                }
                QFPS.miniReset();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void sizeChanged(int w, int h) {
        width = w;
        height = h;
        this.scene.getG3D().resize(width, (int)((float)height * ((float)Main.getDisplaySize() / 100.0f)));
    }

    public void showDialog(String str) {
        QFPS.miniReset();
        this.keys.reset();
        this.stop();
        this.run = false;
        this.dialogScreen.set(str, this.font, this.scene.getG3D(), this.main, this);
        Main.setCurrentRepaint(this.dialogScreen);
    }

    public final void openShop(int[] items, String[] files, int[] prices) {
        QFPS.miniReset();
        this.stop();
        this.run = false;
        Main.setCurrent(new Shop(this.main, this, this.player, items, files, prices));
    }

    public final void openInventory() {
        QFPS.miniReset();
        this.stop();
        this.run = false;
        Main.setCurrent(new InventoryScreen(this.main, this, this.player));
    }

    public void loadLevel(int lvl, Vector3D stp, boolean stopMus, boolean changePos, boolean showLoad) {
        if (this.player == null) {
            return;
        }
        this.main.addAvailableLevel(lvl - 1);
        if (this.newPos != null && stp != null && this.player != null && this.player.getCharacter().getTransform() != null) {
            if (changePos) {
                this.player.getCharacter().getTransform().setPosition(this.newPos);
            } else {
                this.player.getCharacter().getTransform().subPosition(stp.x, stp.y, stp.z);
                this.player.getCharacter().getTransform().addPosition(this.newPos);
            }
        }
        Main.saveGame(lvl, this.player, this.scene);
        Main.saveObjects(this.levelNumber, this.player, this.scene);
        this.stop();
        if (stopMus) {
            this.stopMus();
        }
        this.destroy(stopMus);
        if (GameHelp.needToShow(this.levelNumber, 1, true)) {
            Main.setCurrent(new GameHelp(this.main, null, this.levelNumber, true, this.hudInfo, 1, showLoad));
        } else {
            Main.loadLevel(true, true, lvl, this.hudInfo, this.main, null, 1, showLoad);
        }
    }

    public void restartGame() {
        this.stop();
        this.msToExit = 0;
        this.msToEnd = 0;
        this.scene.reset();
        this.player.setPart(-1);
        time = 0L;
        this.player.set(this.scene.getG3D().getWidth(), this.scene.getG3D().getHeight(), this.scene.getStartPoint(), this.hudInfo, this.scene.camPose);
        if (Main.getContinueLevel() == this.levelNumber) {
            Main.loadGame(this.player, width, height, this.scene);
            this.scene.getG3D().updateFov((int)this.player.fov);
            Main.loadPosition(this.player);
            Main.loadObjects(this.player, width, height, this.scene, this.levelNumber);
        } else {
            Player.usedPoints.removeAllElements();
            Main.loadGame(this.player, width, height, this.scene);
            this.scene.getG3D().updateFov((int)this.player.fov);
            Main.loadObjects(this.player, width, height, this.scene, Main.getContinueLevel());
        }
        this.player.copyNewToUsed();
        this.scene.getHouse().addObject(this.player);
        LevelLoader.loadObjects(levelFile, this.levelIni, this.scene, this.player, true);
        this.scene.deleteUsedObjects(this.player);
        this.scene.removeKilledBots();
        this.lookAtObj = null;
        this.paused = false;
        delayDialogs.removeAllElements();
        this.start();
        this.stopMus();
        this.startMus(0L);
    }

    public final void openPause() {
        this.paused = true;
        if (Main.musicPlayer.hasPlayer()) {
            this.musTime = Main.musicPlayer.getTime();
            this.stopMus();
        }
        this.stop();
        QFPS.miniReset();
        Main.setCurrent(new PauseScreen(this.main, this, this.scene.getG3D().getDisplay(), this.musTime));
    }

    public void gameEnd() {
        this.stopMus();
        GUIScreen scr = GameHelp.needToShow(this.levelNumber, 1, true) ? new GameHelp(this.main, null, this.levelNumber, true, this.hudInfo, 1, true) : (TitleScreen.hasTitleScreen() ? new TitleScreen(this.main, null) : new Menu(this.main));
        Main.setCurrent(scr);
    }

    public void openTitleScreenScript() {
        if (TitleScreen.hasTitleScreen()) {
            this.stopMus();
            Main.setCurrent(new TitleScreen(this.main, null));
        }
    }

    public final void resize() {
        try {
            this.imgSight = !Main.originalSight ? (!Main.fullScreenSight ? this.createImage2(Main.sight_icon) : ImageResize.createImage(Main.sight_icon, width, height * Main.displaySize / 100)) : Image.createImage((String)Main.sight_icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.player.arsenal.currentWeapon() != null) {
            this.player.arsenal.currentWeapon().reset();
        }
    }

    public void runScriptFromFile(String path) {
        this.runScriptFromFile(path, this.player);
    }

    public void runScriptFromFile(String path, RoomObject obj) {
        String[] script = LevelLoader.createScript(StringTools.getStringFromResource(path));
        obj.give(script, this.player, this.scene.getHouse(), this);
    }

    public void runScript(String[] script) {
        this.runScript(script, this.player);
    }

    public void runScript(String[] script, RoomObject obj) {
        obj.give(script, this.player, this.scene.getHouse(), this);
    }

    public boolean readBooleanFromScript(String val) {
        return RoomObject.readBoolean(val, this.player, this.scene.getHouse(), this, this.player);
    }

    static {
        lines = new Vector();
        mus = "/music.mid";
        levelFile = "/level_1.txt";
        delayDialogs = new Vector();
        bloom = false;
    }
}

