/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay;

import code.AI.Player;
import code.Gameplay.GameScreen;
import code.Gameplay.Weapon;
import code.HUD.Base.Font;
import code.HUD.GUIScreen;
import code.utils.GameIni;
import code.utils.ImageResize;
import code.utils.IniFile;
import code.utils.Main;
import code.utils.WeaponCreator;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Shop
extends GUIScreen {
    public static int weaponCount = 0;
    public static String[] defaultFiles;
    public static int[] defaultPrices;
    public static int[] defaultItems;
    private static boolean proportionalShop;
    public static int[] defaultArsenal;
    public static int[] defaultArsenalAmmo;
    private static boolean side;
    private static long sideAnimTime;
    private static boolean paint;
    private GameScreen gameScreen;
    private Player player;
    private Image iconItem;
    private Image iconPatron;
    private int[] items;
    private String[] files;
    private int[] prices;
    private int index;
    private long sideAnimBegin = 0L;
    private int sideAnimOld = 0;

    public static void initShop() {
        GameIni settings = Main.settings;
        boolean exists = Main.isExist("/weapons.txt");
        if (settings.get("DEFAULT_ARSENAL") != null) {
            defaultArsenal = GameIni.cutOnInts(settings.get("DEFAULT_ARSENAL"), ',', ';');
        } else if (exists) {
            defaultArsenal = new int[1];
            Shop.defaultArsenal[0] = 0;
        } else {
            defaultArsenal = new int[1];
            Shop.defaultArsenal[0] = -1;
        }
        if (settings.get("DEFAULT_ARSENAL_AMMO") != null) {
            defaultArsenalAmmo = GameIni.cutOnInts(settings.get("DEFAULT_ARSENAL_AMMO"), ',', ';');
        }
        if (exists) {
            Object[] tmp = GameIni.createGroups("/weapons.txt");
            String[] names = (String[])tmp[0];
            GameIni[] groups = (GameIni[])tmp[1];
            weaponCount = names.length;
            defaultFiles = new String[weaponCount + 1];
            defaultPrices = new int[weaponCount + 1];
            defaultItems = new int[weaponCount + 1];
            for (int i = 0; i < weaponCount; ++i) {
                GameIni obj = groups[i];
                Shop.defaultFiles[i] = obj.get("SHOP_IMAGE");
                Shop.defaultPrices[i] = obj.getInt("PRICE", 0);
                Shop.defaultItems[i] = i;
            }
        } else {
            weaponCount = 1;
            defaultFiles = new String[2];
            defaultPrices = new int[2];
            defaultItems = new int[]{0, -1};
        }
        Shop.defaultFiles[Shop.weaponCount] = Main.shop_medkit;
        Shop.defaultPrices[Shop.weaponCount] = settings.getInt("PRICE_MEDICINE_CHEST");
        Shop.defaultItems[Shop.weaponCount] = -1;
        if (settings.getInt("SHOP_PROPORTIONAL", 1) == 0) {
            proportionalShop = false;
        }
    }

    public Shop(Main main, GameScreen gameScreen, Player player, int[] items, String[] files, int[] prices) {
        this.gameScreen = gameScreen;
        this.player = player;
        this.items = items;
        this.files = files;
        this.prices = prices;
        this.setMissingData();
        IniFile lang = Main.getGameText();
        this.set(Main.getFont(), lang.get("BUY"), lang.get("BACK"));
        this.iconPatron = ImageResize.createImageProportional(Main.shop_patron, (float)this.getWidth() / 240.0f, (float)this.getHeight() / 320.0f);
        this.setImage();
        this.inverseHScroll = true;
        this.inverseVScroll = true;
    }

    private void setMissingData() {
        int idx;
        int i;
        if (this.items == null) {
            this.items = defaultItems;
            if (this.files == null) {
                this.files = defaultFiles;
            }
            if (this.prices == null) {
                this.prices = defaultPrices;
            }
            return;
        }
        if (this.files == null) {
            this.files = new String[this.items.length];
            for (i = 0; i < this.files.length; ++i) {
                idx = this.items[i];
                if (idx == -1) {
                    idx = defaultFiles.length - 1;
                }
                this.files[i] = defaultFiles[idx];
            }
        }
        if (this.prices == null) {
            this.prices = new int[this.items.length];
            for (i = 0; i < this.prices.length; ++i) {
                idx = this.items[i];
                if (idx == -1) {
                    idx = defaultPrices.length - 1;
                }
                this.prices[i] = defaultPrices[idx];
            }
        }
    }

    public final void destroy() {
        super.destroy();
        this.iconPatron = null;
        this.iconItem = null;
        this.player = null;
    }

    private void setImage() {
        String path = this.files[this.index];
        if (Main.getGameText().get(path) != null) {
            path = Main.getGameText().get(path);
        }
        this.iconItem = proportionalShop ? ImageResize.createImageProportional(path, (float)this.getWidth() / 240.0f, (float)this.getHeight() / 320.0f) : ImageResize.createImage(path, this.getWidth(), this.getHeight());
    }

    private boolean isMedkit() {
        return this.items[this.index] == -1;
    }

    private boolean isAllowedToBuy() {
        if (this.isMedkit()) {
            return this.player.getHp() < 100;
        }
        Weapon[] weapons = this.player.arsenal.getWeapons();
        Weapon weapon = weapons[this.items[this.index]];
        return weapon == null || weapon.patronbuy;
    }

    private int price() {
        Weapon[] weapons;
        Weapon weapon;
        int price = this.prices[this.index];
        if (!this.isMedkit() && (weapon = (weapons = this.player.arsenal.getWeapons())[this.items[this.index]]) != null) {
            price = weapon.patronbuy ? (int)((float)price * weapon.ammoPriceFactor) : Integer.MAX_VALUE;
        }
        return price;
    }

    protected final void paint(Graphics g) {
        int coof;
        paint = true;
        int w = this.getWidth();
        int h = this.getHeight();
        int n = coof = Main.verticalShopScroll ? h : w;
        if (System.currentTimeMillis() - this.sideAnimBegin < sideAnimTime && sideAnimTime != 0L) {
            coof = (int)((System.currentTimeMillis() - this.sideAnimBegin) * (long)coof / sideAnimTime);
        }
        if (coof < w && !Main.verticalShopScroll) {
            if (!side) {
                g.setClip(this.sideAnimOld, 0, coof - this.sideAnimOld, h);
            }
            if (side) {
                g.setClip(w - coof, 0, coof - this.sideAnimOld, h);
            }
        } else if (coof < h && Main.verticalShopScroll) {
            if (!side) {
                g.setClip(0, this.sideAnimOld, w, coof - this.sideAnimOld);
            }
            if (side) {
                g.setClip(0, h - coof, w, coof - this.sideAnimOld);
            }
        } else {
            g.setClip(0, 0, w, h);
        }
        g.setColor(0);
        g.fillRect(0, 0, w, h);
        IniFile lang = Main.getGameText();
        if (!this.isAllowedToBuy()) {
            this.setLeftSoft("");
        } else {
            this.setLeftSoft(lang.get(this.player.money >= this.price() ? "BUY" : "NOTENOUGHMONEY"));
        }
        int arWidth = w / 34;
        int arHeight = h / 34;
        if (!Main.verticalShopScroll) {
            this.drawArrow(g, 4, h / 4, arWidth + 4, h / 4 - arHeight / 2, arWidth + 4, h / 4 + arHeight / 2);
            this.drawArrow(g, w - 4, h / 4, w - 4 - arWidth, h / 4 - arHeight / 2, w - 4 - arWidth, h / 4 + arHeight / 2);
        }
        Font font = this.getFont();
        font.drawString(g, lang.get("MONEY") + ":" + this.player.money, w - 2, 2, 24);
        g.drawImage(this.iconItem, w / 2, h / 2, 3);
        boolean printPrice = true;
        if (!this.isMedkit() && this.player.arsenal.getWeapons()[this.items[this.index]] != null) {
            if (!this.player.arsenal.getWeapons()[this.items[this.index]].patronbuy) {
                printPrice = false;
            } else {
                g.drawImage(this.iconPatron, w / 2 - this.iconItem.getWidth() / 2, h / 2 + this.iconItem.getHeight() / 2, 36);
            }
        }
        if (lang.get("CENA") != null && printPrice) {
            font.drawString(g, lang.get("CENA") + ":" + this.price(), w / 2, h / 2 + this.iconItem.getHeight() / 2 + 2, 17);
        }
        this.drawSoftKeys(g);
        this.sideAnimOld = coof;
        if (coof < w && !Main.verticalShopScroll || coof < h && Main.verticalShopScroll) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.repaint();
        } else {
            paint = false;
            this.dragIgnore = false;
        }
    }

    private void drawArrow(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3) {
        int miny = Math.min(y1, Math.min(y2, y3));
        int maxy = Math.max(y1, Math.max(y2, y3));
        int sizey = (maxy - miny) / 3;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int price = this.price();
        for (int i = 0; i < sizey; ++i) {
            int brightness;
            if (this.player.money >= price) {
                brightness = Math.min(255, i * 255 / sizey);
                g.setColor(brightness, brightness, brightness);
            } else {
                brightness = Math.min(255, i * 255 / sizey);
                g.setColor(brightness, 0, 0);
            }
            g.setClip(clipX, Math.max(clipY, miny + (maxy - miny) * i / sizey), clipWidth, Math.min(clipHeight, maxy));
            g.fillTriangle(x1, y1, x2, y2, x3, y3);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected final void onRightSoftKey() {
        try {
            this.destroy();
            System.gc();
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gameScreen.start();
        Main.setCurrent(this.gameScreen);
        this.gameScreen = null;
    }

    protected final void onLeftSoftKey() {
        if (this.player.money < this.price()) {
            return;
        }
        if (this.isMedkit()) {
            if (this.player.getHp() < 100) {
                this.player.pay(this.price());
                this.player.setHp(100);
                if (!paint) {
                    this.repaint();
                }
            }
        } else {
            int weaponIdx = this.items[this.index];
            Weapon[] weapons = this.player.arsenal.getWeapons();
            Weapon weapon = weapons[weaponIdx];
            if (weapon == null) {
                this.player.pay(this.price());
                weapon = WeaponCreator.createWeapon(weaponIdx);
                weapon.setAmmo(weapon.ammoBundled);
                weapons[weaponIdx] = weapon;
                int playerWeapon = this.player.arsenal.current;
                if (playerWeapon == -1 || weapons[playerWeapon].getDamageValue() < weapon.getDamageValue()) {
                    this.player.arsenal.current = weaponIdx;
                }
                if (!paint) {
                    this.repaint();
                }
            } else {
                this.player.pay(this.price());
                weapon.addAmmo(weapon.ammoInShop);
                if (!paint) {
                    this.repaint();
                }
            }
        }
    }

    protected final void onKey6() {
        if (Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        ++this.index;
        this.index %= this.files.length;
        this.setImage();
        side = true;
        this.sideAnimBegin = System.currentTimeMillis();
        this.sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey4() {
        if (Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        --this.index;
        if (this.index < 0) {
            this.index += this.files.length;
        }
        this.setImage();
        side = false;
        this.sideAnimBegin = System.currentTimeMillis();
        this.sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey8() {
        if (!Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        ++this.index;
        this.index %= this.files.length;
        this.setImage();
        side = true;
        this.sideAnimBegin = System.currentTimeMillis();
        this.sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey2() {
        if (!Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        --this.index;
        if (this.index < 0) {
            this.index += this.files.length;
        }
        this.setImage();
        side = false;
        this.sideAnimBegin = System.currentTimeMillis();
        this.sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    static {
        proportionalShop = true;
        defaultArsenal = null;
        defaultArsenalAmmo = null;
        side = false;
        sideAnimTime = 130L;
        paint = false;
    }
}

