/*
 * Decompiled with CFR 0.152.
 */
package code.HUD;

import code.HUD.Base.TextView;
import code.HUD.GUIScreen;
import code.HUD.Menu;
import code.utils.Main;
import javax.microedition.lcdui.Graphics;

public class TitleScreen
extends GUIScreen {
    Main main;
    Menu menu;
    TextView text;
    int pixelsPerSec;
    int w;
    int h;
    long start;

    public TitleScreen(Main main, Menu menu) {
        this.main = main;
        this.menu = menu;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.setFont(Main.getFont());
        this.setSoftKeysNames(null, null);
        this.text = new TextView(Main.getGameText().get("TITLE_SCREEN_TEXT"), this.w, this.h, Main.getFont());
        this.text.setCenter(true);
        this.pixelsPerSec = Main.settings.getInt("TITLE_SCREEN_SPEED", 10);
        String music = Main.settings.get("TITLE_SCREEN_MUSIC");
        if (Main.isMusic && music != null) {
            Main.musicPlayer.loadFile(music);
            Main.musicPlayer.setVolume(Main.music);
            Main.musicPlayer.start();
        }
        this.start = System.currentTimeMillis();
    }

    protected final void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(0xFFFFFF);
        int y = this.h - (int)((System.currentTimeMillis() - this.start) * (long)this.pixelsPerSec / 1000L);
        this.text.setY(y);
        this.text.paint(g, 0, 0);
        if (y == -this.text.getTextHeight()) {
            this.onRightSoftKey();
            return;
        }
        try {
            Thread.sleep(5L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    protected final void onRightSoftKey() {
        if (Main.musicPlayer.hasPlayer()) {
            Main.musicPlayer.stop();
        }
        if (this.menu == null) {
            this.menu = new Menu(this.main);
        }
        Main.setCurrent(this.menu);
    }

    public static boolean hasTitleScreen() {
        return Main.getGameText().get("TITLE_SCREEN_TEXT") != null;
    }
}

