/*
 * Decompiled with CFR 0.152.
 */
package cn.agrj.rsRk.zip;

import cn.agrj.rsRk.zip.DeflaterEngine;
import cn.agrj.rsRk.zip.PendingBuffer;

public class Deflater {
    private int level;
    private int state;
    private int totalOut;
    private boolean noHeader;
    private PendingBuffer pending = new PendingBuffer(65536);
    private DeflaterEngine engine = new DeflaterEngine(this.pending);
    static int num = 0;

    public Deflater(int lvl, boolean nowrap) {
        this.noHeader = nowrap;
        this.engine.setStrategy(0);
        this.setLevel(lvl);
        this.reset();
    }

    public void reset() {
        this.state = this.noHeader ? 16 : 0;
        this.totalOut = 0;
        this.pending.reset();
        this.engine.reset();
    }

    public int getTotalOut() {
        return this.totalOut;
    }

    void flush() {
        this.state |= 4;
    }

    public void finish() {
        this.state |= 0xC;
    }

    public boolean finished() {
        return this.state == 30 && this.pending.isFlushed();
    }

    public boolean needsInput() {
        return this.engine.needsInput();
    }

    public void setInput(byte[] input, int off, int len) {
        this.engine.setInput(input, off, len);
    }

    public void setLevel(int lvl) {
        if (this.level != lvl) {
            this.level = lvl;
            this.engine.setLevel(lvl);
        }
    }

    private void writeHead() {
        int header = 30720;
        int level_flags = this.level - 1 >> 1;
        if (level_flags < 0 || level_flags > 3) {
            level_flags = 3;
        }
        header |= level_flags << 6;
        if ((this.state & 1) != 0) {
            header |= 0x20;
        }
        header += 31 - header % 31;
        this.pending.writeShortMSB(header);
        if ((this.state & 1) != 0) {
            int chksum = this.engine.getAdler();
            this.engine.resetAdler();
            this.pending.writeShortMSB(chksum >> 16);
            this.pending.writeShortMSB(chksum & 0xFFFF);
        }
        this.state = 0x10 | this.state & 0xC;
    }

    public int deflate(byte[] output, int offset, int length) {
        int origLength = length;
        if (this.state < 16) {
            this.writeHead();
        }
        while (true) {
            int count = this.pending.flush(output, offset, length);
            offset += count;
            this.totalOut += count;
            if ((length -= count) == 0 || this.state == 30) break;
            if (this.engine.deflate((this.state & 4) != 0, (this.state & 8) != 0)) continue;
            if (this.state == 16) {
                return origLength - length;
            }
            if (this.state == 20) {
                if (this.level != 0) {
                    count = 8 + (-this.pending.getBitCount() & 7);
                    while (count > 0) {
                        this.pending.writeBits(2, 10);
                        count -= 10;
                    }
                }
                this.state = 16;
                continue;
            }
            if (this.state != 28) continue;
            this.pending.alignToByte();
            if (!this.noHeader) {
                count = this.engine.getAdler();
                this.pending.writeShortMSB(count >> 16);
                this.pending.writeShortMSB(count & 0xFFFF);
            }
            this.state = 30;
        }
        return origLength - length;
    }
}

