/*
 * Decompiled with CFR 0.152.
 */
package cn.agrj.rsRk.zip;

import cn.agrj.rsRk.zip.DeflaterHuffman;
import cn.agrj.rsRk.zip.PendingBuffer;

class HuffmanTree {
    short[] freqs;
    short[] codes;
    byte[] length;
    int[] bl_counts;
    int minNumCodes;
    int numCodes;
    int maxLength;
    int frelen;
    PendingBuffer ping;

    HuffmanTree(int elems, int minCodes, int maxL, PendingBuffer pen) {
        this.ping = pen;
        this.minNumCodes = minCodes;
        this.maxLength = maxL;
        this.frelen = elems;
        this.freqs = new short[elems];
        this.bl_counts = new int[maxL];
    }

    public int getEncodedLength() {
        int len = 0;
        int i = 0;
        while (i < this.frelen) {
            len += this.freqs[i] * this.length[i];
            ++i;
        }
        return len;
    }

    public void reset() {
        int i = this.frelen - 1;
        while (i >= 0) {
            this.freqs[i] = 0;
            --i;
        }
        this.codes = null;
        this.length = null;
    }

    public void writeSymbol(int code) {
        this.ping.writeBits(this.codes[code] & 0xFFFF, this.length[code]);
    }

    public void setStaticCodes(short[] stCodes, byte[] stLength) {
        this.codes = stCodes;
        this.length = stLength;
    }

    public void buildCodes() {
        int[] nextCode = new int[this.maxLength];
        int code = 0;
        this.codes = new short[this.frelen];
        int bits = 0;
        while (bits < this.maxLength) {
            nextCode[bits] = code;
            code += this.bl_counts[bits] << 15 - bits;
            ++bits;
        }
        int i = 0;
        while (i < this.numCodes) {
            byte bits2 = this.length[i];
            if (bits2 > 0) {
                this.codes[i] = DeflaterHuffman.bitReverse(nextCode[bits2 - 1]);
                int n = bits2 - 1;
                nextCode[n] = nextCode[n] + (1 << 16 - bits2);
            }
            ++i;
        }
    }

    private void buildLength(int[] childs, int len) {
        this.length = new byte[this.frelen];
        int numNodes = len / 2;
        int numLeafs = (numNodes + 1) / 2;
        int overflow = 0;
        int i = 0;
        while (i < this.maxLength) {
            this.bl_counts[i] = 0;
            ++i;
        }
        int[] lengths = new int[numNodes];
        lengths[numNodes - 1] = 0;
        int i2 = numNodes - 1;
        while (i2 >= 0) {
            int bitLength;
            if (childs[2 * i2 + 1] != -1) {
                bitLength = lengths[i2] + 1;
                if (bitLength > this.maxLength) {
                    bitLength = this.maxLength;
                    ++overflow;
                }
                int n = bitLength;
                lengths[childs[2 * i2 + 1]] = n;
                lengths[childs[2 * i2]] = n;
            } else {
                bitLength = lengths[i2];
                int n = bitLength - 1;
                this.bl_counts[n] = this.bl_counts[n] + 1;
                this.length[childs[2 * i2]] = (byte)lengths[i2];
            }
            --i2;
        }
        if (overflow == 0) {
            return;
        }
        int incrBitLen = this.maxLength - 1;
        while (true) {
            if (this.bl_counts[--incrBitLen] == 0) {
                continue;
            }
            do {
                int n = incrBitLen++;
                this.bl_counts[n] = this.bl_counts[n] - 1;
                int n2 = incrBitLen;
                this.bl_counts[n2] = this.bl_counts[n2] + 1;
            } while ((overflow -= 1 << this.maxLength - 1 - incrBitLen) > 0 && incrBitLen < this.maxLength - 1);
            if (overflow <= 0) break;
        }
        int n = this.maxLength - 1;
        this.bl_counts[n] = this.bl_counts[n] + overflow;
        int n3 = this.maxLength - 2;
        this.bl_counts[n3] = this.bl_counts[n3] - overflow;
        int nodePtr = 2 * numLeafs;
        int bits = this.maxLength;
        while (bits != 0) {
            int n4 = this.bl_counts[bits - 1];
            while (n4 > 0) {
                int childPtr;
                if (childs[(childPtr = 2 * childs[nodePtr++]) + 1] != -1) continue;
                this.length[childs[childPtr]] = (byte)bits;
                --n4;
            }
            --bits;
        }
    }

    public void buildTree() {
        int numSymbols = this.frelen;
        int[] heap = new int[numSymbols];
        int heapLen = 0;
        int maxCode = 0;
        int n = 0;
        while (n < numSymbols) {
            short freq = this.freqs[n];
            if (freq != 0) {
                int ppos;
                int pos = heapLen++;
                while (pos > 0 && this.freqs[heap[ppos = (pos - 1) / 2]] > freq) {
                    heap[pos] = heap[ppos];
                    pos = ppos;
                }
                heap[pos] = n;
                maxCode = n;
            }
            ++n;
        }
        while (heapLen < 2) {
            int n2 = heap[heapLen++] = maxCode < 2 ? ++maxCode : 0;
        }
        this.numCodes = Math.max(maxCode + 1, this.minNumCodes);
        int childlen = 4 * heapLen - 2;
        int[] childs = new int[childlen];
        int[] values = new int[2 * heapLen - 1];
        int numNodes = heapLen;
        int i = 0;
        while (i < heapLen) {
            int node;
            childs[2 * i] = node = heap[i];
            childs[2 * i + 1] = -1;
            values[i] = this.freqs[node] << 8;
            heap[i] = i;
            ++i;
        }
        do {
            int first = heap[0];
            int last = heap[--heapLen];
            int ppos = 0;
            int path = 1;
            while (path < heapLen) {
                if (path + 1 < heapLen && values[heap[path]] > values[heap[path + 1]]) {
                    ++path;
                }
                heap[ppos] = heap[path];
                ppos = path;
                path = path * 2 + 1;
            }
            int lastVal = values[last];
            while ((path = ppos) > 0 && values[heap[ppos = (path - 1) / 2]] > lastVal) {
                heap[path] = heap[ppos];
            }
            heap[path] = last;
            int second = heap[0];
            last = numNodes++;
            childs[2 * last] = first;
            childs[2 * last + 1] = second;
            int mindepth = Math.min(values[first] & 0xFF, values[second] & 0xFF);
            values[last] = lastVal = values[first] + values[second] - mindepth + 1;
            ppos = 0;
            path = 1;
            while (path < heapLen) {
                if (path + 1 < heapLen && values[heap[path]] > values[heap[path + 1]]) {
                    ++path;
                }
                heap[ppos] = heap[path];
                ppos = path;
                path = ppos * 2 + 1;
            }
            while ((path = ppos) > 0 && values[heap[ppos = (path - 1) / 2]] > lastVal) {
                heap[path] = heap[ppos];
            }
            heap[path] = last;
        } while (heapLen > 1);
        this.buildLength(childs, childlen);
    }

    public void calcBLFreq(HuffmanTree blTree) {
        byte curlen = -1;
        int i = 0;
        while (i < this.numCodes) {
            int max_count;
            int count = 1;
            byte nextlen = this.length[i];
            if (nextlen == 0) {
                max_count = 138;
            } else {
                max_count = 6;
                if (curlen != nextlen) {
                    byte by = nextlen;
                    blTree.freqs[by] = (short)(blTree.freqs[by] + 1);
                    count = 0;
                }
            }
            curlen = nextlen;
            ++i;
            while (i < this.numCodes && curlen == this.length[i]) {
                ++i;
                if (++count >= max_count) break;
            }
            if (count < 3) {
                byte by = curlen;
                blTree.freqs[by] = (short)(blTree.freqs[by] + count);
                continue;
            }
            if (curlen != 0) {
                blTree.freqs[16] = (short)(blTree.freqs[16] + 1);
                continue;
            }
            if (count <= 10) {
                blTree.freqs[17] = (short)(blTree.freqs[17] + 1);
                continue;
            }
            blTree.freqs[18] = (short)(blTree.freqs[18] + 1);
        }
    }

    public void writeTree(HuffmanTree blTree) {
        byte curlen = -1;
        int i = 0;
        while (i < this.numCodes) {
            int max_count;
            int count = 1;
            byte nextlen = this.length[i];
            if (nextlen == 0) {
                max_count = 138;
            } else {
                max_count = 6;
                if (curlen != nextlen) {
                    blTree.writeSymbol(nextlen);
                    count = 0;
                }
            }
            curlen = nextlen;
            ++i;
            while (i < this.numCodes && curlen == this.length[i]) {
                ++i;
                if (++count >= max_count) break;
            }
            if (count < 3) {
                while (count-- > 0) {
                    blTree.writeSymbol(curlen);
                }
                continue;
            }
            if (curlen != 0) {
                blTree.writeSymbol(16);
                this.ping.writeBits(count - 3, 2);
                continue;
            }
            if (count <= 10) {
                blTree.writeSymbol(17);
                this.ping.writeBits(count - 3, 3);
                continue;
            }
            blTree.writeSymbol(18);
            this.ping.writeBits(count - 11, 7);
        }
    }
}

