/*
 * Decompiled with CFR 0.152.
 */
package cn.agrj.rsRk.zip;

public class CRC32 {
    private int crc = 0;
    private static int[] crc_table;

    private static int[] make_crc_table() {
        int[] ctab = new int[256];
        int n = 0;
        while (n < 256) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            ctab[n] = c;
            ++n;
        }
        return ctab;
    }

    public CRC32() {
        if (crc_table == null) {
            crc_table = CRC32.make_crc_table();
        }
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset() {
        this.crc = 0;
    }

    public void update(byte[] buf, int off, int len) {
        int c = ~this.crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        this.crc = ~c;
    }
}

