/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private int maxDelimCodePoint;
    private boolean hasSurrogates = false;
    private int[] delimiterCodePoints;

    private int charCount(int n) {
        return n >= 65536 ? 2 : 1;
    }

    private void setMaxDelimCodePoint() {
        int n;
        char c;
        if (this.delimiters == null) {
            this.maxDelimCodePoint = 0;
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.delimiters.length(); n += this.charCount(c)) {
            c = this.delimiters.charAt(n);
            if (c >= '\ud800' && c <= '\udbff') {
                c = this.delimiters.charAt(n);
                this.hasSurrogates = true;
            }
            if (n2 < c) {
                n2 = c;
            }
            ++n3;
        }
        this.maxDelimCodePoint = n2;
        if (this.hasSurrogates) {
            this.delimiterCodePoints = new int[n3];
            n = 0;
            int n4 = 0;
            while (n < n3) {
                c = this.delimiters.charAt(n4);
                this.delimiterCodePoints[n] = c;
                ++n;
                n4 += this.charCount(c);
            }
        }
    }

    public StringTokenizer(String string, String string2, boolean bl) {
        this.str = string;
        this.maxPosition = string.length();
        this.delimiters = string2;
        this.retDelims = bl;
        this.setMaxDelimCodePoint();
    }

    public StringTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public StringTokenizer(String string) {
        this(string, " \t\n\r\f", false);
    }

    private int skipDelimiters(int n) {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        while (!this.retDelims && n2 < this.maxPosition) {
            char c;
            if (!this.hasSurrogates) {
                c = this.str.charAt(n2);
                if (c > this.maxDelimCodePoint || this.delimiters.indexOf(c) < 0) break;
                ++n2;
                continue;
            }
            c = this.str.charAt(n2);
            if (c > this.maxDelimCodePoint || !this.isDelimiter(c)) break;
            n2 += this.charCount(c);
        }
        return n2;
    }

    private int scanToken(int n) {
        char c;
        int n2 = n;
        while (n2 < this.maxPosition) {
            if (!this.hasSurrogates) {
                c = this.str.charAt(n2);
                if (c <= this.maxDelimCodePoint && this.delimiters.indexOf(c) >= 0) break;
                ++n2;
                continue;
            }
            c = this.str.charAt(n2);
            if (c <= this.maxDelimCodePoint && this.isDelimiter(c)) break;
            n2 += this.charCount(c);
        }
        if (this.retDelims && n == n2) {
            if (!this.hasSurrogates) {
                c = this.str.charAt(n2);
                if (c <= this.maxDelimCodePoint && this.delimiters.indexOf(c) >= 0) {
                    ++n2;
                }
            } else {
                c = this.str.charAt(n2);
                if (c <= this.maxDelimCodePoint && this.isDelimiter(c)) {
                    n2 += this.charCount(c);
                }
            }
        }
        return n2;
    }

    private boolean isDelimiter(int n) {
        for (int i = 0; i < this.delimiterCodePoints.length; ++i) {
            if (this.delimiterCodePoints[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(n, this.currentPosition);
    }

    public String nextToken(String string) {
        this.delimiters = string;
        this.delimsChanged = true;
        this.setMaxDelimCodePoint();
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int n = 0;
        int n2 = this.currentPosition;
        while (n2 < this.maxPosition && (n2 = this.skipDelimiters(n2)) < this.maxPosition) {
            n2 = this.scanToken(n2);
            ++n;
        }
        return n;
    }
}

