/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

import gameboy.core.Interrupt;
import gameboy.core.driver.JoypadDriver;

public class Joypad {
    public static final int JOYP = 65280;
    private static final int GAMEBOY_CLOCK = 0x100000;
    private static final int JOYPAD_CLOCK = 16384;
    private int joyp;
    private int cycles;
    private Interrupt interrupt;
    private JoypadDriver driver;

    public Joypad(JoypadDriver driver, Interrupt interrupt) {
        this.driver = driver;
        this.interrupt = interrupt;
        this.reset();
    }

    public final void reset() {
        this.joyp = 255;
        this.cycles = 16384;
    }

    public int cycles() {
        return this.cycles;
    }

    public final void emulate(int ticks) {
        this.cycles -= ticks;
        if (this.cycles <= 0) {
            if (this.driver.isRaised()) {
                this.update();
            }
            this.cycles = 16384;
        }
    }

    public final void write(int address, int data) {
        if (address == 65280) {
            this.joyp = (this.joyp & 0xCF) + (data & 0x30);
            this.update();
        }
    }

    public final int read(int address) {
        if (address == 65280) {
            return this.joyp;
        }
        return 255;
    }

    private final void update() {
        int data = this.joyp & 0xF0;
        switch (data & 0x30) {
            case 16: {
                data |= this.driver.getButtons();
                break;
            }
            case 32: {
                data |= this.driver.getDirections();
                break;
            }
            case 48: {
                data |= 0xF;
            }
        }
        if ((this.joyp & ~data & 0xF) != 0) {
            this.interrupt.raise(16);
        }
        this.joyp = data;
    }

    public final String toString() {
        return "JOYP=" + Integer.toHexString(this.joyp);
    }
}

