/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core.cartridge;

import gameboy.core.cartridge.HuC1;
import gameboy.core.cartridge.HuC3;
import gameboy.core.cartridge.MBC;
import gameboy.core.cartridge.MBC1;
import gameboy.core.cartridge.MBC2;
import gameboy.core.cartridge.MBC3;
import gameboy.core.cartridge.MBC5;
import gameboy.core.driver.ClockDriver;

public class CartridgeFactory {
    public static final int TYPE_ROM_ONLY = 0;
    public static final int TYPE_MBC1 = 1;
    public static final int TYPE_MBC1_RAM = 2;
    public static final int TYPE_MBC1_RAM_BATTERY = 3;
    public static final int TYPE_MBC2 = 5;
    public static final int TYPE_MBC2_BATTERY = 6;
    public static final int TYPE_MBC3_RTC_BATTERY = 15;
    public static final int TYPE_MBC3_RTC_RAM_BATTERY = 16;
    public static final int TYPE_MBC3 = 17;
    public static final int TYPE_MBC3_RAM = 18;
    public static final int TYPE_MBC3_RAM_BATTERY = 19;
    public static final int TYPE_MBC5 = 25;
    public static final int TYPE_MBC5_RAM = 26;
    public static final int TYPE_MBC5_RAM_BATTERY = 27;
    public static final int TYPE_MBC5_RUMBLE = 28;
    public static final int TYPE_MBC5_RUMBLE_RAM = 29;
    public static final int TYPE_MBC5_RUMBLE_RAM_BATTERY = 30;
    public static final int TYPE_HUC3_RTC_RAM = 254;
    public static final int TYPE_HUC1_RAM_BATTERY = 255;

    public static final boolean hasCartridgeBattery(int cartridgeType) {
        return cartridgeType == 3 || cartridgeType == 6 || cartridgeType == 15 || cartridgeType == 16 || cartridgeType == 19 || cartridgeType == 27 || cartridgeType == 30 || cartridgeType == 255;
    }

    public static final String getCartridgeDescription(int cartridgeType) {
        switch (cartridgeType) {
            case 0: {
                return "ROM ONLY";
            }
            case 1: {
                return "MBC1";
            }
            case 2: {
                return "MBC1+RAM";
            }
            case 3: {
                return "MBC1+RAM+BATTERY";
            }
            case 5: {
                return "MBC2";
            }
            case 6: {
                return "MBC2+BATTERY";
            }
            case 15: {
                return "MBC3+RTC+BATTERY";
            }
            case 16: {
                return "MBC3+RTC+RAM+BATTERY";
            }
            case 17: {
                return "MBC3";
            }
            case 18: {
                return "MBC3+RAM";
            }
            case 19: {
                return "MBC3+RAM+BATTERY";
            }
            case 25: {
                return "MBC5";
            }
            case 26: {
                return "MBC5+RAM";
            }
            case 27: {
                return "MBC5+RAM+BATTERY";
            }
            case 28: {
                return "MBC5+RUMBLE";
            }
            case 29: {
                return "MBC5+RUMBLE+RAM";
            }
            case 30: {
                return "MBC5+RUMBLE+RAM+BATTERY";
            }
            case 254: {
                return "HuC3+RTC+RAM";
            }
            case 255: {
                return "HuC1+RAM+BATTERY";
            }
        }
        return "UNKNOWN";
    }

    public static final MBC createBankController(int cartridgeType, byte[] rom, byte[] ram, ClockDriver clock) {
        switch (cartridgeType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new MBC1(rom, ram);
            }
            case 5: 
            case 6: {
                return new MBC2(rom, ram);
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return new MBC3(rom, ram, clock);
            }
            case 25: 
            case 26: 
            case 27: {
                return new MBC5(rom, ram, false);
            }
            case 28: 
            case 29: 
            case 30: {
                return new MBC5(rom, ram, true);
            }
            case 254: {
                return new HuC3(rom, ram, clock);
            }
            case 255: {
                return new HuC1(rom, ram);
            }
            case 234: {
                return new MBC1(rom, ram);
            }
        }
        throw new RuntimeException("Unsupported memory bank controller (0x" + Integer.toHexString(cartridgeType) + ")");
    }
}

