/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.emulation.PerformanceMeter;
import de.joergjahnke.common.emulation.RunnableDevice;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.util.DefaultLogger;
import de.joergjahnke.common.util.Observer;
import de.joergjahnke.gameboy.core.CPU;
import de.joergjahnke.gameboy.core.Cartridge;
import de.joergjahnke.gameboy.core.Joypad;
import de.joergjahnke.gameboy.core.SoundChip;
import de.joergjahnke.gameboy.core.Tile;
import de.joergjahnke.gameboy.core.VideoChip;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Gameboy
extends RunnableDevice
implements Observer,
Serializable {
    public static final Integer SIGNAL_NEW_PERFORMANCE_MEASUREMENT = new Integer(1);
    public static final int ORIGINAL_SPEED_CLASSIC = 0x400000;
    public static final int ORIGINAL_SPEED_COLOR = 8388000;
    public static final int DEFAULT_SAMPLE_RATE = 8000;
    private PerformanceMeter performanceMeter = null;
    private DefaultLogger logger = new DefaultLogger(100);
    private CPU cpu;
    private final Cartridge cartridge = new Cartridge(this);
    private final VideoChip video = new VideoChip(this);
    private SoundChip sound;
    private Joypad joypad;
    private int soundSampleRate = 8000;

    public Gameboy() {
        this.video.addObserver(this);
    }

    public void load(InputStream romStream) throws IOException {
        Tile.resetCache();
        this.cartridge.load(romStream);
        this.cpu = new CPU(this, this.cartridge);
        this.cpu.addObserver(this.video);
        this.cpu.addObserver(this.cartridge);
        this.sound = new SoundChip(this);
        this.joypad = new Joypad(this);
        this.performanceMeter = new PerformanceMeter(this.cpu, 0x400000);
        this.performanceMeter.addObserver(this);
        this.video.reset();
        Tile.initializeCache();
        this.getLogger().info("Loaded cartridge '" + this.cartridge.getTitle().trim() + "' (" + this.cartridge.getCartridgeTypeName() + ")");
    }

    public final DefaultLogger getLogger() {
        return this.logger;
    }

    public final void setLogger(DefaultLogger logger) {
        this.logger = logger;
    }

    public final CPU getCPU() {
        return this.cpu;
    }

    public final Cartridge getCartridge() {
        return this.cartridge;
    }

    public final VideoChip getVideoChip() {
        return this.video;
    }

    public final SoundChip getSoundChip() {
        return this.sound;
    }

    public final Joypad getJoypad() {
        return this.joypad;
    }

    public PerformanceMeter getPerformanceMeter() {
        return this.performanceMeter;
    }

    public int getSoundSampleRate() {
        return this.soundSampleRate;
    }

    public void setSoundSampleRate(int soundSampleRate) {
        this.soundSampleRate = soundSampleRate;
    }

    public void run() {
        if (!this.isRunning()) {
            this.logger.info("Gameboy starting");
            super.run();
            try {
                this.cpu.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.logger.info("Gameboy stopping");
            this.cpu.stop();
            super.stop();
        }
    }

    public void pause() {
        if (this.isRunning() && !this.isPaused()) {
            this.cpu.pause();
            super.pause();
            this.logger.info("Gameboy paused");
        }
    }

    public void resume() {
        if (this.isRunning() && this.isPaused()) {
            this.cpu.resume();
            this.performanceMeter.setupNextMeasurement(this.cpu.getCycles());
            super.resume();
            this.logger.info("Gameboy resumed");
        }
    }

    public void update(Object observed, Object arg) {
        if (observed == this.video && arg == VideoChip.SIGNAL_NEW_FRAME) {
            this.performanceMeter.measure(this.cpu.getCycles());
        } else if (observed == this.performanceMeter) {
            this.getLogger().info(arg.toString());
            this.setChanged(true);
            this.notifyObservers(SIGNAL_NEW_PERFORMANCE_MEASUREMENT);
        }
    }

    public void serialize(DataOutputStream out) throws IOException {
        this.cpu.serialize(out);
        SerializationUtils.setMarker(out);
        this.video.serialize(out);
        SerializationUtils.setMarker(out);
        this.sound.serialize(out);
        SerializationUtils.setMarker(out);
        this.joypad.serialize(out);
        SerializationUtils.setMarker(out);
        out.writeInt(this.soundSampleRate);
        SerializationUtils.setMarker(out);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.cpu.deserialize(in);
        SerializationUtils.verifyMarker(in);
        this.video.deserialize(in);
        SerializationUtils.verifyMarker(in);
        this.sound.deserialize(in);
        SerializationUtils.verifyMarker(in);
        this.joypad.deserialize(in);
        SerializationUtils.verifyMarker(in);
        this.soundSampleRate = in.readInt();
        SerializationUtils.verifyMarker(in);
    }
}

