/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.gameboy.core.SoundChannel;
import de.joergjahnke.gameboy.core.SoundChip;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SquareWaveChannel
extends SoundChannel {
    private int dutyPercent = 50;
    private int frequencyGB;
    private int envelopeSweeps;
    private int envelopeSweepsLeft;
    private int envelopeDirection = -1;
    private int sweepTime;
    private int sweepTimeLeft;
    private int sweepShift;
    private int sweepDirection = 1;

    public SquareWaveChannel(SoundChip sound) {
        super(sound);
    }

    public void setSweep(int time, boolean decrease, int shift) {
        this.sweepTime = this.sweepTimeLeft = (time + 1) * 128 >> 7;
        this.sweepShift = shift;
        this.sweepDirection = decrease ? -1 : 1;
    }

    public void setWavePatternDuty(int duty) {
        this.dutyPercent = duty == 0 ? 13 : (duty == 1 ? 25 : (duty == 2 ? 50 : 75));
    }

    public void setVolumeEnvelope(int initialVolume, boolean increase, int envelopeSweeps) {
        this.volume = initialVolume;
        this.envelopeSweeps = this.envelopeSweepsLeft = envelopeSweeps * 128 >> 6;
        this.envelopeDirection = increase ? 1 : -1;
    }

    public void setFrequency(int frequencyGB) {
        this.frequencyGB = frequencyGB;
        this.frequency = 131072 / (2048 - frequencyGB);
    }

    public void update() {
        --this.length;
        if (this.sweepTime > 0) {
            --this.sweepTimeLeft;
            if (this.sweepTimeLeft <= 0) {
                this.setFrequency(this.frequencyGB + this.sweepDirection * (this.frequencyGB >> this.sweepShift) & 0x7FF);
                this.sweepTimeLeft = this.sweepTime;
            }
        }
        if (this.envelopeSweeps > 0) {
            --this.envelopeSweepsLeft;
            if (this.envelopeSweepsLeft <= 0) {
                this.volume = Math.min(15, Math.max(0, this.volume + this.envelopeDirection));
                this.envelopeSweepsLeft = this.envelopeSweeps;
            }
        }
    }

    public void mix(byte[] buffer) {
        int sampleRate = this.sound.getSampleRate();
        boolean isLeftActive = this.isTerminalActive(0);
        boolean isRightActive = this.isTerminalActive(1);
        int target = this.dutyPercent * sampleRate / 100;
        int to = buffer.length;
        for (int i = 0; i < to; i += 2) {
            byte sample = (byte)(this.audioIndex >= target ? this.volume << 1 : -this.volume << 1);
            if (isLeftActive) {
                int n = i + 0;
                buffer[n] = (byte)(buffer[n] + sample);
            }
            if (isRightActive) {
                int n = i + 1;
                buffer[n] = (byte)(buffer[n] + sample);
            }
            this.audioIndex += this.frequency;
            this.audioIndex %= sampleRate;
        }
    }

    public final int getFrequency() {
        return Math.min(12544, this.startFrequency);
    }

    public final int getVolume() {
        return this.hasSound() && this.length > 0 ? this.startVolume * 100 / 15 : 0;
    }

    public final int getType() {
        return 80;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.dutyPercent);
        out.writeInt(this.frequencyGB);
        out.writeInt(this.envelopeSweeps);
        out.writeInt(this.envelopeSweepsLeft);
        out.writeInt(this.envelopeDirection);
        out.writeInt(this.sweepTime);
        out.writeInt(this.sweepTimeLeft);
        out.writeInt(this.sweepShift);
        out.writeInt(this.sweepDirection);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.dutyPercent = in.readInt();
        this.frequencyGB = in.readInt();
        this.envelopeSweeps = in.readInt();
        this.envelopeSweepsLeft = in.readInt();
        this.envelopeDirection = in.readInt();
        this.sweepTime = in.readInt();
        this.sweepTimeLeft = in.readInt();
        this.sweepShift = in.readInt();
        this.sweepDirection = in.readInt();
    }
}

