/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AppleCanvas
extends Canvas
implements Runnable {
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int COLORMODE_GREEN = 0;
    public static final int COLORMODE_COLOR = 1;
    public static final int COLORMODE_WHITE = 2;
    private static final int REFRESH_INTERVAL = 250;
    private Display display;
    private EmAppleII apple;
    public Keyboard keyboard;
    private Displayable dispBack;
    private Thread thread;
    private boolean threadStop = false;
    private boolean threadPause = false;
    private int canvasWidth;
    private int canvasHeight;
    private int pageOrientation;
    private boolean pageOrientationInit = false;
    private int pageDoubleTextBase = 0;
    private Image screen = null;
    private int screenLeft;
    private int screenTop;
    private int screenWidth;
    private int screenHeight;
    private int screenFactorX;
    private int screenFactorY;
    private int colorMode = 0;
    private boolean drawInit = false;
    private boolean drawPrepare;
    private boolean drawRepaint;
    private boolean drawBackground;
    private boolean drawStatInfo = false;
    private boolean[] dirty = new boolean[192];
    private int graphicsMode = 0;
    private Image text;
    private Image textAlt;
    private int[] ht = new int[16384];
    private int[] htData;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int h5;
    private int h6;
    private int h7;
    private int[] lores_map;
    private static final int[] textLine = new int[]{0, 128, 256, 384, 512, 640, 768, 896, 40, 168, 296, 424, 552, 680, 808, 936, 80, 208, 336, 464, 592, 720, 848, 976};
    private static final int[] loresMapGreen = new int[]{0, 935694, 266756, 0x166E16, 1001999, 0x115411, 801548, 2072095, 1203218, 1804827, 0x22AB22, 2405668, 1738522, 3007277, 2473253, 0x32FF32};
    private static final int[] loresMapColor = new int[]{0, 0xDD0033, 153, 0xDD22DD, 30498, 0x555555, 0x2222FF, 0x66AAFF, 0x885500, 0xFF6600, 0xAAAAAA, 0xFF9988, 0x11DD00, 0xFFFF00, 0x44FF99, 0xFFFFFF};
    final int[][] htcGreen = new int[][]{{0, 0}, {0, 1024}, {0, 67841}, {0, 134402}, {0, 201219}, {0, 267780}, {0, 334597}, {0, 401158}};
    final int[][] htcWhite = new int[][]{{0, 0}, {0, 263172}, {0, 592137}, {0, 855309}, {0, 0x121212}, {0, 0x161616}, {0, 0x1B1B1B}, {0, 0x1F1F1F}};
    final int[][] htcColor = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 196611, 768, 263172, 0, 4, 262144, 263172}, {0, 459015, 1792, 592137, 0, 265, 590080, 592137}, {0, 721163, 2816, 855309, 0, 525, 852480, 855309}, {0, 983567, 69376, 0x121212, 0, 786, 1180416, 0x121212}, {0, 0x130313, 70400, 0x161616, 0, 1046, 1442816, 0x161616}, {0, 1508119, 71424, 0x1B1B1B, 0, 1307, 1770752, 0x1B1B1B}, {0, 1770523, 137984, 0x1F1F1F, 0, 1567, 2033152, 0x1F1F1F}};
    final int[] htci = new int[]{0, 0, 1, 3, 0, 2, 3, 3, 0, 0, 2, 3, 0, 1, 3, 3};

    public AppleCanvas(Display display, EmAppleII emAppleII) {
        this.display = display;
        this.apple = emAppleII;
        this.keyboard = new Keyboard(display, this, emAppleII);
        this.setFullScreenMode(true);
        this.thread = new Thread(this);
        this.thread.setPriority(10);
    }

    public void setPageOrientation(int n) {
        this.pageOrientation = n;
        this.pageOrientationInit = true;
        this.pageDoubleTextBase = 0;
        this.drawPrepare = true;
    }

    public int getPageOrientation() {
        return this.pageOrientation;
    }

    public boolean getPageRotation() {
        switch (this.pageOrientation) {
            case 0: {
                return this.canvasWidth > this.canvasHeight;
            }
            case 1: {
                return this.canvasHeight > this.canvasWidth;
            }
        }
        return false;
    }

    public void setColorMode(int n) {
        this.colorMode = n;
        this.drawPrepare = true;
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void toggleStatInfo() {
        this.drawStatInfo = !this.drawStatInfo;
    }

    public void togglePage() {
        this.pageDoubleTextBase = this.pageDoubleTextBase == 0 ? 20 : 0;
        this.drawRepaint = true;
    }

    public void show() {
        this.dispBack = this.display.getCurrent();
        this.display.setCurrent((Displayable)this);
    }

    public void back() {
        this.display.setCurrent(this.dispBack);
    }

    protected void sizeChanged(int n, int n2) {
        this.canvasWidth = n;
        this.canvasHeight = n2;
        if (!this.pageOrientationInit) {
            this.setPageOrientation(1);
        }
        this.drawPrepare = true;
    }

    protected void showNotify() {
        this.drawBackground = true;
        this.repaint();
        if (!this.drawInit) {
            this.drawInit = true;
            this.sizeChanged(this.getWidth(), this.getHeight());
            this.thread.start();
        }
        this.apple.go();
    }

    protected void hideNotify() {
        this.apple.pause();
    }

    protected void keyPressed(int n) {
        this.keyboard.keyPressed(n, this.getGameAction(n));
    }

    protected void keyReleased(int n) {
        this.keyboard.keyReleased(n, this.getGameAction(n));
    }

    private void hiresPrecalc(int n) {
        if (n != 1) {
            int[][] nArray;
            switch (n) {
                case 0: {
                    nArray = this.htcGreen;
                    break;
                }
                default: {
                    nArray = this.htcWhite;
                }
            }
            for (int i = 0; i < 256; ++i) {
                int n2 = i >> 0 & 1;
                int n3 = i >> 1 & 1;
                int n4 = i >> 2 & 1;
                int n5 = i >> 3 & 1;
                int n6 = i >> 4 & 1;
                int n7 = i >> 5 & 1;
                int n8 = i >> 6 & 1;
                switch (this.screenFactorX) {
                    case 3: {
                        this.ht[0 + i] = nArray[3][n2] + nArray[3][n3] + nArray[1][n4];
                        this.ht[256 + i] = nArray[2][n4] + nArray[3][n5] + nArray[2][n6];
                        this.ht[512 + i] = nArray[1][n6] + nArray[3][n7] + nArray[3][n8];
                        break;
                    }
                    case 4: {
                        this.ht[0 + i] = nArray[4][n2] + nArray[3][n3];
                        this.ht[256 + i] = nArray[1][n3] + nArray[4][n4] + nArray[2][n5];
                        this.ht[512 + i] = nArray[2][n5] + nArray[4][n6] + nArray[1][n7];
                        this.ht[768 + i] = nArray[3][n7] + nArray[4][n8];
                        break;
                    }
                    case 5: {
                        this.ht[0 + i] = nArray[5][n2] + nArray[2][n3];
                        this.ht[256 + i] = nArray[3][n3] + nArray[4][n4];
                        this.ht[512 + i] = nArray[1][n4] + nArray[5][n5] + nArray[1][n6];
                        this.ht[768 + i] = nArray[4][n6] + nArray[3][n7];
                        this.ht[1024 + i] = nArray[2][n7] + nArray[5][n8];
                        break;
                    }
                    case 6: {
                        this.ht[0 + i] = nArray[6][n2] + nArray[1][n3];
                        this.ht[256 + i] = nArray[5][n3] + nArray[2][n4];
                        this.ht[512 + i] = nArray[4][n4] + nArray[3][n5];
                        this.ht[768 + i] = nArray[3][n5] + nArray[4][n6];
                        this.ht[1024 + i] = nArray[2][n6] + nArray[5][n7];
                        this.ht[1280 + i] = nArray[1][n7] + nArray[6][n8];
                        break;
                    }
                    case 7: {
                        this.ht[0 + i] = nArray[7][n2];
                        this.ht[256 + i] = nArray[7][n3];
                        this.ht[512 + i] = nArray[7][n4];
                        this.ht[768 + i] = nArray[7][n5];
                        this.ht[1024 + i] = nArray[7][n6];
                        this.ht[1280 + i] = nArray[7][n7];
                        this.ht[1536 + i] = nArray[7][n8];
                    }
                }
                System.arraycopy(this.ht, 0, this.ht, 2048, 2048);
            }
        } else {
            int[][] nArray = this.htcColor;
            block18: for (int i = 0; i < 512; ++i) {
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = (i & 0x80) != 0 ? 4 : 0;
                int n17 = i & 0x7F;
                n17 |= ((n17 |= ((n17 <<= 1) & 2) == 0 ? 1 : 0) & 0x80) == 0 ? 256 : 0;
                if ((i & 0x100) == 0) {
                    n15 = this.htci[n17 & 7] | n16;
                    n14 = this.htci[(n17 >>= 1) & 7 | 8] | n16;
                    n13 = this.htci[(n17 >>= 1) & 7] | n16;
                    n12 = this.htci[(n17 >>= 1) & 7 | 8] | n16;
                    n11 = this.htci[(n17 >>= 1) & 7] | n16;
                    n10 = this.htci[(n17 >>= 1) & 7 | 8] | n16;
                    n9 = this.htci[(n17 >>= 1) & 7] | n16;
                    n17 = i & 0xFF;
                } else {
                    n15 = this.htci[n17 & 7 | 8] | n16;
                    n14 = this.htci[(n17 >>= 1) & 7] | n16;
                    n13 = this.htci[(n17 >>= 1) & 7 | 8] | n16;
                    n12 = this.htci[(n17 >>= 1) & 7] | n16;
                    n11 = this.htci[(n17 >>= 1) & 7 | 8] | n16;
                    n10 = this.htci[(n17 >>= 1) & 7] | n16;
                    n9 = this.htci[(n17 >>= 1) & 7 | 8] | n16;
                    n17 = i & 0xFF | 0x800;
                }
                switch (this.screenFactorX) {
                    case 3: {
                        this.ht[0 + n17] = nArray[3][n15] + nArray[3][n14] + nArray[1][n13];
                        this.ht[256 + n17] = nArray[2][n13] + nArray[3][n12] + nArray[2][n11];
                        this.ht[512 + n17] = nArray[1][n11] + nArray[3][n10] + nArray[3][n9];
                        continue block18;
                    }
                    case 4: {
                        this.ht[0 + n17] = nArray[4][n15] + nArray[3][n14];
                        this.ht[256 + n17] = nArray[1][n14] + nArray[4][n13] + nArray[2][n12];
                        this.ht[512 + n17] = nArray[2][n12] + nArray[4][n11] + nArray[1][n10];
                        this.ht[768 + n17] = nArray[3][n10] + nArray[4][n9];
                        continue block18;
                    }
                    case 5: {
                        this.ht[0 + n17] = nArray[5][n15] + nArray[2][n14];
                        this.ht[256 + n17] = nArray[3][n14] + nArray[4][n13];
                        this.ht[512 + n17] = nArray[1][n13] + nArray[5][n12] + nArray[1][n11];
                        this.ht[768 + n17] = nArray[4][n11] + nArray[3][n10];
                        this.ht[1024 + n17] = nArray[2][n10] + nArray[5][n9];
                        continue block18;
                    }
                    case 6: {
                        this.ht[0 + n17] = nArray[6][n15] + nArray[1][n14];
                        this.ht[256 + n17] = nArray[5][n14] + nArray[2][n13];
                        this.ht[512 + n17] = nArray[4][n13] + nArray[3][n12];
                        this.ht[768 + n17] = nArray[3][n12] + nArray[4][n11];
                        this.ht[1024 + n17] = nArray[2][n11] + nArray[5][n10];
                        this.ht[1280 + n17] = nArray[1][n10] + nArray[6][n9];
                        continue block18;
                    }
                    case 7: {
                        this.ht[0 + n17] = nArray[7][n15];
                        this.ht[256 + n17] = nArray[7][n14];
                        this.ht[512 + n17] = nArray[7][n13];
                        this.ht[768 + n17] = nArray[7][n12];
                        this.ht[1024 + n17] = nArray[7][n11];
                        this.ht[1280 + n17] = nArray[7][n10];
                        this.ht[1536 + n17] = nArray[7][n9];
                    }
                }
            }
        }
    }

    private final int hiresBuildByte(int n) {
        return (this.htData[n + 0] & 1) + (this.htData[n + 1] & 2) + (this.htData[n + 2] & 4) + (this.htData[n + 3] & 8) + (this.htData[n + 4] & 0x10) + (this.htData[n + 5] & 0x20) + (this.htData[n + 6] & 0x40);
    }

    private final void hiresDownsample(int n, int n2, boolean bl) {
        if (bl) {
            this.h0 |= 0x800;
            this.h1 |= 0x800;
            this.h2 |= 0x800;
            this.h3 |= 0x800;
            this.h4 |= 0x800;
            this.h5 |= 0x800;
            this.h6 |= 0x800;
            this.h7 |= 0x800;
        }
        switch (this.screenFactorY) {
            case 4: {
                this.htData[n + 0] = 4 * (this.ht[0 + this.h0] + this.ht[0 + this.h1]);
                this.htData[n + 1] = 4 * (this.ht[256 + this.h0] + this.ht[256 + this.h1]);
                this.htData[n + 2] = 4 * (this.ht[512 + this.h0] + this.ht[512 + this.h1]);
                this.htData[(n += n2) + 0] = 4 * (this.ht[0 + this.h2] + this.ht[0 + this.h3]);
                this.htData[n + 1] = 4 * (this.ht[256 + this.h2] + this.ht[256 + this.h3]);
                this.htData[n + 2] = 4 * (this.ht[512 + this.h2] + this.ht[512 + this.h3]);
                this.htData[(n += n2) + 0] = 4 * (this.ht[0 + this.h4] + this.ht[0 + this.h5]);
                this.htData[n + 1] = 4 * (this.ht[256 + this.h4] + this.ht[256 + this.h5]);
                this.htData[n + 2] = 4 * (this.ht[512 + this.h4] + this.ht[512 + this.h5]);
                this.htData[(n += n2) + 0] = 4 * (this.ht[0 + this.h6] + this.ht[0 + this.h7]);
                this.htData[n + 1] = 4 * (this.ht[256 + this.h6] + this.ht[256 + this.h7]);
                this.htData[n + 2] = 4 * (this.ht[512 + this.h6] + this.ht[512 + this.h7]);
                break;
            }
            case 5: {
                this.htData[n + 0] = 5 * this.ht[0 + this.h0] + 3 * this.ht[0 + this.h1];
                this.htData[n + 1] = 5 * this.ht[256 + this.h0] + 3 * this.ht[256 + this.h1];
                this.htData[n + 2] = 5 * this.ht[512 + this.h0] + 3 * this.ht[512 + this.h1];
                this.htData[n + 3] = 5 * this.ht[768 + this.h0] + 3 * this.ht[768 + this.h1];
                this.htData[(n += n2) + 0] = 2 * this.ht[0 + this.h1] + 5 * this.ht[0 + this.h2] + this.ht[0 + this.h3];
                this.htData[n + 1] = 2 * this.ht[256 + this.h1] + 5 * this.ht[256 + this.h2] + this.ht[256 + this.h3];
                this.htData[n + 2] = 2 * this.ht[512 + this.h1] + 5 * this.ht[512 + this.h2] + this.ht[512 + this.h3];
                this.htData[n + 3] = 2 * this.ht[768 + this.h1] + 5 * this.ht[768 + this.h2] + this.ht[768 + this.h3];
                this.htData[(n += n2) + 0] = 4 * (this.ht[0 + this.h3] + this.ht[0 + this.h4]);
                this.htData[n + 1] = 4 * (this.ht[256 + this.h3] + this.ht[256 + this.h4]);
                this.htData[n + 2] = 4 * (this.ht[512 + this.h3] + this.ht[512 + this.h4]);
                this.htData[n + 3] = 4 * (this.ht[768 + this.h3] + this.ht[768 + this.h4]);
                this.htData[(n += n2) + 0] = this.ht[0 + this.h4] + 5 * this.ht[0 + this.h5] + 2 * this.ht[0 + this.h6];
                this.htData[n + 1] = this.ht[256 + this.h4] + 5 * this.ht[256 + this.h5] + 2 * this.ht[256 + this.h6];
                this.htData[n + 2] = this.ht[512 + this.h4] + 5 * this.ht[512 + this.h5] + 2 * this.ht[512 + this.h6];
                this.htData[n + 3] = this.ht[768 + this.h4] + 5 * this.ht[768 + this.h5] + 2 * this.ht[768 + this.h6];
                this.htData[(n += n2) + 0] = 3 * this.ht[0 + this.h6] + 5 * this.ht[0 + this.h7];
                this.htData[n + 1] = 3 * this.ht[256 + this.h6] + 5 * this.ht[256 + this.h7];
                this.htData[n + 2] = 3 * this.ht[512 + this.h6] + 5 * this.ht[512 + this.h7];
                this.htData[n + 3] = 3 * this.ht[768 + this.h6] + 5 * this.ht[768 + this.h7];
                break;
            }
            case 6: {
                this.htData[n + 0] = 6 * this.ht[0 + this.h0] + 2 * this.ht[0 + this.h1];
                this.htData[n + 1] = 6 * this.ht[256 + this.h0] + 2 * this.ht[256 + this.h1];
                this.htData[n + 2] = 6 * this.ht[512 + this.h0] + 2 * this.ht[512 + this.h1];
                this.htData[n + 3] = 6 * this.ht[768 + this.h0] + 2 * this.ht[768 + this.h1];
                this.htData[n + 4] = 6 * this.ht[1024 + this.h0] + 2 * this.ht[1024 + this.h1];
                this.htData[(n += n2) + 0] = 4 * (this.ht[0 + this.h1] + this.ht[0 + this.h2]);
                this.htData[n + 1] = 4 * (this.ht[256 + this.h1] + this.ht[256 + this.h2]);
                this.htData[n + 2] = 4 * (this.ht[512 + this.h1] + this.ht[512 + this.h2]);
                this.htData[n + 3] = 4 * (this.ht[768 + this.h1] + this.ht[768 + this.h2]);
                this.htData[n + 4] = 4 * (this.ht[1024 + this.h1] + this.ht[1024 + this.h2]);
                this.htData[(n += n2) + 0] = 2 * this.ht[0 + this.h2] + 6 * this.ht[0 + this.h3];
                this.htData[n + 1] = 2 * this.ht[256 + this.h2] + 6 * this.ht[256 + this.h3];
                this.htData[n + 2] = 2 * this.ht[512 + this.h2] + 6 * this.ht[512 + this.h3];
                this.htData[n + 3] = 2 * this.ht[768 + this.h2] + 6 * this.ht[768 + this.h3];
                this.htData[n + 4] = 2 * this.ht[1024 + this.h2] + 6 * this.ht[1024 + this.h3];
                this.htData[(n += n2) + 0] = 6 * this.ht[0 + this.h4] + 2 * this.ht[0 + this.h5];
                this.htData[n + 1] = 6 * this.ht[256 + this.h4] + 2 * this.ht[256 + this.h5];
                this.htData[n + 2] = 6 * this.ht[512 + this.h4] + 2 * this.ht[512 + this.h5];
                this.htData[n + 3] = 6 * this.ht[768 + this.h4] + 2 * this.ht[768 + this.h5];
                this.htData[n + 4] = 6 * this.ht[1024 + this.h4] + 2 * this.ht[1024 + this.h5];
                this.htData[(n += n2) + 0] = 4 * (this.ht[0 + this.h5] + this.ht[0 + this.h6]);
                this.htData[n + 1] = 4 * (this.ht[256 + this.h5] + this.ht[256 + this.h6]);
                this.htData[n + 2] = 4 * (this.ht[512 + this.h5] + this.ht[512 + this.h6]);
                this.htData[n + 3] = 4 * (this.ht[768 + this.h5] + this.ht[768 + this.h6]);
                this.htData[n + 4] = 4 * (this.ht[1024 + this.h5] + this.ht[1024 + this.h6]);
                this.htData[(n += n2) + 0] = 2 * this.ht[0 + this.h6] + 6 * this.ht[0 + this.h7];
                this.htData[n + 1] = 2 * this.ht[256 + this.h6] + 6 * this.ht[256 + this.h7];
                this.htData[n + 2] = 2 * this.ht[512 + this.h6] + 6 * this.ht[512 + this.h7];
                this.htData[n + 3] = 2 * this.ht[768 + this.h6] + 6 * this.ht[768 + this.h7];
                this.htData[n + 4] = 2 * this.ht[1024 + this.h6] + 6 * this.ht[1024 + this.h7];
                break;
            }
            case 7: {
                this.htData[n + 0] = 7 * this.ht[0 + this.h0] + this.ht[0 + this.h1];
                this.htData[n + 1] = 7 * this.ht[256 + this.h0] + this.ht[256 + this.h1];
                this.htData[n + 2] = 7 * this.ht[512 + this.h0] + this.ht[512 + this.h1];
                this.htData[n + 3] = 7 * this.ht[768 + this.h0] + this.ht[768 + this.h1];
                this.htData[n + 4] = 7 * this.ht[1024 + this.h0] + this.ht[1024 + this.h1];
                this.htData[n + 5] = 7 * this.ht[1280 + this.h0] + this.ht[1280 + this.h1];
                this.htData[(n += n2) + 0] = 6 * this.ht[0 + this.h1] + 2 * this.ht[0 + this.h2];
                this.htData[n + 1] = 6 * this.ht[256 + this.h1] + 2 * this.ht[256 + this.h2];
                this.htData[n + 2] = 6 * this.ht[512 + this.h1] + 2 * this.ht[512 + this.h2];
                this.htData[n + 3] = 6 * this.ht[768 + this.h1] + 2 * this.ht[768 + this.h2];
                this.htData[n + 4] = 6 * this.ht[1024 + this.h1] + 2 * this.ht[1024 + this.h2];
                this.htData[n + 5] = 6 * this.ht[1280 + this.h1] + 2 * this.ht[1280 + this.h2];
                this.htData[(n += n2) + 0] = 5 * this.ht[0 + this.h2] + 3 * this.ht[0 + this.h3];
                this.htData[n + 1] = 5 * this.ht[256 + this.h2] + 3 * this.ht[256 + this.h3];
                this.htData[n + 2] = 5 * this.ht[512 + this.h2] + 3 * this.ht[512 + this.h3];
                this.htData[n + 3] = 5 * this.ht[768 + this.h2] + 3 * this.ht[768 + this.h3];
                this.htData[n + 4] = 5 * this.ht[1024 + this.h2] + 3 * this.ht[1024 + this.h3];
                this.htData[n + 5] = 5 * this.ht[1280 + this.h2] + 3 * this.ht[1280 + this.h3];
                this.htData[(n += n2) + 0] = 4 * (this.ht[0 + this.h3] + this.ht[0 + this.h4]);
                this.htData[n + 1] = 4 * (this.ht[256 + this.h3] + this.ht[256 + this.h4]);
                this.htData[n + 2] = 4 * (this.ht[512 + this.h3] + this.ht[512 + this.h4]);
                this.htData[n + 3] = 4 * (this.ht[768 + this.h3] + this.ht[768 + this.h4]);
                this.htData[n + 4] = 4 * (this.ht[1024 + this.h3] + this.ht[1024 + this.h4]);
                this.htData[n + 5] = 4 * (this.ht[1280 + this.h3] + this.ht[1280 + this.h4]);
                this.htData[(n += n2) + 0] = 3 * this.ht[0 + this.h4] + 5 * this.ht[0 + this.h5];
                this.htData[n + 1] = 3 * this.ht[256 + this.h4] + 5 * this.ht[256 + this.h5];
                this.htData[n + 2] = 3 * this.ht[512 + this.h4] + 5 * this.ht[512 + this.h5];
                this.htData[n + 3] = 3 * this.ht[768 + this.h4] + 5 * this.ht[768 + this.h5];
                this.htData[n + 4] = 3 * this.ht[1024 + this.h4] + 5 * this.ht[1024 + this.h5];
                this.htData[n + 5] = 3 * this.ht[1280 + this.h4] + 5 * this.ht[1280 + this.h5];
                this.htData[(n += n2) + 0] = 2 * this.ht[0 + this.h5] + 6 * this.ht[0 + this.h6];
                this.htData[n + 1] = 2 * this.ht[256 + this.h5] + 6 * this.ht[256 + this.h6];
                this.htData[n + 2] = 2 * this.ht[512 + this.h5] + 6 * this.ht[512 + this.h6];
                this.htData[n + 3] = 2 * this.ht[768 + this.h5] + 6 * this.ht[768 + this.h6];
                this.htData[n + 4] = 2 * this.ht[1024 + this.h5] + 6 * this.ht[1024 + this.h6];
                this.htData[n + 5] = 2 * this.ht[1280 + this.h5] + 6 * this.ht[1280 + this.h6];
                this.htData[(n += n2) + 0] = this.ht[0 + this.h6] + 7 * this.ht[0 + this.h7];
                this.htData[n + 1] = this.ht[256 + this.h6] + 7 * this.ht[256 + this.h7];
                this.htData[n + 2] = this.ht[512 + this.h6] + 7 * this.ht[512 + this.h7];
                this.htData[n + 3] = this.ht[768 + this.h6] + 7 * this.ht[768 + this.h7];
                this.htData[n + 4] = this.ht[1024 + this.h6] + 7 * this.ht[1024 + this.h7];
                this.htData[n + 5] = this.ht[1280 + this.h6] + 7 * this.ht[1280 + this.h7];
                break;
            }
            case 8: {
                this.htData[n + 0] = 8 * this.ht[0 + this.h0];
                this.htData[n + 1] = 8 * this.ht[256 + this.h0];
                this.htData[n + 2] = 8 * this.ht[512 + this.h0];
                this.htData[n + 3] = 8 * this.ht[768 + this.h0];
                this.htData[n + 4] = 8 * this.ht[1024 + this.h0];
                this.htData[n + 5] = 8 * this.ht[1280 + this.h0];
                this.htData[n + 6] = 8 * this.ht[1536 + this.h0];
                this.htData[(n += n2) + 0] = 8 * this.ht[0 + this.h1];
                this.htData[n + 1] = 8 * this.ht[256 + this.h1];
                this.htData[n + 2] = 8 * this.ht[512 + this.h1];
                this.htData[n + 3] = 8 * this.ht[768 + this.h1];
                this.htData[n + 4] = 8 * this.ht[1024 + this.h1];
                this.htData[n + 5] = 8 * this.ht[1280 + this.h1];
                this.htData[n + 6] = 8 * this.ht[1536 + this.h1];
                this.htData[(n += n2) + 0] = 8 * this.ht[0 + this.h2];
                this.htData[n + 1] = 8 * this.ht[256 + this.h2];
                this.htData[n + 2] = 8 * this.ht[512 + this.h2];
                this.htData[n + 3] = 8 * this.ht[768 + this.h2];
                this.htData[n + 4] = 8 * this.ht[1024 + this.h2];
                this.htData[n + 5] = 8 * this.ht[1280 + this.h2];
                this.htData[n + 6] = 8 * this.ht[1536 + this.h2];
                this.htData[(n += n2) + 0] = 8 * this.ht[0 + this.h3];
                this.htData[n + 1] = 8 * this.ht[256 + this.h3];
                this.htData[n + 2] = 8 * this.ht[512 + this.h3];
                this.htData[n + 3] = 8 * this.ht[768 + this.h3];
                this.htData[n + 4] = 8 * this.ht[1024 + this.h3];
                this.htData[n + 5] = 8 * this.ht[1280 + this.h3];
                this.htData[n + 6] = 8 * this.ht[1536 + this.h3];
                this.htData[(n += n2) + 0] = 8 * this.ht[0 + this.h4];
                this.htData[n + 1] = 8 * this.ht[256 + this.h4];
                this.htData[n + 2] = 8 * this.ht[512 + this.h4];
                this.htData[n + 3] = 8 * this.ht[768 + this.h4];
                this.htData[n + 4] = 8 * this.ht[1024 + this.h4];
                this.htData[n + 5] = 8 * this.ht[1280 + this.h4];
                this.htData[n + 6] = 8 * this.ht[1536 + this.h4];
                this.htData[(n += n2) + 0] = 8 * this.ht[0 + this.h5];
                this.htData[n + 1] = 8 * this.ht[256 + this.h5];
                this.htData[n + 2] = 8 * this.ht[512 + this.h5];
                this.htData[n + 3] = 8 * this.ht[768 + this.h5];
                this.htData[n + 4] = 8 * this.ht[1024 + this.h5];
                this.htData[n + 5] = 8 * this.ht[1280 + this.h5];
                this.htData[n + 6] = 8 * this.ht[1536 + this.h5];
                this.htData[(n += n2) + 0] = 8 * this.ht[0 + this.h6];
                this.htData[n + 1] = 8 * this.ht[256 + this.h6];
                this.htData[n + 2] = 8 * this.ht[512 + this.h6];
                this.htData[n + 3] = 8 * this.ht[768 + this.h6];
                this.htData[n + 4] = 8 * this.ht[1024 + this.h6];
                this.htData[n + 5] = 8 * this.ht[1280 + this.h6];
                this.htData[n + 6] = 8 * this.ht[1536 + this.h6];
                this.htData[(n += n2) + 0] = 8 * this.ht[0 + this.h7];
                this.htData[n + 1] = 8 * this.ht[256 + this.h7];
                this.htData[n + 2] = 8 * this.ht[512 + this.h7];
                this.htData[n + 3] = 8 * this.ht[768 + this.h7];
                this.htData[n + 4] = 8 * this.ht[1024 + this.h7];
                this.htData[n + 5] = 8 * this.ht[1280 + this.h7];
                this.htData[n + 6] = 8 * this.ht[1536 + this.h7];
            }
        }
    }

    private void hiresBlockCopyInvert(int n, int n2, boolean bl) {
        int n3 = n2 * 32 * 8;
        int n4 = n * 32 * 8;
        int n5 = 0;
        for (int i = 0; i < 8; ++i) {
            if (bl) {
                for (int j = 0; j < 256; ++j) {
                    this.htData[n5 + n4 + j] = ~this.htData[n5 + n3 + j];
                }
            } else {
                System.arraycopy(this.htData, n5 + n3, this.htData, n5 + n4, 256);
            }
            n5 += 2048;
        }
    }

    private Image fontPrepare(Image image) {
        this.htData = new int[16384];
        image.getRGB(this.htData, 1024, 2048, 0, 0, 1024, 8);
        this.hiresPrecalc(this.colorMode == 1 ? 2 : this.colorMode);
        this.hiresBlockCopyInvert(0, 6, true);
        this.hiresBlockCopyInvert(1, 5, true);
        this.hiresBlockCopyInvert(2, 4, false);
        this.hiresBlockCopyInvert(3, 7, true);
        this.hiresBlockCopyInvert(4, 6, false);
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            this.h0 = this.hiresBuildByte(n + 0);
            this.h1 = this.hiresBuildByte(n + 2048);
            this.h2 = this.hiresBuildByte(n + 4096);
            this.h3 = this.hiresBuildByte(n + 6144);
            this.h4 = this.hiresBuildByte(n + 8192);
            this.h5 = this.hiresBuildByte(n + 10240);
            this.h6 = this.hiresBuildByte(n + 12288);
            this.h7 = this.hiresBuildByte(n + 14336);
            this.hiresDownsample(n, 2048, false);
            n += 8;
        }
        image = Image.createRGBImage((int[])this.htData, (int)2048, (int)8, (boolean)false);
        Image image2 = Image.createImage((int)2048, (int)8);
        Graphics graphics = image2.getGraphics();
        graphics.drawRegion(image, 0, 0, 2048, 8, 0, 0, 0, 20);
        this.htData = null;
        return image2;
    }

    private Image fontPrepareAlt(Image image) {
        Image image2 = Image.createImage((Image)image, (int)512, (int)0, (int)512, (int)8, (int)0);
        Graphics graphics = image.getGraphics();
        graphics.copyArea(0, 0, 512, 8, 512, 0, 20);
        return image2;
    }

    private void canvasPrepare() {
        int n = 0;
        int n2 = 0;
        if (this.getPageRotation()) {
            n = this.canvasHeight;
            n2 = this.canvasWidth;
        } else {
            n = this.canvasWidth;
            n2 = this.canvasHeight;
        }
        for (int i = 8; i >= 4; --i) {
            this.screenFactorX = i - 1;
            this.screenFactorY = i;
            this.screenWidth = 40 * this.screenFactorX;
            this.screenHeight = 24 * this.screenFactorY;
            if (this.screenWidth <= n && this.screenHeight <= n2) break;
        }
        if (this.getPageRotation()) {
            this.screenLeft = (n2 - this.screenHeight) / 2;
            this.screenTop = (n - this.screenWidth) / 2;
        } else {
            this.screenLeft = (n - this.screenWidth) / 2;
            this.screenTop = (n2 - this.screenHeight) / 2;
        }
        this.screen = Image.createImage((int)this.screenWidth, (int)this.screenHeight);
        Image image = null;
        try {
            image = Image.createImage((String)"/Resources/apple2echar.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (image == null) {
            try {
                image = Image.createImage((String)"/Resources/apple2char.png");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            image = Image.createImage((int)1024, (int)8);
        }
        this.text = this.fontPrepare(image);
        this.textAlt = this.fontPrepareAlt(this.text);
        switch (this.colorMode) {
            case 0: {
                this.lores_map = loresMapGreen;
                break;
            }
            case 1: {
                this.lores_map = loresMapColor;
            }
        }
        if (this.colorMode == 1) {
            this.hiresPrecalc(this.colorMode);
        }
        this.htData = new int[this.screenWidth * this.screenHeight];
    }

    public void renderText(Graphics graphics, int n, boolean bl) {
        int n2 = bl ? 20 : 0;
        int n3 = n2 * this.screenFactorY;
        for (int i = n2; i < 24; ++i) {
            int n4 = n + textLine[i];
            if (this.dirty[n4 >> 7]) {
                int n5 = 0;
                int n6 = n4 + 40;
                for (int j = n4; j < n6; ++j) {
                    int n7 = this.apple.mem[j] & 0xFF;
                    graphics.drawRegion(this.text, n7 << 3, 0, this.screenFactorX, this.screenFactorY, 0, n5, n3, 20);
                    n5 += this.screenFactorX;
                }
            }
            n3 += this.screenFactorY;
        }
    }

    public void renderDoubleText(Graphics graphics, int n, boolean bl) {
        int n2 = bl ? 20 : 0;
        int n3 = n2 * this.screenFactorY;
        for (int i = n2; i < 24; ++i) {
            int n4 = n + textLine[i] + this.pageDoubleTextBase;
            if (this.dirty[n4 >> 7]) {
                int n5 = 0;
                int n6 = n4 + 20;
                for (int j = n4; j < n6; ++j) {
                    int n7 = this.apple.mem[j + 65536] & 0xFF;
                    graphics.drawRegion(this.text, n7 << 3, 0, this.screenFactorX, this.screenFactorY, 0, n5, n3, 20);
                    n7 = this.apple.mem[j] & 0xFF;
                    graphics.drawRegion(this.text, n7 << 3, 0, this.screenFactorX, this.screenFactorY, 0, n5 += this.screenFactorX, n3, 20);
                    n5 += this.screenFactorX;
                }
            }
            n3 += this.screenFactorY;
        }
    }

    public void renderLores(Graphics graphics, int n, boolean bl) {
        int n2 = bl ? 20 : 24;
        int n3 = this.screenFactorY >> 1;
        int n4 = this.screenFactorY - n3;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = n + textLine[i];
            if (this.dirty[n6 >> 7]) {
                int n7 = 0;
                int n8 = n6 + 40;
                for (int j = n6; j < n8; ++j) {
                    int n9 = this.apple.mem[j] & 0xFF;
                    graphics.setColor(this.lores_map[n9 & 0xF]);
                    graphics.fillRect(n7, n5, this.screenFactorX, n3);
                    graphics.setColor(this.lores_map[(n9 & 0xF0) >> 4]);
                    graphics.fillRect(n7, n5 + n3, this.screenFactorX, n4);
                    n7 += this.screenFactorX;
                }
            }
            n5 += this.screenFactorY;
        }
    }

    public void renderDoubleLores(Graphics graphics, int n, boolean bl) {
        int n2 = bl ? 20 : 24;
        int n3 = this.screenFactorX >> 1;
        int n4 = this.screenFactorX - n3;
        int n5 = this.screenFactorY >> 1;
        int n6 = this.screenFactorY - n5;
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            int n8 = n + textLine[i];
            if (this.dirty[n8 >> 7]) {
                int n9 = 0;
                int n10 = n8 + 40;
                for (int j = n8; j < n10; ++j) {
                    int n11 = this.apple.mem[j + 65536] & 0xFF;
                    graphics.setColor(this.lores_map[n11 & 0xF]);
                    graphics.fillRect(n9, n7, n3, n5);
                    graphics.setColor(this.lores_map[(n11 & 0xF0) >> 4]);
                    graphics.fillRect(n9, n7 + n5, n3, n6);
                    n11 = this.apple.mem[j] & 0xFF;
                    graphics.setColor(this.lores_map[n11 & 0xF]);
                    graphics.fillRect(n9 + n3, n7, n4, n5);
                    graphics.setColor(this.lores_map[(n11 & 0xF0) >> 4]);
                    graphics.fillRect(n9 + n3, n7 + n5, n4, n6);
                    n9 += this.screenFactorX;
                }
            }
            n7 += this.screenFactorY;
        }
    }

    public void renderHires(Graphics graphics, int n, boolean bl) {
        int n2 = bl ? 20 : 24;
        int n3 = this.screenFactorY >> 1;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = n + textLine[i];
            if (this.dirty[n6 >> 7]) {
                int n7 = n5;
                int n8 = n6 + 40;
                for (int j = n6; j < n8; j += 2) {
                    this.h0 = this.apple.mem[j + 0] & 0xFF;
                    this.h1 = this.apple.mem[j + 1024] & 0xFF;
                    this.h2 = this.apple.mem[j + 2048] & 0xFF;
                    this.h3 = this.apple.mem[j + 3072] & 0xFF;
                    this.h4 = this.apple.mem[j + 4096] & 0xFF;
                    this.h5 = this.apple.mem[j + 5120] & 0xFF;
                    this.h6 = this.apple.mem[j + 6144] & 0xFF;
                    this.h7 = this.apple.mem[j + 7168] & 0xFF;
                    this.hiresDownsample(n7, this.screenWidth, false);
                    n7 += this.screenFactorX;
                    this.h0 = this.apple.mem[j + 1] & 0xFF;
                    this.h1 = this.apple.mem[j + 1025] & 0xFF;
                    this.h2 = this.apple.mem[j + 2049] & 0xFF;
                    this.h3 = this.apple.mem[j + 3073] & 0xFF;
                    this.h4 = this.apple.mem[j + 4097] & 0xFF;
                    this.h5 = this.apple.mem[j + 5121] & 0xFF;
                    this.h6 = this.apple.mem[j + 6145] & 0xFF;
                    this.h7 = this.apple.mem[j + 7169] & 0xFF;
                    this.hiresDownsample(n7, this.screenWidth, true);
                    n7 += this.screenFactorX;
                }
            }
            n5 += this.screenFactorY * this.screenWidth;
            n4 += this.screenFactorY;
        }
        graphics.drawRGB(this.htData, 0, this.screenWidth, 0, 0, this.screenWidth, n4, false);
    }

    private final int doubleHiresToHires(int n, int n2) {
        n2 = n2 & 1 | n2 >> 1 & 2 | n2 >> 2 & 4 | n2 >> 3 & 8;
        return n2 |= n << 3 & 0x10 | n << 2 & 0x20 | n << 1 & 0x40;
    }

    public void renderDoubleHires(Graphics graphics, int n, boolean bl) {
        int n2 = bl ? 20 : 24;
        int n3 = this.screenFactorY >> 1;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = n + textLine[i];
            if (this.dirty[n6 >> 7]) {
                int n7 = n5;
                int n8 = n6 + 40;
                for (int j = n6; j < n8; j += 2) {
                    this.h0 = this.doubleHiresToHires(this.apple.mem[j + 0], this.apple.mem[j + 65536]);
                    this.h1 = this.doubleHiresToHires(this.apple.mem[j + 1024], this.apple.mem[j + 66560]);
                    this.h2 = this.doubleHiresToHires(this.apple.mem[j + 2048], this.apple.mem[j + 67584]);
                    this.h3 = this.doubleHiresToHires(this.apple.mem[j + 3072], this.apple.mem[j + 68608]);
                    this.h4 = this.doubleHiresToHires(this.apple.mem[j + 4096], this.apple.mem[j + 69632]);
                    this.h5 = this.doubleHiresToHires(this.apple.mem[j + 5120], this.apple.mem[j + 70656]);
                    this.h6 = this.doubleHiresToHires(this.apple.mem[j + 6144], this.apple.mem[j + 71680]);
                    this.h7 = this.doubleHiresToHires(this.apple.mem[j + 7168], this.apple.mem[j + 72704]);
                    this.hiresDownsample(n7, this.screenWidth, false);
                    n7 += this.screenFactorX;
                    this.h0 = this.doubleHiresToHires(this.apple.mem[j + 1], this.apple.mem[j + 65537]);
                    this.h1 = this.doubleHiresToHires(this.apple.mem[j + 1025], this.apple.mem[j + 66561]);
                    this.h2 = this.doubleHiresToHires(this.apple.mem[j + 2049], this.apple.mem[j + 67585]);
                    this.h3 = this.doubleHiresToHires(this.apple.mem[j + 3073], this.apple.mem[j + 68609]);
                    this.h4 = this.doubleHiresToHires(this.apple.mem[j + 4097], this.apple.mem[j + 69633]);
                    this.h5 = this.doubleHiresToHires(this.apple.mem[j + 5121], this.apple.mem[j + 70657]);
                    this.h6 = this.doubleHiresToHires(this.apple.mem[j + 6145], this.apple.mem[j + 71681]);
                    this.h7 = this.doubleHiresToHires(this.apple.mem[j + 7169], this.apple.mem[j + 72705]);
                    this.hiresDownsample(n7, this.screenWidth, true);
                    n7 += this.screenFactorX;
                }
            }
            n5 += this.screenFactorY * this.screenWidth;
            n4 += this.screenFactorY;
        }
        graphics.drawRGB(this.htData, 0, this.screenWidth, 0, 0, this.screenWidth, n4, false);
    }

    private String zeroPad(String string, int n) {
        n -= string.length();
        while (n > 0) {
            string = "0" + string;
            --n;
        }
        return string;
    }

    private void paintStatInfo(Graphics graphics) {
        Font font = graphics.getFont();
        int n = font.getHeight();
        int n2 = this.apple.PC;
        int n3 = this.apple.memoryRead(n2);
        int n4 = this.apple.memoryRead(n2 + 1);
        int n5 = this.apple.memoryRead(n2 + 2);
        graphics.setColor(0xFFFFFF);
        int n6 = 0;
        if (this.apple.delay100ms > 100L) {
            n6 = 100000 / (int)this.apple.delay100ms;
        } else if (this.apple.delay100ms > 0L) {
            n6 = 1000;
        }
        String string = Integer.toString(n6 / 1000) + "." + this.zeroPad(Integer.toString(n6 % 1000), 3) + " MHz";
        graphics.drawString(string, this.screenLeft, this.screenTop, 20);
        string = "PC=" + this.zeroPad(Integer.toString(this.apple.PC, 16), 4);
        graphics.drawString(string, this.screenLeft, this.screenTop + n * 1, 20);
        string = " [" + this.zeroPad(Integer.toString(n3, 16), 2) + " " + this.zeroPad(Integer.toString(n4, 16), 2) + " " + this.zeroPad(Integer.toString(n5, 16), 2) + "]";
        graphics.drawString(string, this.screenLeft, this.screenTop + n * 2, 20);
        string = "A=" + this.zeroPad(Integer.toString(this.apple.A, 16), 2);
        graphics.drawString(string, this.screenLeft, this.screenTop + n * 3, 20);
        string = "X=" + this.zeroPad(Integer.toString(this.apple.X, 16), 2);
        graphics.drawString(string, this.screenLeft, this.screenTop + n * 4, 20);
        string = "Y=" + this.zeroPad(Integer.toString(this.apple.Y, 16), 2);
        graphics.drawString(string, this.screenLeft, this.screenTop + n * 5, 20);
        string = "S=" + this.zeroPad(Integer.toString(this.apple.S, 16), 2);
        graphics.drawString(string, this.screenLeft, this.screenTop + n * 6, 20);
    }

    public void run() {
        try {
            while (!this.threadStop) {
                long l;
                long l2 = System.currentTimeMillis();
                if (!this.threadPause) {
                    int n;
                    int n2;
                    int n3;
                    boolean bl;
                    boolean bl2 = false;
                    int n4 = 0;
                    int n5 = 0;
                    this.keyboard.update();
                    if (this.drawPrepare) {
                        this.canvasPrepare();
                        this.drawPrepare = false;
                        this.drawBackground = true;
                        this.drawRepaint = true;
                    }
                    if (this.graphicsMode != this.apple.graphicsMode) {
                        if ((this.graphicsMode & 0x40) != (this.apple.graphicsMode & 0x40)) {
                            Graphics graphics = this.text.getGraphics();
                            if ((this.apple.graphicsMode & 0x40) != 0) {
                                graphics.drawRegion(this.textAlt, 0, 0, 512, 8, 0, 512, 0, 20);
                            } else {
                                graphics.copyArea(0, 0, 512, 8, 512, 0, 20);
                            }
                        }
                        this.graphicsMode = this.apple.graphicsMode;
                        this.drawRepaint = true;
                        this.pageDoubleTextBase = 0;
                    }
                    boolean bl3 = (this.graphicsMode & 3) != 0;
                    boolean bl4 = (this.graphicsMode & 9) == 0;
                    boolean bl5 = (this.graphicsMode & 9) == 8;
                    boolean bl6 = (this.graphicsMode & 3) == 2;
                    boolean bl7 = (this.graphicsMode & 0x14) == 4;
                    boolean bl8 = (this.graphicsMode & 0x20) == 32;
                    boolean bl9 = bl = (this.graphicsMode & 0xA0) == 160;
                    if (bl3 || bl4) {
                        n4 = bl7 ? 2048 : 1024;
                        n3 = n4 >> 7;
                        n2 = n3 + 8;
                        for (n = n3; n < n2; ++n) {
                            this.dirty[n] = this.drawRepaint ? true : this.apple.dirty[n];
                            this.apple.dirty[n] = false;
                            if (!this.dirty[n]) continue;
                            bl2 = true;
                        }
                    }
                    if (bl5) {
                        n5 = bl7 ? 16384 : 8192;
                        n3 = n5 >> 7;
                        n2 = n3 + 8;
                        for (n = n3; n < n2; ++n) {
                            this.dirty[n] = this.drawRepaint ? true : this.apple.dirty[n + 0] || this.apple.dirty[n + 8] || this.apple.dirty[n + 16] || this.apple.dirty[n + 24] || this.apple.dirty[n + 32] || this.apple.dirty[n + 40] || this.apple.dirty[n + 48] || this.apple.dirty[n + 56];
                            this.apple.dirty[n + 0] = false;
                            this.apple.dirty[n + 8] = false;
                            this.apple.dirty[n + 16] = false;
                            this.apple.dirty[n + 24] = false;
                            this.apple.dirty[n + 32] = false;
                            this.apple.dirty[n + 40] = false;
                            this.apple.dirty[n + 48] = false;
                            this.apple.dirty[n + 56] = false;
                            if (!this.dirty[n]) continue;
                            bl2 = true;
                        }
                    }
                    this.drawRepaint = false;
                    if (bl2) {
                        Graphics graphics = this.screen.getGraphics();
                        if (bl5) {
                            if (bl) {
                                this.renderDoubleHires(graphics, n5, bl6);
                            } else {
                                this.renderHires(graphics, n5, bl6);
                            }
                        } else if (bl4) {
                            if (bl) {
                                this.renderDoubleLores(graphics, n4, bl6);
                            } else {
                                this.renderLores(graphics, n4, bl6);
                            }
                        }
                        if (bl3) {
                            if (bl8) {
                                this.renderDoubleText(graphics, n4, bl6);
                            } else {
                                this.renderText(graphics, n4, bl6);
                            }
                        }
                        this.repaint();
                    }
                }
                if ((l = 250L + (System.currentTimeMillis() - l2)) > 0L) {
                    Thread.sleep(l);
                }
                Thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void paint(Graphics graphics) {
        if (this.drawBackground) {
            this.drawBackground = false;
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
        if (this.screen != null) {
            if (this.getPageRotation()) {
                graphics.drawRegion(this.screen, 0, 0, this.screenWidth, this.screenHeight, 5, this.screenLeft, this.screenTop, 20);
            } else {
                graphics.drawImage(this.screen, this.screenLeft, this.screenTop, 20);
            }
        }
        if (this.drawStatInfo) {
            this.paintStatInfo(graphics);
        }
        if (this.apple.threadError != null) {
            Alert alert = new Alert(null, "Emulator fatal error. Press Left Action-1 for more info. Java Error: " + this.apple.threadError, null, AlertType.ERROR);
            this.apple.threadError = null;
            alert.setTimeout(-2);
            this.display.setCurrent((Displayable)alert);
        }
    }
}

