/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DiskII
extends Peripheral {
    private static final int NUM_DRIVES = 2;
    private static final int DOS_NUM_SECTORS = 16;
    private static final int DOS_NUM_TRACKS = 35;
    private static final int DOS_TRACK_BYTES = 4096;
    private static final int RAW_TRACK_BYTES = 6250;
    private int trackPos;
    private byte[] track;
    private int physTrackNum;
    private int phase;
    private int[] drivePhysTrackNum = new int[2];
    private byte[][][] disk = new byte[2][35][];
    private boolean[] writeProtect = new boolean[2];
    private int drive = 0;
    private boolean motorOn = false;
    private int latchAddress;
    private int latchData;
    private boolean writeMode;
    private static final int[] gcrEncodingTable = new int[]{150, 151, 154, 155, 157, 158, 159, 166, 167, 171, 172, 173, 174, 175, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 203, 205, 206, 207, 211, 214, 215, 217, 218, 219, 220, 221, 222, 223, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 242, 243, 244, 245, 246, 247, 249, 250, 251, 252, 253, 254, 255};
    private int[] gcrDecodingTable = new int[256];
    private int[] gcrSwapBit = new int[]{0, 2, 1, 3};
    private int[] gcrBuffer = new int[256];
    private int[] gcrBuffer2 = new int[86];
    private static final int[] gcrLogicalSector = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};
    private byte[] gcrNibbles = new byte[6250];
    private int gcrNibblesPos;

    public DiskII(EmAppleII emAppleII, int n) {
        super(emAppleII, n);
    }

    public int ioRead(int n) {
        switch (n & 0xF) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 1: {
                this.phase = this.physTrackNum & 3;
                if (this.phase == 1) {
                    if (this.physTrackNum > 0) {
                        --this.physTrackNum;
                    }
                } else if (this.phase == 3 && this.physTrackNum < 69) {
                    ++this.physTrackNum;
                }
                this.track = this.disk[this.drive][this.physTrackNum >> 1];
                break;
            }
            case 3: {
                this.phase = this.physTrackNum & 3;
                if (this.phase == 2) {
                    if (this.physTrackNum > 0) {
                        --this.physTrackNum;
                    }
                } else if (this.phase == 0 && this.physTrackNum < 69) {
                    ++this.physTrackNum;
                }
                this.track = this.disk[this.drive][this.physTrackNum >> 1];
                break;
            }
            case 5: {
                this.phase = this.physTrackNum & 3;
                if (this.phase == 3) {
                    if (this.physTrackNum > 0) {
                        --this.physTrackNum;
                    }
                } else if (this.phase == 1 && this.physTrackNum < 69) {
                    ++this.physTrackNum;
                }
                this.track = this.disk[this.drive][this.physTrackNum >> 1];
                break;
            }
            case 7: {
                this.phase = this.physTrackNum & 3;
                if (this.phase == 0) {
                    if (this.physTrackNum > 0) {
                        --this.physTrackNum;
                    }
                } else if (this.phase == 2 && this.physTrackNum < 69) {
                    ++this.physTrackNum;
                }
                this.track = this.disk[this.drive][this.physTrackNum >> 1];
                break;
            }
            case 8: {
                this.motorOn = false;
                break;
            }
            case 9: {
                this.motorOn = true;
                break;
            }
            case 10: {
                this.drivePhysTrackNum[this.drive] = this.physTrackNum;
                this.drive = 0;
                this.physTrackNum = this.drivePhysTrackNum[this.drive];
                this.track = this.disk[this.drive][this.physTrackNum >> 1];
                break;
            }
            case 11: {
                this.drivePhysTrackNum[this.drive] = this.physTrackNum;
                this.drive = 1;
                this.physTrackNum = this.drivePhysTrackNum[this.drive];
                this.track = this.disk[this.drive][this.physTrackNum >> 1];
                break;
            }
            case 12: {
                return this.ioLatchC();
            }
            case 13: {
                this.ioLatchD(255);
                break;
            }
            case 14: {
                return this.ioLatchE();
            }
            case 15: {
                this.ioLatchF(255);
            }
        }
        return this.apple.noise();
    }

    public void ioWrite(int n, int n2) {
        switch (n & 0xF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.ioRead(n);
                break;
            }
            case 12: {
                this.ioLatchC();
                break;
            }
            case 13: {
                this.ioLatchD(n2);
                break;
            }
            case 14: {
                this.ioLatchE();
                break;
            }
            case 15: {
                this.ioLatchF(n2);
            }
        }
    }

    public void reset() {
        this.ioRead(8);
    }

    public int ioLatchC() {
        if (this.writeMode) {
            this.track[this.trackPos] = (byte)this.latchData;
        } else {
            this.latchData = this.track[this.trackPos] & 0xFF;
        }
        ++this.trackPos;
        if (this.trackPos >= 6250) {
            this.trackPos = 0;
        }
        this.latchAddress = 12;
        return this.latchData;
    }

    public void ioLatchD(int n) {
        this.writeMode = true;
        this.latchData = n;
        this.latchAddress = 13;
    }

    public int ioLatchE() {
        if (this.latchAddress == 13) {
            this.latchAddress = 14;
            return this.writeProtect[this.drive] ? 128 : 0;
        }
        this.writeMode = false;
        this.latchAddress = 14;
        return 60;
    }

    public void ioLatchF(int n) {
        this.writeMode = true;
        this.latchData = n;
        this.latchAddress = 15;
    }

    private final void gcrWriteNibble(int n) {
        this.gcrNibbles[this.gcrNibblesPos] = (byte)n;
        ++this.gcrNibblesPos;
    }

    private final void writeSync(int n) {
        while (n > 0) {
            --n;
            this.gcrWriteNibble(255);
        }
    }

    private final void encode44(int n) {
        this.gcrWriteNibble(n >> 1 | 0xAA);
        this.gcrWriteNibble(n | 0xAA);
    }

    private void encode62(byte[] byArray, int n) {
        int n2;
        this.gcrBuffer2[0] = this.gcrSwapBit[byArray[n + 1] & 3];
        this.gcrBuffer2[1] = this.gcrSwapBit[byArray[n] & 3];
        int n3 = 2;
        for (n2 = 255; n2 >= 0; --n2) {
            this.gcrBuffer2[n3] = this.gcrBuffer2[n3] << 2 | this.gcrSwapBit[byArray[n + n2] & 3];
            this.gcrBuffer[n2] = (byArray[n + n2] & 0xFF) >> 2;
            n3 = n3 == 85 ? 0 : n3 + 1;
        }
        n2 = 0;
        while (n2 < 86) {
            int n4 = n2++;
            this.gcrBuffer2[n4] = this.gcrBuffer2[n4] & 0x3F;
        }
    }

    private final void writeAddressField(int n, int n2, int n3) {
        this.gcrWriteNibble(213);
        this.gcrWriteNibble(170);
        this.gcrWriteNibble(150);
        this.encode44(n);
        this.encode44(n2);
        this.encode44(n3);
        this.encode44(n ^ n2 ^ n3);
        this.gcrWriteNibble(222);
        this.gcrWriteNibble(170);
        this.gcrWriteNibble(235);
    }

    private void writeDataField() {
        int n;
        int n2;
        int n3 = 0;
        this.gcrWriteNibble(213);
        this.gcrWriteNibble(170);
        this.gcrWriteNibble(173);
        for (n2 = 85; n2 >= 0; --n2) {
            n = n3 ^ this.gcrBuffer2[n2];
            this.gcrWriteNibble(gcrEncodingTable[n]);
            n3 = this.gcrBuffer2[n2];
        }
        for (n2 = 0; n2 < 256; ++n2) {
            n = n3 ^ this.gcrBuffer[n2];
            this.gcrWriteNibble(gcrEncodingTable[n]);
            n3 = this.gcrBuffer[n2];
        }
        this.gcrWriteNibble(gcrEncodingTable[n3]);
        this.gcrWriteNibble(222);
        this.gcrWriteNibble(170);
        this.gcrWriteNibble(235);
    }

    private void trackToNibbles(byte[] byArray, byte[] byArray2, int n, int n2) {
        this.gcrNibbles = byArray2;
        this.gcrNibblesPos = 0;
        for (int i = 0; i < 16; ++i) {
            this.encode62(byArray, gcrLogicalSector[i] << 8);
            this.writeSync(12);
            this.writeAddressField(n, n2, i);
            this.writeSync(8);
            this.writeDataField();
        }
        this.writeSync(6250 - this.gcrNibblesPos);
    }

    public boolean mountDisk(InputStream inputStream, int n, boolean bl) {
        byte[] byArray = new byte[6250];
        try {
            for (int i = 0; i < 35; ++i) {
                this.disk[n][i] = new byte[6250];
                inputStream.read(byArray, 0, 4096);
                this.trackToNibbles(byArray, this.disk[n][i], 254, i);
            }
            this.track = this.disk[n][this.physTrackNum >> 1];
            this.writeProtect[n] = bl;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean initDrive(int n, boolean bl) {
        for (int i = 0; i < 35; ++i) {
            this.disk[n][i] = new byte[6250];
        }
        this.track = this.disk[n][this.physTrackNum >> 1];
        this.writeProtect[n] = bl;
        return true;
    }

    public boolean unmountDisk(OutputStream outputStream, int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadROM(String string) {
        boolean bl = false;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            return bl;
        }
        try {
            inputStream.read(this.apple.mem, 147456 + (this.slot << 8), 256);
            bl = true;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }
}

