/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.c64.core.CPU6502Instruction;
import de.joergjahnke.c64.core.VIA6522;
import de.joergjahnke.c64.core.VIA6522_DC;
import de.joergjahnke.c64.drive.DiskDriveHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class C1541CPU6502
extends CPU6502 {
    private static final int OPCODE_DCROUTINE = 2;
    private static final int OPCODE_SKIPROMTEST = 18;
    private static final int OPCODE_WAITLOOP = 34;
    private static final int OPCODE_PRINTFILENAME = 50;
    private static final int OPCODE_FILEWRITE1 = 66;
    private static final int OPCODE_FILEWRITE2 = 82;
    private static final int OPCODE_FILEWRITE3 = 98;
    private static final int RAM_SIZE = 2048;
    private static final int ROM_OFFSET = 2048;
    private static final int FLOPPY_ROM_SIZE = 16384;
    private static final int FLOPPY_ROM_ADDRESS = 49152;
    private static final int FLOPPY_ROM_OFFSET = -47104;
    private static final int BUFFER0_MEMORY = 768;
    private static final int BUFFER0_TRACKSECTOR = 6;
    private static final int JOB_READ_SECTOR = 128;
    private static final int JOB_WRITE_SECTOR = 144;
    private static final int JOB_VERIFY_SECTOR = 160;
    private static final int JOB_SEARCH_SECTOR = 176;
    private static final int JOB_BUMP = 192;
    private static final int JOB_EXECUTE = 208;
    private static final int JOB_EXECUTE_WITH_STARTUP = 224;
    private static final int STATUS_OK = 1;
    private static final int STATUS_BLOCK_NOT_FOUND = 4;
    private static final int STATUS_WRITE_PROTECT = 8;
    private static final int STATUS_NO_DISK = 15;
    private static final int XDI = -1;
    private final C1541 c1541;
    private long nextIOUpdate = 0L;
    static /* synthetic */ Class class$de$joergjahnke$c64$core$VIA6522_BC;
    static /* synthetic */ Class class$de$joergjahnke$c64$core$VIA6522_DC;

    public C1541CPU6502(C1541 c1541) {
        super(c1541, 18432);
        this.ramSize = 2048;
        this.c1541 = c1541;
        this.setLogger(this.c1541.getLogger());
        this.installROMs();
        this.setPC(this.getStartAddress());
    }

    protected final int getPC() {
        return this.pc >= 49152 ? this.pc + -47104 : this.pc;
    }

    protected final int readByte(int address) {
        switch (address & 0xF000) {
            case 0: {
                return this.memory[address & 0x7FF] & 0xFF;
            }
            case 4096: {
                switch (address & 0xFF00) {
                    case 6144: {
                        return this.c1541.getVIA(0).readRegister(address & 0xF);
                    }
                    case 7168: {
                        return this.c1541.getVIA(1).readRegister(address & 0xF);
                    }
                }
                return 0;
            }
            case 49152: 
            case 53248: 
            case 57344: 
            case 61440: {
                return this.memory[-47104 + address] & 0xFF;
            }
        }
        return 0;
    }

    protected final void writeByte(int address, int data) {
        block0 : switch (address & 0xF000) {
            case 0: {
                this.memory[address & 0x7FF] = (byte)data;
                break;
            }
            case 4096: {
                switch (address & 0xFF00) {
                    case 6144: {
                        this.c1541.getVIA(0).writeRegister(address & 0xF, data);
                        break block0;
                    }
                    case 7168: {
                        this.c1541.getVIA(1).writeRegister(address & 0xF, data);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void reset() {
        super.reset();
        for (int i = 0; i < 2048; ++i) {
            this.memory[i] = 0;
        }
        this.setPC(this.getStartAddress());
    }

    protected final void installROMs() {
        this.loadROM("/roms/floppy.c64", 2048, 16384);
    }

    protected void patchROMs() {
        this.addInstruction(new CPU6502Instruction("XI0", 2, -1, 0, 0));
        this.addInstruction(new CPU6502Instruction("XI1", 18, -1, 0, 0));
        this.addInstruction(new CPU6502Instruction("XI2", 34, -1, 0, 0));
        this.addInstruction(new CPU6502Instruction("XI3", 50, -1, 1, 0));
        this.addInstruction(new CPU6502Instruction("XI4", 66, -1, 1, 0));
        this.addInstruction(new CPU6502Instruction("XI5", 82, -1, 1, 0));
        this.addInstruction(new CPU6502Instruction("XI6", 98, -1, 1, 0));
        this.memory[15024] = 2;
        this.memory[13001] = 18;
        this.memory[13311] = 34;
        this.memory[8116] = 50;
        this.memory[15756] = 66;
        this.memory[15779] = 82;
        this.memory[17585] = 98;
        this.memory[17628] = 98;
    }

    protected void emulateExtendedInstruction(CPU6502Instruction instruction) {
        switch (instruction.opCode) {
            case 2: {
                if (!this.c1541.isEmulateDiskController()) {
                    this.emulateDiskControllerIRQRoutine();
                    break;
                }
                this.operationTSX();
                break;
            }
            case 18: {
                this.setPC(60138);
                break;
            }
            case 34: {
                this.operationCLI();
                this.c1541.stop();
                break;
            }
            case 50: {
                this.operationLDA(this.getOperand(instruction));
                StringBuffer filename = new StringBuffer();
                for (int i = 512; i < 528 && this.memory[i] > 0; ++i) {
                    filename.append((char)this.memory[i]);
                }
                this.getLogger().info("Opening file '" + filename + "'");
                break;
            }
            case 66: {
                ((VIA6522_DC)this.c1541.getVIA(1)).proceedToNextSync();
                this.setPC(62868);
                break;
            }
            case 82: {
                ((VIA6522_DC)this.c1541.getVIA(1)).writeSync();
                this.setPC(62897);
                break;
            }
            case 98: {
                ((VIA6522_DC)this.c1541.getVIA(1)).writeSync();
                this.setPC(this.pc + 11);
                break;
            }
            default: {
                super.emulateExtendedInstruction(instruction);
            }
        }
    }

    protected void emulateDiskControllerIRQRoutine() {
        this.readByte(7172);
        block7: for (int m = 0; m < 5; ++m) {
            int cmd = this.readByte(m) & 0xF0;
            int track = this.readByte(6 + m * 2);
            int sector = this.readByte(6 + m * 2 + 1);
            int bufferAdr = 768 + 256 * m;
            if (cmd > 0) {
                this.c1541.markActive();
            }
            this.writeByte(63, m);
            switch (cmd) {
                case 128: {
                    int i;
                    this.c1541.getDriveHandler().gotoBlock(track, sector);
                    byte[] bytes = this.c1541.getDriveHandler().readBlock();
                    for (i = 0; i < bytes.length; ++i) {
                        this.writeByte(bufferAdr + i, bytes[i] & 0xFF);
                    }
                    this.writeByte(76, sector);
                    this.writeByte(m, 1);
                    continue block7;
                }
                case 144: {
                    int i;
                    this.c1541.getDriveHandler().gotoBlock(track, sector);
                    byte[] bytes = new byte[256];
                    for (i = 0; i < bytes.length; ++i) {
                        bytes[i] = (byte)this.readByte(bufferAdr + i);
                    }
                    this.c1541.getDriveHandler().writeBlock(bytes);
                    this.writeByte(76, sector);
                    this.writeByte(m, 1);
                    continue block7;
                }
                case 160: 
                case 192: {
                    this.writeByte(m, 1);
                    continue block7;
                }
                case 176: {
                    this.writeByte(34, track);
                    this.writeByte(67, DiskDriveHandler.SECTORS_PER_TRACK[track - 1]);
                    this.writeByte(77, sector);
                    this.writeByte(m, 1);
                    continue block7;
                }
                case 208: 
                case 224: {
                    throw new RuntimeException("Executing jobs not yet implemented!");
                }
            }
        }
        this.setPC(64198);
    }

    public void serialize(DataOutputStream out) throws IOException {
        int i;
        super.serialize(out);
        out.writeInt(this.irqs.size());
        for (i = 0; i < this.irqs.size(); ++i) {
            out.writeUTF(this.irqs.elementAt(i).getClass().getName());
        }
        out.writeInt(this.nmis.size());
        for (i = 0; i < this.nmis.size(); ++i) {
            out.writeUTF(this.nmis.elementAt(i).getClass().getName());
        }
    }

    public void deserialize(DataInputStream in) throws IOException {
        String className;
        int i;
        super.deserialize(in);
        int size = in.readInt();
        this.irqs.removeAllElements();
        for (i = 0; i < size; ++i) {
            className = in.readUTF();
            if ((class$de$joergjahnke$c64$core$VIA6522_BC == null ? C1541CPU6502.class$("de.joergjahnke.c64.core.VIA6522_BC") : class$de$joergjahnke$c64$core$VIA6522_BC).getName().equals(className)) {
                this.irqs.addElement(this.c1541.getVIA(0));
                continue;
            }
            if ((class$de$joergjahnke$c64$core$VIA6522_DC == null ? C1541CPU6502.class$("de.joergjahnke.c64.core.VIA6522_DC") : class$de$joergjahnke$c64$core$VIA6522_DC).getName().equals(className)) {
                this.irqs.addElement(this.c1541.getVIA(1));
                continue;
            }
            throw new IllegalStateException("Unsupported interrupt type for deserialization: " + className + "!");
        }
        size = in.readInt();
        this.nmis.removeAllElements();
        for (i = 0; i < size; ++i) {
            className = in.readUTF();
            if ((class$de$joergjahnke$c64$core$VIA6522_BC == null ? C1541CPU6502.class$("de.joergjahnke.c64.core.VIA6522_BC") : class$de$joergjahnke$c64$core$VIA6522_BC).getName().equals(className)) {
                this.irqs.addElement(this.c1541.getVIA(0));
                continue;
            }
            if ((class$de$joergjahnke$c64$core$VIA6522_DC == null ? C1541CPU6502.class$("de.joergjahnke.c64.core.VIA6522_DC") : class$de$joergjahnke$c64$core$VIA6522_DC).getName().equals(className)) {
                this.irqs.addElement(this.c1541.getVIA(1));
                continue;
            }
            throw new IllegalStateException("Unsupported interrupt type for deserialization: " + className + "!");
        }
    }

    protected void checkIOChips() {
        this.overflowFlag |= ((VIA6522_DC)this.c1541.getVIA(1)).isByteReady();
        long cycles_ = this.cycles;
        if (cycles_ >= this.nextIOUpdate) {
            VIA6522_DC via1;
            VIA6522 via0 = this.c1541.getVIA(0);
            if (cycles_ >= via0.getNextUpdate()) {
                via0.update(cycles_);
            }
            if (cycles_ >= (via1 = (VIA6522_DC)this.c1541.getVIA(1)).getNextUpdate()) {
                via1.update(cycles_);
            }
            this.nextIOUpdate = Math.min(Math.min(cycles_ + 1000L, via0.getNextUpdate()), via1.getNextUpdate());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

