/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.IOChip;
import de.joergjahnke.c64.core.SID6581;
import de.joergjahnke.common.emulation.FrequencyDataProducer;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class SID6581Voice
implements IOChip,
Serializable,
FrequencyDataProducer {
    private static final int FREQUENCY_CONTROL_LOW = 0;
    private static final int FREQUENCY_CONTROL_HIGH = 1;
    private static final int PULSE_WAVEFORM_WIDTH_LOW = 2;
    private static final int PULSE_WAVEFORM_WIDTH_HIGH = 3;
    private static final int CONTROL = 4;
    private static final int ENVELOPE_GENERATE_ATTACKDECAY_CONTROL = 5;
    private static final int ENVELOPE_GENERATE_SUSTAINRELEASE_CONTROL = 6;
    private static final double ENVELOPE_MAX = 255.0;
    private static final int ATTACK = 1;
    private static final int DECAY = 2;
    private static final int SUSTAIN = 3;
    private static final int RELEASE = 4;
    private static final int FINISHED = 5;
    private static final int WAVE_ZERO = 2048;
    private static final int WAVEFORM_TRIANGLE = 1;
    private static final int[] ENVELOPE_RATE_TIMES = new int[]{2000, 8000, 16000, 24000, 38000, 56000, 68000, 80000, 100000, 240000, 500000, 800000, 1000000, 3000000, 5000000, 8000000};
    private static final double[] DECAY_FACTORS = new double[]{0.9038571383911007, 0.9750456476692515, 0.987443997231869, 0.9916117159902613, 0.9946939186227746, 0.9963963671608145, 0.9970313573998748, 0.9974760913310542, 0.9979803629404478, 0.9991916551761941, 0.9995957458773989, 0.9997473220188804, 0.9997978525068952, 0.9999326129613874, 0.9999595672318936, 0.999974729328351};
    private static final WaveForm[] waveForms = new WaveForm[16];
    private int ac = 0;
    private final double[] attackDeltas = new double[ENVELOPE_RATE_TIMES.length];
    private int envelopePhase = 5;
    private SID6581Voice syncSource = null;
    private int output = 0;
    private int oscillator = 0;
    private double envelopeOutput = 0.0;
    private boolean hasNewOutput = false;
    private boolean isRingBitSet = false;
    private boolean isSyncBitSet = false;
    private boolean isTestBitSet = false;
    private int waveFormNo = 0;
    private WaveForm waveForm;
    private int frequency = 0;
    private long nextUpdate;
    private final SID6581 sid;
    protected final int[] registers;
    private final int offset;

    public SID6581Voice(SID6581 sid, int offset) {
        this.sid = sid;
        this.registers = sid.registers;
        this.offset = offset;
        this.nextUpdate = sid.c64.getCPU().getCycles();
        for (int i = 0; i < ENVELOPE_RATE_TIMES.length; ++i) {
            this.attackDeltas[i] = 2.5123824E8 / (double)(this.sid.getSampleRate() * ENVELOPE_RATE_TIMES[i]);
        }
        if (null == waveForms[0]) {
            SID6581Voice.waveForms[0] = new NullWaveForm();
            SID6581Voice.waveForms[1] = new TriangleWaveForm();
            SID6581Voice.waveForms[2] = new SawWaveForm();
            SID6581Voice.waveForms[3] = new CombinedWaveForm(waveForms[1], waveForms[2]);
            SID6581Voice.waveForms[4] = new PulseWaveForm();
            SID6581Voice.waveForms[5] = new CombinedWaveForm(waveForms[1], waveForms[4]);
            SID6581Voice.waveForms[6] = new CombinedWaveForm(waveForms[2], waveForms[4]);
            SID6581Voice.waveForms[7] = new CombinedWaveForm(waveForms[3], waveForms[4]);
            SID6581Voice.waveForms[8] = new NoiseWaveForm();
            SID6581Voice.waveForms[9] = new CombinedWaveForm(waveForms[1], waveForms[8]);
            SID6581Voice.waveForms[10] = new CombinedWaveForm(waveForms[2], waveForms[8]);
            SID6581Voice.waveForms[11] = new CombinedWaveForm(waveForms[3], waveForms[8]);
            SID6581Voice.waveForms[12] = new CombinedWaveForm(waveForms[4], waveForms[8]);
            SID6581Voice.waveForms[13] = new CombinedWaveForm(waveForms[1], waveForms[12]);
            SID6581Voice.waveForms[14] = new CombinedWaveForm(waveForms[2], waveForms[12]);
            SID6581Voice.waveForms[15] = new CombinedWaveForm(waveForms[3], waveForms[12]);
        }
        this.waveForm = waveForms[0];
    }

    protected void setSyncSource(SID6581Voice sync) {
        this.syncSource = sync;
    }

    private int getFrequencyLevel() {
        return this.registers[this.offset + 0] + (this.registers[this.offset + 1] << 8);
    }

    private int getPulseWidthLevel() {
        return this.registers[this.offset + 2] + (this.registers[this.offset + 3] & 0xF00);
    }

    private int getPulseWidth() {
        return this.getPulseWidthLevel() * this.sid.getSampleRate() / 4095;
    }

    private boolean isGateBitSet() {
        return (this.registers[this.offset + 4] & 1) != 0;
    }

    private boolean isSyncBitSet() {
        return (this.registers[this.offset + 4] & 2) != 0;
    }

    private boolean isRingBitSet() {
        return (this.registers[this.offset + 4] & 4) != 0;
    }

    private boolean isTestBitSet() {
        return (this.registers[this.offset + 4] & 8) != 0;
    }

    private int getWaveFormNo() {
        return this.registers[this.offset + 4] >> 4;
    }

    private int getAttackRate() {
        return this.registers[this.offset + 5] >> 4;
    }

    private int getDecayRate() {
        return this.registers[this.offset + 5] & 0xF;
    }

    private double getDecayFactor() {
        return DECAY_FACTORS[this.getDecayRate()];
    }

    private int getReleaseRate() {
        return this.registers[this.offset + 6] & 0xF;
    }

    private double getReleaseFactor() {
        return DECAY_FACTORS[this.getReleaseRate()];
    }

    private int getSustainLevel() {
        return this.registers[this.offset + 6] >> 4;
    }

    private int getSustainValue() {
        int sustainLevel = this.getSustainLevel();
        return (sustainLevel << 4) + sustainLevel;
    }

    private boolean isSoundStarted() {
        return this.envelopePhase < 4;
    }

    protected int getOscillatorOutput() {
        return this.oscillator >> 3 & 0xFF;
    }

    protected int getEnvelopeOutput() {
        return (int)this.envelopeOutput;
    }

    protected int getOutput() {
        this.hasNewOutput = false;
        return this.output;
    }

    protected final boolean hasNewOutput() {
        return this.hasNewOutput;
    }

    public void reset() {
        this.ac = 0;
        for (int i = 0; i <= 6; ++i) {
            this.writeRegister(i, 0);
        }
        this.oscillator = 0;
        this.envelopeOutput = 0.0;
        this.envelopePhase = 5;
        this.output = 0;
        this.hasNewOutput = false;
    }

    public final int readRegister(int register) {
        return this.registers[this.offset + register];
    }

    public final void writeRegister(int register, int data) {
        this.registers[this.offset + register] = data;
        switch (register) {
            case 0: 
            case 1: {
                this.frequency = this.getFrequency();
                break;
            }
            case 4: {
                if (this.isGateBitSet()) {
                    if (!this.isSoundStarted()) {
                        this.envelopePhase = 1;
                    }
                } else {
                    this.envelopePhase = 4;
                }
                this.isRingBitSet = this.isRingBitSet();
                this.isSyncBitSet = this.isSyncBitSet();
                this.isTestBitSet = this.isTestBitSet();
                this.waveFormNo = this.getWaveFormNo();
                this.waveForm = waveForms[this.waveFormNo];
                break;
            }
            case 6: {
                if (this.envelopePhase != 3 || !((double)this.getSustainValue() < this.envelopeOutput)) break;
                this.envelopePhase = 4;
                break;
            }
        }
    }

    public final long getNextUpdate() {
        return this.nextUpdate;
    }

    public void update(long cycles) {
        if (cycles >= this.getNextUpdate()) {
            if (this.isRingBitSet && this.waveFormNo == 1) {
                this.oscillator = this.waveForm.getOutput(this.ac ^ this.syncSource.ac);
                this.ac += this.frequency;
                this.ac %= this.sid.getSampleRate();
            } else {
                this.oscillator = this.waveForm.getOutput(this.ac);
                this.ac += this.frequency;
                this.ac %= this.sid.getSampleRate();
            }
            if (this.isSyncBitSet && this.syncSource.ac + this.syncSource.frequency > this.sid.getSampleRate()) {
                this.ac = 0;
            }
            switch (this.envelopePhase) {
                case 1: {
                    this.envelopeOutput += this.attackDeltas[this.getAttackRate()];
                    if (!(this.envelopeOutput > 255.0)) break;
                    this.envelopeOutput = 255.0;
                    this.envelopePhase = 2;
                    break;
                }
                case 2: {
                    this.envelopeOutput *= this.getDecayFactor();
                    if (!(this.envelopeOutput < (double)this.getSustainValue())) break;
                    this.envelopeOutput = this.getSustainValue();
                    this.envelopePhase = 3;
                    break;
                }
                case 4: {
                    this.envelopeOutput *= this.getReleaseFactor();
                    if (!(this.envelopeOutput < 1.0)) break;
                    this.envelopeOutput = 0.0;
                    this.envelopePhase = 5;
                    break;
                }
            }
            this.output = this.isTestBitSet ? 0 : (this.oscillator - 2048) * (int)this.envelopeOutput >> 7;
            this.nextUpdate += (long)this.sid.getUpdateRate();
            this.hasNewOutput = true;
        }
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.ac);
        out.writeInt(this.envelopePhase);
        out.writeInt(this.output);
        out.writeInt(this.oscillator);
        out.writeDouble(this.envelopeOutput);
        out.writeBoolean(this.hasNewOutput);
        out.writeBoolean(this.isRingBitSet);
        out.writeBoolean(this.isSyncBitSet);
        out.writeBoolean(this.isTestBitSet);
        out.writeInt(this.waveFormNo);
        out.writeInt(this.frequency);
        out.writeLong(this.nextUpdate);
        SerializationUtils.serialize(out, this.registers);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.ac = in.readInt();
        this.envelopePhase = in.readInt();
        this.output = in.readInt();
        this.oscillator = in.readInt();
        this.envelopeOutput = in.readDouble();
        this.hasNewOutput = in.readBoolean();
        this.isRingBitSet = in.readBoolean();
        this.isSyncBitSet = in.readBoolean();
        this.isTestBitSet = in.readBoolean();
        this.waveFormNo = in.readInt();
        this.waveForm = waveForms[this.waveFormNo];
        this.frequency = in.readInt();
        this.nextUpdate = in.readLong();
        SerializationUtils.deserialize(in, this.registers);
    }

    public int getVolume() {
        return this.waveFormNo == 0 || this.envelopeOutput == 0.0 ? 0 : this.sid.getVolume() * 100 / 15;
    }

    public int getType() {
        switch (this.waveFormNo) {
            case 1: {
                return 69;
            }
            case 2: {
                return 81;
            }
            case 4: {
                return 80;
            }
            case 8: {
                return 127;
            }
        }
        return 0;
    }

    public int getFrequency() {
        return (int)((long)this.getFrequencyLevel() * 985248L / 0x1000000L);
    }

    class CombinedWaveForm
    extends WaveForm {
        private final WaveForm waveForm1;
        private final WaveForm waveForm2;

        public CombinedWaveForm(WaveForm waveForm1, WaveForm waveForm2) {
            this.waveForm1 = waveForm1;
            this.waveForm2 = waveForm2;
        }

        public final int getOutput(int n) {
            int sample1 = this.waveForm1.getOutput(n);
            int sample2 = this.waveForm2.getOutput(n);
            return sample1 << 1 & sample1 >> 1 & sample2 << 1 & sample2 >> 1;
        }
    }

    class NullWaveForm
    extends WaveForm {
        NullWaveForm() {
        }

        public final int getOutput(int n) {
            return 0;
        }
    }

    class NoiseWaveForm
    extends WaveForm {
        private final Random rand = new Random();

        NoiseWaveForm() {
        }

        public final int getOutput(int n) {
            return this.rand.nextInt(4096);
        }
    }

    class TriangleWaveForm
    extends WaveForm {
        TriangleWaveForm() {
        }

        public final int getOutput(int n) {
            int sampleRate = SID6581Voice.this.sid.getSampleRate();
            return n < sampleRate / 2 ? 8190 * n / sampleRate : 8190 * (sampleRate - n) / sampleRate;
        }
    }

    class PulseWaveForm
    extends WaveForm {
        PulseWaveForm() {
        }

        public final int getOutput(int n) {
            return SID6581Voice.this.isTestBitSet || n >= SID6581Voice.this.getPulseWidth() ? 4095 : 0;
        }
    }

    class SawWaveForm
    extends WaveForm {
        SawWaveForm() {
        }

        public final int getOutput(int n) {
            return 4095 * n / SID6581Voice.this.sid.getSampleRate();
        }
    }

    abstract class WaveForm {
        WaveForm() {
        }

        public abstract int getOutput(int var1);
    }
}

