/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.CIA6526;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CIA6526_1
extends CIA6526 {
    private int prbRead = 0;

    public CIA6526_1(C64 c64) {
        super(c64, 56320);
        this.initDataDirectionRegisters();
    }

    private void initDataDirectionRegisters() {
        this.registers[2] = 255;
        this.registers[3] = 0;
    }

    public int getPRBReads() {
        return this.prbRead;
    }

    public void reset() {
        super.reset();
        this.prbRead = 0;
        this.initDataDirectionRegisters();
    }

    public int readRegister(int register) {
        switch (register) {
            case 0: {
                return super.readRegister(register) & this.c64.getKeyboard().getCIAPRAAdjustment(super.readRegister(1) & this.c64.getJoystick(0).getValue()) & this.c64.getJoystick(1).getValue();
            }
            case 1: {
                ++this.prbRead;
                return super.readRegister(register) & this.c64.getKeyboard().getCIAPRBAdjustment(super.readRegister(0) & this.c64.getJoystick(1).getValue()) & this.c64.getJoystick(0).getValue();
            }
        }
        return super.readRegister(register);
    }

    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeInt(this.prbRead);
    }

    public void deserialize(DataInputStream in) throws IOException {
        super.deserialize(in);
        this.prbRead = in.readInt();
    }

    protected final void clearInterrupt() {
        this.cpu.setIRQ(this, false);
    }

    protected final void triggerInterrupt() {
        this.cpu.setIRQ(this, true);
    }
}

