/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery.browser;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.DataElement;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Command;
import net.benhui.btgallery.Util;
import net.benhui.btgallery.XList;
import net.benhui.btgallery.browser.BBRemoteDevice;
import net.benhui.btgallery.browser.BTBrowserMain;

public class ServiceDetailsUI
extends XList {
    public Hashtable map = new Hashtable();

    public ServiceDetailsUI() {
        this.addCommand(new Command("View Value", 1, 1));
        this.addCommand(new Command("View Debug Logs", 1, 1));
        this.addCommand(new Command("Back", 2, 2));
        this.setCommandListener(BTBrowserMain.instance);
    }

    public void showui() {
        super.deleteAll();
        this.map.clear();
        BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)BTBrowserMain.devices.elementAt(BTBrowserMain.selectedDevice));
        try {
            super.setHeader(remoteDevice.getFriendlyName(false), null, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            remoteDevice = (BBRemoteDevice)((Object)BTBrowserMain.devices.elementAt(BTBrowserMain.selectedDevice));
            ServiceRecord r = (ServiceRecord)remoteDevice.serviceRecords.elementAt(BTBrowserMain.selectedService);
            BTBrowserMain.log("selectedDevice " + BTBrowserMain.selectedDevice + " selectedService " + BTBrowserMain.selectedService + " ServiceRecord " + r);
            int idx = this.append("URL", null);
            String url = r.getConnectionURL(0, false);
            if (url != null) {
                this.append(" " + url, null);
            } else {
                url = "NOT AVAILABLE";
                this.append(" " + url, null);
            }
            String[] details = new String[]{"Name: Connection URL", "Type: URL", "Value: " + url};
            this.map.put(new Integer(idx), details);
            int[] ids = r.getAttributeIDs();
            int i = 0;
            while (i < ids.length) {
                DataElement el = r.getAttributeValue(ids[i]);
                this.appendDataElement(el, ids[i], " ");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BTBrowserMain.err(e);
        }
        this.repaint();
    }

    public void appendDataElement(DataElement e, int id, String indent) {
        int type = e.getDataType();
        if (type == 56 || type == 48) {
            Enumeration enumeration = (Enumeration)e.getValue();
            while (enumeration.hasMoreElements()) {
                DataElement e2 = (DataElement)enumeration.nextElement();
                this.appendDataElement(e2, id, indent + " ");
            }
        } else if (type == 8 || type == 9 || type == 10 || type == 16 || type == 17 || type == 18 || type == 19) {
            long v = e.getLong();
            String s = Util.toHexString(v);
            int idx = this.append(Util.idToName(id) + " " + Util.toHexString(id), null);
            this.append(indent + String.valueOf(v), null);
            String[] details = new String[]{"Name: " + Util.idToName(id) + "(" + Util.toHexString(id) + ")", "Type: " + Util.attrTypeToName(type) + "(" + type + ")", "Value: " + String.valueOf(v) + "(" + s + ")"};
            this.map.put(new Integer(idx), details);
        } else if (type == 11 || type == 12 || type == 20) {
            byte[] v = (byte[])e.getValue();
            String s = Util.toHexString(v);
            int idx = this.append(Util.idToName(id) + " " + s, null);
            this.append(indent + s, null);
            String[] details = new String[]{"Name: " + Util.idToName(id) + "(" + Util.toHexString(id) + ")", "Type: " + Util.attrTypeToName(type) + "(" + type + ")", "Value: " + String.valueOf(s) + "(" + Util.toHexString(v) + ")"};
            this.map.put(new Integer(idx), details);
        } else if (type == 24) {
            UUID uuid = (UUID)e.getValue();
            int idx = this.append(Util.idToName(id) + " " + Util.toHexString(id), null);
            this.append(indent + Util.uuidToName(uuid), null);
            String[] details = new String[]{"Name: " + Util.idToName(id) + "(" + Util.toHexString(id) + ")", "Type: " + Util.attrTypeToName(type) + "(" + type + ")", "Value: " + Util.uuidToName(uuid) + "(" + uuid.toString() + ")"};
            this.map.put(new Integer(idx), details);
        } else if (type == 32 || type == 64) {
            String v = (String)e.getValue();
            int idx = this.append(Util.idToName(id) + " " + Util.toHexString(id), null);
            this.append(indent + v, null);
            String[] details = new String[]{"Name: " + Util.idToName(id) + "(" + Util.toHexString(id) + ")", "Type: " + Util.attrTypeToName(type) + "(" + type + ")", "Value: " + v};
            this.map.put(new Integer(idx), details);
        } else if (type == 40) {
            boolean v = e.getBoolean();
            int idx = this.append(Util.idToName(id) + " " + Util.toHexString(id), null);
            this.append(indent + String.valueOf(v), null);
            String[] details = new String[]{"Name: " + Util.idToName(id) + "(" + Util.toHexString(id) + ")", "Type: " + Util.attrTypeToName(type) + "(" + type + ")", "Value: " + String.valueOf(v)};
            this.map.put(new Integer(idx), details);
        } else if (type == 0) {
            int idx = this.append(Util.idToName(id) + " " + Util.toHexString(id), null);
            this.append(indent + "NULL", null);
            String[] details = new String[]{"Name: " + Util.idToName(id) + "(" + Util.toHexString(id) + ")", "Type: " + Util.attrTypeToName(type) + "(" + type + ")", "Value: NULL"};
            this.map.put(new Integer(idx), details);
        }
    }
}

