/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import utilitare.BTConn;
import utilitare.FCConnectionTester;
import utilitare.FCList;
import utilitare.FCTextBox;
import utilitare.PCConn;
import utilitare.roatadefoc;

public class FCHubConnection {
    public int connState = 0;
    public static final int CONN_ADD_OK = 669;
    public static final int CONN_ERROR = 667;
    public static final int CONN_START = 3;
    public static final int CONN_SELECTTRANSPORT = 4;
    public static final int CONN_SELECTCONN = 5;
    public static final int CONN_CONNECTING = 6;
    public static final int CONN_CONNECTING_URL = 67;
    public static final int CONN_SEARCHDEVICES = 7;
    public static final int CONN_SELECTDEVICE = 8;
    public static final int CONN_SEARCHSERVICES = 9;
    public static final int CONN_SELECTSERVICE = 10;
    public static final int CONN_TESTSERVICES = 6969;
    public static final int CONN_TESTSERVICESW = 6970;
    public static final int CONN_TESTSERVICESDONE = 6971;
    public static final String RMS_NAME = "fchub_btremote";
    public int[] serviceIndexes;
    public String err_string = "";
    public FCConnectionTester[] fcHubConnectionTesters;
    public int connTestingIndex = 0;
    public long connTestingSTime = 0L;
    public int connGoodIndex = -1;
    public int connTestingTimeOut = 3000;
    public BTConn btConn = new BTConn();
    public PCConn pcConn = new PCConn();
    private FCList selectBTDeviceList;
    private FCList selectBTServiceList;
    private FCList devHistoryList;
    public FCTextBox errorTextBox;
    public FCTextBox connOKTextBox;
    private Image cIcon;
    private Image pBack;
    private roatadefoc roatadeFoc = new roatadefoc();
    private int ciclicFrame = 0;
    private int canvasW = 0;
    private int canvasH = 0;
    private String[] conn_rms_url_list;
    private RecordStore rs;

    public FCHubConnection(Image cicon, Image pback, int canvasw, int canvash) {
        this.canvasW = canvasw;
        this.canvasH = canvash;
        this.cIcon = cicon;
        this.pBack = pback;
        this.selectBTDeviceList = new FCList(Font.getDefaultFont(), 300, "SELECT DEVICE", "SELECT", "v^", "EXIT", 0, 0, this.canvasW, this.canvasH, true, 0, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 255, 0, this.pBack, 0);
        this.selectBTServiceList = new FCList(Font.getDefaultFont(), 300, "SELECT SERVICE", "SELECT", "v^", "EXIT", 0, 0, this.canvasW, this.canvasH, true, 0, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 255, 0, this.pBack, 0);
        this.devHistoryList = new FCList(Font.getDefaultFont(), 300, "SELECT CONNECTION", "SELECT", "v^", "EXIT", 0, 0, this.canvasW, this.canvasH, true, 0, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 255, 0, this.pBack, 0);
        this.errorTextBox = new FCTextBox("NO ERROR", "!ERROR!", "", "v^", "EXIT", Font.getDefaultFont(), 15, 0, 0, this.canvasW, this.canvasH, true, true, 0xFFFFFF, 0xFFFFFF, 0, this.pBack, 1, 0);
        this.connOKTextBox = new FCTextBox("CONGRATULATIONS", "CONNECTION SUCCESSFUL", "", "v^", "EXIT", Font.getDefaultFont(), 15, 0, 0, this.canvasW, this.canvasH, true, true, 0xFFFFFF, 0xFFFFFF, 0, this.pBack, 1, 0);
    }

    public void loadHistoryFromRMS() {
        try {
            this.rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            byte[] recData = new byte[512];
            int nRecords = this.rs.getNumRecords();
            this.conn_rms_url_list = new String[nRecords / 2];
            String[] conn_rms_url_list_inv = new String[nRecords / 2];
            String[] conn_rms_name_list_inv = new String[nRecords / 2];
            for (int i = 1; i <= nRecords; ++i) {
                recData = new byte[this.rs.getRecordSize(i)];
                int len = this.rs.getRecord(i, recData, 0);
                if (i % 2 == 1) {
                    conn_rms_name_list_inv[(i - 1) / 2] = new String(recData, 0, len);
                }
                if (i % 2 != 0) continue;
                conn_rms_url_list_inv[(i - 2) / 2] = new String(recData, 0, len);
            }
            this.rs.closeRecordStore();
            if (nRecords > 0) {
                for (int kko = 0; kko < conn_rms_name_list_inv.length; ++kko) {
                    this.conn_rms_url_list[kko] = conn_rms_url_list_inv[conn_rms_name_list_inv.length - 1 - kko];
                    this.devHistoryList.addItem(conn_rms_name_list_inv[conn_rms_name_list_inv.length - 1 - kko]);
                }
            }
        }
        catch (Exception e) {
            this.connState = 667;
            this.errorTextBox.setText("LOAD FROM RMS EXCEPTION: ");
            this.err_string = e.toString();
        }
    }

    public void addConnectionToRMS2() {
        try {
            String devName = (String)this.btConn.devNameList.elementAt(this.selectBTDeviceList.selectedIndex);
            String devUrl = this.fcHubConnectionTesters[this.connGoodIndex].connUrl;
            this.rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            this.rs.addRecord(devName.getBytes(), 0, devName.length());
            this.rs.addRecord(devUrl.getBytes(), 0, devUrl.length());
            this.rs.closeRecordStore();
        }
        catch (Exception ee) {
            this.connState = 667;
            this.errorTextBox.setText("ADD TO RMS EXCEPTION");
        }
    }

    public void addConnectionToRMS() {
        try {
            String devName = (String)this.btConn.devNameList.elementAt(this.selectBTDeviceList.selectedIndex);
            String devUrl = this.btConn.BTurl;
            this.rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            this.rs.addRecord(devName.getBytes(), 0, devName.length());
            this.rs.addRecord(devUrl.getBytes(), 0, devUrl.length());
            this.rs.closeRecordStore();
        }
        catch (Exception ee) {
            this.connState = 667;
            this.errorTextBox.setText("ADD TO RMS EXCEPTION");
        }
    }

    public void fc3_disconnect() {
        this.pcConn.fc3_disconnect();
        try {
            this.btConn.comCon.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fc3_reconnect_req() {
        this.pcConn.fc3_reconnect_req();
    }

    public void doJobs(Graphics g) {
        if (this.connState == 3) {
            this.devHistoryList.removeAllItems();
            this.loadHistoryFromRMS();
            this.devHistoryList.addItem("ADD NEW CONNECTION...");
            this.devHistoryList.selectedIndex = 0;
            if (this.connState != 667) {
                this.connState = 5;
            }
        }
        if (this.connState == 6969) {
            g.setColor(0);
            g.fillRect(0, 0, this.canvasW, this.canvasH);
            g.drawImage(this.cIcon, this.canvasW / 2 - this.cIcon.getWidth() / 2, this.canvasH / 2 - this.cIcon.getHeight() / 2, 0);
            this.roatadeFoc.nextdraw(g, this.canvasW / 2, this.canvasH / 2, 45, 255, 1.1f, 10);
            g.setColor(0xFFFFFF);
            g.drawString("Testing services", this.canvasW / 2, 1, 17);
            g.setColor(0xFFFFFF - 0x111111 * this.ciclicFrame);
            g.drawString("Please Wait...", this.canvasW / 2, this.canvasH - 1, 33);
            this.fcHubConnectionTesters[this.connTestingIndex].connUrl = ((ServiceRecord)this.btConn.serviceList.elementAt(this.connTestingIndex)).getConnectionURL(0, false);
            this.connTestingSTime = System.currentTimeMillis();
            this.fcHubConnectionTesters[this.connTestingIndex].curComm = 3;
            this.connState = 6970;
        }
        if (this.connState == 6970) {
            g.setColor(0);
            g.fillRect(0, 0, this.canvasW, this.canvasH);
            g.drawImage(this.cIcon, this.canvasW / 2 - this.cIcon.getWidth() / 2, this.canvasH / 2 - this.cIcon.getHeight() / 2, 0);
            this.roatadeFoc.nextdraw(g, this.canvasW / 2, this.canvasH / 2, 45, 255, 1.1f, 10);
            g.setColor(0xFFFFFF);
            g.drawString("Testing services", this.canvasW / 2, 1, 17);
            g.setColor(0xFFFFFF - 0x111111 * this.ciclicFrame);
            g.drawString("Please Wait...", this.canvasW / 2, this.canvasH - 1, 33);
            if (this.fcHubConnectionTesters[this.connTestingIndex].helpString == "CONN_OK") {
                this.connGoodIndex = this.connTestingIndex;
                this.connState = 6971;
            } else {
                long ctt = System.currentTimeMillis();
                if (ctt - this.connTestingSTime > (long)this.connTestingTimeOut || this.fcHubConnectionTesters[this.connTestingIndex].helpString == "CONN_ERROR") {
                    this.connTestingSTime = ctt;
                    ++this.connTestingIndex;
                    if (this.connTestingIndex >= this.btConn.serviceList.size()) {
                        this.connGoodIndex = -1;
                        this.connState = 6971;
                    } else {
                        this.connState = 6969;
                    }
                }
            }
        }
        if (this.connState == 6971) {
            if (this.connGoodIndex < 0) {
                this.connState = 667;
                this.err_string = "could not connect";
                this.errorTextBox.setText("Required service not found on the selected Remote PC. Be sure that Mobile BT Remote PC application is running and it is in discovery mode!!! Please restart the application and try again...");
            } else {
                this.addConnectionToRMS2();
                this.connState = 669;
                this.err_string = "connection_ok";
                this.connOKTextBox.setText("Connection was SUCCESSFUL !!! The PC you selected was added to the connection list. Please restart the application, select start and then you should see this PC.");
            }
        }
        if (this.connState == 669) {
            this.connOKTextBox.draw(g);
        }
        if (this.connState == 667) {
            this.errorTextBox.draw(g);
        }
        if (this.connState == 5) {
            this.devHistoryList.draw(g);
        }
        if (this.connState == 7) {
            g.setColor(0);
            g.fillRect(0, 0, this.canvasW, this.canvasH);
            g.drawImage(this.cIcon, this.canvasW / 2 - this.cIcon.getWidth() / 2, this.canvasH / 2 - this.cIcon.getHeight() / 2, 0);
            this.roatadeFoc.nextdraw(g, this.canvasW / 2, this.canvasH / 2, 45, 255, 1.1f, 10);
            g.setColor(0xFFFFFF);
            g.drawString("Searching BT Devices", this.canvasW / 2, 3, 17);
            g.setColor(0xFFFFFF - 0x111111 * this.ciclicFrame);
            g.drawString("Please Wait...", this.canvasW / 2, this.canvasH, 33);
            if (this.btConn.loginfo == "Inquiry compeleted") {
                this.btConn.getNames();
                if (this.btConn.deviceList.size() == 0) {
                    this.connState = 667;
                    this.err_string = "DEVICE_SEARCH_FAILED";
                    this.errorTextBox.setText("No bluetooth device found in range. Please restart the application and try again...");
                }
                if (this.btConn.deviceList.size() > 0) {
                    this.selectBTDeviceList.removeAllItems();
                    for (int xx = 0; xx < this.btConn.devNameList.size(); ++xx) {
                        this.selectBTDeviceList.addItem((String)this.btConn.devNameList.elementAt(xx));
                    }
                    this.selectBTDeviceList.selectedIndex = 0;
                    this.connState = 8;
                }
            }
        }
        if (this.connState == 8) {
            this.selectBTDeviceList.draw(g);
        }
        if (this.connState == 9) {
            g.setColor(0);
            g.fillRect(0, 0, this.canvasW, this.canvasH);
            g.drawImage(this.cIcon, this.canvasW / 2 - this.cIcon.getWidth() / 2, this.canvasH / 2 - this.cIcon.getHeight() / 2, 0);
            this.roatadeFoc.nextdraw(g, this.canvasW / 2, this.canvasH / 2, 45, 255, 1.1f, 10);
            g.setColor(0xFFFFFF);
            g.drawString("Searching for services", this.canvasW / 2, 1, 17);
            g.setColor(0xFFFFFF - 0x111111 * this.ciclicFrame);
            g.drawString("Please Wait...", this.canvasW / 2, this.canvasH - 1, 33);
            if (this.btConn.loginfo == "the service search completed normally") {
                this.selectBTServiceList.removeAllItems();
                for (int xx = 0; xx < this.btConn.serviceList.size(); ++xx) {
                    this.selectBTServiceList.addItem(this.btConn.findServiceName((ServiceRecord)this.btConn.serviceList.elementAt(xx)).toUpperCase().trim());
                }
                this.selectBTServiceList.selectedIndex = 0;
                this.connState = 10;
            } else if (this.btConn.loginfo == "an error occurred while processing the request" || this.btConn.loginfo == "no records were found during the service search" || this.btConn.loginfo == "the device specified in the search request could not be reached or the local device could not establish a connection to the remote device") {
                this.connState = 667;
                this.err_string = "could not enumerate services";
                this.errorTextBox.setText("Could not enumerate services on the selected device. Please restart the application and try again...");
            }
        }
        if (this.connState == 10) {
            this.selectBTServiceList.draw(g);
        }
        if (this.connState == 6) {
            this.btConn.connecTInd(this.selectBTServiceList.selectedIndex);
            if (this.btConn.loginfo == "bt conn error") {
                this.connState = 667;
                this.err_string = "could not connect";
                this.errorTextBox.setText("Could not connect to the specified service. Please restart the application and try again...");
            }
            if (this.btConn.loginfo != "bt conn error") {
                this.pcConn = new PCConn();
                this.pcConn.connectToPc(2, null, this.btConn.comCon, this.canvasW, this.canvasH);
                if (!this.pcConn.checkPcConnError) {
                    this.addConnectionToRMS();
                    if (this.connState != 667) {
                        this.exitClass(999);
                    }
                } else {
                    this.connState = 667;
                    this.err_string = "communication error";
                    this.errorTextBox.setText("There was a communication error between the phone and the PC. Please restart the application and try again...");
                }
            }
        }
        if (this.connState == 67) {
            this.btConn.connecTUrl(this.conn_rms_url_list[this.devHistoryList.selectedIndex]);
            if (this.btConn.loginfo == "bt conn error") {
                this.connState = 667;
                this.err_string = "could not connect";
                this.errorTextBox.setText("Could not connect to the specified service. Please restart the application and try again...");
            }
            if (this.btConn.loginfo != "bt conn error") {
                this.pcConn = new PCConn();
                this.pcConn.connectToPc(2, null, this.btConn.comCon, this.canvasW, this.canvasH);
                if (!this.pcConn.checkPcConnError) {
                    if (this.connState != 667) {
                        this.exitClass(999);
                    }
                } else {
                    this.connState = 667;
                    this.err_string = "communication error";
                    this.errorTextBox.setText("There was a communication error between the phone and the PC. Please restart the application and try again...");
                }
            }
        }
        this.ciclicFrame = (this.ciclicFrame + 1) % 10;
    }

    public void exitClass(int reason) {
        this.connState = reason;
    }

    public void keyEvent(int keyCode) {
        switch (this.connState) {
            case 667: {
                if (keyCode == -2) {
                    this.errorTextBox.scrollUp();
                }
                if (keyCode == -1) {
                    this.errorTextBox.scrollDown();
                }
                if (keyCode != -7) break;
                this.exitClass(-1);
                break;
            }
            case 669: {
                if (keyCode == -2) {
                    this.errorTextBox.scrollUp();
                }
                if (keyCode == -1) {
                    this.errorTextBox.scrollDown();
                }
                if (keyCode != -7) break;
                this.exitClass(-1);
                break;
            }
            case 5: {
                if (keyCode == -1) {
                    this.devHistoryList.scrollDown();
                }
                if (keyCode == -2) {
                    this.devHistoryList.scrollUp();
                }
                if (keyCode == -7) {
                    this.exitClass(-1);
                }
                if (keyCode != -6) break;
                if (this.devHistoryList.selectedIndex == this.devHistoryList.Count() - 1) {
                    this.btConn.startDeviceInquiry();
                    this.connState = 7;
                    break;
                }
                this.connState = 67;
                break;
            }
            case 8: {
                if (keyCode == -1) {
                    this.selectBTDeviceList.scrollDown();
                }
                if (keyCode == -2) {
                    this.selectBTDeviceList.scrollUp();
                }
                if (keyCode == -7) {
                    this.exitClass(-1);
                }
                if (keyCode != -6) break;
                this.btConn.startServiceSearch((RemoteDevice)this.btConn.deviceList.elementAt(this.selectBTDeviceList.selectedIndex));
                this.connState = 9;
                break;
            }
            case 10: {
                if (keyCode == -1) {
                    this.selectBTServiceList.scrollDown();
                }
                if (keyCode == -2) {
                    this.selectBTServiceList.scrollUp();
                }
                if (keyCode == -7) {
                    this.exitClass(-1);
                }
                if (keyCode != -6) break;
                this.connState = 6;
                break;
            }
        }
    }
}

