/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import utilitare.FCTicker;

public class FCNumericInput {
    public String boxTitle;
    public String boxCommLeft;
    public String boxCommMiddle;
    public Font textFont;
    public int posX;
    public int posY;
    public int bWidth;
    public int bHeight;
    public boolean hasBorder;
    public int textColor;
    public int borderColor;
    public int backColor;
    public Image backImage;
    public int textMode;
    public int borderType;
    public String curText = "";
    private FCTicker titleTicker;
    private int curOffset = 0;
    private int curCaretPos = 0;
    private int ciclicFrame = 0;
    private int wnChars = 1;

    public FCNumericInput(String boxtitle, String boxcommLeft, String boxcommMiddle, Font textfont, int posx, int posy, int bwidth, int bheight, boolean hasborder, int textcolor, int bordercolor, int backcolor, Image backimage, int textmode, int bordertype) {
        this.textFont = textfont;
        this.posX = posx + this.textFont.charWidth('A');
        this.posY = posy + this.textFont.getHeight();
        this.bWidth = bwidth - 2 * this.textFont.charWidth('A');
        this.bHeight = bheight - 3 * this.textFont.getHeight();
        this.hasBorder = hasborder;
        this.textColor = textcolor;
        this.borderColor = bordercolor;
        this.backColor = backcolor;
        this.backImage = backimage;
        this.textMode = textmode;
        this.borderType = bordertype;
        this.boxTitle = boxtitle;
        this.boxCommLeft = boxcommLeft;
        this.boxCommMiddle = boxcommMiddle;
        this.titleTicker = new FCTicker(this.boxTitle, this.textFont, posx + 3 * this.textFont.charWidth('A'), posy, bwidth - 6 * this.textFont.charWidth('A'), 0xFFFFFF, 0, this.backImage, 0);
        this.wnChars = (this.bWidth - 2) / this.textFont.charWidth('0');
    }

    public void draw(Graphics g) {
        int cX = g.getClipX();
        int cY = g.getClipY();
        int cWid = g.getClipWidth();
        int cHei = g.getClipHeight();
        this.drawBox(g);
        this.titleTicker.draw(g);
        g.setClip(cX, cY, cWid, cHei);
    }

    private void drawBox(Graphics g) {
        int px = this.posX - this.textFont.charWidth('A');
        int py = this.posY - this.textFont.getHeight();
        int bw = this.bWidth + 2 * this.textFont.charWidth('A');
        int bh = this.bHeight + 3 * this.textFont.getHeight();
        g.clipRect(px, py, bw, bh);
        g.setColor(this.backColor);
        g.fillRect(px, py, bw, bh);
        if (this.backImage != null) {
            int nx = bw / this.backImage.getWidth() + 1;
            int ny = bh / this.backImage.getHeight() + 1;
            for (int ii = 0; ii < nx; ++ii) {
                for (int jj = 0; jj < ny; ++jj) {
                    g.drawImage(this.backImage, ii * this.backImage.getWidth(), jj * this.backImage.getHeight(), 0);
                }
            }
        }
        int midd = px + bw / 2;
        g.setColor(this.textColor);
        g.drawString(this.boxCommLeft, px + 1, py + bh - 1, 36);
        g.drawString(this.boxCommMiddle, midd, py + bh - 1, 33);
        g.drawString("DEL", px + bw - 1, py + bh - 1, 40);
        if (this.hasBorder && this.borderType == 0) {
            int ppx = px + (this.posX - px) / 2;
            int ppy = py + (this.posY - py) / 2;
            int bbw = this.posX + this.bWidth + (this.posX - px) / 2;
            int bbh2 = this.posY + this.bHeight + this.textFont.getHeight() / 2;
            g.setColor(this.borderColor);
            int l1 = this.posX + 2 * this.textFont.charWidth('A');
            int l2 = this.posX + this.bWidth - 2 * this.textFont.charWidth('A');
            g.drawLine(ppx, ppy, l1, ppy);
            g.drawLine(l2, ppy, bbw, ppy);
            g.drawLine(bbw, ppy, bbw, bbh2);
            g.drawLine(bbw, bbh2, ppx, bbh2);
            g.drawLine(ppx, bbh2, ppx, ppy);
        }
        g.setClip(this.posX + 1, this.posY + 1, this.bWidth - 2, this.bHeight - 2);
        g.setColor(this.textColor);
        if (this.curText.length() < this.wnChars) {
            g.drawString(this.curText, this.posX + 2, this.posY + 2, 0);
        } else {
            g.drawString(this.curText.substring(this.curOffset), this.posX + 2, this.posY + 2, 0);
        }
        if (this.ciclicFrame < 25) {
            g.drawString("|", this.posX + this.textFont.substringWidth(this.curText, this.curOffset, this.curCaretPos), this.posY + 2, 0);
        }
        this.ciclicFrame = (this.ciclicFrame + 1) % 50;
    }

    private void recalcOffset() {
        if (this.curCaretPos - this.curOffset < 0) {
            this.curOffset = this.curCaretPos;
        }
        if (this.curCaretPos - this.curOffset > this.wnChars) {
            this.curOffset = this.curCaretPos - this.wnChars;
        }
    }

    private void left() {
        --this.curCaretPos;
        if (this.curCaretPos < 0) {
            this.curCaretPos = this.curText.length();
        }
        this.recalcOffset();
    }

    private void right() {
        ++this.curCaretPos;
        if (this.curCaretPos > this.curText.length()) {
            this.curCaretPos = 0;
        }
        this.recalcOffset();
    }

    private void backspace() {
        if (this.curCaretPos > 0) {
            String tmpStr = this.curText.substring(0, this.curCaretPos - 1);
            this.curText = tmpStr = tmpStr + this.curText.substring(this.curCaretPos);
            --this.curCaretPos;
            this.recalcOffset();
        }
    }

    private void insertNumber(String number) {
        String tmpStr = this.curText.substring(0, this.curCaretPos);
        tmpStr = tmpStr + number;
        this.curText = tmpStr = tmpStr + this.curText.substring(this.curCaretPos);
        ++this.curCaretPos;
        this.recalcOffset();
    }

    public void keyEvent(int keyCode) {
        if (keyCode == -7) {
            this.backspace();
        }
        if (keyCode == -3) {
            this.left();
        }
        if (keyCode == -4) {
            this.right();
        }
        if (keyCode == 109 || keyCode == 48) {
            this.insertNumber("0");
        }
        if (keyCode == 114 || keyCode == 49) {
            this.insertNumber("1");
        }
        if (keyCode == 116 || keyCode == 50) {
            this.insertNumber("2");
        }
        if (keyCode == 121 || keyCode == 51) {
            this.insertNumber("3");
        }
        if (keyCode == 102 || keyCode == 52) {
            this.insertNumber("4");
        }
        if (keyCode == 103 || keyCode == 53) {
            this.insertNumber("5");
        }
        if (keyCode == 104 || keyCode == 54) {
            this.insertNumber("6");
        }
        if (keyCode == 118 || keyCode == 55) {
            this.insertNumber("7");
        }
        if (keyCode == 98 || keyCode == 56) {
            this.insertNumber("8");
        }
        if (keyCode == 110 || keyCode == 57) {
            this.insertNumber("9");
        }
    }
}

