/*
 * Decompiled with CFR 0.152.
 */
package Server;

import MIDLetPackage.RoomMIDLet;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class Server
implements Runnable {
    private static final UUID serverUUID = new UUID(4660L);
    private StreamConnectionNotifier notifier;
    private boolean isClosed = false;
    private LocalDevice local;
    private Thread serverThread;
    private ClientProcessor processor;
    private RoomMIDLet parent;

    public Server(RoomMIDLet parent) {
        this.parent = parent;
        try {
            this.local = LocalDevice.getLocalDevice();
            this.local.setDiscoverable(10390323);
        }
        catch (BluetoothStateException bex) {
            this.isClosed = true;
            bex.printStackTrace();
        }
        this.processor = new ClientProcessor();
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    public void destroy() {
        this.isClosed = true;
        if (this.notifier != null) {
            try {
                this.notifier.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.processor != null) {
            this.processor.destroy(true);
        }
        this.processor = null;
    }

    public void run() {
        if (this.isClosed) {
            return;
        }
        StringBuffer url = new StringBuffer("btspp://");
        url.append("localhost").append(':');
        url.append(serverUUID.toString());
        url.append(";name=SCRServer");
        url.append(";authorize=true");
        try {
            this.notifier = (StreamConnectionNotifier)Connector.open((String)url.toString());
        }
        catch (IOException ioex) {
            this.isClosed = true;
            ioex.printStackTrace();
        }
        while (!this.isClosed) {
            StreamConnection conn = null;
            try {
                conn = this.notifier.acceptAndOpen();
            }
            catch (IOException ioex) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
                continue;
            }
            this.processor.addConnection(conn);
        }
    }

    public void processDataTransfer(StreamConnection conn) {
        try {
            DataInputStream in = conn.openDataInputStream();
            String msg = in.readUTF();
            this.parent.getIncomingMessageBox().append(msg);
            in.close();
            conn.close();
        }
        catch (IOException ioex) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ioex.printStackTrace();
        }
    }

    private class ClientProcessor
    implements Runnable {
        private Vector queue = new Vector();
        private Thread processThread = new Thread(this);

        public ClientProcessor() {
            this.processThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Server.this.isClosed) {
                ClientProcessor clientProcessor = this;
                synchronized (clientProcessor) {
                    if (this.queue.size() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            this.destroy(false);
                            return;
                        }
                    }
                }
                ClientProcessor clientProcessor2 = this;
                synchronized (clientProcessor2) {
                    if (Server.this.isClosed) {
                        return;
                    }
                    StreamConnection conn = (StreamConnection)this.queue.firstElement();
                    this.queue.removeElementAt(0);
                    Server.this.processDataTransfer(conn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addConnection(StreamConnection conn) {
            ClientProcessor clientProcessor = this;
            synchronized (clientProcessor) {
                this.queue.addElement(conn);
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy(boolean needJoin) {
            Server.this.isClosed = true;
            ClientProcessor clientProcessor = this;
            synchronized (clientProcessor) {
                this.notify();
                while (this.queue.size() != 0) {
                    StreamConnection conn = (StreamConnection)this.queue.firstElement();
                    this.queue.removeElementAt(0);
                    try {
                        conn.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

