/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.GameControl;
import com.ximad.pvn.game.Launcher;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.pandas.Panda;
import com.ximad.pvn.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class LauncherPandaPunk
extends Launcher {
    int delta;
    float angle_step;
    Point force_vector;
    public static long mLastTime = 0L;
    long now = 0L;
    final int stepMusik;
    static final float PAPA_PANDA_MAX_STATE = 40.0f;
    static final int PAPA_PANDA_ANGULAR_OFFSET_X = 9;
    static final int PAPA_PANDA_ANGULAR_OFFSET_Y = 13;
    static final float PHYSICAL_STEP_PERIOD = 0.05263158f;
    private static int rightPoint;
    static float SPEED_MAX;
    private static final int[] BACK_WHELL_POS_DX;
    private static final int[] BACK_WHELL_POS_DY;
    private static final int[] SHOT_PANDA_POS_DX;
    private static final int[] SHOT_PANDA_POS_DY;
    private static final int[] HEAD_POS_DX;
    private static final int[] HEAD_POS_DY;
    private static final int HEAD_DELTA_Y = 32;

    public LauncherPandaPunk() {
        this.stepMusik = 500;
    }

    public void reset() {
        super.reset();
        this.delta = 0;
        LauncherPandaPunk.launcher.angle = 90;
    }

    public void draw(Graphics g) {
        if (rightPoint < Camera.position) {
            return;
        }
        if (this.hand_state < 19) {
            this.hand_state = 19;
        }
        if (this.head_state < 0) {
            this.head_state = 0;
        }
        if ((MyWorld.onLaunch || MyWorld.onShot || MyWorld.onSetUp || MyWorld.onCharge || MyWorld.ondeCharge || MyWorld.lives == 0) && this.show) {
            this.frames[this.hand_state].drawRotated(g, this.back_wheel_position.x - Camera.position, this.back_wheel_position.y, this.back_wheel_position.x + 9 - Camera.position, this.back_wheel_position.y + 13, this.angle - 90);
        } else {
            this.frames[this.hand_state].draw(g, this.back_wheel_position.x - Camera.position, this.back_wheel_position.y);
        }
        Textures.launcher_papa_punk_charge.drawSprite(g, this.position.x - Camera.position, this.position.y, this.state < 18 ? this.state : 0);
        Textures.launcher_papa_punk_head.drawSprite(g, this.head_position.x - Camera.position, this.head_position.y, this.head_state);
        if (MyWorld.shot_panda != null && MyWorld.lives > 0) {
            MyWorld.shot_panda.draw(g);
        }
    }

    public static void createNewLauncher(int X1, int Y1) {
        launcher = new LauncherPandaPunk();
        LauncherPandaPunk.launcher.tick = 0;
        LauncherPandaPunk.launcher.nFrames = 33;
        LauncherPandaPunk.launcher.lastAngle = 90;
        LauncherPandaPunk.launcher.frames = Textures.launcher_papa_punk;
        Y1 = Application.screenHeight;
        LauncherPandaPunk.launcher.position.set(X1, MyWorld.floor - Textures.launcher_papa_punk_charge.getHeight());
        MyWorld.launcherObjectIndex = MyWorld.gameObjects.size() - 1;
        LauncherPandaPunk.launcher.back_wheel_position.set(LauncherPandaPunk.launcher.position.x + 66, LauncherPandaPunk.launcher.position.y + 37 - 32);
        LauncherPandaPunk.launcher.angular_position.set(LauncherPandaPunk.launcher.back_wheel_position.x + 9, LauncherPandaPunk.launcher.back_wheel_position.y + 13);
        LauncherPandaPunk.launcher.angle = 90;
        LauncherPandaPunk.launcher.state = 0;
        LauncherPandaPunk.launcher.hand_state = 19;
        LauncherPandaPunk.launcher.head_state = 0;
        LauncherPandaPunk.launcher.front_wheel_position.set(LauncherPandaPunk.launcher.back_wheel_position.x, LauncherPandaPunk.launcher.back_wheel_position.y);
        LauncherPandaPunk.launcher.head_position.set(LauncherPandaPunk.launcher.position.x + 28, LauncherPandaPunk.launcher.position.y + 6 - 32);
        MyWorld.playerCoord.set(LauncherPandaPunk.launcher.position.x + 56, LauncherPandaPunk.launcher.position.y + 38 - 32);
        Launcher.shot_position.set(LauncherPandaPunk.launcher.position.x + 79, LauncherPandaPunk.launcher.position.y + 34 - 32);
        LauncherPandaPunk.launcher.touch_position.set(LauncherPandaPunk.launcher.position.x + Textures.launcher_papa_punk_charge.getTileWidth() / 2, LauncherPandaPunk.launcher.position.y + Textures.launcher_papa_punk_charge.getHeight() / 2);
        SPEED_MAX = (float)(0.5 * Math.sqrt(((float)MyWorld.center + MyWorld.ADD_RIGHT_BOUND) * 10.0f)) / 2.1052632f;
        rightPoint = LauncherPandaPunk.launcher.back_wheel_position.x + LauncherPandaPunk.launcher.frames[LauncherPandaPunk.launcher.hand_state].getWidth();
    }

    public static void getAngle(float x, float y) {
        float dy = LauncherPandaPunk.launcher.angular_position.y - GameControl.RawY;
        float dx = GameControl.RawX - (LauncherPandaPunk.launcher.angular_position.x + Camera.position);
        if (dx == 0.0f) {
            dx = 0.1f;
        }
        if (MyWorld.onLaunch) {
            if (dx >= 0.0f && dy > 0.0f) {
                LauncherPandaPunk.launcher.angle = 90 - (int)(Utils.atan(dy / dx) * 180.0 / Math.PI);
            } else if (dx > 0.0f && dy <= 0.0f) {
                LauncherPandaPunk.launcher.angle = 90 - (int)(Utils.atan(dy / dx) * 180.0 / Math.PI);
            } else if (dx <= 0.0f && dy < 0.0f) {
                LauncherPandaPunk.launcher.angle = 180 + (90 - (int)(Utils.atan(dy / dx) * 180.0 / Math.PI));
            } else if (dx < 0.0f && dy >= 0.0f) {
                LauncherPandaPunk.launcher.angle = 270 - (int)(Utils.atan(dy / dx) * 180.0 / Math.PI);
            }
            LauncherPandaPunk.launcher.angle += 180;
        }
        float r = (float)Math.sqrt(dx * dx + dy * dy);
        LauncherPandaPunk.launcher.force_vector.x = dx / r;
        LauncherPandaPunk.launcher.force_vector.y = dy / r;
    }

    public void getState(int delta) {
        if (delta > 70) {
            LauncherPandaPunk.launcher.head_state = 6;
            LauncherPandaPunk.launcher.hand_state = 25;
            return;
        }
        if (delta > 60) {
            LauncherPandaPunk.launcher.head_state = 5;
            LauncherPandaPunk.launcher.hand_state = 24;
            return;
        }
        if (delta > 50) {
            LauncherPandaPunk.launcher.head_state = 4;
            LauncherPandaPunk.launcher.hand_state = 23;
            return;
        }
        if (delta > 40) {
            LauncherPandaPunk.launcher.head_state = 3;
            LauncherPandaPunk.launcher.hand_state = 22;
            return;
        }
        if (delta > 30) {
            LauncherPandaPunk.launcher.head_state = 2;
            LauncherPandaPunk.launcher.hand_state = 21;
            return;
        }
        if (delta > 20) {
            LauncherPandaPunk.launcher.head_state = 1;
            LauncherPandaPunk.launcher.hand_state = 20;
            return;
        }
    }

    public void getSpeed() {
        this.speed = (float)(this.hand_state - 18) / 7.0f * SPEED_MAX;
        if (this.speed > SPEED_MAX) {
            this.speed = SPEED_MAX;
        }
        if (this.speed > 0.0f && this.hand_state != 19) {
            this.valid = true;
        }
    }

    private void setPositions() {
        int lx = LauncherPandaPunk.launcher.position.x;
        int ly = LauncherPandaPunk.launcher.position.y;
        LauncherPandaPunk.launcher.back_wheel_position.set(lx + BACK_WHELL_POS_DX[this.state - 1], ly + BACK_WHELL_POS_DY[this.state - 1] - 32);
        LauncherPandaPunk.launcher.angular_position.set(LauncherPandaPunk.launcher.back_wheel_position.x + 9, LauncherPandaPunk.launcher.back_wheel_position.y + 13);
        if (this.state < 12) {
            MyWorld.shot_panda.position.set(lx + SHOT_PANDA_POS_DX[this.state - 1], ly + SHOT_PANDA_POS_DY[this.state - 1] - 32);
        }
        LauncherPandaPunk.launcher.head_position.set(lx + HEAD_POS_DX[this.state - 1], ly + HEAD_POS_DY[this.state - 1] - 32);
    }

    public void update(long dt) {
        if (MyWorld.onLaunch && (LauncherPandaPunk.previous_touch_position.x != GameControl.RawX || LauncherPandaPunk.previous_touch_position.y != GameControl.RawY)) {
            this.delta = this.touch_position.x - Camera.position - GameControl.RawX;
            if (this.delta > 20) {
                this.show = true;
                this.getState(this.delta);
                LauncherPandaPunk.getAngle(GameControl.RawX, GameControl.RawY);
            } else {
                this.hand_state = 19;
                this.head_state = 0;
                this.back_wheel_position.set(this.front_wheel_position.x, this.front_wheel_position.y);
                LauncherPandaPunk.launcher.angular_position.set(LauncherPandaPunk.launcher.back_wheel_position.x + 9, LauncherPandaPunk.launcher.back_wheel_position.y + 13);
                LauncherPandaPunk.launcher.head_position.set(LauncherPandaPunk.launcher.position.x + 28, LauncherPandaPunk.launcher.position.y + 6 - 32);
                this.state = 0;
                this.show = false;
            }
            previous_touch_position.set(GameControl.RawX, GameControl.RawY);
        }
        if (MyWorld.onSetUp) {
            if (!this.valid) {
                MyWorld.onSetUp = false;
                return;
            }
            this.angle_step = (510 - this.angle) / 3;
            MyWorld.onSetUp = false;
            MyWorld.onCharge = true;
        }
        if (MyWorld.onCharge) {
            this.tick = (int)((long)this.tick + dt);
            if (this.tick > 25) {
                this.tick -= 25;
                this.hand_state = 19;
                ++this.state;
                if (this.state >= 1 && this.state <= 11) {
                    if (this.head_state != 0 && this.state < 8) {
                        --this.head_state;
                    } else if (this.state >= 9) {
                        this.angle = (int)((float)this.angle + this.angle_step);
                    }
                    this.setPositions();
                }
                if (this.state == 11) {
                    this.angle_step = 20.0f;
                    MyWorld.onCharge = false;
                    this.tick = 0;
                    MyWorld.onShot = true;
                    MyWorld.ondeCharge = true;
                    this.tick = 0;
                    return;
                }
            }
        }
        if (MyWorld.ondeCharge) {
            this.tick = (int)((long)this.tick + dt);
            if (this.tick > 25) {
                this.tick -= 25;
                ++this.state;
                if (this.state >= 12 && this.state <= 19) {
                    this.setPositions();
                    if (this.state >= 16 && this.state <= 18) {
                        this.angle = (int)((float)this.angle - this.angle_step);
                    } else if (this.state == 19) {
                        this.back_wheel_position.set(this.front_wheel_position.x, this.front_wheel_position.y);
                        MyWorld.ondeCharge = false;
                        this.state = 0;
                        this.tick = 0;
                    }
                }
            }
        }
        if (MyWorld.onShot) {
            MyWorld.onShot = false;
            MyWorld.gameObjects.set(MyWorld.gameObjects.getIndex(MyWorld.shot_panda), null);
            MyWorld.shot_panda = null;
            Panda.launchPanda(-LauncherPandaPunk.launcher.force_vector.x * this.speed, LauncherPandaPunk.launcher.force_vector.y * this.speed);
            this.show = true;
            MyWorld.camera.setTargetById(MyWorld.playerPanda);
            if (MyWorld.lives == 0) {
                this.angle = 90;
            }
        }
        if (MyWorld.onWin || MyWorld.onLost) {
            Launcher.launcher.angle = 90;
        }
    }

    static {
        BACK_WHELL_POS_DX = new int[]{64, 63, 62, 60, 59, 58, 56, 55, 64, 75, 84, 81, 78, 75, 72, 70, 68, 66, -1};
        BACK_WHELL_POS_DY = new int[]{37, 36, 36, 35, 34, 34, 34, 33, 34, 36, 39, 39, 38, 37, 37, 37, 37, 37, -1};
        SHOT_PANDA_POS_DX = new int[]{54, 51, 47, 42, 36, 27, 19, 9, 39, 63, 79};
        SHOT_PANDA_POS_DY = new int[]{45, 53, 61, 68, 76, 79, 81, 85, 75, 57, 34};
        HEAD_POS_DX = new int[]{26, 25, 23, 22, 20, 19, 17, 15, 27, 38, 51, 46, 43, 40, 36, 33, 30, 28, 28};
        HEAD_POS_DY = new int[]{6, 6, 6, 6, 5, 4, 5, 5, 2, 1, 2, 0, 0, 2, 2, 4, 5, 6, 6};
    }
}

