/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.game.BaseObject;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Rect;
import com.ximad.pvn.utils.ArrayList;

public abstract class PhysicalGameObject
extends BaseObject {
    public String imageName = "Empty";
    public int n = 0;
    public int contourWidth = 3;
    protected ArrayList shape;
    public int width;
    public int height;
    public boolean isBullet = false;
    public int friction = 0;
    public int restitution = 0;
    public boolean isStatic = false;
    public boolean isCircle = false;
    public boolean isSquare = false;
    public boolean isTriangle = false;
    public int density = 0;
    public boolean isPlayerPenetratable = false;
    public boolean fixedRotation = false;
    public boolean onDestroy = false;
    public float mass = 0.0f;
    public float velocityX = 0.0f;
    public float velocityY = 0.0f;
    public int angle = 0;

    public void update(long dt) {
    }

    public void ability() {
    }

    public void OnCollision(PhysicalGameObject obj, float force) {
    }

    public void setShape(ArrayList polyShape, boolean isNew, boolean isPlayer) {
        Rect rect = this.getBoundingRectangle(polyShape);
        int x = rect.left;
        int y = rect.top;
        int[] fShape = new int[polyShape.size() * 2];
        int j = 0;
        for (int i = 0; i < polyShape.size(); ++i) {
            Point p = (Point)polyShape.get(i);
            fShape[j] = p.x;
            fShape[j + 1] = p.y;
            j += 2;
        }
        if (!this.isCircle) {
            Point p0 = (Point)polyShape.get(0);
            Point p1 = (Point)polyShape.get(1);
            Point p2 = (Point)polyShape.get(2);
            this.width = Math.abs(p1.x - p2.x);
            if (this.width == 0) {
                this.width = Math.abs(p0.x - p1.x);
                this.height = Math.abs(p1.y - p2.y);
            } else {
                this.height = Math.abs(p0.y - p1.y);
            }
            this.box2dId = Box2d.b2createPolygonBody(x, y, fShape, polyShape.size(), this.density, this.friction, this.restitution, this.isStatic, this.isBullet, this.isPlayerPenetratable, this.fixedRotation, this.angle);
        } else {
            this.box2dId = Box2d.b2createCircleBody(fShape[0], fShape[1], this.radius, this.density, this.friction, this.restitution, this.isStatic, this.isBullet, this.isPlayerPenetratable, isPlayer, this.fixedRotation);
        }
    }
}

