/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.engine.CustomButton;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.HomeScreen;
import com.ximad.pvn.screens.SelectLevelScreen;
import javax.microedition.lcdui.Graphics;

public class SelectScenarioScreen
extends UiScreen {
    private static SelectScenarioScreen instance;
    private Bitmap farBackground;
    private Bitmap mainBackground;
    private Bitmap caption;
    private CustomButton[] btLevel = new CustomButton[5];
    private CustomButton btBack;
    private int openScenario = -1;

    public SelectScenarioScreen() {
        this.farBackground = Textures.mainMenuBackground;
        this.mainBackground = Textures.selectScenarioMainBackground;
        this.caption = Textures.selectScenarioCaption;
        for (int lvl = 0; lvl < 5; ++lvl) {
            final int k = lvl;
            this.btLevel[lvl] = new CustomButton(Textures.selectScenarioLevels, lvl, lvl){

                protected void touchAction() {
                    SelectScenarioScreen.this.openScenario(k);
                }
            };
        }
        this.btBack = new CustomButton(Textures.back, 0, 1){

            protected void touchAction() {
                Application.setScreen(HomeScreen.getInstance());
            }
        };
        this.add(this.btBack, 257, 310);
        this.add(this.btLevel[0], 121, 98);
        this.add(this.btLevel[1], 257, 96);
        this.add(this.btLevel[2], 388, 95);
        this.add(this.btLevel[3], 189, 193);
        this.add(this.btLevel[4], 328, 196);
    }

    public void onPaint(Graphics g) {
        this.farBackground.draw(g, 0, 0);
        this.mainBackground.draw(g, 33, 0);
        this.caption.drawFlag(g, 321, 72, 3);
        super.onPaint(g);
    }

    private void openScenario(int number) {
        if (number >= 0 && number < 5 && ((Scenario)GameParameters.scenarios.get((int)number)).isOpen) {
            SelectLevelScreen.getInstance().scenarioNumber = number;
            GameParameters.indexCurrentScenario = number;
            GameParameters.currentScenario = (Scenario)GameParameters.scenarios.get(number);
            Application.setScreen(SelectLevelScreen.getInstance());
        }
    }

    public void onShow() {
        for (int lvl = 0; lvl < 5; ++lvl) {
            if (((Scenario)GameParameters.scenarios.get((int)lvl)).isOpen) {
                this.btLevel[lvl].setOffImage(lvl);
                this.btLevel[lvl].setOnImage(lvl);
                this.openScenario = lvl;
                continue;
            }
            this.btLevel[lvl].setOffImage(lvl + 5);
            this.btLevel[lvl].setOnImage(lvl + 5);
        }
        SelectScenarioScreen.repaint();
    }

    public static SelectScenarioScreen getInstance() {
        if (instance == null) {
            instance = new SelectScenarioScreen();
        }
        return instance;
    }
}

