/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Image;

public class Lib_png2 {
    public static FileConnection fc = null;
    public static OutputStream os = null;
    static int[] crcTable = null;

    private static byte[] getByteArrayAlpha(Image image) {
        int[] raw = new int[image.getWidth() * image.getHeight()];
        image.getRGB(raw, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        byte[] rawByte = new byte[image.getWidth() * image.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < raw.length; ++i) {
            int ARGB = raw[i];
            int a = (ARGB & 0xFF000000) >> 24;
            rawByte[n] = (byte)a;
            ++n;
        }
        raw = null;
        return rawByte;
    }

    private static byte[] getByteArrayBlue(Image image) {
        int[] raw = new int[image.getWidth() * image.getHeight()];
        image.getRGB(raw, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        byte[] rawByte = new byte[image.getWidth() * image.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < raw.length; ++i) {
            int ARGB = raw[i];
            int b = ARGB & 0xFF;
            rawByte[n] = (byte)b;
            ++n;
        }
        raw = null;
        return rawByte;
    }

    private static byte[] getByteArrayRed(Image image) {
        int[] raw = new int[image.getWidth() * image.getHeight()];
        image.getRGB(raw, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        byte[] rawByte = new byte[image.getWidth() * image.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < raw.length; ++i) {
            int ARGB = raw[i];
            int r = (ARGB & 0xFF0000) >> 16;
            rawByte[n] = (byte)r;
            ++n;
        }
        raw = null;
        return rawByte;
    }

    private static byte[] getByteArrayGreen(Image image) {
        int[] raw = new int[image.getWidth() * image.getHeight()];
        image.getRGB(raw, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        byte[] rawByte = new byte[image.getWidth() * image.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < raw.length; ++i) {
            int ARGB = raw[i];
            int g = (ARGB & 0xFF00) >> 8;
            rawByte[n] = (byte)g;
            ++n;
        }
        raw = null;
        return rawByte;
    }

    private static byte[] toPNG(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] header = Lib_png2.createHeaderChunk(width, height);
        byte[] data = Lib_png2.createDataChunk(width, height, alpha, red, green, blue);
        byte[] trailer = Lib_png2.createTrailerChunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
        png.write(signature);
        png.write(header);
        png.write(data);
        png.write(trailer);
        return png.toByteArray();
    }

    private static byte[] createHeaderChunk(int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(width);
        chunk.writeInt(height);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        return Lib_png2.toChunk("IHDR", baos.toByteArray());
    }

    private static byte[] createDataChunk(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        for (int y = 0; y < height; ++y) {
            raw[dest++] = 0;
            for (int x = 0; x < width; ++x) {
                raw[dest++] = red[source];
                raw[dest++] = green[source];
                raw[dest++] = blue[source];
                raw[dest++] = alpha[source++];
            }
        }
        return Lib_png2.toChunk("IDAT", Lib_png2.toZLIB(raw));
    }

    private static byte[] createTrailerChunk() throws IOException {
        return Lib_png2.toChunk("IEND", new byte[0]);
    }

    private static byte[] toChunk(String id, byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        byte[] bid = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bid[i] = (byte)id.charAt(i);
        }
        chunk.write(bid);
        chunk.write(raw);
        int crc = -1;
        crc = Lib_png2.updateCRC(crc, bid);
        crc = Lib_png2.updateCRC(crc, raw);
        chunk.writeInt(~crc);
        return baos.toByteArray();
    }

    private static void createCRCTable() {
        crcTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            Lib_png2.crcTable[i] = c;
        }
    }

    private static int updateCRC(int crc, byte[] raw) {
        if (crcTable == null) {
            Lib_png2.createCRCTable();
        }
        for (int i = 0; i < raw.length; ++i) {
            crc = crcTable[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    private static byte[] toZLIB(byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 5 + 6);
        DataOutputStream zlib = new DataOutputStream(baos);
        int tmp = 8;
        zlib.writeByte(tmp);
        zlib.writeByte((31 - (tmp << 8) % 31) % 31);
        zlib.writeByte(1);
        char length = (char)raw.length;
        zlib.writeByte((byte)(length & 0xFF));
        zlib.writeByte((byte)((length & 0xFF00) >> 8));
        zlib.writeByte((byte)(~length & 0xFF));
        zlib.writeByte((byte)((~length & 0xFF00) >> 8));
        zlib.write(raw);
        zlib.writeInt(Lib_png2.calcADLER32(raw));
        return baos.toByteArray();
    }

    private static int calcADLER32(byte[] raw) {
        int s1 = 1;
        int s2 = 0;
        for (int i = 0; i < raw.length; ++i) {
            s1 = (s1 + raw[i]) % 65521;
            s2 = (s2 + s1) % 65521;
        }
        return (s2 << 16) + s1;
    }

    public static int save_png(Image img, String FileName) {
        byte[] ba = null;
        try {
            ba = Lib_png2.toPNG(img.getWidth(), img.getHeight(), Lib_png2.getByteArrayAlpha(img), Lib_png2.getByteArrayRed(img), Lib_png2.getByteArrayGreen(img), Lib_png2.getByteArrayBlue(img));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            fc = (FileConnection)Connector.open((String)("file:///" + FileName));
            if (fc.exists()) {
                fc.delete();
            }
            fc.create();
            os = fc.openOutputStream();
            os.write(ba);
            if (os != null) {
                os.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 1;
    }

    public static String png_to_string(Image img) {
        byte[] ba = null;
        try {
            ba = Lib_png2.toPNG(img.getWidth(), img.getHeight(), Lib_png2.getByteArrayAlpha(img), Lib_png2.getByteArrayRed(img), Lib_png2.getByteArrayGreen(img), Lib_png2.getByteArrayBlue(img));
        }
        catch (Exception e) {
            return null;
        }
        return new String(ba);
    }
}

