/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Rect;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.XBody;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;
import javax.microedition.lcdui.Graphics;

public abstract class BaseObject {
    public Bitmap[] frames;
    public int nFrames = 0;
    public int cFrame = 0;
    public int radius = 0;
    public int defaultFrame = 0;
    public int frameLength = 100;
    public boolean isAnimationPlaying = false;
    public boolean repeatAnimation = false;
    public long animationStartTime = 0L;
    public ArrayList animationSequence = new ArrayList();
    public XBody box2dId;
    public int typeDinamicalObjects;

    public abstract void update(long var1);

    public abstract void draw(Graphics var1);

    public Rect getBoundingRectangle(ArrayList shape) {
        Rect rect = new Rect();
        Point p0 = (Point)shape.get(0);
        if (this.radius != 0) {
            rect.left = p0.x - this.radius;
            rect.top = p0.y - this.radius;
            rect.right = rect.left + this.radius * 2;
            rect.bottom = rect.top + this.radius * 2;
            return rect;
        }
        int maxLeft = p0.x;
        int maxRight = p0.x;
        int maxTop = p0.y;
        int maxBottom = p0.y;
        for (int i = 1; i < shape.size(); ++i) {
            Point p = (Point)shape.get(i);
            if (p.x < maxLeft) {
                maxLeft = p.x;
            }
            if (p.x > maxRight) {
                maxRight = p.x;
            }
            if (p.y < maxTop) {
                maxTop = p.y;
            }
            if (p.y <= maxBottom) continue;
            maxBottom = p.y;
        }
        rect.left = maxLeft;
        rect.right = maxRight;
        rect.top = maxTop;
        rect.bottom = maxBottom;
        return rect;
    }

    public void loadImage(String name, ArrayList polyShape) {
        if (name.equals("Empty")) {
            return;
        }
        this.getFramesCount(name);
        this.frames = new Bitmap[this.nFrames];
        String workingName = name;
        Rect boundingRect = this.getBoundingRectangle(polyShape);
        int width = boundingRect.right - boundingRect.left;
        int height = boundingRect.bottom - boundingRect.top;
        for (int i = 0; i < this.nFrames; ++i) {
            this.frames[i] = Textures.getBitmapByName(workingName, width, height);
            workingName = Utils.replace(name, "1", String.valueOf(i + 2));
        }
    }

    public void getFramesCount(String imageName) {
        this.nFrames = 0;
        if (!imageName.endsWith("1")) {
            int bmp_id = Textures.getBitmapIdByName(imageName);
            if (bmp_id == -1) {
                return;
            }
            this.nFrames = 1;
            return;
        }
        String workingName = imageName;
        int bmp_id = 0;
        int cnt = 2;
        while ((bmp_id = Textures.getBitmapIdByName(workingName)) != -1) {
            ++this.nFrames;
            workingName = Utils.replace(imageName, "1", String.valueOf(cnt));
            ++cnt;
        }
        return;
    }

    public int getCurrentFrame() {
        long now = System.currentTimeMillis();
        if (now - this.animationStartTime >= (long)(this.animationSequence.size() * this.frameLength)) {
            if (this.repeatAnimation) {
                this.animationStartTime = now;
            } else {
                this.isAnimationPlaying = false;
            }
        }
        if (!this.isAnimationPlaying) {
            return this.defaultFrame;
        }
        if ((long)this.nFrames < (now - this.animationStartTime) / (long)this.frameLength) {
            return 0;
        }
        if (this.animationStartTime > now || this.animationStartTime == 0L) {
            this.animationStartTime = now;
        }
        return (Integer)this.animationSequence.get((int)((now - this.animationStartTime) / (long)this.frameLength));
    }

    public void setDefaultAnimationSequence() {
        this.animationSequence.clear();
        for (int i = 0; i < this.nFrames; ++i) {
            this.animationSequence.add(new Integer(i));
        }
        this.repeatAnimation = true;
    }

    public void setRandomPlayerAnimation() {
        this.animationSequence.clear();
        if (MyWorld.onFly) {
            this.animationSequence.add(new Integer(Utils.random.nextInt(3) + 1));
        }
        if (!MyWorld.onFly) {
            this.animationSequence.add(new Integer(Utils.random.nextInt(3) + 1));
        }
        this.frameLength = 750;
        this.animationStartTime = System.currentTimeMillis();
        this.isAnimationPlaying = true;
    }
}

