/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.GameObject;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class Particle
extends GameObject {
    public boolean free = true;
    float scaleSpeed;
    float speed;
    float gravity;
    Bitmap frame;
    Point positionOffset = new Point();
    boolean SpinVariation;
    boolean SizeVariation;
    boolean GravityVariation;
    boolean alive;
    boolean isScalable;
    boolean isRotatable;
    float size;
    float angle;
    float rotationSpeedAcceleration;
    float rotationSpeed;
    int ParticleLife;
    float vecX;
    float vecY;
    float random;
    float random2;
    float distance;
    int k;

    Particle() {
    }

    public void draw(Graphics g) {
        if (this.alive && !this.isScalable && !this.isRotatable) {
            this.frame.draw(g, this.position.x - Camera.position, this.position.y);
        }
    }

    public void setDirection() {
        float dx = this.position.x - this.positionOffset.x;
        float dy = this.position.y - this.positionOffset.y;
        this.distance = (float)Math.sqrt(dx * dx + dy * dy);
        this.vecX = dx / this.distance;
        this.vecY = dy / this.distance;
    }

    public void setGravity(float min, float max) {
        this.gravity = (max - min) * Utils.random.nextFloat() + min;
        this.k = 0;
    }

    public void setGravityVariation(boolean gravityvar) {
        this.GravityVariation = gravityvar;
    }

    public void setOffset(Point emmiter) {
        this.positionOffset = emmiter;
    }

    public void setParticleLife(float min, float max) {
        this.ParticleLife = (int)((max - min) * Utils.random.nextFloat() + min);
    }

    public void setRadialAcceleration(float min, float max) {
        this.rotationSpeedAcceleration = (max - min) * Utils.random.nextFloat() + min;
    }

    public void setRotation(float min, float max) {
        this.angle = (max - min) * Utils.random.nextFloat() + min;
    }

    public void setParticleSize(float min, float max) {
        this.size = this.SizeVariation ? (max - min) * Utils.random.nextFloat() + min : max;
    }

    public void setSizeVariation(boolean sizevar) {
        this.SizeVariation = sizevar;
    }

    public void setSpeed(float min, float max) {
        this.speed = (max - min) * Utils.random.nextFloat() + min;
    }

    public void setScaleSpeed(float min, float max) {
        this.scaleSpeed = (max - min) * Utils.random.nextFloat() + min;
    }

    public void setSpin(float min, float max) {
        this.rotationSpeed = (max - min) * Utils.random.nextFloat() + min;
    }

    public void setSpinVariation(boolean variation) {
        this.SpinVariation = variation;
    }

    public void setSpread(PhysicalGameObject pGO, float cAngle) {
        this.random = Utils.random.nextFloat();
        this.random2 = Utils.random.nextFloat();
        if (pGO.isCircle) {
            float a = this.random2 * 2.0f * (float)Math.PI;
            float r = (float)pGO.radius * this.random;
            this.position.x = (int)((double)this.positionOffset.x + Math.cos(a) * (double)r);
            this.position.y = (int)((double)this.positionOffset.y + Math.sin(a) * (double)r);
        } else {
            float w = pGO.width;
            float h = pGO.height;
            float a = cAngle;
            float cos = (float)Math.cos(a);
            float sin = (float)Math.sin(a);
            float w2 = w / 2.0f;
            float h2 = h / 2.0f;
            this.position.x = (int)((float)this.positionOffset.x - cos * w2 + sin * h2 + (cos * w * this.random - sin * h * this.random2));
            this.position.y = (int)((float)this.positionOffset.y - sin * w2 - cos * h2 + (sin * w * this.random + cos * h * this.random2));
        }
        this.alive = true;
        this.isRotatable = false;
        this.isScalable = false;
    }

    public void setSprite(Bitmap sprite) {
        this.frame = sprite;
    }

    public void update(long dt) {
        if (this.alive) {
            this.position.x = (int)((float)this.position.x + this.vecX * this.speed);
            this.position.y = (int)((float)this.position.y + (this.vecY * this.speed + this.gravity * (float)this.k));
            ++this.k;
            if (this.isScalable) {
                this.size -= this.scaleSpeed;
                if (this.size < 0.0f) {
                    this.alive = false;
                }
            }
            if (this.isRotatable) {
                this.angle += this.rotationSpeed + this.rotationSpeedAcceleration * (float)this.k;
            }
        }
    }
}

