#
#      BluePadApplet.py
#
#      Copyright 2007 - 2008 	Joaquim Rocha <joaquimrocha1@gmail.com>   
#								Valerio Valerio <vdv100@gmail.com>
#						
#
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#


#!/usr/bin/python -u

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import sys
import os
import os.path
import pynotify
import time
import bluetooth
import webbrowser
import locale
import gettext
import gobject
import gtk.gdk as gdk
from threading import Thread
from gettext import textdomain, gettext as _

import BluePadUinput
import BluePadServer

gtk.gdk.threads_init()

class BluePadApplet:
	"""
	Create a new BluePadApplet that stay\'s in the system tray
	"""
	def __init__(self):
		"""
		Initialize the applet icons and actions.\n
		Read the glade files whith the preferences windows and about menus.\n
		Initialize the splasScreen.
		"""
		
		self.APP_NAME = "BluePad"
		self.local_path = os.path.realpath(os.path.dirname(sys.argv[0]))
		
		
		gtk.glade.bindtextdomain(self.APP_NAME, self.local_path)
		gtk.glade.textdomain(self.APP_NAME)
		gettext.bindtextdomain(self.APP_NAME, self.local_path)
		gettext.textdomain(self.APP_NAME)
		
		self.process_id = os.getpid()
		self.counter = 0
		self.near_devices = []
		self.exceptt = False
		self.connectionData = _("You are not connect to any device.")
		self.comboText = ""
		self.devices = False
		self.isConnect = False
		
		self.keyRelease = False
		self.mouseCounter = 0
		
		self.statusIcon = gtk.StatusIcon()
		self.statusIcon2 = gtk.StatusIcon()
		
		
 		#Splash
 		self.splash = 'splash.glade'
		self.wTree3 = gtk.glade.XML(self.splash) 
		self.splashDialog = self.wTree3.get_widget("splashWindow")
		
		self.menu = gtk.Menu()
		self.menuItem = gtk.ImageMenuItem(gtk.STOCK_CONNECT)
		self.menuItem.connect('activate', self.activate_preferences)
		self.menu.append(self.menuItem)
		self.menuItem = gtk.ImageMenuItem(gtk.STOCK_ABOUT)
		self.menuItem.connect('activate', self.show_about)
		self.menu.append(self.menuItem)
		self.menuItem = gtk.ImageMenuItem(gtk.STOCK_QUIT)
		self.menuItem.connect('activate', self.quit_applet, self.statusIcon)
		self.menu.append(self.menuItem)
		
		self.menu2 = gtk.Menu()
		self.menuItem = gtk.ImageMenuItem(gtk.STOCK_DISCONNECT)
		self.menuItem.connect('activate', self.disconnect_phone)
		self.menu2.append(self.menuItem)
		self.menuItem = gtk.ImageMenuItem(gtk.STOCK_ABOUT)
		self.menuItem.connect('activate', self.show_about)
		self.menu2.append(self.menuItem)
		self.menuItem = gtk.ImageMenuItem(gtk.STOCK_QUIT)
		self.menuItem.connect('activate', self.quit_applet, self.statusIcon)
		self.menu2.append(self.menuItem)
 
 		
		self.statusIcon.set_from_file("images/bluepad_off.svg")
		self.statusIcon.set_tooltip("BluePad")
		self.statusIcon.connect('activate', self.show_info,gtk.STOCK_INFO,self.statusIcon, self.connectionData)
		self.popupId = self.statusIcon.connect('popup-menu', self.popup_menu, self.menu)
		self.statusIcon.set_visible(True)
		
		pynotify.init("App")
		
		#Set the Glade file
		self.gladefile = "BluePad.glade"  
		self.aboutfile = "aboutBluePad.glade"
		
		#splashScreen
		while gtk.events_pending():
   			gtk.main_iteration()
		time.sleep(3)
		self.splashDialog.destroy()
	   
		
	def quit_applet(self, widget, data = None):
		"""
		Quit the BluePadApplet.
		@param widget: Current widget
		@type widget: gtk widget
		@param data: widget to destroy
		@type data: gtk widget
		"""
		if data:
			data.set_visible(False)
			os.popen("kill -9 "+str(self.process_id))
     		gtk.main_quit()
    	
 
	def popup_menu(self,widget, button, time, data = None):
		"""
		Create the popup menu for the BluePadApplet.
		@param widget: Current widget
		@type widget: gtk widget
		@param button: Widget to destroy
		@type button: gtk widget
		@param time: Current time
		@type time: time
		"""

		if button == 3:
			if data:
				data.show_all()
				data.popup(None, None, None, 3, time)
		pass
 
	def show_about(self, widget, data = None):
		
		"""
		Create the about dialog.
		@param widget: Current widget
		@type widget: gtk widget
		"""
		
		self.wTree2 = gtk.glade.XML(self.aboutfile,"aboutdialog1", self.APP_NAME) 
		self.aboutDialog = self.wTree2.get_widget("aboutdialog1")
		self.aboutDialog.connect("response", lambda d, r: d.destroy())
     
	def activate_preferences(self, widget, data = None):
		
		"""
		Create the preferences dialog.
		@param widget: Current widget
		@type widget: gtk widget
		"""
		
		#Set the Glade file
		
	   	self.wTree = gtk.glade.XML(self.gladefile) 
		
		#Create our dictionay and connect it
		dic = {"on_MainWindow_destroy" : gtk.main_quit,}
		self.wTree.signal_autoconnect(dic)
		self.combo = self.wTree.get_widget ("combobox1")
		self.buttonConnect = self.wTree.get_widget ("button1")
		self.buttonCancel = self.wTree.get_widget ("button2")
		self.buttonSearch = self.wTree.get_widget ("button3")
		self.mainWindows = self.wTree.get_widget ("dialog1")
		self.aboutMenu = self.wTree.get_widget ("About")
		self.helpMenu = self.wTree.get_widget ("Online Help")
		self.quitMenu = self.wTree.get_widget ("Quit")
		self.combo.connect('changed', self.changed_combo)
		self.combo.set_active(0)
		self.buttonCancel.connect('clicked',self.destroy_applet, self.mainWindows)
		self.buttonSearch.connect('clicked',self.search_applet)
		self.buttonConnect.connect('clicked',self.connect_applet)
		self.aboutMenu.connect('activate',self.show_about)
		self.helpMenu.connect('activate',self.show_help)
		self.quitMenu.connect('activate', self.destroy_applet, self.mainWindows)
		
	
	def show_help(self, widget, data = None):
		
		webbrowser.open_new('http://bluepad.sourceforge.net')

				
	def show_info(self, widget, icon, statsIcon, data = None):
		
		self.info(icon, statsIcon, data)
		
	def info(self, iconInfo, statsIcon, data = None):
		
		self.n = pynotify.Notification(_("BluePad"), _(data))
		self.n.attach_to_status_icon(statsIcon)
		info = gtk.Button()
		icon = info.render_icon(iconInfo, gtk.ICON_SIZE_DIALOG)
		self.n.set_icon_from_pixbuf(icon)
		self.n.show()	
	
	
	def disconnect_phone(self,widget, data = None):
		
		self.statusIcon.disconnect(self.popupId)
		self.popupId = self.statusIcon.connect('popup-menu', self.popup_menu, self.menu)
		self.statusIcon.set_from_file("images/bluepad_off.svg")
		self.connectionData = _("The connection has been closed.")
		self.info(gtk.STOCK_DISCONNECT,self.statusIcon, self.connectionData)
		self.connectionData = _("You are not connect to any device")
		
		BluePadServer.disconnect_by_pc(self.BluePadServer)
	
		
	def disconnect_by_phone(self, data = None):
		
		if self.isConnect:
			return True
			
		else:	
		
			self.statusIcon.disconnect(self.popupId)
			self.popupId = self.statusIcon.connect('popup-menu', self.popup_menu, self.menu)
			self.statusIcon.set_from_file("images/bluepad_off.svg")
			self.connectionData = _("The connection has been closed.")
			self.info(gtk.STOCK_DISCONNECT,self.statusIcon, self.connectionData)
			self.connectionData = _("You are not connect to any device")
			return False
			
	def dialog_response_cb(self,dialog, response_id):
   		dialog.destroy()

   		if response_id == gtk.RESPONSE_OK:
			print 'OK clicked'

 	def dialog_run(self,dialog):
 		
   		if not dialog.modal:
			dialog.set_modal(True)
			dialog.connect('response', self.dialog_response_cb)
			dialog.show()
		
	def show_message_error(self, error_string):
	
		message_error =gtk.MessageDialog(type=gtk.MESSAGE_ERROR
				, message_format=error_string
				, buttons=gtk.BUTTONS_OK)
		message_error.set_icon_from_file("images/bluepad_on.svg")
		message_error.set_title(_("Error"))
		
		self.dialog_run(message_error)
		
		
		
	def destroy_applet(self, widget, data = None):
		"""
		Destroy a dialog/window.
		@param widget: Current widget
		@type widget: gtk widget
		@param data: widget to destroy
		@type data: gtk widget
		"""
		if data:
			data.hide()
			
	def search_applet(self, widget):
		"""
		Perform a search for bluetooth devices and display the results
		in the combo box.
		@param widget: Current widget
		@type widget: gtk widget
		"""
		
		devices_list = []
		
		if self.counter > 0:
			for i in range(0, self.counter+1):
				self.combo.remove_text(i)
				
		self.counter = 0
		watch = gtk.gdk.Cursor(gtk.gdk.WATCH)
		widget.window.set_cursor(watch)
		
		self.search_dev = self.search_devices(self)
		self.search_dev.start()
		gobject.timeout_add(100,self.progSearch)
			
			
					
		
		
	def search_applet_result(self):
			
		devices_len = len(self.near_devices)
		
		if devices_len > 0:
				
			self.devices = True
			for i in range(0, devices_len):
				self.counter = self.counter +1
				(a,b) = self.near_devices[i]
				self.combo.insert_text(i,b)
					
		else:
			if self.exceptt:
				self.show_message_error(_("Error: \n\nNone Bluetooth device found in your system."))
			else:
								
				self.connectionData = _("None device found.")
				self.counter = self.counter + 1
				self.combo.append_text(self.connectionData)
				
			
		
		self.combo.set_active(0)
		self.mainWindows.window.set_cursor(None)
		

	def connect_applet(self,widget, data= None):
		
		"""
		Connect to the bluetooth device chosen in the combo box.
		@param widget: Current widget
		@type widget: gtk widget
		"""
		
		
		if self.devices:
			
			self.isConnect = False
			self.destroy_applet(widget,self.mainWindows)
		 	
			self.connectionData = _("Waiting response from ") + self.comboText
			self.show_info(widget, gtk.STOCK_INFO, self.statusIcon, self.connectionData)
			gobject.timeout_add(100,self.progConnect)
			
			
			self.BluePadServer = BluePadServer.server_start(self)
			
		else:
		
			
			self.connectionData = _("No devices found")
			self.show_info(widget, gtk.STOCK_INFO, self.statusIcon, self.connectionData)


	def changed_combo(self, entry):
		"""
		Return the text in the given combo box entry
		@param entry: combo box entry
		@type entry: integer
		"""
		self.comboText = entry.get_active_text()
		
	def progSearch(self):
		
		if self.search_dev.isAlive():
			
			return True
		else:
			
			self.search_applet_result()
			
			return False	
			 
	def progConnect(self):
		
		if self.isConnect:
			
			
			self.statusIcon.disconnect(self.popupId)
			self.popupId = self.statusIcon.connect('popup-menu', self.popup_menu, self.menu2)
			self.statusIcon.set_from_file("images/bluepad_on.svg")
			self.connectionData = _("Connect to ") + self.comboText
			self.info(gtk.STOCK_CONNECT, self.statusIcon2, self.connectionData)
			gobject.timeout_add(100,self.disconnect_by_phone)
			return False
		else:
			
			return True
		

	class search_devices(Thread):
		"""
		Perform a search for bluetooth devices.
		@return: A tuple whith the address and name of nerby bluetooth
		devices.
		"""
		
		def __init__(self,bpa):
			
			Thread.__init__(self)
			self.bpa = bpa
		
		def run(self):	
				
				bpa.exceptt = False
				try:
					
					devices_list = []
				
					
					print _("Search Devices...")

					nearby_devices = bluetooth.discover_devices(lookup_names = True)

					print _("Found %d devices") % len(nearby_devices)

					for name, addr in nearby_devices:
						print "  %s - %s" % (addr, name)
						
					self.bpa.near_devices = nearby_devices
					return nearby_devices
					
				except bluetooth.BluetoothError:
					self.bpa.exceptt = True
					
				
if __name__ == "__main__":
	
	bpa = BluePadApplet()
	gtk.main()
	
