/*
 * Decompiled with CFR 0.152.
 */
package library.fs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import library.fs.FilePtr;
import library.fs.FilePtrPdap;
import library.fs.FileSystem;

public class FsPdap
extends FileSystem {
    FsPdap() {
    }

    public FilePtr Open(String path, int mode) throws IOException {
        FileConnection fconn = (FileConnection)Connector.open((String)(path.startsWith("file://") ? path : "file://" + path));
        FilePtrPdap file = new FilePtrPdap(this);
        file.mode = mode;
        file.fconn = fconn;
        if (mode == 1) {
            if (!fconn.exists()) {
                throw new IOException("file not found");
            }
            file.is = fconn.openInputStream();
            file.os = null;
        } else if (mode == 2) {
            if (fconn.exists()) {
                fconn.delete();
            }
            fconn.create();
            file.os = fconn.openOutputStream();
            file.is = null;
        } else {
            throw new IOException("unknown file mode");
        }
        return file;
    }

    public int Size(String path) throws IOException {
        FileConnection fconn = (FileConnection)Connector.open((String)(path.startsWith("file://") ? path : "file://" + path));
        int size = (int)fconn.fileSize();
        fconn.close();
        return size;
    }

    public String[] List(String path) throws IOException {
        if (path.equals("/")) {
            Vector<String> vFiles = new Vector<String>();
            Enumeration rootEnum = FileSystemRegistry.listRoots();
            while (rootEnum.hasMoreElements()) {
                String root = (String)rootEnum.nextElement();
                vFiles.addElement(root);
            }
            Object[] list = new String[vFiles.size()];
            vFiles.copyInto(list);
            vFiles.removeAllElements();
            vFiles = null;
            return list;
        }
        if (path.length() > 1) {
            Vector vFiles = new Vector();
            FileConnection fconn = (FileConnection)Connector.open((String)(path.startsWith("file://") ? path : "file://" + path));
            Enumeration e = fconn.list("*", false);
            while (e.hasMoreElements()) {
                vFiles.addElement(e.nextElement());
            }
            fconn.close();
            Object[] list = new String[vFiles.size()];
            vFiles.copyInto(list);
            vFiles.removeAllElements();
            vFiles = null;
            return list;
        }
        throw new IOException("List() : invalid path");
    }
}

