/*
 * Decompiled with CFR 0.152.
 */
package library;

import common.JccFunction;
import common.JccObject;
import common.JccType;
import java.util.Hashtable;
import library.BaseLibrary;
import library.fs.FilePtr;
import library.fs.FileSystem;
import library.lib_iolib.jcc_InputStream;
import library.lib_iolib.jcc_OutputStream;
import runtime.JccVoid;

public class filelib
extends BaseLibrary {
    Hashtable htObjects;
    JccFunction[] vFunc;
    Hashtable htFunc;
    FileSystem fs;
    Hashtable htFiles;
    int nextIndex;

    public JccObject getObject(String name) {
        return null;
    }

    public JccObject createObject(int num) {
        return null;
    }

    public String getName() {
        return "filelib";
    }

    public String[] requires() {
        String[] req = new String[]{"iolib"};
        return req;
    }

    public String getFuncName(int iFunc) {
        return new String(this.vFunc[iFunc].name);
    }

    public void init(boolean bCompilation) {
        if (bCompilation) {
            this.htObjects = new Hashtable();
            this.vFunc = new JccFunction[10];
            this.htFunc = new Hashtable();
            JccFunction f_fopen = new JccFunction("fopen", JccType.TYPE_INT, false);
            f_fopen.iFunc = 0;
            f_fopen.args = new JccType[2];
            f_fopen.args[0] = JccType.TYPE_STRING;
            f_fopen.args[1] = JccType.TYPE_STRING;
            this.vFunc[0] = f_fopen;
            this.htFunc.put(f_fopen.getSpec(), f_fopen);
            JccFunction f_fclose = new JccFunction("fclose", JccType.TYPE_INT, false);
            f_fclose.iFunc = 1;
            f_fclose.args = new JccType[1];
            f_fclose.args[0] = JccType.TYPE_INT;
            this.vFunc[1] = f_fclose;
            this.htFunc.put(f_fclose.getSpec(), f_fclose);
            JccFunction f_fread = new JccFunction("fread", JccType.TYPE_INT, false);
            f_fread.iFunc = 2;
            f_fread.args = new JccType[4];
            f_fread.args[0] = JccType.TYPE_INT;
            f_fread.args[1] = new JccType(23, 1);
            f_fread.args[2] = JccType.TYPE_INT;
            f_fread.args[3] = JccType.TYPE_INT;
            this.vFunc[2] = f_fread;
            this.htFunc.put(f_fread.getSpec(), f_fread);
            JccFunction fwrite = new JccFunction("fwrite", JccType.TYPE_INT, false);
            fwrite.iFunc = 3;
            fwrite.args = new JccType[4];
            fwrite.args[0] = JccType.TYPE_INT;
            fwrite.args[1] = new JccType(23, 1);
            fwrite.args[2] = JccType.TYPE_INT;
            fwrite.args[3] = JccType.TYPE_INT;
            this.vFunc[3] = fwrite;
            this.htFunc.put(fwrite.getSpec(), fwrite);
            JccFunction f_dirlist = new JccFunction("dirlist", new JccType(22, 1), false);
            f_dirlist.iFunc = 4;
            f_dirlist.args = new JccType[1];
            f_dirlist.args[0] = JccType.TYPE_STRING;
            this.vFunc[4] = f_dirlist;
            this.htFunc.put(f_dirlist.getSpec(), f_dirlist);
            JccFunction f_filesize = new JccFunction("filesize", JccType.TYPE_INT, false);
            f_filesize.iFunc = 5;
            f_filesize.args = new JccType[1];
            f_filesize.args[0] = JccType.TYPE_STRING;
            this.vFunc[5] = f_filesize;
            this.htFunc.put(f_filesize.getSpec(), f_filesize);
            JccFunction f_fputs = new JccFunction("fputs", JccType.TYPE_INT, false);
            f_fputs.iFunc = 6;
            f_fputs.args = new JccType[2];
            f_fputs.args[0] = JccType.TYPE_INT;
            f_fputs.args[1] = JccType.TYPE_STRING;
            this.vFunc[6] = f_fputs;
            this.htFunc.put(f_fputs.getSpec(), f_fputs);
            JccFunction f_gets = new JccFunction("fgets", JccType.TYPE_STRING, false);
            f_gets.iFunc = 7;
            f_gets.args = new JccType[2];
            f_gets.args[0] = JccType.TYPE_INT;
            f_gets.args[1] = JccType.TYPE_INT;
            this.vFunc[7] = f_gets;
            this.htFunc.put(f_gets.getSpec(), f_gets);
            JccFunction f_fileOpenInputStream = new JccFunction("fileOpenInputStream", jcc_InputStream.singleton.type, false);
            f_fileOpenInputStream.iFunc = 8;
            f_fileOpenInputStream.args = new JccType[1];
            f_fileOpenInputStream.args[0] = JccType.TYPE_STRING;
            this.vFunc[8] = f_fileOpenInputStream;
            this.htFunc.put(f_fileOpenInputStream.getSpec(), f_fileOpenInputStream);
            JccFunction f_fileOpenOutputStream = new JccFunction("fileOpenOutputStream", jcc_OutputStream.singleton.type, false);
            f_fileOpenOutputStream.iFunc = 9;
            f_fileOpenOutputStream.args = new JccType[1];
            f_fileOpenOutputStream.args[0] = JccType.TYPE_STRING;
            this.vFunc[9] = f_fileOpenOutputStream;
            this.htFunc.put(f_fileOpenOutputStream.getSpec(), f_fileOpenOutputStream);
        } else {
            this.nextIndex = 1;
            try {
                this.fs = FileSystem.GetInstance();
                this.htFiles = new Hashtable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JccFunction getFunction(String name) {
        return (JccFunction)this.htFunc.get(name);
    }

    public Object callFunction(int num, Object[] arglist) throws Exception {
        switch (num) {
            case 0: {
                return new Integer(this.fopen((String)arglist[0], (String)arglist[1]));
            }
            case 1: {
                return new Integer(this.fclose((Integer)arglist[0]));
            }
            case 2: {
                Object[] arr = (Object[])arglist[1];
                byte[] data = new byte[arr.length];
                int res = this.fread((Integer)arglist[0], data, (Integer)arglist[2], (Integer)arglist[3]);
                for (int i = 0; i < data.length; ++i) {
                    arr[i] = new Integer(data[i]);
                }
                return new Integer(res);
            }
            case 3: {
                Object[] arr = (Object[])arglist[1];
                byte[] data = new byte[arr.length];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = ((Integer)arr[i]).byteValue();
                }
                int res = this.fwrite((Integer)arglist[0], data, (Integer)arglist[2], (Integer)arglist[3]);
                return new Integer(res);
            }
            case 4: {
                return this.dirlist((String)arglist[0]);
            }
            case 5: {
                return new Integer(this.filesize((String)arglist[0]));
            }
            case 6: {
                return new Integer(this.fputs((Integer)arglist[0], (String)arglist[1]));
            }
            case 7: {
                return this.fgets((Integer)arglist[0], (Integer)arglist[1]);
            }
            case 8: {
                return this.fileOpenInputStream((String)arglist[0]);
            }
            case 9: {
                return this.fileOpenOutputStream((String)arglist[0]);
            }
        }
        return JccVoid.singleton;
    }

    public int fopen(String fName, String mode) {
        int fmode;
        if (this.fs == null) {
            return -1;
        }
        if (mode.equals("r")) {
            fmode = 1;
        } else if (mode.equals("w")) {
            fmode = 2;
        } else {
            return -2;
        }
        try {
            FilePtr f = this.fs.Open(fName, fmode);
            this.htFiles.put(new Integer(this.nextIndex), f);
            int ind = this.nextIndex++;
            return ind;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -3;
        }
    }

    public int fclose(int fd) {
        try {
            FilePtr f = (FilePtr)this.htFiles.get(new Integer(fd));
            f.Close();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int fread(int fd, byte[] buf, int offset, int len) {
        try {
            FilePtr f = (FilePtr)this.htFiles.get(new Integer(fd));
            return f.Read(buf, offset, len);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int fwrite(int fd, byte[] buf, int offset, int len) {
        try {
            FilePtr f = (FilePtr)this.htFiles.get(new Integer(fd));
            f.Write(buf, offset, len);
            return len;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String[] dirlist(String path) {
        try {
            return this.fs.List(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public int filesize(String path) {
        try {
            return this.fs.Size(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int fputs(int fd, String s) {
        try {
            FilePtr f = (FilePtr)this.htFiles.get(new Integer(fd));
            byte[] bytes = s.getBytes();
            f.Write(bytes, 0, bytes.length);
            return bytes.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String fgets(int fd, int n) {
        try {
            FilePtr f = (FilePtr)this.htFiles.get(new Integer(fd));
            if (n < 0) {
                String s = "";
                byte[] buf = new byte[]{0};
                f.Read(buf);
                char c = (char)buf[0];
                while (true) {
                    if (c == '\r') {
                        f.Read(buf);
                        return s;
                    }
                    if (c == '\n') {
                        return s;
                    }
                    if (c == '\uffffffff') {
                        return s;
                    }
                    s = s + c;
                    f.Read(buf);
                    c = (char)buf[0];
                }
            }
            byte[] buf = new byte[n];
            f.Read(buf);
            return new String(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public jcc_InputStream fileOpenInputStream(String sFile) {
        try {
            FilePtr fp = this.fs.Open(sFile, 1);
            jcc_InputStream is = new jcc_InputStream();
            is.is = fp.GetDataInputStream();
            return is;
        }
        catch (Exception e) {
            return null;
        }
    }

    public jcc_OutputStream fileOpenOutputStream(String sFile) {
        try {
            FilePtr fp = this.fs.Open(sFile, 2);
            jcc_OutputStream os = new jcc_OutputStream();
            os.os = fp.GetDataOutputStream();
            return os;
        }
        catch (Exception e) {
            return null;
        }
    }
}

