/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class BinaryClockRms {
    protected static RecordStore m_rs = null;
    protected static final String RS_NAME = "BinaryClockRMS";
    public int[] Settings = new int[3];
    public String FilePath = "";

    BinaryClockRms() {
        this.init();
        this.GetSettings();
        this.Shutdown();
    }

    public void init() {
        try {
            m_rs = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void Shutdown() {
        try {
            m_rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void Clear() {
        try {
            RecordStore.deleteRecordStore((String)RS_NAME);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void Save() {
        this.Clear();
        this.init();
        this.SaveSettings();
        this.Shutdown();
    }

    public void SaveSettings() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.FilePath);
            for (int i = 0; i < this.Settings.length; ++i) {
                dataOutputStream.writeInt(this.Settings[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            int n = m_rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void GetSettings() {
        boolean bl = true;
        try {
            RecordEnumeration recordEnumeration = m_rs.enumerateRecords(null, null, true);
            while (recordEnumeration.hasNextElement()) {
                try {
                    int n = recordEnumeration.nextRecordId();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(m_rs.getRecord(n));
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    this.FilePath = dataInputStream.readUTF();
                    for (int i = 0; i < this.Settings.length; ++i) {
                        this.Settings[i] = dataInputStream.readInt();
                    }
                    bl = false;
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            recordStoreNotOpenException.printStackTrace();
        }
        if (bl) {
            this.FilePath = "";
            this.Settings[0] = 0;
            this.Settings[1] = 0;
            this.Settings[2] = 0;
            this.SaveSettings();
        }
    }
}

