/*
 * Decompiled with CFR 0.152.
 */
package frostbit.theme.controls;

import frostbit.theme.controls.ColorControl;
import frostbit.theme.controls.Manager;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;

public class ColorSelect
implements CommandListener {
    public static Image image;
    private static Graphics c;
    public static ImageItem ii;
    public static Form f;
    public static Gauge gr;
    public static Gauge gg;
    public static Gauge gb;
    public static Gauge ga;
    public static int r;
    public static int g;
    public static int b;
    public static int a;
    public static Display disp;
    public static Displayable prevDisp;
    public static ColorControl cc;
    public static int step;
    public static int clipboard;
    public static final Command copy;
    public static final Command paste;
    public static final Command cList;
    public static final String[] sColors;
    public static final int[] colors;
    private static final String[] d;
    public static final List list;
    public static final ChoiceGroup tr;

    public static void load(Display display, int n) {
        disp = display;
        step = n;
        image = Image.createImage((int)64, (int)24);
        c = image.getGraphics();
        ii = new ImageItem("\u041f\u0440\u0435\u0432\u044c\u044e", null, 0, "", 0);
        gr = new Gauge("Red", true, 255 / step, 0);
        gg = new Gauge("Green:", true, 255 / step, 0);
        gb = new Gauge("Blue:", true, 255 / step, 0);
        ga = new Gauge("Alpha:", true, 255 / step, 0);
        if (f != null) {
            f.deleteAll();
        }
        f = new Form("\u0412\u044b\u0431\u043e\u0440 \u0446\u0432\u0435\u0442\u0430");
        f.addCommand(Manager.cBack);
        f.addCommand(Manager.cApply);
        f.addCommand(copy);
        f.addCommand(paste);
        f.addCommand(cList);
        f.setCommandListener((CommandListener)new ColorSelect());
        f.append((Item)gr);
        f.append((Item)gg);
        f.append((Item)gb);
        ii.setImage(image);
        f.append((Item)ii);
        f.append((Item)tr);
        f.append((Item)ga);
        list.setCommandListener((CommandListener)new ColorSelect());
        list.addCommand(Manager.cBack);
    }

    public static String toHex(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(n).toUpperCase());
        if (stringBuffer.length() == (bl ? 8 : 6)) {
            return stringBuffer.toString();
        }
        while (stringBuffer.length() < (bl ? 8 : 6)) {
            stringBuffer.insert(0, "0");
        }
        return stringBuffer.toString();
    }

    public static void show(ColorControl colorControl, Displayable displayable) {
        prevDisp = displayable;
        cc = colorControl;
        int n = colorControl.color;
        if (n == -1) {
            n = 0;
        }
        gr.setValue((n >> 16 & 0xFF) / step);
        gg.setValue((n >> 8 & 0xFF) / step);
        gb.setValue((n & 0xFF) / step);
        ga.setValue((ColorSelect.cc.isAC ? n >>> 24 : 255) / step);
        tr.setSelectedIndex(0, ColorSelect.cc.isAC);
        ColorSelect.refresh();
        disp.setCurrent((Displayable)f);
    }

    public static void refresh() {
        if (cc == null) {
            return;
        }
        r = gr.getValue() * step;
        gr.setLabel("Red" + ColorSelect.a(r));
        g = gg.getValue() * step;
        gg.setLabel("Green" + ColorSelect.a(g));
        b = gb.getValue() * step;
        gb.setLabel("Blue" + ColorSelect.a(b));
        a = ga.getValue() * step;
        ga.setLabel("Alpha" + ColorSelect.a(a));
        int n = r << 16 | g << 8 | b;
        if (ColorSelect.cc.isAC) {
            n = a << 24 | n;
        }
        c.setColor(n);
        c.fillRect(0, 0, 63, 23);
        c.setColor(0xFFFFFF);
        c.drawRect(0, 0, 63, 23);
        ii.setLabel("\u041f\u0440\u0435\u0432\u044c\u044e (0x" + ColorSelect.toHex(n, ColorSelect.cc.isAC) + ")");
        ii.setImage(image);
    }

    public static void rfr() {
        if (cc == null) {
            return;
        }
        if (gr.getValue() == r / step && gg.getValue() == g / step && gb.getValue() == b / step) {
            ga.getValue();
        }
        ColorSelect.refresh();
    }

    private static String a(int n) {
        StringBuffer stringBuffer = new StringBuffer(" 0x");
        String string = Integer.toHexString(n).toUpperCase();
        stringBuffer.append(string.length() == 1 ? "0" + string : string);
        stringBuffer.append(" / ");
        stringBuffer.append(Integer.toString(n));
        return stringBuffer.toString();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == list) {
            if (command != Manager.cBack) {
                int n = colors[list.getSelectedIndex()];
                gr.setValue((n >> 16 & 0xFF) / step);
                gg.setValue((n >> 8 & 0xFF) / step);
                gb.setValue((n & 0xFF) / step);
            }
            disp.setCurrent((Displayable)f);
            return;
        }
        if (command == Manager.cApply) {
            Object object = new boolean[1];
            tr.getSelectedFlags((boolean[])object);
            ColorSelect.cc.isAC = object[0];
            ColorSelect.cc.color = ColorSelect.cc.isAC ? a << 24 | r << 16 | g << 8 | b : r << 16 | g << 8 | b;
            cc.refresh();
            cc.save();
            System.gc();
            disp.setCurrent(prevDisp);
            return;
        }
        if (command == Manager.cBack) {
            disp.setCurrent(prevDisp);
            return;
        }
        if (command == copy) {
            clipboard = r << 16 | g << 8 | b;
            return;
        }
        if (command == paste) {
            gr.setValue((clipboard >> 16 & 0xFF) / step);
            gg.setValue((clipboard >> 8 & 0xFF) / step);
            gb.setValue((clipboard & 0xFF) / step);
            return;
        }
        if (command == cList) {
            disp.setCurrent((Displayable)list);
        }
    }

    static {
        step = 17;
        copy = new Command("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 1, 1);
        paste = new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", 1, 2);
        cList = new Command("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435", 1, 3);
        sColors = new String[]{"\u0427\u0451\u0440\u043d\u044b\u0439", "\u0422\u0451\u043c\u043d\u043e-\u043a\u0440\u0430\u0441\u043d\u044b\u0439", "\u0422\u0451\u043c\u043d\u043e-\u0437\u0435\u043b\u0451\u043d\u044b\u0439", "\u041e\u043b\u0438\u0432\u043a\u043e\u0432\u044b\u0439", "\u0422\u0451\u043c\u043d\u043e-\u0441\u0438\u043d\u0438\u0439", "\u0424\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u044b\u0439", "\u041c\u043e\u0440\u0441\u043a\u043e\u0439 \u0432\u043e\u043b\u043d\u044b", "\u0422\u0451\u043c\u043d\u043e-\u0441\u0435\u0440\u044b\u0439", "\u0421\u0432\u0435\u0442\u043b\u043e-\u0441\u0435\u0440\u044b\u0439", "\u041a\u0440\u0430\u0441\u043d\u044b\u0439", "\u0417\u0435\u043b\u0451\u043d\u044b\u0439", "\u0416\u0451\u043b\u0442\u044b\u0439", "\u0421\u0438\u043d\u0438\u0439", "\u0420\u043e\u0437\u043e\u0432\u044b\u0439", "\u0411\u0438\u0440\u044e\u0437\u043e\u0432\u044b\u0439", "\u0411\u0435\u043b\u044b\u0439"};
        colors = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0x808080, 0xC0C0C0, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
        d = new String[]{"\u041f\u043e\u043b\u0443\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u043e\u0441\u0442\u044c"};
        list = new List("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435", 3, sColors, null);
        tr = new ChoiceGroup(null, 2, d, null);
    }
}

