/*
 * Decompiled with CFR 0.152.
 */
package com.movaya.license.gamecontrol;

import com.movaya.M123456;
import com.movaya.license.gamecontrol.MResource;
import com.movaya.license.rms.RmsBiz;
import com.movaya.license.structure.Array;
import com.movaya.license.structure.CarrierBlock;
import com.movaya.license.structure.MLicense;
import com.movaya.license.utils.Utils;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class MBuyUI
extends Form
implements CommandListener {
    public final String ORDER_TYPE_WAP;
    public final String ORDER_TYPE_MIDLET;
    private M123456 mmidlet = null;
    private Form m_buyForm = null;
    private ChoiceGroup m_carrierGroup = null;
    private ChoiceGroup m_priceGroup = null;
    private TextField m_phoneNumber = null;
    private Command m_exit = null;
    private Command m_ok = null;
    private Command m_back = null;
    RmsBiz rmsBiz = null;

    public MBuyUI(M123456 m2) {
        super("");
        this.ORDER_TYPE_WAP = "waporder";
        this.ORDER_TYPE_MIDLET = "midorder";
        this.mmidlet = m2;
        this.rmsBiz = this.mmidlet.rmsBiz;
        this.m_exit = Utils.getCmdExit();
        this.m_ok = Utils.getCmdOk("BUY");
        this.m_back = Utils.getCmdBack();
    }

    public MLicense getLic() {
        return this.rmsBiz.getDatLicense();
    }

    public MResource getRes() {
        return MResource.getResource(this.getLic());
    }

    public void process(boolean isAfterTry) {
        try {
            if (isAfterTry && !this.rmsBiz.isBuyable(this.getLic().getDefFeature().getFeatureId())) {
                this.m_buyForm = new Form(this.getRes().buy_trialExpiredTitle);
                this.m_buyForm.append(this.getRes().buy_trialExpired);
                this.m_buyForm.addCommand(this.m_exit);
            } else {
                this.m_buyForm = new Form(this.getRes().buy_displayName);
                this.m_buyForm.append(this.getRes().buy_pageTitle);
                this.m_phoneNumber = Utils.getPhoneText(this.getRes().buy_phoneNoLable, this.getLic().getBase().getPhoneNo());
                this.m_buyForm.append((Item)this.m_phoneNumber);
                this.m_carrierGroup = new ChoiceGroup(this.getRes().buy_carrierLable, 1);
                Array carriers = this.getLic().getDefReference().getCarriers();
                CarrierBlock carrier = null;
                int i2 = 0;
                while (i2 < carriers.size()) {
                    carrier = (CarrierBlock)carriers.elementAt(i2);
                    this.m_carrierGroup.append(carrier.getCarrierDName(), null);
                    ++i2;
                }
                this.m_buyForm.append((Item)this.m_carrierGroup);
                this.m_priceGroup = new ChoiceGroup(this.getRes().buy_priceLable, 1);
                this.m_priceGroup.append(Utils.formatMoney(this.getLic().getDefFeaSellProduct().getProductPrice()), null);
                this.m_buyForm.append((Item)this.m_priceGroup);
                if (isAfterTry) {
                    this.m_buyForm.setTitle(this.getRes().buy_trialExpiredTitle);
                    this.m_buyForm.addCommand(this.m_exit);
                } else {
                    this.m_buyForm.addCommand(this.m_back);
                }
                this.m_buyForm.addCommand(this.m_ok);
            }
            this.m_buyForm.setCommandListener((CommandListener)this);
            this.mmidlet.display.setCurrent((Displayable)this.m_buyForm);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void commandAction(Command cmd, Displayable dp) {
        block19: {
            try {
                int orderStatus;
                if (cmd == this.m_exit) {
                    this.mmidlet.notifyDestroyed();
                    break block19;
                }
                if (cmd == this.m_back) {
                    this.mmidlet.tryNBuy_123456();
                    break block19;
                }
                if (cmd != this.m_ok) break block19;
                if (this.m_phoneNumber.getString() == null || 10 != this.m_phoneNumber.getString().trim().length()) {
                    this.mmidlet.display.setCurrent(Utils.getAlertError(this.getRes().buy_phoneNoErrorTitle, this.getRes().buy_phoneNoError), (Displayable)this.m_buyForm);
                    break block19;
                }
                Alert tempAlert = null;
                String carrierDName = "";
                if (this.getLic().getBase().getCarrierID() <= 0) {
                    carrierDName = this.m_carrierGroup.getString(this.m_carrierGroup.getSelectedIndex());
                    carrierDName = Utils.htmlParaTransfer(carrierDName);
                }
                if ((orderStatus = this.rmsBiz.order(this.getLic().getDefFeature().getFeatureId(), this.getLic().getDefFeaSell().getBuyFlag(), this.getLic().getDefFeaSellProduct().getProductId(), carrierDName, this.m_phoneNumber.getString())) == -1) {
                    tempAlert = Utils.getAlertCfm(this.getRes().buy_connRefusedTitle, this.getRes().buy_connRefused);
                } else if (orderStatus == 3) {
                    tempAlert = Utils.getAlertCfm(this.getRes().buy_wapOrderTitle, this.getRes().buy_wapOrder);
                } else if (orderStatus == 4) {
                    tempAlert = Utils.getAlertCfm(this.getRes().buy_wapOrderErrorTitle, this.getRes().buy_wapOrderError);
                } else if (orderStatus == -2) {
                    tempAlert = Utils.getAlertCfm(this.getRes().buy_connFailedTitle, this.getRes().buy_connFailed);
                } else if (orderStatus == 1) {
                    tempAlert = Utils.getAlertCfm(this.getRes().buy_orderSuccessTitle, this.getRes().buy_orderSuccess);
                } else if (orderStatus == 2) {
                    tempAlert = Utils.getAlertCfm(this.getRes().buy_orderExistedTitle, this.getRes().buy_orderExisted);
                } else if (orderStatus == 0) {
                    tempAlert = Utils.getAlertCfm(this.getRes().buy_orderFailedTitle, this.getRes().buy_orderFailed);
                }
                tempAlert.setTimeout(-2);
                tempAlert.addCommand(this.m_exit);
                tempAlert.setCommandListener((CommandListener)this);
                this.mmidlet.display.setCurrent((Displayable)tempAlert);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

