/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import javax.microedition.lcdui.Graphics;
import mwnw.sg.Globals;
import mwnw.sg.Graphic;

class CutScene {
    public static final int CUTSCENE_SCROLL_DELAY = 270;
    public static final int CUTSCENE_SCROLL_PIXEL_JUMP = 14;
    public static final int SG_ANIM_DELAY_MS = 280;
    public static final int SG_TIME_ON_SCREEN_MS = 3000;
    public static final byte CUTSCENE_TYPE_NORMAL = 0;
    public static final byte CUTSCENE_TYPE_SG = 1;
    private byte type = 0;
    private Graphic curImage = null;
    private long textTimer = 0L;
    private short textX;
    private short textY;
    private String text;
    private boolean textOffScreen = false;
    private long imageTimer = 0L;
    private byte animFrame = 0;
    private long advanceTimer = 0L;
    private long ignoreTimer = 0L;
    private int stringwidth;

    public void OnKeyDown(int n) {
        if (this.ignoreTimer > Globals.GetTick()) {
            return;
        }
        this.ExitCutScene();
    }

    public void Update() {
        switch (this.type) {
            case 0: {
                this.UpdateText();
                break;
            }
            case 1: {
                this.UpdateFullScreenAnim();
                this.UpdateText();
            }
        }
        if (this.advanceTimer != 0L && this.advanceTimer < Globals.GetTick()) {
            this.ExitCutScene();
        }
    }

    public void Render(Graphics graphics) {
        if (this.stringwidth < 0 && this.text != null && this.text.length() > 0) {
            this.stringwidth = graphics.getFont().stringWidth(this.text);
        }
        graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
        if (this.curImage != null) {
            this.curImage.blitNoClip(graphics, Globals.screenCenterX - this.curImage.frameWidth / 2, (Globals.screenHeight - (Globals.screenHeight - this.textY)) / 2 - this.curImage.frameHeight / 2);
        }
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        graphics.setColor(255, 255, 255);
        graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
        if (this.text.equals("Stargate Activated...")) {
            graphics.drawString(this.text, (int)this.textX, this.textY - 5, 0);
        } else {
            graphics.drawString(this.text, (int)this.textX, (int)this.textY, 0);
        }
    }

    public boolean SetPic(int n) {
        if (this.curImage != null) {
            this.curImage.Kill();
        }
        this.curImage = null;
        System.gc();
        this.curImage = new Graphic();
        return !this.curImage.Load("/chars/" + n + ".png");
    }

    public boolean SetText(String string, int n) {
        this.textX = Globals.screenWidth;
        this.textY = (short)n;
        if (this.textY == 2) {
            this.textY = (short)(Globals.screenHeight - 16);
        }
        if (this.textY == 0) {
            this.textY = (short)(Globals.screenCenterY - 16);
        }
        this.text = string;
        this.textOffScreen = false;
        this.stringwidth = -1;
        this.SetTextTimer();
        return true;
    }

    public void UpdateText() {
        if (this.textTimer < Globals.GetTick()) {
            this.textX = (short)(this.textX - 14);
            this.SetTextTimer();
            if (this.textX + this.stringwidth + 100 < 0) {
                this.textOffScreen = true;
                this.ExitCutScene();
            }
        }
    }

    public void UpdateFullScreenAnim() {
        if (this.imageTimer < Globals.GetTick() || this.curImage == null) {
            this.imageTimer = Globals.GetTick() + 280L;
            this.SetPic(500 + this.animFrame);
            this.animFrame = (byte)((this.animFrame + 1) % 2);
        }
    }

    public void SetTextTimer() {
        this.textTimer = Globals.GetTick() + 270L;
    }

    public void IgnoreKeysForAwhile(int n) {
        this.ignoreTimer = Globals.GetTick() + (long)n;
    }

    public void SetType(byte by, String string) {
        this.type = by;
        this.textY = Globals.screenHeight;
        if (this.type == 1) {
            String string2 = string;
            if (string2 == null) {
                string2 = "Stargate Activated...";
            }
            this.SetText(string2, 2);
        }
    }

    public void KillAll() {
        this.curImage = null;
        this.text = null;
        this.SetType((byte)0, "");
        this.textY = 0;
        this.animFrame = 0;
        this.advanceTimer = 0L;
        System.gc();
    }

    private void SetAdvanceTimer(int n) {
        this.advanceTimer = Globals.GetTick() + (long)n;
    }

    private boolean ExitCutScene() {
        Globals.GetGameCanvas().SetState((byte)0);
        this.KillAll();
        boolean bl = Globals.logic.RunScript();
        if (!bl) {
            Globals.KillGame();
            Globals.app.ShowMenu(2, 0);
        }
        return bl;
    }
}

