/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import mwnw.sg.DrawOrderItem;
import mwnw.sg.GameCanvas;
import mwnw.sg.Globals;
import mwnw.sg.Graphic;
import mwnw.sg.Point;
import mwnw.sg.SoundPlayer;

class SGPlayer {
    public static final byte ANIM_MODE_IDLE = 0;
    public static final byte ANIM_MODE_WALK = 1;
    public static final byte ANIM_MODE_SHOOT = 2;
    public static final byte ANIM_MODE_DIE = 3;
    public static final byte CONTROL_NORMAL = 0;
    public static final byte CONTROL_FREEZE = 1;
    public static final byte CONTROL_FREEZE_AND_HIDE = 2;
    public static final byte STATUS_NORMAL = 0;
    public static final byte STATUS_FAILED = 1;
    public static final short NORMAL_ANIM_SPEED = 150;
    public static final short IDLE_ANIM_SPEED = 400;
    public static final short DEATH_ANIM_SPEED = 500;
    public static final byte MAX_HEALTH = 50;
    public static final short TIME_TO_RELOAD = 2000;
    public static final byte CIVILIAN_CASUALTIES_TO_LOSE = 10;
    public static final short MAP_SCROLL_PADDING = 0;
    public short reloadTimeMs = 0;
    public short bullets = (short)100;
    public short maxBullets = (short)250;
    public short startingBullets = (short)100;
    public byte bulletId = (byte)2;
    short x;
    short y;
    public int health;
    public int armor;
    byte activeWeapon = 0;
    public byte controlLevel = 0;
    DrawOrderItem di = new DrawOrderItem();
    public Graphic graphic = null;
    public short civilianDeaths = 0;
    public boolean[] keysPressed = new boolean[5];
    public byte curDir = 1;
    public byte lastLeftRight = 1;
    public byte animMode = 0;
    public byte status = 0;
    public int playerHealth = 100;
    public int playerArmor = 100;
    public boolean haveKeycard = false;
    private short animDelay = (short)150;
    long idleTimer = 0L;
    long dieTimer = 0L;
    long shotTimer = 0L;
    long reloadTimer = 0L;
    long animTimer = 0L;
    int finalScore = 0;
    int shotsFired = 0;
    int hits = 0;
    int kills = 0;
    int curFrame = 0;
    int curStartFrame = 0;
    int curFrameCount = 0;
    private static int PLAYER_MAX_HEALTH = 50;

    public SGPlayer() {
        this.di.type = 0;
    }

    public void Init() {
        this.graphic = new Graphic();
        this.graphic.Load("/chars/jack.png", 10, 1);
    }

    public void Kill() {
        if (this.graphic != null) {
            this.graphic.Kill();
        }
        this.graphic = null;
        System.gc();
    }

    public void ResetGame() {
        this.bullets = (short)100;
        this.startingBullets = (short)100;
        this.animDelay = (short)150;
        this.reloadTimer = 0L;
        this.finalScore = 0;
        this.shotsFired = 0;
        this.hits = 0;
        this.kills = 0;
        this.health = 50;
        this.status = 0;
        this.civilianDeaths = 0;
    }

    public void ResetKeys() {
        for (int i = 0; i < this.keysPressed.length; ++i) {
            this.keysPressed[i] = false;
        }
        this.CueNewFrame();
        this.animMode = 0;
    }

    public int GetAccuracy() {
        if (this.shotsFired == 0) {
            return 0;
        }
        return this.hits * 100 / this.shotsFired;
    }

    public void ReloadWeapon() {
        if (this.reloadTimer != 0L) {
            return;
        }
        Globals.GetGameCanvas().SetMessage("Reloading...", 2000);
        this.reloadTimer = Globals.GetTick() + 2000L;
    }

    public void FireWeapon() {
        if (this.shotTimer > Globals.GetTick()) {
            return;
        }
        if (this.bullets < 1) {
            this.ReloadWeapon();
            return;
        }
        if (Globals.curMap == null) {
            return;
        }
        this.shotTimer = Globals.GetTick() + (long)this.reloadTimeMs;
        ++this.shotsFired;
        this.bullets = (short)(this.bullets - 1);
        byte by = this.curDir;
        Point point = Globals.enemyMgr.GetXYOffsetToClosestEnemy(this.x, this.y, (short)16);
        if (point.x != 10000 && Globals.curMap.PositionIsOnScreen((short)(this.x + point.x), this.y, (byte)30)) {
            this.curDir = point.x > 0 ? (byte)1 : 0;
        } else {
            point = Globals.enemyMgr.GetXYOffsetToClosestEnemy(this.x, this.y, (short)80);
            if (point.x != 10000 && Globals.curMap.PositionIsOnScreen((short)(this.x + point.x), this.y, (byte)0)) {
                if (point.x > 0) {
                    this.curDir = 1;
                    if (point.y < 0) {
                        Globals.projectileMgr.Add((byte)4, (byte)0, this.bulletId, this.x, this.y, null);
                    } else {
                        Globals.projectileMgr.Add((byte)5, (byte)0, this.bulletId, this.x, this.y, null);
                    }
                    return;
                }
                this.curDir = 0;
                if (point.y < 0) {
                    Globals.projectileMgr.Add((byte)6, (byte)0, this.bulletId, this.x, this.y, null);
                } else {
                    Globals.projectileMgr.Add((byte)7, (byte)0, this.bulletId, this.x, this.y, null);
                }
                return;
            }
        }
        if (this.curDir == 2 || this.curDir == 3) {
            this.curDir = this.lastLeftRight;
        }
        Globals.projectileMgr.Add(this.curDir, (byte)0, this.bulletId, this.x, this.y, null);
        if (by != this.curDir) {
            this.CueNewFrame();
        }
    }

    public void UpdateAnimStopOnLastFrame() {
        if (this.animTimer < Globals.GetTick()) {
            if (this.curFrame + 1 == this.curStartFrame + this.curFrameCount) {
                return;
            }
            this.curFrame = (this.curFrame + 1 - this.curStartFrame) % this.curFrameCount + this.curStartFrame;
            this.animTimer = Globals.GetTick() + (long)this.animDelay;
        }
    }

    public void UpdateAnim() {
        if (this.animTimer < Globals.GetTick()) {
            this.curFrame = Math.abs((this.curFrame + 1 - this.curStartFrame) % this.curFrameCount) + this.curStartFrame;
            this.animTimer = Globals.GetTick() + (long)this.animDelay;
        }
    }

    public void Update() {
        if (Globals.curMap == null) {
            return;
        }
        if (this.reloadTimer != 0L && this.reloadTimer < Globals.GetTick()) {
            this.PickedUpAmmo();
            this.reloadTimer = 0L;
        }
        short s = this.x;
        short s2 = this.y;
        int n = 15;
        if (this.controlLevel == 0) {
            if (this.keysPressed[0]) {
                this.y = (short)(this.y - (short)(Globals.deltaMs / (long)n));
            }
            if (this.keysPressed[1]) {
                this.y = (short)(this.y + (short)(Globals.deltaMs / (long)n));
            }
            if (this.keysPressed[2]) {
                this.x = (short)(this.x - (short)(Globals.deltaMs / (long)n));
            }
            if (this.keysPressed[3]) {
                this.x = (short)(this.x + (short)(Globals.deltaMs / (long)n));
            }
        }
        if (Globals.curMap.mapId == 0 && this.x > 664 && (this.y <= 114 || this.y >= 123)) {
            this.y = (short)118;
        }
        if (!Globals.curMap.ValidPositionAccurate(this.x, this.y)) {
            this.x = s;
            this.y = s2;
        }
        Globals.curMap.ScrollFollowXY(this.x, (short)(this.y - 32), (short)0);
        this.di.y = this.y;
        Globals.drawSort.Add(this.di);
    }

    public void CueNewFrame() {
        this.animTimer = 1L;
    }

    public void Render(Graphics graphics) {
        if (Globals.curMap == null) {
            return;
        }
        if (this.controlLevel != 2) {
            if ((this.keysPressed[0] || this.keysPressed[1] || this.keysPressed[2] || this.keysPressed[3]) && this.animMode != 1) {
                this.CueNewFrame();
                this.animMode = 1;
            }
            switch (this.animMode) {
                case 0: {
                    this.animDelay = (short)400;
                    switch (this.curDir) {
                        case 0: {
                            this.curFrameCount = 1;
                            this.curStartFrame = 2;
                            break;
                        }
                        case 1: {
                            this.curFrameCount = 1;
                            this.curStartFrame = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (this.lastLeftRight == 0) {
                                this.curFrameCount = 1;
                                this.curStartFrame = 2;
                                break;
                            }
                            this.curFrameCount = 1;
                            this.curStartFrame = 0;
                        }
                    }
                    break;
                }
                case 1: {
                    this.animDelay = (short)150;
                    switch (this.curDir) {
                        case 0: {
                            this.curFrameCount = 2;
                            this.curStartFrame = 2;
                            break;
                        }
                        case 1: {
                            this.curFrameCount = 2;
                            this.curStartFrame = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (this.lastLeftRight == 0) {
                                this.curFrameCount = 2;
                                this.curStartFrame = 2;
                                break;
                            }
                            this.curFrameCount = 2;
                            this.curStartFrame = 0;
                        }
                    }
                    break;
                }
            }
            switch (this.animMode) {
                case 3: {
                    this.UpdateAnimStopOnLastFrame();
                    break;
                }
                default: {
                    this.UpdateAnim();
                }
            }
            Point point = Globals.curMap.WorldToScreen(this.x, this.y);
            this.graphic.blit(graphics, point.x, point.y, this.curFrame, 0, true);
        }
    }

    public void RenderOverlay(Graphics graphics) {
        graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
        graphics.setColor(200, 0, 0);
        graphics.fillRect(3, 3, this.health, 6);
        graphics.setColor(255, 0, 0);
        graphics.drawRect(3, 3, 50, 6);
        if (Globals.curMap.mapId == 4) {
            graphics.setColor(255, 255, 0);
        } else {
            graphics.setColor(255, 255, 255);
        }
        String string = "" + this.bullets;
        graphics.drawString(string, Globals.screenWidth - 23, 2, 0x10 | 4);
    }

    public void SetStatus(int n) {
        this.status = (byte)n;
    }

    public void ModifyDamage(int n) {
        if (this.controlLevel == 2) {
            return;
        }
        if (this.health <= 0) {
            return;
        }
        this.health += n;
        if (n < 0) {
            if (this.health < 1) {
                this.health = 0;
                this.ResetKeys();
                this.SetupDieAnim();
                SoundPlayer.playEffect(SoundPlayer.PDEAD);
                GameCanvas gameCanvas = Globals.GetGameCanvas();
                Globals.ClearCommands((Displayable)gameCanvas);
                Globals.SetCommands(9, (Displayable)gameCanvas, gameCanvas);
                gameCanvas.SetState((byte)9);
                this.dieTimer = Globals.GetTick() + 2600L;
                this.animDelay = (short)500;
                this.animTimer = Globals.GetTick() + 500L;
                return;
            }
            int n2 = Globals.RandInt(3);
            switch (n2) {
                case 0: {
                    Globals.GetGameCanvas().SetMessage("Ouch!", 0);
                    break;
                }
                case 1: {
                    Globals.GetGameCanvas().SetMessage("Ahhh!", 0);
                    break;
                }
                case 2: {
                    Globals.GetGameCanvas().SetMessage("Urgh!", 0);
                }
            }
            Globals.Vibrate(200);
        } else if (this.health > PLAYER_MAX_HEALTH) {
            this.health = PLAYER_MAX_HEALTH;
        }
    }

    public void AddHit() {
        ++this.hits;
    }

    public void AddKill() {
        ++this.kills;
    }

    public void SetXY(short s, short s2) {
        this.x = s;
        this.y = s2;
        this.Update();
    }

    public void SetX(short s) {
        this.x = s;
    }

    boolean CheckCollision(short s, short s2, short s3) {
        short s4 = (short)Math.abs(Globals.curMap.WorldToScreenX(s) - Globals.curMap.WorldToScreenX(this.x));
        short s5 = (short)Math.abs(s2 - this.y);
        return s4 < s3 && s5 < s3;
    }

    void SetupDieAnim() {
        this.animMode = (byte)3;
        this.curFrameCount = 3;
        switch (this.curDir) {
            case 0: 
            case 3: {
                this.curStartFrame = 7;
                break;
            }
            case 1: 
            case 2: {
                this.curStartFrame = 4;
                break;
            }
            default: {
                this.curStartFrame = 4;
            }
        }
        this.curFrame = this.curStartFrame;
        this.CueNewFrame();
    }

    public void PickedUpAmmo() {
        this.bullets = this.bullets + this.startingBullets > this.maxBullets ? this.maxBullets : (short)(this.bullets + this.startingBullets);
    }

    public void ResetIdleTimer() {
        this.idleTimer = Globals.GetTick();
    }

    public void ResetForNewLevel() {
        this.animMode = 0;
        this.haveKeycard = false;
        this.lastLeftRight = 1;
        this.curDir = 1;
        this.shotTimer = 0L;
        this.controlLevel = 0;
        this.ResetIdleTimer();
        this.ResetKeys();
    }

    public void GiveItem(byte by) {
    }

    public void KeyDown(int n) {
        this.idleTimer = Globals.GetTick();
        if (this.controlLevel != 0) {
            return;
        }
        if (Globals.gameState == 9) {
            if (this.dieTimer < Globals.GetTick()) {
                Globals.KillGame();
                Globals.GetGameCanvas().KillTimer();
                Globals.app.ShowMenu(20, Globals.missionId);
                SoundPlayer.playMidi(SoundPlayer.THEME);
            }
            return;
        }
        switch (n) {
            case 1: {
                this.keysPressed[0] = true;
                this.curDir = (byte)2;
                return;
            }
            case 6: {
                this.keysPressed[1] = true;
                this.curDir = (byte)3;
                return;
            }
            case 2: {
                this.keysPressed[2] = true;
                this.lastLeftRight = this.curDir = 0;
                return;
            }
            case 5: {
                this.keysPressed[3] = true;
                this.lastLeftRight = this.curDir = 1;
                return;
            }
            case 8: {
                this.keysPressed[4] = true;
                this.FireWeapon();
                return;
            }
        }
    }

    public void KeyUp(int n) {
        switch (n) {
            case 1: {
                this.keysPressed[0] = false;
                this.UpdateDirection();
                break;
            }
            case 6: {
                this.keysPressed[1] = false;
                this.UpdateDirection();
                break;
            }
            case 2: {
                this.keysPressed[2] = false;
                this.UpdateDirection();
                break;
            }
            case 5: {
                this.keysPressed[3] = false;
                this.UpdateDirection();
                break;
            }
            case 8: {
                this.keysPressed[4] = false;
            }
        }
    }

    public void UpdateDirection() {
        if (this.keysPressed[0]) {
            this.curDir = (byte)2;
        } else if (this.keysPressed[1]) {
            this.curDir = (byte)3;
        } else if (this.keysPressed[2]) {
            this.curDir = 0;
        } else if (this.keysPressed[3]) {
            this.curDir = 1;
        } else if (this.animMode != 0) {
            this.CueNewFrame();
            this.animMode = 0;
        }
    }
}

