/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import mwnw.sg.DrawSorter;
import mwnw.sg.EnemyMgr;
import mwnw.sg.Globals;
import mwnw.sg.Logic;
import mwnw.sg.Point;
import mwnw.sg.ProjectileMgr;
import mwnw.sg.SGPlayer;
import mwnw.sg.SoundPlayer;

class GameCanvas
extends Canvas
implements CommandListener {
    Logic gameLogic = null;
    String message = null;
    String statusMessage = null;
    long msgTimer = 0L;
    long statusMsgTimer = 0L;
    GameTimer gameTimer = null;
    Timer timer = null;
    public boolean[] keysPressed = new boolean[5];
    byte lastState = 0;
    boolean loading = false;
    public int amtToLoad = 1;
    public int amtLoaded = 0;
    Timer loadingTimer = null;
    public boolean pickOneTime = false;

    public GameCanvas() {
        Globals.screenWidth = (short)this.getWidth();
        Globals.screenHeight = (short)this.getHeight();
        Globals.screenCenterX = (short)(Globals.screenWidth / 2);
        Globals.screenCenterY = (short)(Globals.screenHeight / 2);
        this.gameLogic = new Logic();
        Globals.drawSort = new DrawSorter();
        Globals.logic = new Logic();
        Globals.enemyMgr = new EnemyMgr();
        Globals.thePlayer = new SGPlayer();
        Globals.thePlayer.Init();
        Globals.projectileMgr = new ProjectileMgr();
        Globals.projectileMgr.Init();
    }

    public void Destroy() {
        this.gameLogic = null;
        Globals.drawSort = null;
        Globals.logic = null;
        Globals.enemyMgr = null;
        Globals.thePlayer = null;
        Globals.projectileMgr = null;
        System.gc();
    }

    public void pause() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.gameTimer = null;
            Globals.PauseTimer(true);
            this.lastState = Globals.gameState;
            Globals.ClearCommands((Displayable)this);
        }
    }

    public void resume() {
        if (this.lastState == 0 || this.lastState == 8 || this.lastState == 9) {
            Globals.gameState = this.lastState;
        }
        Globals.PauseTimer(false);
        Globals.ClearCommands((Displayable)this);
        Globals.SetCommands(Globals.gameState, (Displayable)this, this);
        this.gameTimer = new GameTimer();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.gameTimer, 0L, 50L);
        Globals.paused = false;
        if (Globals.gameState == 0) {
            Globals.thePlayer.KeyUp(1);
            Globals.thePlayer.KeyUp(2);
            Globals.thePlayer.KeyUp(5);
            Globals.thePlayer.KeyUp(8);
            Globals.thePlayer.KeyUp(6);
        }
    }

    public void SetState(byte by) {
        this.lastState = Globals.gameState;
        Globals.gameState = by;
    }

    public boolean InitGame() {
        Globals.runScriptASAP = false;
        this.msgTimer = 0L;
        this.statusMsgTimer = 0L;
        Globals.thePlayer.ResetForNewLevel();
        Globals.thePlayer.SetXY(Globals.curMap.startX, Globals.curMap.startY);
        if (!Globals.enemyMgr.Init()) {
            this.KillGame();
            return false;
        }
        Globals.ClearCommands((Displayable)this);
        this.SetState((byte)0);
        Globals.SetCommands(0, (Displayable)this, this);
        return true;
    }

    public void KillGame() {
        this.timer.cancel();
        this.timer = null;
        this.gameTimer = null;
    }

    public void KillTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.gameTimer = null;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Globals.cmdPause) {
            this.pause();
            Globals.app.ShowMenu(22, 0);
            return;
        }
        if (command == Globals.cmdOK && Globals.gameState == 9) {
            Globals.KillGame();
            this.KillTimer();
            Globals.app.ShowMenu(20, 0);
            SoundPlayer.playMidi(SoundPlayer.THEME);
        }
        if (command == Globals.cmdBack && Globals.gameState == 9) {
            Globals.KillGame();
            this.KillTimer();
            Globals.app.ShowMenu(21, 0);
        }
    }

    protected void keyPressed(int n) {
        if (!(Globals.gameState != 0 && Globals.gameState != 9 || Globals.logic == null || Globals.logic.scriptRunning)) {
            if (!Globals.isLoading) {
                switch (this.getGameAction(n)) {
                    case 1: {
                        Globals.thePlayer.KeyDown(1);
                        return;
                    }
                    case 6: {
                        Globals.thePlayer.KeyDown(6);
                        return;
                    }
                    case 2: {
                        Globals.thePlayer.KeyDown(2);
                        return;
                    }
                    case 5: {
                        Globals.thePlayer.KeyDown(5);
                        return;
                    }
                    case 8: {
                        Globals.thePlayer.KeyDown(8);
                        return;
                    }
                }
                switch (n) {
                    case 50: {
                        Globals.thePlayer.KeyDown(1);
                        break;
                    }
                    case 56: {
                        Globals.thePlayer.KeyDown(6);
                        break;
                    }
                    case 52: {
                        Globals.thePlayer.KeyDown(2);
                        break;
                    }
                    case 54: {
                        Globals.thePlayer.KeyDown(5);
                        break;
                    }
                    case 53: {
                        Globals.thePlayer.KeyDown(8);
                    }
                }
            }
        } else if (Globals.gameState == 8 && n != -21 && n != -22 && n != 22 && n != 21) {
            Globals.cutScene.OnKeyDown(n);
        }
    }

    protected void keyReleased(int n) {
        if (Globals.gameState == 0) {
            switch (this.getGameAction(n)) {
                case 1: {
                    Globals.thePlayer.KeyUp(1);
                    break;
                }
                case 6: {
                    Globals.thePlayer.KeyUp(6);
                    break;
                }
                case 2: {
                    Globals.thePlayer.KeyUp(2);
                    break;
                }
                case 5: {
                    Globals.thePlayer.KeyUp(5);
                    break;
                }
                case 8: {
                    Globals.thePlayer.KeyUp(8);
                }
            }
            switch (n) {
                case 50: {
                    Globals.thePlayer.KeyUp(1);
                    break;
                }
                case 56: {
                    Globals.thePlayer.KeyUp(6);
                    break;
                }
                case 52: {
                    Globals.thePlayer.KeyUp(2);
                    break;
                }
                case 54: {
                    Globals.thePlayer.KeyUp(5);
                    break;
                }
                case 53: {
                    Globals.thePlayer.KeyUp(8);
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        if (this.loading) {
            graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
            graphics.setColor(255, 0, 0);
            String string = "Loading...";
            graphics.drawString(string, (int)Globals.screenCenterX, (int)Globals.screenCenterY, 1 | 0x10);
            this.pickOneTime = true;
            Globals.isLoading = true;
            return;
        }
        if (this.pickOneTime) {
            Globals.thePlayer.KeyUp(1);
            Globals.thePlayer.KeyUp(2);
            Globals.thePlayer.KeyUp(5);
            Globals.thePlayer.KeyUp(8);
            Globals.thePlayer.KeyUp(6);
            this.pickOneTime = false;
        }
        Globals.isLoading = false;
        if (Globals.gameState == 0) {
            if (!Globals.logic.scriptRunning) {
                Globals.drawSort.Reset();
                Globals.logic.Update();
                if (Globals.curMap != null) {
                    Globals.enemyMgr.Update();
                    Globals.projectileMgr.Update();
                    Globals.thePlayer.Update();
                    Globals.curMap.DrawMap(graphics);
                    Globals.drawSort.RenderList(graphics);
                    Globals.thePlayer.RenderOverlay(graphics);
                }
                this.RenderMessages(graphics);
                if (Globals.runScriptASAP) {
                    Globals.runScriptASAP = false;
                    if (!Globals.logic.RunScript()) {
                        Globals.KillGame();
                        this.KillTimer();
                        Globals.app.ShowMenu(2, 0);
                        return;
                    }
                }
            }
        } else if (Globals.gameState == 9) {
            if (!Globals.logic.scriptRunning) {
                graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
                if (Globals.thePlayer.dieTimer < Globals.GetTick()) {
                    String string;
                    graphics.setColor(0, 0, 0);
                    graphics.fillRect(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
                    graphics.setColor(255, 255, 255);
                    if (Globals.thePlayer.health > 0) {
                        string = "Mission " + (Globals.resources.downloadId * 2 + (Globals.missionId + 1));
                        graphics.drawString(string, (int)Globals.screenCenterX, 40, 1 | 0x40);
                        string = Globals.thePlayer.status == 1 ? "Failed!!!" : "COMPLETED";
                        graphics.drawString(string, (int)Globals.screenCenterX, 58, 1 | 0x40);
                    } else {
                        if (Globals.thePlayer.y > 170) {
                            Globals.thePlayer.SetXY(Globals.thePlayer.x, (short)170);
                        }
                        Globals.thePlayer.Render(graphics);
                        graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
                        string = "GAME OVER";
                        graphics.drawString(string, (int)Globals.screenCenterX, 30, 1 | 0x40);
                    }
                    string = "SCORE: " + Globals.thePlayer.finalScore;
                    graphics.drawString(string, (int)Globals.screenCenterX, Globals.screenHeight - 20, 1 | 0x10);
                } else {
                    Globals.thePlayer.Update();
                    graphics.setColor(0, 0, 0);
                    graphics.fillRect(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
                    Globals.thePlayer.Render(graphics);
                }
            }
        } else if (Globals.gameState == 8 && !Globals.logic.scriptRunning) {
            Globals.cutScene.Update();
            if (Globals.gameState == 8) {
                Globals.cutScene.Render(graphics);
            }
        }
    }

    public void DrawStatusMessage(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 23, (int)Globals.screenWidth, 16);
        graphics.setColor(255, 255, 255);
        graphics.drawString(Globals.statusMessage, (int)Globals.screenCenterX, 23, 1 | 0x10);
    }

    public void StartLoad(int n) {
        this.loading = true;
        this.amtToLoad = n;
        this.amtLoaded = 0;
        this.repaint();
        this.serviceRepaints();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void UpdateLoad(int n) {
        this.amtLoaded += n;
        this.repaint();
        this.serviceRepaints();
    }

    public void EndLoad() {
        if (this.loadingTimer != null) {
            this.loadingTimer.cancel();
            this.loadingTimer = null;
        }
        this.loading = false;
        SoundPlayer.stopPlayer();
    }

    public void RenderMessages(Graphics graphics) {
        graphics.setClip(0, 0, (int)Globals.screenWidth, (int)Globals.screenHeight);
        graphics.setColor(255, 255, 255);
        if (this.msgTimer > Globals.GetTick()) {
            short s = (short)(Globals.thePlayer.x - 20);
            short s2 = (short)(Globals.thePlayer.y - 50);
            int n = graphics.getFont().stringWidth(this.message);
            Point point = Globals.curMap.WorldToScreen(s, s2);
            if (point.x < 0) {
                point.x = 0;
            }
            if (point.x + n > Globals.screenWidth) {
                point.x = (short)(Globals.screenWidth - n);
            }
            graphics.drawString(this.message, (int)point.x, (int)point.y, 0);
        } else {
            this.msgTimer = 0L;
        }
        if (this.statusMsgTimer > Globals.GetTick()) {
            graphics.drawString(this.statusMessage, 1, 18, 0);
        } else {
            this.statusMsgTimer = 0L;
        }
    }

    public boolean LoadMission(byte by) {
        this.StartLoad(0);
        Globals.UpdateTime();
        Globals.thePlayer.ResetGame();
        boolean bl = Globals.logic.InitNewGame(by);
        this.EndLoad();
        return bl;
    }

    public void SetMessage(String string, int n) {
        this.message = string;
        this.msgTimer = n == 0 ? Globals.GetTick() + 2000L : Globals.GetTick() + (long)n;
    }

    public void SetStatusMessage(String string, int n) {
        this.statusMessage = string;
        this.statusMsgTimer = n == 0 ? Globals.GetTick() + 2000L : Globals.GetTick() + (long)n;
    }

    class GameTimer
    extends TimerTask {
        GameTimer() {
        }

        public final void run() {
            Globals.UpdateTime();
            GameCanvas.this.repaint();
        }
    }
}

