/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Map {
    GameClass game;
    SorrowMIDlet theApp;
    AI ai;
    int maxMetaBlocks = 0;
    int maxHitBlocks = 0;
    boolean Map_GraphicsLoaded;
    static final byte STAGE9_MASK = 64;
    static final byte[] outsideAreas = new byte[]{0, 2, 3, 9, 12, 64, 65, 82, 87};
    int backBlockImage;
    static final int BLOCKS_ACROSS_IMAGE = 8;
    static final int BLOCKS_ACROSS_IMAGE_MASK = 7;
    static final int BLOCKS_ACROSS_IMAGE_SHIFT = 3;
    static final int BLOCKS_DOWN_IMAGE = 1;
    static final int BLOCKS_DOWN_IMAGE_MASK = 0;
    static final int MAX_BLOCK_TEXTURE_PAGES = 64;
    static final byte SCROLLED_NOWHERE = 0;
    static final byte SCROLLED_LEFT = 1;
    static final byte SCROLLED_RIGHT = 2;
    static final byte SCROLLED_UP = 4;
    static final byte SCROLLED_DOWN = 8;
    int mapScrolled;
    static final int PIXELS_ACROSS_METABLOCK = 32;
    static final int MAX_CHARFILE_SIZE = 32768;
    static final int MAX_MODFILE_SIZE = 12288;
    static final int MAX_SRNFILE_SIZE = 56000;
    static final int MAX_PALETTEFILE_SIZE = 12288;
    static final int MAX_HITFILE_SIZE = 8192;
    static final int PIXELS_ACROSS_METABLOCK_IMAGE = 256;
    static final int ROL_KIND_NOP = 0;
    static final int ROL_KIND_NORMAL = 1;
    static final int ROL_KIND_HALF_LR = 2;
    static final int ROL_KIND_OPTION_LR = 3;
    static final int ROL_KIND_OPTION_UD = 4;
    static final int ROL_KIND_OPTION_LRUD = 5;
    static final int ROL_KIND_RASTER_00 = 6;
    static final int ROL_KIND_RASTER_01 = 7;
    static final int ROL_KIND_RASTER_02 = 8;
    static final int ROL_KIND_SPECIAL_040A = 9;
    static final int ROL_KIND_SPECIAL_040B = 10;
    static final int ROL_KIND_SPECIAL_0504 = 11;
    static final int ROL_KIND_SPECIAL_0507 = 12;
    static final int ROL_KIND_SPECIAL_0616 = 13;
    static final int ROL_KIND_SPECIAL_0701 = 14;
    static final int ROL_KIND_SPECIAL_0704 = 15;
    static final int ROL_KIND_SPECIAL_0708 = 16;
    static final int ROL_KIND_SPECIAL_0721 = 17;
    static final int ROL_KIND_SPECIAL_0725 = 18;
    static final int ROL_KIND_SPECIAL_0900 = 19;
    static final int ROL_KIND_SPECIAL_0904 = 20;
    static final int ROL_KIND_SPECIAL_0907 = 21;
    static final int ROL_KIND_SPECIAL_0a05 = 22;
    static final int ROL_KIND_SPECIAL_0B00 = 23;
    static final int ROL_KIND_SPECIAL_0B0B = 24;
    static final int ROL_NOT_DEFINED = 28;
    short stagesRemoved;
    byte[] pickupItems;
    static final int DRACULA_AREA = 4;
    static final int DRACULA_STAGE = 9;
    int numAreasInGame;
    int originalMapIndex = 0;
    int originalMapStage = 0;
    int[] areasVisited;
    int[] exitList;
    int numExits;
    static final int MAX_EXITS = 8;
    static final int LEFT_EXIT = -1;
    static final int RIGHT_EXIT = 1;
    static final boolean BUILD_ORIGINAL_MAP = false;
    static final byte[] numAreasInStage = new byte[]{45, 17, 22, 29, 22, 15, 35, 56, 23, 26, 11};
    static final int SRN_HEADER_AREA_AND_STAGE = 0;
    static final int SRN_HEADER_FILE_POSITION = 1;
    static final int MAX_AREAS_PER_STAGE = 56;
    int[] srnHeader = new int[114];
    int srnStage = -1;
    byte percenthi;
    byte percentlo;
    static final int REMAP_BLOCKSET_MASK = 63;
    static final int REMAP_BLOCKSET_SHIFT = 10;
    static final int REMAP_STAGE_MASK = 15;
    static final int REMAP_STAGE_SHIFT = 6;
    static final int REMAP_AREA_MASK = 63;
    static final int REMAP_AREA_SHIFT = 0;
    static final short[] remaps = new short[]{0, 16385, 2, 3, 16388, 5, 3, 16388, 21, 9, 3, 41, 12, 13, 16398, 15, 16, 17, 18, 19, 20, 21, 18, 25, 18, 25, 18, 16388, 16388, 16388, 16388, 16398, 16388, 33, 16388, 35, 16398, 18, 38, 40, 40, 41, 16, 5, 44, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1090, 1099, 16385, 16388, 16398, 1103, 1090, 2176, 2177, 2178, 2179, 2183, 2176, 2182, 2183, 2193, 2185, 2186, 2187, 16398, 16388, 2190, 2195, 2192, 2193, 2194, 2195, 2196, 2197, 3264, 3265, 3266, 3265, 3268, 3269, 3270, 3271, 3272, 3273, 3274, 3283, 3276, 3277, 3278, 3279, 3280, 16385, 3278, 3283, 3284, 16398, 16398, 16388, 3288, 3289, 3283, 3291, 3292, 4352, 4353, 4354, 4355, 4356, 4357, 4358, 4359, 4360, 4359, 4362, 4363, 4365, 4365, 4366, 16388, 4368, 4369, 4370, 4371, 16398, 16385, 5440, 5441, 5442, 5443, 5444, 5445, 16388, 16388, 5448, 5448, 5448, 16398, 16398, 5448, 16388, 6528, 6529, 6532, 6529, 6532, 6533, 6534, 6535, 6536, 6537, 6532, 6528, 6540, 6533, 6534, 16398, 16385, 6529, 6546, 6547, 6548, 6534, 6550, 6532, 6534, 6553, 6554, 6529, 6554, 6554, 6554, 16398, 6560, 6554, 16388, 7616, 7617, 7618, 7619, 7620, 7621, 7625, 7623, 7631, 7625, 7626, 7627, 7628, 7636, 7630, 7631, 7632, 7633, 7634, 7635, 7636, 7637, 7638, 7639, 7640, 7641, 7660, 7623, 7644, 7645, 7646, 7647, 7647, 7649, 7632, 7651, 7652, 7653, 16388, 16398, 16385, 16398, 7658, 7659, 7660, 7661, 7623, 7636, 16398, 7665, 7666, 7667, 7652, 7651, 7632, 7632, 8704, 8705, 8706, 8707, 8708, 8709, 8711, 8711, 8712, 8713, 8713, 8713, 8716, 8717, 8718, 8719, 8719, 8719, 8719, 8723, 8724, 16398, 16385, 9792, 9793, 9794, 9795, 9796, 9797, 9798, 9799, 9800, 9801, 9806, 9803, 9804, 9805, 9806, 9807, 9808, 9808, 9810, 9811, 9812, 9812, 16398, 9815, 16388, 16385};
    short[] warpRooms = new short[]{1, 57, 101, 134, 166, 225, 263, 289};
    int numWarpRoomsVisited;
    int warpRoomIndex;
    short[] saveRooms = new short[]{14, 31, 36, 59, 74, 105, 106, 133, 146, 147, 165, 181, 224, 226, 233, 262, 233, 262, 286, 303, 320, 332};
    int Map_FloorInCentre;
    static final int MAX_AREAS = 290;
    static final int MAX_STAGES = 10;
    static final int ORIGINAL_MAP_SIZE = 0;
    static final int ORIGINAL_MAP_WIDTH_SHIFT = 4;
    static final int ORIGINAL_MAP_WIDTH_MASK = 15;
    static final int ORIGINAL_MAP_HEIGHT_SHIFT = 0;
    static final int ORIGINAL_MAP_HEIGHT_MASK = 15;
    static final int ORIGINAL_MAP_X = 1;
    static final int ORIGINAL_MAP_Y = 2;
    static final int ORIGINAL_MAP_AREA = 3;
    static final int ORIGINAL_MAP_STAGE = 4;
    static final int ORIGINAL_MAP_STAGE_SHIFT = 0;
    static final int ORIGINAL_MAP_STAGE_MASK = 15;
    static final int ORIGINAL_MAP_NUMEXITS = 4;
    static final int ORIGINAL_MAP_NUMEXITS_SHIFT = 4;
    static final int ORIGINAL_MAP_NUMEXITS_MASK = 15;
    static final int ORIGINAL_MAP_EXITS = 5;
    static final int ORIGINAL_MAP_EXIT_X = 0;
    static final int ORIGINAL_MAP_EXIT_X_SHIFT = 4;
    static final int ORIGINAL_MAP_EXIT_X_MASK = 15;
    static final int ORIGINAL_MAP_EXIT_Y = 0;
    static final int ORIGINAL_MAP_EXIT_Y_SHIFT = 0;
    static final int ORIGINAL_MAP_EXIT_Y_MASK = 15;
    static final int ORIGINAL_MAP_EXIT_STAGE = 1;
    static final int ORIGINAL_MAP_EXIT_AREA = 2;
    static final int ORIGINAL_MAP_EXIT_OFFSETX = 3;
    static final int ORIGINAL_MAP_EXIT_OFFSETY = 4;
    static final int ORIGINAL_MAP_EXIT_OFFSET_SHIFT = 1;
    static final int ORIGINAL_MAP_EXIT_NEWX = 5;
    static final int ORIGINAL_MAP_EXIT_NEWX_SHIFT = 5;
    static final int ORIGINAL_MAP_EXIT_NEWY = 6;
    static final int ORIGINAL_MAP_EXIT_LENGTH = 7;
    static final int MAP_NORMAL_ROOM_COLOUR = 255;
    static final int MAP_WARP_ROOM_COLOUR = 0xFFFF00;
    static final int MAP_SAVE_ROOM_COLOUR = 0xFF0000;
    static final int MAP_UNVISITED_COLOUR = 0x7F7F7F;
    static final int MAP_CURRENT_ROOM_COLOUR = 65280;
    static final int MAP_ROOM_OUTLINE_COLOUR = 0xFFFFFF;
    static final int MAP_EXIT_COLOUR = 0;
    byte[][] originalMap;
    int originalMapLength;
    static final int DRAW_MAP_MULTIPLIER = 7;
    static final int DRAW_MAP_X = 0;
    static final int DRAW_MAP_Y = 1;
    static final int DRAW_MAP_VAR_SIZE = 2;
    static final String SRN_FILE_EXTENSION = "_v1.srn";
    static final short END_OF_LINK_DATA = 127;
    static final short LINK_STAGE = 0;
    static final short LINK_AREA = 1;
    static final short LINK_CHECKX = 2;
    static final short LINK_CHECKY = 3;
    static final short LINK_OFFSETX = 4;
    static final short LINK_OFFSETY = 5;
    static final short LINK_NEWX = 6;
    static final short LINK_NEWY = 7;
    static final short LENGTH_OF_LINK_DATA = 8;
    short[] hitMetaBlocks;
    int gbaVirtualScreenSize;
    int shakeTimer;
    static final int SHAKE_AMOUNT = 500;
    int pixelVirtualWidth;
    int blockVirtualWidth;
    int charVirtualWidth;
    int blockImageWidth;
    static final int MAX_METABLOCKS = 170;
    static final int NUM_LAYERS = 3;
    static final int NUM_LAYERS_TO_DRAW = 1;
    int[] layerWidth = new int[3];
    int[] layerGBAWidth = new int[3];
    int[] layerHeight = new int[3];
    int[] layerGBAHeight = new int[3];
    int[] layerSize = new int[3];
    int[] layerBlockRight = new int[3];
    int[] layerBlockBottom = new int[3];
    int[] layerScroll = new int[3];
    short[][] layers = new short[3][];
    int[] layerX = new int[3];
    int[] layerY = new int[3];
    int numberOfLayers;
    static final int CHARS_ACROSS_METABLOCK = 4;
    static final int PIXELS_ACROSS_CHAR = 8;
    static final int PIXELS_PER_CHAR = 64;
    static final int METABLOCK_PIXEL_SIZE = 1024;
    static final int PIXELS_DOWN_METABLOCK_IMAGE = 32;
    static final int METABLOCKS_PER_SCREEN = 8;
    int layer0GBAWidth;
    int layer0GBAHeight;
    int layer0VirtualWidth;
    int layer0VirtualHeight;
    int layer0CharWidth;
    int layer0CharHeight;
    int screenBlockT = 0;
    int screenBlockW;
    int screenBlockH;
    int screenBlockB;
    int mapPixelWidthVisible;
    int mapPixelHeightVisible;
    int mapPixelXOffset;
    int mapPixelYOffset;
    int mapVirtualWidthVisible;
    int mapVirtualHeightVisible;
    Image backBuffer;
    Graphics backBufferGraphics;
    byte[] hitArray;
    int screenVirtualWidth;
    int screenVirtualHeight;
    int mapX;
    int mapY;
    int lastMapX;
    int lastMapY;
    int mapTargetX;
    int mapTargetY;
    boolean mapSnap;
    static final int MAP_SMOOTH = 1;
    int mapMaxX;
    int mapMaxY;
    int mapMinY;
    int bottomOfMap;
    static final byte COLLISION_NONE = 0;
    static final byte COLLISION_FOOT = 1;
    static final byte COLLISION_HEAD = 2;
    static final byte COLLISION_HEAD_OR_FOOT = 3;
    static final byte COLLISION_V_FLIP = 2;
    static final byte COLLISION_H_FLIP = 4;
    static final byte COLLISION_DAMAGE = 4;
    static final byte COLLISION_WATER = 8;
    static final byte COLLISION_WATERFALL = 16;
    static final byte COLLISION_45SLOPE = 64;
    static final byte COLLISION_ODDSLOPE = -128;
    static final byte HEAD_CHAR = 0;
    static final byte FOOT_CHAR = 1;
    static final byte SLOPE_CHAR = 3;
    static final byte SLOPE_WATER_CHAR = 4;
    static final byte H_FLIP_CHAR = 5;
    static final byte V_FLIP_CHAR = 10;
    static final int NUM_COLLISION_IMAGES = 5;
    int[] blockSprites = new int[64];
    int numberOfMetaBlocks;
    boolean metaBlocksLoaded;
    boolean onlyOneLayer;
    boolean insideArea;
    int mapScroll = 0;
    int minMapScroll = 0;
    int maxMapScroll = 0;
    static final int MAP_SCROLL_WIDTH = 48;
    static final int[] pngTransparentArray = new int[]{0};
    static final int PALETTE_DATA_OFFSET = 0;
    static final int PALETTE_NUMBER_OFFSET = 2;
    static final int PALETTE_HEADER_SIZE = 4;
    static final int B3_CHAR_FLIP_SHIFT = 4;
    static final int B2_CHAR_FLIP_SHIFT = 6;
    static final int METABLOCK_FLIP_SHIFT = 14;
    static final int FLIP_V = 1;
    static final int FLIP_H = 2;
    static final int SRNM_STAGE = 0;
    static final int SRNM_AREA = 1;
    static final int SRNM_LAYER_X_SIZE = 2;
    static final int SRNM_LAYER_X_SCROLL = 3;
    static final int SRNM_LAYER_Y_SIZE = 4;
    static final int SRNM_LAYER_Y_SCROLL = 5;
    static final int SRNM_LAYER_Z_SIZE = 6;
    static final int SRNM_LAYER_Z_SCROLL = 7;
    static final int SRNM_HEADER_SIZE = 8;
    static final int SRNM_HEIGHT_SHIFT = 0;
    static final int SRNM_WIDTH_SHIFT = 3;
    static final int SRNM_ALPHA_SHIFT = 7;
    static final int SRNM_HEIGHT_MASK = 7;
    static final int SRNM_WIDTH_MASK = 15;
    static final int SRNM_ALPHA_MASK = 1;
    static final int SRNM_PRIORITY_SHIFT = 5;
    static final int SRNM_PRIORITY_MASK = 7;
    static final int SRNM_SCROLL_SHIFT = 0;
    static final int SRNM_SCROLL_MASK = 31;
    boolean clearBelowFloor = false;

    Map() {
    }

    void Map_initClass(GameClass g) {
        this.game = g;
        this.theApp = GameClass.theApp;
        this.ai = GameClass.ai;
    }

    boolean Map_OpenArea() {
        int i;
        int rooms = 0;
        this.mapSnap = true;
        this.mapX = 0;
        this.mapY = 0;
        this.mapTargetX = 0;
        this.mapTargetY = 0;
        this.Map_LoadArea();
        this.Map_AddAreaVisited(GameClass.stageNumber, GameClass.areaNumber);
        this.numWarpRoomsVisited = 1;
        for (i = 1; i < this.warpRooms.length; ++i) {
            if (!this.Map_IsAreaVisited(this.warpRooms[i])) continue;
            ++this.numWarpRoomsVisited;
        }
        this.Map_RemoveExits(2, 13, 2);
        this.Map_SetupExits();
        for (i = 0; i < 290; ++i) {
            int mask = 1 << (i & 0x1F);
            if ((this.areasVisited[i >> 5] & mask) == 0) continue;
            ++rooms;
        }
        rooms = this.theApp.limit(rooms * 1000 / this.numAreasInGame, 0, 1000);
        this.percenthi = (byte)(rooms / 10);
        this.percentlo = (byte)(rooms % 10);
        this.theApp.garbageCollect();
        this.game.drawFullScreen = true;
        return true;
    }

    boolean Map_OpenGame() {
        this.screenBlockH = 8;
        this.screenBlockW = 8;
        this.areasVisited = new int[10];
        this.pickupItems = new byte[290];
        this.exitList = new int[32];
        this.blockVirtualWidth = this.game.convertCoordToVirtual(256);
        this.blockVirtualWidth = this.theApp.divideWithRemainder(this.blockVirtualWidth, 8);
        this.game.hudYVirtual = this.blockVirtualWidth * this.screenBlockH - this.blockVirtualWidth * 3 / 2;
        this.game.hudY = this.game.convertYToBuild(this.game.hudYVirtual);
        this.Map_AddAreaVisited(0, 0);
        this.stagesRemoved = (short)1400;
        this.originalMap = new byte[10][];
        this.numAreasInGame = 0;
        for (int i = 0; i < numAreasInStage.length; ++i) {
            if ((this.stagesRemoved & 1 << i) != 0) continue;
            this.numAreasInGame += numAreasInStage[i];
            if (i == 5) {
                this.numAreasInGame -= 3;
            }
            GameClass.theApp.addResourceDirectory("");
            String filename = "o" + i + ".bin";
            this.originalMap[i] = new byte[this.theApp.fileLoad("om", filename, null, true, 0, 0)];
            this.theApp.fileLoad("om", filename.toString(), this.originalMap[i], false, 0, 0);
        }
        --this.numAreasInGame;
        this.Map_RemoveStage(10);
        this.Map_RemoveStage(8);
        this.Map_RemoveStage(6);
        this.Map_RemoveStage(5);
        this.Map_RemoveStage(4);
        this.Map_RemoveStage(3);
        this.backBuffer = Image.createImage((int)(this.screenBlockW * 32), (int)(this.screenBlockH * 32));
        this.backBufferGraphics = this.backBuffer.getGraphics();
        this.backBufferGraphics.setColor(0);
        this.backBufferGraphics.fillRect(0, 0, 300, 300);
        return true;
    }

    boolean Map_Close() {
        this.originalMap = null;
        this.backBufferGraphics = null;
        this.backBuffer = null;
        this.theApp.garbageCollect();
        return true;
    }

    void Map_setMapCoords(int x, int y) {
        if (this.layerScroll[0] == 0) {
            this.mapTargetX = this.theApp.limit(x, 0, this.mapMaxX);
            this.mapTargetY = 0;
        } else {
            this.mapTargetX = this.theApp.limit(x, 0, this.mapMaxX);
            this.mapTargetY = this.theApp.limit(y, this.mapMinY, this.mapMaxY);
        }
        if (this.mapSnap) {
            this.game.drawFullScreen = true;
            this.mapX = this.mapTargetX;
            this.mapY = this.mapTargetY;
            this.mapSnap = false;
        }
    }

    int Map_GetBlockIndex(int x, int y, int width, int height) {
        return this.theApp.limit(y / this.blockVirtualWidth, 0, height - 1) * width + this.theApp.limit(x / this.blockVirtualWidth, 0, width - 1);
    }

    int Map_GetFloor(int x, int y, boolean water) {
        boolean gotblank = false;
        int test = 1;
        int maxy = this.layerHeight[0] * 32 - 8;
        x = this.game.convertCoordToBuild(x);
        y = this.game.convertCoordToBuild(y);
        y /= 8;
        y *= 8;
        if (water) {
            test += 8;
        }
        byte col = this.Map_GetCollision(x, y);
        while ((col & test) == 0) {
            gotblank = true;
            if ((y += 8) < -32) {
                y = -32;
            }
            if (y > maxy) {
                if (GameClass.remapStageNumber == 6) {
                    if (GameClass.remapAreaNumber == 26) {
                        if (GameClass.areaNumber != 29) {
                            return this.layer0VirtualHeight - this.blockVirtualWidth - (this.charVirtualWidth << 1);
                        }
                    }
                }
                return Integer.MAX_VALUE;
            }
            col = this.Map_GetCollision(x, y);
        }
        if (!gotblank) {
            while ((this.Map_GetCollision(x, y) & test) != 0) {
                if ((y -= 8) >= 0) continue;
                return Integer.MAX_VALUE;
            }
            y += 8;
        }
        if (((col = this.Map_GetCollision(x, y)) & 0xFFFFFFC0) != 0) {
            return this.Map_GetSlopeHeight(x, y, col);
        }
        y /= 8;
        return this.game.convertCoordToVirtual(y *= 8);
    }

    int Map_GetCeiling(int x, int y) {
        if (y > this.layer0VirtualHeight) {
            return 0;
        }
        x = this.game.convertCoordToBuild(x);
        y = this.game.convertCoordToBuild(y);
        while ((this.Map_GetCollision(x, y) & 2) == 0) {
            if ((y -= 8) >= 0) continue;
            return -40000;
        }
        byte col = this.Map_GetCollision(x, y);
        if ((col & 0x40) != 0) {
            return this.Map_GetSlopeHeight(x, y, col);
        }
        return this.game.convertCoordToVirtual((y /= 8) * 8);
    }

    int Map_GetWater(int x, int y) {
        if (y > this.layer0VirtualHeight) {
            return Integer.MAX_VALUE;
        }
        x = this.game.convertCoordToBuild(x);
        y = this.game.convertCoordToBuild(y);
        y -= 8;
        while (this.Map_GetCollision(x, y) == 0) {
            if ((y -= 8) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        byte col = this.Map_GetCollision(x, y);
        if ((col & 8) == 0) {
            return Integer.MAX_VALUE;
        }
        while ((this.Map_GetCollision(x, y) & 0xA) != 0) {
            if ((y -= 8) >= 0) continue;
            return -32;
        }
        y /= 8;
        return this.game.convertCoordToVirtual(++y * 8);
    }

    void Map_UnloadArea() {
        if (this.Map_GraphicsLoaded) {
            this.layers = null;
            for (int i = 0; i < 64; ++i) {
                this.game.RFM_IUnload(this.blockSprites[i], false);
            }
            this.game.RFM_IUnload(this.backBlockImage, false);
            this.theApp.garbageCollect();
            this.hitArray = null;
            this.Map_GraphicsLoaded = false;
            this.theApp.garbageCollect();
        }
    }

    int Map_GetSlopeHeight(int x, int y, byte col) {
        int basey = y / 8;
        ++basey;
        basey *= 8;
        if ((col & 0xFFFFFF80) != 0) {
            if ((col & 0x40) != 0) {
                x = (col & 0x30) >> 4;
                int dy = x * 8 >> 2;
                return this.game.convertCoordToVirtual(basey + dy - 8);
            }
            x = (col & 0x20) >> 5;
            int dy = x * 8 >> 1;
            return this.game.convertCoordToVirtual(basey + dy - 8);
        }
        int dy = x %= 8;
        if ((col & 4) != 0) {
            dy = 8 - dy;
        }
        return this.game.convertCoordToVirtual(basey + dy - 8);
    }

    byte Map_GetCollision(int x, int y) {
        int Width = this.layerWidth[0];
        int Height = this.layerHeight[0];
        int bx = x >> 5;
        int by = y >> 5;
        int charx = (x & 0x1F) >> 3;
        int chary = (y & 0x1F) >> 3;
        if (by < 0 || by >= Height || chary < 0) {
            return 0;
        }
        if (bx < 0) {
            bx = 0;
            charx = 0;
        } else if (bx >= Width) {
            bx = Width - 1;
            charx = 3;
        } else if (charx < 0) {
            charx = 0;
        }
        int index = by * Width + bx;
        short blockNumber = this.hitMetaBlocks[index];
        charx = (chary << 2) + charx;
        return (byte)(this.hitArray[(blockNumber << 4) + charx] & 0xFF);
    }

    byte Map_GetCollisionVirtual(int x, int y) {
        x = this.game.convertCoordToBuild(x);
        y = this.game.convertCoordToBuild(y);
        return this.Map_GetCollision(x, y);
    }

    void Map_Update() {
        this.lastMapX = this.mapX;
        this.lastMapY = this.mapY;
        this.mapX = this.theApp.moveTowards(this.mapTargetX, this.mapX, 1);
        this.mapY = this.theApp.moveTowards(this.mapTargetY, this.mapY, 1);
        this.mapX = this.theApp.limit(this.mapX, 0, this.mapMaxX);
        this.mapY = this.theApp.limit(this.mapY, this.mapMinY, this.mapMaxY);
        if (this.shakeTimer != 0) {
            this.mapX += this.theApp.randomNumberLimit(1000) - 500;
            this.mapY += this.theApp.randomNumberLimit(1000) - 500;
            --this.shakeTimer;
        }
        this.mapScrolled = 0;
        if (this.mapX > this.lastMapX) {
            this.mapScrolled |= 2;
        } else if (this.mapX < this.lastMapX) {
            this.mapScrolled |= 1;
        }
        if (this.mapY > this.lastMapY) {
            this.mapScrolled |= 8;
        } else if (this.mapY < this.lastMapY) {
            this.mapScrolled |= 4;
        }
        if (GameClass.areaNumber == 12) {
            if (GameClass.stageNumber == 7) {
                this.mapY = -this.charVirtualWidth;
            }
        }
    }

    boolean Map_CheckExit() {
        int GBAWidth = this.layer0GBAWidth;
        int GBAHeight = this.layer0GBAHeight;
        if (GameClass.draculaDead != 0) {
            return false;
        }
        int sx = AI.playerMapX;
        int sy = AI.playerMapY;
        if (GameClass.areaNumber == 3) {
            if (GameClass.stageNumber == 8) {
                if (this.ai.playerState != 32 && sy > this.layer0VirtualHeight - this.blockVirtualWidth) {
                    sy += this.blockVirtualWidth;
                    this.ai.playerDX = 0;
                }
            }
        }
        if (sy <= this.blockVirtualWidth + this.charVirtualWidth && this.ai.playerDY < 0) {
            sy -= this.blockVirtualWidth * 4;
        }
        int x0 = sx < 0 ? -1 : sx / this.gbaVirtualScreenSize;
        int y0 = sy < 0 ? -1 : sy / this.gbaVirtualScreenSize;
        int i = this.originalMapIndex + 5;
        for (int exit = 0; exit < this.numExits; ++exit) {
            block26: {
                block27: {
                    block28: {
                        int y;
                        int x;
                        block24: {
                            block25: {
                                block23: {
                                    x = this.exitList[exit << 2];
                                    y = this.exitList[(exit << 2) + 1];
                                    if (GameClass.stageNumber != 9) break block23;
                                    if (GameClass.areaNumber == 1) break block24;
                                }
                                if (GameClass.stageNumber != 5) break block25;
                                if (GameClass.areaNumber == 5) break block24;
                            }
                            if (x >= 0 && x < GBAWidth && y >= 0 && y < GBAHeight) {
                                if (x >= 0 && x < GBAWidth) {
                                    x = GBAWidth;
                                } else {
                                    y = GBAHeight;
                                }
                            }
                            if (x > GBAWidth) {
                                x = GBAWidth;
                            }
                            if (y > GBAHeight) {
                                y = GBAHeight;
                            }
                        }
                        if (x != x0 || y != y0) break block26;
                        GameClass.forceNewStage = (byte)this.exitList[(exit << 2) + 2];
                        if (GameClass.forceNewStage >= 10) {
                            GameClass.forceNewStage = (byte)-1;
                            return false;
                        }
                        GameClass.forcedDirection = x0 == this.layer0GBAWidth ? (byte)3 : (x0 < 0 ? (byte)2 : (y0 < 0 ? (byte)1 : (byte)4));
                        GameClass.forceNewArea = (byte)this.exitList[(exit << 2) + 3];
                        if (GameClass.forceNewStage != 9) break block27;
                        if (GameClass.forceNewArea != 4) break block27;
                        if (this.ai.Player_CheckForItem(132, 5) == 0) break block28;
                        if (this.ai.Player_CheckForItem(133, 5) == 0) break block28;
                        if (this.ai.Player_CheckForItem(134, 5) != 0) break block27;
                    }
                    this.game.Hud_InitSoulTextBox(this.game.Menu_GetResourceString(69));
                    GameClass.forceNewStage = (byte)-1;
                    GameClass.forceNewArea = (byte)-1;
                    this.ai.Player_ResetToLastPosition();
                    return false;
                }
                GameClass.oldLevelXAdjust = this.originalMap[this.originalMapStage][i + 3] << 1;
                GameClass.oldLevelYAdjust = this.originalMap[this.originalMapStage][i + 4] << 1;
                sx = sx < 0 ? (sx += this.gbaVirtualScreenSize) : (sx %= this.gbaVirtualScreenSize);
                if (sy < 0) {
                    sy += this.gbaVirtualScreenSize;
                    sy -= this.charVirtualWidth << 1;
                } else {
                    sy %= this.gbaVirtualScreenSize;
                    if (GameClass.forcedDirection == 4) {
                        sy += this.blockVirtualWidth;
                    }
                }
                int mx = this.originalMap[this.originalMapStage][i + 5] << 5;
                int my = this.originalMap[this.originalMapStage][i + 6] << 5;
                mx >>= 8;
                my >>= 8;
                GameClass.newLevelPlayerScreenX = sx + (mx *= this.gbaVirtualScreenSize);
                GameClass.newLevelPlayerScreenY = sy + (my *= this.gbaVirtualScreenSize);
                this.Map_AddAreaVisited(GameClass.forceNewStage, GameClass.forceNewArea);
                return true;
            }
            i += 7;
        }
        int checky = this.charVirtualWidth;
        if (this.ai.playerState == 32) {
            checky = 0;
        }
        if (AI.playerMapY < checky) {
            AI.playerMapY = this.charVirtualWidth;
            this.ai.playerDY = 0;
            this.ai.playerDX = 0;
        }
        return false;
    }

    void Map_Render() {
        if (!this.Map_GraphicsLoaded) {
            return;
        }
        this.Map_RenderBackground();
        this.Map_GetLayerXY();
        this.Map_RenderLayer(0);
        GameClass.ai.AI_Render(2);
        GameClass.ai.AI_Render(1);
        this.Map_DumpBackBuffer();
        if (this.clearBelowFloor) {
            this.game.currentDrawGraphics.setColor(0);
            int h = 224;
            this.game.currentDrawGraphics.fillRect(0, h, this.game.B_W, this.game.hudY - h);
        }
    }

    void Map_AddAreaVisited(int stage, int area) {
        int i = 0;
        i = this.Map_ConvertStageAndAreaToLevel(stage, area);
        int mask = 1 << (i & 0x1F);
        int n = i >> 5;
        this.areasVisited[n] = this.areasVisited[n] | mask;
    }

    int Map_ConvertStageAndAreaToLevel(int stage, int area) {
        int level = 0;
        for (int i = 0; i < stage; ++i) {
            level += numAreasInStage[i];
        }
        return area + level;
    }

    int Map_ConvertLevelToStageAndArea(int level) {
        int stage = 0;
        int oldLevelCount = 0;
        for (int levelCount = 0; levelCount <= level; levelCount += numAreasInStage[stage++]) {
            oldLevelCount = levelCount;
        }
        return (level -= oldLevelCount) + (--stage << 16);
    }

    boolean Map_IsLevelWarp(int level) {
        return this.Map_IsLevelSaveOrWarp(this.warpRooms, level);
    }

    boolean Map_IsLevelSave(int level) {
        return this.Map_IsLevelSaveOrWarp(this.saveRooms, level);
    }

    boolean Map_IsLevelSaveOrWarp(short[] array, int level) {
        int end = array.length;
        for (int i = 0; i < end; ++i) {
            if (level != array[i]) continue;
            return true;
        }
        return false;
    }

    void Map_RenderMap(boolean warp) {
        int i = 0;
        short level = 0;
        int sx = 0;
        int sy = 0;
        short levelToHighlight = GameClass.levelNumber;
        sx = this.game.R_CellScrW >> 1;
        sy = this.game.R_CellScrH >> 1;
        if (warp) {
            levelToHighlight = this.warpRooms[this.warpRoomIndex];
        }
        boolean map1 = this.ai.Player_CheckForItem(129, 5) == 1;
        boolean map2 = this.ai.Player_CheckForItem(130, 5) == 1;
        boolean map3 = this.ai.Player_CheckForItem(131, 5) == 1;
        int area = this.Map_ConvertLevelToStageAndArea(levelToHighlight);
        int stage = area >> 16 & 0xFFFF;
        i = this.Map_FindAreaInOriginalMap(0, 0);
        byte startx = this.originalMap[0][i + 1];
        byte starty = this.originalMap[0][i + 2];
        i = this.Map_FindAreaInOriginalMap(stage, area &= 0xFFFF);
        byte cx = this.originalMap[stage][i + 1];
        this.maxMapScroll = cx - startx;
        this.minMapScroll = this.maxMapScroll - 48;
        this.mapScroll = this.theApp.limit(this.mapScroll, this.minMapScroll, this.maxMapScroll);
        for (level = 0; level < 290; ++level) {
            int dy;
            int dx;
            int mask;
            block13: {
                block14: {
                    area = this.Map_ConvertLevelToStageAndArea(level);
                    stage = area >> 16 & 0xFFFF;
                    mask = 1 << (level & 0x1F);
                    if (stage == 2 && (area &= 0xFFFF) == 13 || (this.stagesRemoved & 1 << stage) != 0 || stage == 5 && (area == 6 || area == 7 || area == 14)) continue;
                    if ((this.areasVisited[level >> 5] & mask) != 0) break block13;
                    if (area != GameClass.areaNumber) break block14;
                    if (stage == GameClass.stageNumber) break block13;
                }
                if (!(map1 && stage < 2 || map2 && stage >= 2 && stage <= 7 || map3 && stage > 7) && (!warp || level != this.warpRooms[0])) continue;
            }
            i = this.Map_FindAreaInOriginalMap(stage, area);
            int numExits = this.originalMap[stage][i + 4] >> 4 & 0xF;
            int x = this.originalMap[stage][i + 1];
            int y = this.originalMap[stage][i + 2];
            if (x == -1 && y == -1) continue;
            x -= cx;
            y -= starty;
            x += this.mapScroll;
            int w = this.originalMap[stage][i + 0];
            int h = w & 0xF;
            w = w >> 4 & 0xF;
            x *= 7;
            y *= 7;
            int col = (this.areasVisited[level >> 5] & mask) != 0 ? (this.Map_IsLevelWarp(level) ? 0xFFFF00 : (this.Map_IsLevelSave(level) ? 0xFF0000 : 255)) : 0x7F7F7F;
            this.game.Renderer_FillRect(x += sx, y += sy, w *= 7, h *= 7, col);
            if (level == levelToHighlight && (this.game.frameCounter & 4) != 0) {
                dx = AI.playerMapX / this.gbaVirtualScreenSize * 7;
                dy = AI.playerMapY / this.gbaVirtualScreenSize * 7;
                if (dx > w - 7) {
                    dx = w - 7;
                }
                if (dy > h - 7) {
                    dy = h - 7;
                }
                this.game.Renderer_FillRect(x + dx, y + dy, 7, 7, 65280);
            }
            this.game.Renderer_DrawRect(x, y, w, h, 0xFFFFFF);
            i += 5;
            for (int exit = 0; exit < numExits; ++exit) {
                if (stage == 5 && area == 5 && exit == 0 || this.originalMap[stage][i + 1] == 10) continue;
                dx = this.originalMap[stage][i + 0];
                dy = dx & 0xF;
                dx = (dx >> 4) * 7;
                dy <<= 28;
                dy = (dy >> 28) * 7;
                if (dx >= w || dx < 0) {
                    if (dx < 0) {
                        dx = 0;
                    }
                    this.game.Renderer_DrawRect(dx + x, dy + y + 1, 0, 5, 0);
                } else {
                    if (dy < 0) {
                        dy = 0;
                    }
                    this.game.Renderer_DrawRect(dx + x + 1, dy + y, 5, 0, 0);
                }
                i += 7;
            }
        }
    }

    int Map_FindAreaInOriginalMap(int stage, int area) {
        int j = 0;
        if (this.originalMap[stage] == null) {
            return 0;
        }
        while (this.originalMap[stage][j + 3] != area || (this.originalMap[stage][j + 4] & 0xF) != stage) {
            int off = this.originalMap[stage][j + 4] >> 4 & 0xF;
            off *= 7;
            j += (off += 5);
        }
        return j;
    }

    int Map_CopySRNData(int layerNumber, byte[] data, int Index) {
        short[] layer = this.layers[layerNumber];
        int Width = this.layerWidth[layerNumber];
        int Height = this.layerHeight[layerNumber];
        int maxx = 0;
        int maxy = 0;
        int i = 0;
        for (int y = 0; y < Height; ++y) {
            for (int x = 0; x < Width; ++x) {
                layer[i] = (short)(((data[Index + (i << 1)] & 0xFF) << 8) + (data[Index + (i << 1) + 1] & 0xFF));
                if (layer[i] != 0) {
                    if (x > maxx) {
                        maxx = x;
                    }
                    if (y > maxy) {
                        maxy = y;
                    }
                }
                ++i;
            }
        }
        maxx = this.theApp.limit(maxx - 5, 0, Width);
        maxy = this.theApp.limit(maxy - 5, 0, Height);
        return (maxx << 16) + maxy;
    }

    boolean Map_IsAreaVisited(int level) {
        int mask = 1 << (level & 0x1F);
        return (this.areasVisited[level >> 5] & mask) != 0;
    }

    void Map_SetWarpRoomIndex(int level) {
        int i = 0;
        while (true) {
            if (level == this.warpRooms[i]) {
                this.warpRoomIndex = i;
                return;
            }
            ++i;
        }
    }

    void Map_IncWarpRoomIndex() {
        do {
            ++this.warpRoomIndex;
            this.warpRoomIndex %= this.warpRooms.length;
        } while (!this.Map_IsAreaVisited(this.warpRooms[this.warpRoomIndex]) && this.warpRoomIndex != 0);
    }

    void Map_BlockExits() {
        boolean hitsolidleft = false;
        boolean hitsolidright = false;
        int x1 = this.charVirtualWidth >> 1;
        int x2 = this.layer0VirtualWidth - this.charVirtualWidth * 3;
        for (int y = (this.charVirtualWidth >> 1) + this.blockVirtualWidth; y < this.layer0VirtualHeight - this.blockVirtualWidth; y += this.blockVirtualWidth) {
            if (this.Map_IsBlockSolid(x1, y) == 0) {
                if (!this.Map_FindExit(-1, (y >> 3) / this.blockVirtualWidth) && hitsolidleft) {
                    this.Map_CopyMetablockBelow(x1, y);
                }
            } else {
                hitsolidleft = true;
            }
            if (this.Map_IsBlockSolid(x2, y) == 0) {
                if (this.Map_FindExit(1, (y >> 3) / this.blockVirtualWidth) || !hitsolidright) continue;
                this.Map_CopyMetablockBelow(x2, y);
                continue;
            }
            hitsolidright = true;
        }
    }

    void Map_CopyMetablockBelow(int x, int y) {
        int index = this.Map_GetBlockIndex(x, y, this.layerWidth[0], this.layerHeight[0]);
        short block = this.layers[0][index + this.layerWidth[0]];
        short col = this.hitMetaBlocks[index + this.layerWidth[0]];
        this.layers[0][index] = block;
        this.hitMetaBlocks[index] = col;
        if (this.Map_IsBlockSolid(x, y - this.blockVirtualWidth) != 4) {
            this.layers[0][index - this.layerWidth[0]] = block;
            this.hitMetaBlocks[index - this.layerWidth[0]] = col;
        }
    }

    int Map_IsBlockSolid(int x, int y) {
        int solidLines = 0;
        for (int iy = 0; iy < this.charVirtualWidth << 2; iy += this.charVirtualWidth) {
            boolean lineSolid = false;
            for (int ix = 0; ix < this.charVirtualWidth << 2; ix += this.charVirtualWidth) {
                if ((this.Map_GetCollisionVirtual(x + ix, y + iy) & 3) == 0) continue;
                lineSolid = true;
            }
            if (!lineSolid) continue;
            ++solidLines;
        }
        return solidLines;
    }

    boolean Map_FindExit(int x, int y) {
        for (int i = 0; i < this.numExits; ++i) {
            int x1 = this.exitList[i << 2];
            if (this.exitList[(i << 2) + 1] != y || (x != 1 || x1 == -1) && (x != -1 || x1 != -1)) continue;
            return true;
        }
        return false;
    }

    void Map_SetupExits() {
        byte currentStage = GameClass.stageNumber;
        int i = this.originalMapIndex;
        this.numExits = this.originalMap[currentStage][i + 4] >> 4 & 0xF;
        i += 5;
        for (int exit = 0; exit < this.numExits; ++exit) {
            int stage;
            int x = this.originalMap[currentStage][i + 0];
            int y = x & 0xF;
            if ((x = x >> 4 & 0xF) == 15) {
                x = -1;
            }
            if (y == 15) {
                y = -1;
            }
            if ((stage = this.originalMap[currentStage][i + 1]) >= 10) {
                x = Integer.MAX_VALUE;
                y = Integer.MAX_VALUE;
            }
            this.exitList[exit << 2] = x;
            this.exitList[(exit << 2) + 1] = y;
            this.exitList[(exit << 2) + 2] = stage;
            this.exitList[(exit << 2) + 3] = this.originalMap[currentStage][i + 2];
            i += 7;
        }
    }

    void Map_RemoveExits(int stage, int targArea, int targStage) {
        int numAreas = numAreasInStage[stage];
        if ((this.stagesRemoved & 1 << stage) == 0) {
            for (int area = 0; area < numAreas; ++area) {
                int i = this.Map_FindAreaInOriginalMap(stage, area);
                int numExits = this.originalMap[stage][i + 4] >> 4 & 0xF;
                i += 5;
                for (int exit = 0; exit < numExits; ++exit) {
                    if (targStage == this.originalMap[stage][i + 1] && (targArea == this.originalMap[stage][i + 2] || targArea == -1)) {
                        this.originalMap[stage][i + 0] = 127;
                        this.originalMap[stage][i + 0] = 127;
                    }
                    i += 7;
                }
            }
        }
    }

    void Map_RemoveStage(int stage) {
        for (int i = 0; i < 290; ++i) {
            int thisarea = this.Map_ConvertLevelToStageAndArea(i);
            int thisstage = thisarea >> 16 & 0xFFFF;
            thisarea &= 0xFFFF;
            if ((this.stagesRemoved & 1 << thisstage) != 0) continue;
            this.Map_RemoveExits(thisstage, -1, stage);
        }
    }

    void Map_BuildMetaBlocks(short[] metablocks, int numMetablocks, int blockSet, int areaToLoad) {
        int i;
        int stage;
        int area;
        byte[] metablockpalette = new byte[768];
        int destPaletteIndex = 0;
        String filename1 = null;
        GameClass.theApp.addResourceDirectory("");
        byte[] palettes = new byte[this.theApp.fileLoad(null, "pal_lib_v1.col", null, true, 0, 0)];
        this.theApp.fileLoad(null, "pal_lib_v1.col", palettes, false, 0, 0);
        int sourcePaletteStart = ((palettes[0] & 0xFF) << 8) + (palettes[1] & 0xFF);
        String filename = "" + blockSet / 10 + blockSet % 10;
        filename1 = filename + "_8x8.csr";
        byte[] chars = new byte[this.theApp.fileLoad(null, filename1, null, true, 0, 0)];
        this.theApp.fileLoad(null, filename1, chars, false, 0, 0);
        if (blockSet == 16) {
            blockSet = 0;
        }
        int headerIndex = 4;
        int numPalettes = 0;
        do {
            headerIndex += numPalettes;
            area = palettes[headerIndex++] & 0xFF;
            stage = palettes[headerIndex] & 0xF;
            numPalettes = palettes[headerIndex++] >> 4 & 0xF;
        } while (area != areaToLoad || stage != blockSet);
        for (i = 0; i < numPalettes; ++i) {
            int sourcePaletteIndex;
            if ((sourcePaletteIndex = palettes[headerIndex++] & 0xFF) != 255) {
                sourcePaletteIndex <<= 5;
                sourcePaletteIndex += sourcePaletteStart;
                for (int j = 0; j < 16; ++j) {
                    int colour = (palettes[sourcePaletteIndex++] & 0xFF) << 8;
                    metablockpalette[destPaletteIndex++] = (byte)((colour += palettes[sourcePaletteIndex++] & 0xFF) << 3 & 0xF8);
                    metablockpalette[destPaletteIndex++] = (byte)(colour >> 2 & 0xF8);
                    metablockpalette[destPaletteIndex++] = (byte)(colour >> 7 & 0xF8);
                }
                continue;
            }
            destPaletteIndex += 48;
        }
        palettes = null;
        this.theApp.garbageCollect();
        filename1 = filename + "_b2.mod";
        byte[] mod = new byte[this.theApp.fileLoad(null, filename1, null, true, 0, 0)];
        this.theApp.fileLoad(null, filename1, mod, false, 0, 0);
        byte[] metablockPixels = new byte[numMetablocks * 1024];
        for (i = 0; i < numMetablocks; ++i) {
            short metablocknumber = metablocks[i];
            if (metablocknumber == -1) continue;
            this.theApp.Yield();
            this.Map_DrawMetablock(mod, metablocks[i] & 0x3FFF, chars, metablockPixels, i, metablocks[i] & 0xC000, true);
        }
        mod = null;
        chars = null;
        this.theApp.garbageCollect();
        i = 0;
        while (numMetablocks > 8) {
            this.blockSprites[i] = this.game.RFM_ILoadRAW(256, 32, 256, metablockPixels, metablockpalette, 16, 0, i * 256 * 32, 0, false, 0, true);
            ++i;
            numMetablocks -= 8;
        }
        this.blockSprites[i] = this.game.RFM_ILoadRAW(256, numMetablocks / 8 * 32, 256, metablockPixels, metablockpalette, 16, 0, i * 256 * 32, 0, false, 0, true);
        metablockPixels = null;
        metablockpalette = null;
        this.theApp.garbageCollect();
    }

    void Map_DrawMetablock(byte[] mod, int modnumber, byte[] chars, byte[] metablockpixels, int metablocknumber, int metaflip, boolean b) {
        int charadd;
        int lineindex;
        int lineadd = 4;
        if (modnumber == 0) {
            return;
        }
        metaflip >>= 14;
        if (((metaflip &= 3) & 2) != 0) {
            lineindex = 3;
            charadd = -1;
        } else {
            lineindex = 0;
            charadd = 1;
        }
        if ((metaflip & 1) != 0) {
            lineindex += 12;
            lineadd = -4;
        }
        int metablockindex = (metablocknumber & 7) * 32 + (metablocknumber >> 3) * 32 * 256;
        int modindex = 4 + modnumber * 32;
        for (int y = 0; y < 4; ++y) {
            int charindex = lineindex;
            for (int x = 0; x < 4; ++x) {
                int flip = mod[modindex] >> 6 ^ metaflip;
                int palette = mod[modindex] >> 2 & 0xF;
                int charnumber = (mod[modindex++] & 3) << 8;
                this.Map_DrawChar(chars, charnumber += mod[modindex++] & 0xFF, metablockpixels, metablockindex, charindex, palette, flip);
                charindex += charadd;
            }
            lineindex += lineadd;
        }
    }

    void Map_DrawChar(byte[] chars, int charnumber, byte[] metablockpixels, int metablockindex, int metacharnumber, int palette, int flip) {
        int add;
        int charindex = charnumber * 32;
        palette <<= 4;
        int charx = metacharnumber % 4 * 8;
        int chary = metacharnumber / 4 * 8;
        metablockindex += charx + (chary *= 256);
        if ((flip & 1) != 0) {
            add = -256;
            metablockindex += 1792;
        } else {
            add = 256;
        }
        if ((flip & 2) != 0) {
            for (int y = 0; y < 8; ++y) {
                byte val = chars[charindex++];
                metablockpixels[metablockindex + 7] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 6] = (byte)((val & 0xF) + palette & 0xFF);
                val = chars[charindex++];
                metablockpixels[metablockindex + 5] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 4] = (byte)((val & 0xF) + palette & 0xFF);
                val = chars[charindex++];
                metablockpixels[metablockindex + 3] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 2] = (byte)((val & 0xF) + palette & 0xFF);
                val = chars[charindex++];
                metablockpixels[metablockindex + 1] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 0] = (byte)((val & 0xF) + palette & 0xFF);
                metablockindex += add;
            }
        } else {
            for (int y = 0; y < 8; ++y) {
                byte val = chars[charindex++];
                metablockpixels[metablockindex + 0] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 1] = (byte)((val & 0xF) + palette & 0xFF);
                val = chars[charindex++];
                metablockpixels[metablockindex + 2] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 3] = (byte)((val & 0xF) + palette & 0xFF);
                val = chars[charindex++];
                metablockpixels[metablockindex + 4] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 5] = (byte)((val & 0xF) + palette & 0xFF);
                val = chars[charindex++];
                metablockpixels[metablockindex + 6] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 7] = (byte)((val & 0xF) + palette & 0xFF);
                metablockindex += add;
            }
        }
    }

    void Map_LoadArea() {
        short[] tempArray;
        int layerNumber;
        int thisStage;
        int thisArea;
        int srnIndex;
        byte[] srndata;
        int i;
        int areaToLoad;
        int blockSet;
        int stageToLoad;
        byte stageNumber;
        byte areaNumber;
        block29: {
            int searchMask;
            block28: {
                this.numberOfLayers = 0;
                areaNumber = GameClass.areaNumber;
                stageNumber = GameClass.stageNumber;
                GameClass.draculaLevel = areaNumber == 4 && stageNumber == 9;
                stageToLoad = this.Map_ConvertStageAndAreaToLevel(stageNumber, areaNumber);
                stageToLoad = remaps[stageToLoad];
                this.clearBelowFloor = stageToLoad == 3 || stageToLoad == 4352 || stageToLoad == 9792;
                blockSet = stageToLoad >> 10 & 0x3F;
                areaToLoad = stageToLoad >> 0 & 0x3F;
                stageToLoad = stageToLoad >> 6 & 0xF;
                GameClass.remapStageNumber = (byte)stageToLoad;
                GameClass.remapAreaNumber = (byte)areaToLoad;
                this.onlyOneLayer = true;
                this.insideArea = true;
                searchMask = GameClass.remapAreaNumber;
                if (GameClass.stageNumber == 0) break block28;
                if (GameClass.stageNumber != 9) break block29;
            }
            if (GameClass.remapStageNumber == 9) {
                searchMask += 64;
            }
            for (i = 0; i < outsideAreas.length; ++i) {
                if (outsideAreas[i] != searchMask) continue;
                this.insideArea = false;
            }
        }
        GameClass.theApp.addResourceDirectory("");
        String filename1 = blockSet == 16 ? "block0" : "block" + blockSet;
        this.backBlockImage = this.game.RFM_ILoad(null, 0, filename1);
        int val = this.Map_ConvertStageAndAreaToLevel(stageNumber, areaNumber);
        GameClass.isSave = this.Map_IsLevelSave(val);
        GameClass.isWarp = this.Map_IsLevelWarp(val);
        this.charVirtualWidth = this.blockVirtualWidth >> 2;
        GameClass.theApp.addResourceDirectory("");
        filename1 = "" + blockSet / 10 + blockSet % 10 + SRN_FILE_EXTENSION;
        if (blockSet != this.srnStage) {
            srndata = new byte[this.theApp.fileLoad(null, filename1, null, true, 0, 0)];
            this.theApp.fileLoad(null, filename1, srndata, false, 0, 0);
            for (i = 0; i < 3; ++i) {
                this.layerSize[i] = 0;
            }
            i = 0;
            srnIndex = -8;
            srnIndex += (this.layerSize[0] << 2) + (this.layerSize[1] << 1) + (this.layerSize[2] << 1) + 8;
            while (srnIndex < srndata.length) {
                thisArea = srndata[srnIndex + 1] & 0x7F;
                thisStage = srndata[srnIndex + 0];
                this.srnHeader[i++] = (thisStage & 0xFFFF) + ((thisArea & 0xFFFF) << 16);
                this.srnHeader[i++] = srnIndex;
                for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
                    val = srndata[srnIndex + 2 + (layerNumber << 1)];
                    if (val != 0) {
                        int w = (val >> 3 & 0xF) << 3;
                        int h = (val >> 0 & 7) << 3;
                        this.layerSize[layerNumber] = w * h;
                        continue;
                    }
                    this.layerSize[layerNumber] = 0;
                }
                srnIndex += (this.layerSize[0] << 2) + (this.layerSize[1] << 1) + (this.layerSize[2] << 1) + 8;
            }
            this.srnHeader[i + 1] = srndata.length;
            srndata = null;
            this.theApp.garbageCollect();
            this.srnStage = blockSet;
        }
        i = 0;
        do {
            thisStage = this.srnHeader[i];
            thisArea = thisStage >> 16 & 0xFFFF;
            i += 2;
        } while (thisArea != areaToLoad || (thisStage &= 0xFFFF) != stageToLoad);
        int offset = this.srnHeader[i - 1];
        int size = this.srnHeader[i + 1] - this.srnHeader[i - 1];
        srndata = new byte[size];
        this.theApp.fileLoad(null, filename1, srndata, false, size, offset);
        srnIndex = 0;
        for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
            val = srndata[srnIndex + 2 + (layerNumber << 1)];
            if (val != 0) {
                this.layerWidth[layerNumber] = (val >> 3 & 0xF) << 3;
                this.layerHeight[layerNumber] = (val >> 0 & 7) << 3;
                if (layerNumber == 0) {
                    this.layer0GBAWidth = this.layerWidth[layerNumber] >> 3;
                    this.layer0GBAHeight = this.layerHeight[layerNumber] >> 3;
                }
                this.layerGBAWidth[layerNumber] = this.layerWidth[layerNumber] >> 3;
                this.layerGBAHeight[layerNumber] = this.layerHeight[layerNumber] >> 3;
                this.layerSize[layerNumber] = this.layerWidth[layerNumber] * this.layerHeight[layerNumber];
                ++this.numberOfLayers;
                continue;
            }
            this.layerSize[layerNumber] = 0;
        }
        this.layers = null;
        this.layers = new short[1][];
        for (layerNumber = 0; layerNumber < 1; ++layerNumber) {
            this.layers[layerNumber] = null;
            if (this.layerSize[layerNumber] == 0) continue;
            this.layers[layerNumber] = new short[this.layerSize[layerNumber]];
            if (layerNumber == 0) {
                this.layer0VirtualWidth = this.layerWidth[0] * this.blockVirtualWidth;
                this.layer0VirtualHeight = this.layerHeight[0] * this.blockVirtualWidth;
                this.layer0CharWidth = this.layerWidth[0] << 2;
                this.layer0CharHeight = this.layerHeight[0] << 2;
            }
            this.layerScroll[layerNumber] = srndata[srnIndex + 3 + (layerNumber << 1)] >> 0 & 0x1F;
        }
        srnIndex += 8;
        this.hitMetaBlocks = new short[this.layerSize[0]];
        for (i = 0; i < this.layerSize[0] << 1; i += 2) {
            this.hitMetaBlocks[i >> 1] = (short)(((srndata[srnIndex + i] & 0xFF) << 8) + (srndata[srnIndex + 1 + i] & 0xFF));
        }
        srnIndex += this.layerSize[0] * 2;
        for (layerNumber = 0; layerNumber < 1; ++layerNumber) {
            if (this.layerSize[layerNumber] == 0) continue;
            this.layerBlockRight[layerNumber] = this.Map_CopySRNData(layerNumber, srndata, srnIndex);
            this.layerBlockBottom[layerNumber] = this.layerBlockRight[layerNumber] & 0xFFFF;
            int n = layerNumber;
            this.layerBlockRight[n] = this.layerBlockRight[n] >> 16;
            srnIndex += this.layerSize[layerNumber] * 2;
        }
        srndata = null;
        this.theApp.garbageCollect();
        size = 0;
        for (i = 0; i < 1; ++i) {
            size += this.layerSize[i];
        }
        short[] metablocks = new short[size];
        this.theApp.fillShortArray(metablocks, (short)-1);
        metablocks[0] = 0;
        int index = 1;
        for (layerNumber = 0; layerNumber < 1; ++layerNumber) {
            tempArray = this.layers[layerNumber];
            for (i = 0; i < this.layerSize[layerNumber]; ++i) {
                int j;
                for (j = 0; metablocks[j] != tempArray[i] && j < index; ++j) {
                }
                if (j != index) continue;
                metablocks[index++] = tempArray[i];
            }
        }
        index = (index + 7) / 8;
        if ((index *= 8) > this.game.maxmetablocks) {
            this.game.maxmetablockarea = GameClass.areaNumber;
            this.game.maxmetablockstage = GameClass.stageNumber;
            this.game.maxmetablocks = index;
        }
        this.Map_BuildMetaBlocks(metablocks, index, blockSet, areaToLoad);
        for (layerNumber = 0; layerNumber < 1; ++layerNumber) {
            tempArray = this.layers[layerNumber];
            for (i = 0; i < this.layerSize[layerNumber]; ++i) {
                int k = 0;
                short tmpShort = (short)(tempArray[i] & 0xFFFF);
                while (metablocks[k] != tmpShort) {
                    ++k;
                }
                tempArray[i] = (short)k;
            }
        }
        metablocks = null;
        this.theApp.garbageCollect();
        this.mapPixelWidthVisible = (this.screenBlockW - 1) * 32;
        this.mapVirtualWidthVisible = (this.screenBlockW - 1) * this.blockVirtualWidth;
        this.mapPixelXOffset = this.game.B_W - this.mapPixelWidthVisible >> 1;
        this.mapPixelYOffset = 0;
        this.mapPixelHeightVisible = (this.screenBlockH - 1) * 32;
        this.mapVirtualHeightVisible = (this.screenBlockH - 1) * this.blockVirtualWidth;
        this.screenVirtualHeight = this.screenBlockH * this.blockVirtualWidth;
        this.screenVirtualWidth = this.screenBlockW * this.blockVirtualWidth;
        this.mapMaxX = this.layerWidth[0] * this.blockVirtualWidth - this.mapVirtualWidthVisible - (this.blockVirtualWidth >> 1);
        this.bottomOfMap = this.layerHeight[0] * this.blockVirtualWidth;
        this.mapMaxY = this.layerHeight[0] * this.blockVirtualWidth - this.screenVirtualHeight;
        if (this.mapMaxY < 0) {
            this.mapMaxY = 0;
        }
        if (this.mapMaxX < 0) {
            this.mapMaxX = 0;
        }
        this.mapMinY = this.layer0GBAHeight > 1 ? this.blockVirtualWidth : 0;
        this.gbaVirtualScreenSize = this.blockVirtualWidth << 3;
        this.originalMapIndex = this.Map_FindAreaInOriginalMap(GameClass.stageNumber, GameClass.areaNumber);
        this.originalMapStage = GameClass.stageNumber;
        GameClass.theApp.addResourceDirectory("");
        this.hitArray = new byte[this.theApp.fileLoad(null, "hit_lib_v1.hit", null, true, 0, 0)];
        this.theApp.fileLoad(null, "hit_lib_v1.hit", this.hitArray, false, 0, 0);
        this.Map_FloorInCentre = this.Map_GetFloor(this.layer0VirtualWidth >> 1, this.layer0VirtualHeight - (this.blockVirtualWidth << 1), false);
        this.Map_GraphicsLoaded = true;
    }

    void Map_RenderLayer(int layerNumber) {
        int Size = this.layerSize[layerNumber];
        int Width = this.layerWidth[layerNumber];
        int Height = this.layerHeight[layerNumber];
        short[] layer = this.layers[layerNumber];
        int grW = this.layerBlockRight[layerNumber] - 1;
        int grH = this.layerBlockBottom[layerNumber];
        int w = this.backBuffer.getWidth();
        int h = this.backBuffer.getHeight();
        this.game.currentDrawGraphics = this.backBufferGraphics;
        if (Size != 0) {
            int blockLineIndex;
            int x = this.mapX;
            int y = this.mapY;
            if (Height == 8 && this.screenBlockH == 8) {
                y = 0;
            }
            if (Width == 8) {
                x = this.theApp.limit(x, 0, this.blockVirtualWidth);
            }
            if ((blockLineIndex = (x = this.game.convertCoordToBuild(x)) / 32 + (y = this.game.convertCoordToBuild(y)) / 32 * Width) > Size) {
                this.game.currentDrawGraphics = this.game.canvasGraphics;
                return;
            }
            x %= w;
            y %= h;
            x /= 32;
            y /= 32;
            y *= 32;
            int xstore = x *= 32;
            if (this.game.drawFullScreen) {
                for (int dy = 0; dy < this.screenBlockH; ++dy) {
                    x = xstore;
                    if (blockLineIndex + this.screenBlockW > Size) {
                        blockLineIndex -= Size;
                    }
                    if (blockLineIndex < 0) {
                        blockLineIndex = 0;
                    }
                    this.Map_RenderLayerHorLine(x, y, blockLineIndex, layer, w, Size);
                    if ((y += 32) >= h) {
                        y -= h;
                    }
                    blockLineIndex += Width;
                }
            } else {
                int locLastMapX;
                int locLastMapY;
                int tempy = y;
                int tempBlockLineIndex = blockLineIndex;
                if ((this.mapScrolled & 4) != 0) {
                    this.Map_RenderLayerHorLine(x, y, blockLineIndex, layer, w, Size);
                    if (this.theApp.abs(this.lastMapY - this.mapY) > this.blockVirtualWidth >> 2) {
                        for (locLastMapY = this.lastMapY; locLastMapY >= this.mapY; locLastMapY -= this.blockVirtualWidth) {
                            if ((y += 32) >= h) {
                                y -= h;
                            }
                            if ((blockLineIndex += Width) + this.screenBlockW > Size) {
                                blockLineIndex -= Size;
                            }
                            this.Map_RenderLayerHorLine(x, y, blockLineIndex, layer, w, Size);
                        }
                    }
                }
                if ((this.mapScrolled & 8) != 0) {
                    tempy = y;
                    y = (y + 32 * (this.screenBlockH - 1)) % h;
                    this.Map_RenderLayerHorLine(xstore, y, blockLineIndex += Width * (this.screenBlockH - 1), layer, w, Size);
                    if (this.theApp.abs(this.lastMapY - this.mapY) > this.blockVirtualWidth >> 2) {
                        for (locLastMapY = this.lastMapY; locLastMapY <= this.mapY; locLastMapY += this.blockVirtualWidth) {
                            if ((y -= 32) < 0) {
                                y += h;
                            }
                            if ((blockLineIndex -= Width) < 0) {
                                blockLineIndex = 0;
                            }
                            this.Map_RenderLayerHorLine(x, y, blockLineIndex, layer, w, Size);
                        }
                    }
                }
                y = tempy;
                blockLineIndex = tempBlockLineIndex;
                if ((this.mapScrolled & 1) != 0) {
                    this.Map_RenderLayerVertLine(x, y, blockLineIndex, layer, h, Width, Size);
                    if (this.theApp.abs(this.lastMapX - this.mapX) > this.blockVirtualWidth >> 2) {
                        for (locLastMapX = this.lastMapX; locLastMapX >= this.mapX; locLastMapX -= this.blockVirtualWidth) {
                            if ((x += 32) >= w) {
                                x -= w;
                            }
                            this.Map_RenderLayerVertLine(x, y, ++blockLineIndex, layer, h, Width, Size);
                        }
                    }
                }
                if ((this.mapScrolled & 2) != 0) {
                    x = (x + (this.screenBlockW - 1) * 32) % w;
                    blockLineIndex = blockLineIndex + this.screenBlockW - 1;
                    this.Map_RenderLayerVertLine(x, y, blockLineIndex, layer, h, Width, Size);
                    if (this.theApp.abs(this.lastMapX - this.mapX) > this.blockVirtualWidth >> 2) {
                        for (locLastMapX = this.lastMapX; locLastMapX <= this.mapX; locLastMapX += this.blockVirtualWidth) {
                            if ((x -= 32) < 0) {
                                x += w;
                            }
                            if (--blockLineIndex < 0) {
                                blockLineIndex = 0;
                            }
                            this.Map_RenderLayerVertLine(x, y, blockLineIndex, layer, h, Width, Size);
                        }
                    }
                }
            }
            this.onlyOneLayer = false;
        }
        this.game.currentDrawGraphics = this.game.canvasGraphics;
    }

    void Map_RenderLayerHorLine(int x, int y, int index, short[] layer, int w, int layerSize) {
        for (int dx = 0; dx < this.screenBlockW; ++dx) {
            index %= layerSize;
            short blockNumber = layer[index++];
            int ix = blockNumber & 7;
            int iy = blockNumber >> 3;
            iy &= 0;
            this.game.Renderer_DrawClippedIndexedBmp(this.blockSprites[blockNumber / 8], x, y, 32, 32, ix *= 32, iy *= 32);
            if ((x += 32) < w) continue;
            x -= w;
        }
    }

    void Map_RenderLayerVertLine(int x, int y, int index, short[] layer, int h, int layerWidth, int layerSize) {
        for (int dy = 0; dy < this.screenBlockH; ++dy) {
            short blockNumber = layer[index %= layerSize];
            int ix = blockNumber & 7;
            int iy = blockNumber >> 3;
            iy &= 0;
            this.game.Renderer_DrawClippedIndexedBmp(this.blockSprites[blockNumber / 8], x, y, 32, 32, ix *= 32, iy *= 32);
            if ((y += 32) >= h) {
                y -= h;
            }
            index += layerWidth;
        }
    }

    void Map_DumpBackBuffer() {
        int w = this.backBuffer.getWidth();
        int h = this.backBuffer.getHeight();
        int x = this.game.convertCoordToBuild(this.mapX);
        int y = this.game.convertCoordToBuild(this.mapY);
        int scrw = (this.screenBlockW - 1) * 32;
        int scrh = (this.screenBlockH - 1) * 32;
        int scrx = this.game.convertXToBuild(0);
        int scry = this.game.convertYToBuild(0);
        int x0 = 0;
        int y0 = 0;
        int w0 = w - (x %= w);
        int h0 = h - (y %= h);
        int x1 = w0;
        int y1 = y0;
        int w1 = scrw - w0;
        int h1 = h0;
        int x2 = w0;
        int y2 = h0;
        int w2 = w1;
        int h2 = scrh - h0;
        int x3 = 0;
        int y3 = y2;
        int w3 = w0;
        int h3 = h2;
        if (y0 + scry + h0 > this.game.hudY && (h0 = this.game.hudY - (y0 + scry)) <= 0) {
            return;
        }
        this.game.currentDrawGraphics.setClip(x0 + scrx, y0 + scry, w0, h0);
        this.game.currentDrawGraphics.drawImage(this.backBuffer, -x + scrx, -y + scry, 0);
        if (y1 + scry + h1 > this.game.hudY && (h1 = this.game.hudY - (y1 + scry)) <= 0) {
            return;
        }
        this.game.currentDrawGraphics.setClip(x1 + scrx, y1 + scry, w1, h1);
        this.game.currentDrawGraphics.drawImage(this.backBuffer, w0 + scrx, -y + scry, 0);
        if (y2 + scry + h2 > this.game.hudY && (h2 = this.game.hudY - (y2 + scry)) <= 0) {
            return;
        }
        this.game.currentDrawGraphics.setClip(x2 + scrx, y2 + scry, w2, h2);
        this.game.currentDrawGraphics.drawImage(this.backBuffer, w0 + scrx, h0 + scry, 0);
        if (y3 + scry + h3 > this.game.hudY && (h3 = this.game.hudY - (y3 + scry)) <= 0) {
            return;
        }
        this.game.currentDrawGraphics.setClip(x3 + scrx, y3 + scry, w3, h3);
        this.game.currentDrawGraphics.drawImage(this.backBuffer, -x + scrx, h0 + scry, 0);
        this.game.Renderer_SetClipFullScreen();
    }

    void Map_RenderBackground() {
        this.game.Renderer_FillRectVirtual(0, 0, this.screenBlockW * this.blockVirtualWidth, this.game.hudYVirtual, 0);
    }

    void Map_GetLayerXY() {
        for (int layerNumber = 0; layerNumber < 1; ++layerNumber) {
            int Size = this.layerSize[layerNumber];
            int Scroll = this.layerScroll[layerNumber];
            int Width = this.layerWidth[layerNumber];
            int Height = this.layerHeight[layerNumber];
            int grW = this.layerBlockRight[layerNumber] - 1;
            int grH = this.layerBlockBottom[layerNumber];
            int x = 0;
            int y = 0;
            if (Size != 0) {
                x = this.mapX;
                y = this.mapY;
                switch (Scroll) {
                    case 0: 
                    case 6: {
                        if (layerNumber != 2) break;
                        if (GameClass.isSave) break;
                        if (GameClass.isWarp || this.layerScroll[0] == 0) break;
                        x = 0;
                        y = 0;
                        break;
                    }
                    case 1: 
                    case 21: {
                        break;
                    }
                    case 2: {
                        x >>= 1;
                        break;
                    }
                    case 3: {
                        x = x * grW / this.layerBlockRight[0];
                        break;
                    }
                    case 4: {
                        y = y * grH / this.layerBlockBottom[0];
                        break;
                    }
                    case 5: {
                        x = x * grW / this.layerBlockRight[0];
                        y = y * grH / this.layerBlockBottom[0];
                        break;
                    }
                }
                if (Height == 8 && this.screenBlockH == 8) {
                    y = 0;
                    if (GameClass.areaNumber == 12) {
                        if (GameClass.stageNumber == 7) {
                            y = -this.charVirtualWidth;
                        }
                    }
                }
                if (Width == 8) {
                    x = this.theApp.limit(x, 0, this.blockVirtualWidth);
                }
            }
            this.layerX[layerNumber] = x;
            this.layerY[layerNumber] = y;
        }
    }
}

