/*
 * Decompiled with CFR 0.152.
 */
package engine.world;

import app.GameAppState;
import engine.AnimatedSprite;
import engine.SpriteAnimationSet;
import engine.TilesImage;
import engine.world.Level;
import engine.world.Point;
import engine.world.SectorEdge;
import engine.world.Weapon;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero {
    public int fp_heroX;
    public int fp_heroY;
    public int fp_lastX;
    public int fp_lastY;
    public int currentSector;
    public int lastSector;
    public int currentRegionX;
    public int currentRegionY;
    public boolean visible = true;
    public boolean fading = false;
    public int VISIBLE_TIME = 5000;
    public int INVISIBLE_TIME = 100;
    public int HALF_VISIBLE_TIME = 600;
    public int FADING_VISIBLE_TIME;
    public int fTime = 0;
    public static final byte NOTHING = 0;
    public static final byte STAND = 1;
    public static final byte MOVE = 2;
    public static final byte JUMP = 3;
    public static final byte FALL = 4;
    public static final byte CLIMB = 5;
    public static final byte HIT = 6;
    public static final byte STAND_UP = 7;
    public static final byte DEAD = 8;
    public static final byte IN_ELEVATOR = 100;
    public static final byte STAY_DOWN = 9;
    public static final byte RUN = 10;
    public static final byte PICK_UP = 11;
    public static final byte KOLANKO = 12;
    public static final byte KOLANKO_GRAB = 13;
    public static final byte ENEMY_FLY = 14;
    public static final byte ENEMY_THROW = 15;
    public static final byte POWER_FLY = 16;
    public static final byte LEZE = 17;
    public static final byte BOSS_GRAB = 18;
    public static final byte BOSS_HIT = 19;
    public static final byte DISAPPEART = 20;
    public static final byte FADE_IN = 21;
    public static final byte FADE_OUT = 22;
    public static final byte RUN_AWAY = 23;
    public static final byte BOSS_JUMP = 24;
    public static final byte STUNT = 25;
    public static final byte ROTATE = 26;
    public static final byte BOSS_ROTATE_JUMP = 27;
    public static final byte KNEE_KICK = 28;
    public static final byte KICK_FRONT = 29;
    public static final byte CHARGE = 30;
    public static final byte THROW_ITEM = 31;
    public static final byte KOLANKO_HIT = 32;
    public static final byte PIPE_HIT = 33;
    public static final byte CHAIN_HIT = 34;
    public static final byte ELBOW_PUNCH = 35;
    public static final byte WYKOP = 36;
    public static final byte AIR_STRIKE = 37;
    public static final byte ROUND_KICK = 38;
    public static final byte ROUND_PUNCH = 39;
    public static final byte BOSS_KICK = 40;
    public static final byte LOW_KICK = 41;
    public static final byte SHADOW_ATTACK = 42;
    public static final byte JUMP_KICK = 43;
    public static final byte UPPERCUT = 44;
    public static final byte PUNCH = 45;
    public static final byte PUNCH_2 = 46;
    public static final byte KICK = 47;
    public static final byte SPINNING_CYCLONE = 48;
    public static final byte HYPPER_UPPERCUT = 49;
    public boolean nieKucam = false;
    public byte state;
    public short enemyType;
    public static final byte RIGHT_ORIENTATION = 0;
    public static final byte LEFT_ORIENTATION = 1;
    public byte orientation;
    private static final int CLIMB_FRAME_CHANGE_DELTA_Y = 15;
    public SpriteAnimationSet heroAnimation;
    public AnimatedSprite heroSprite;
    public Level level;
    static final int BASE_WIDTH = 176;
    private int moveSpeedPerMS = 16896;
    private int moveSpeedEnemyPerMS = 16896;
    private int animationTime;
    public int nextSectorFall;
    public static final int X_WIDTH = 3840;
    public static final int X_WIDTH_NONFP = 15;
    public static final int Y_HEIGHT_NONFP = 35;
    byte punchOrientation = 0;
    boolean continuePunch = false;
    boolean continueKick = false;
    byte doNotHitMe = 0;
    int timeAfterPunch = 0;
    long timeAfterHit = 0L;
    int jumpBeginHeight;
    int jumpDirection;
    int jumpVelocity;
    static final int jumpVelocityThrowEnemy = -52800;
    static final int jumpVelocityBegin = -57024;
    static final int jumpVelocityBegin2 = -70400;
    static final int jumpVelocityBeginShort = -51040;
    static final int jumpVelocityDelta = 140800;
    static final int powerhitVelocityBegin = -45056;
    static final int hypperKneeBegin = -35200;
    static final int spinVelocityMin = -8448;
    static final int spinVelocityMax = 4224;
    static final int moveSpeedJumpPerMS = 12672;
    static final int moveSpeedJump2PerMS = 25344;
    static final int moveSpeedJumpShortPerMS = 17600;
    static final int moveSpeedFallPerMS = 4224;
    static final int moveSpeedFastFlyPerMS = 34496;
    static final int moveSpeedPowerHitPerMS = 11264;
    public static final int moveSpeedPowerHitSteamMachinePerMS = 22528;
    int fallSpeedX;
    int moveSpeedJumpHero = 12672;
    int jumpVelocityBeginHero = -57024;
    public int id;
    public int flySpeedX;
    boolean isComputer;
    int stepRight;
    int stepDown;
    int jump;
    int diagonalJump;
    public boolean shortJump = false;
    int[] attack = new int[2];
    public short life;
    public byte lives;
    public byte stanAkcji;
    public byte akcja;
    public byte backUpakcja;
    public byte backUpstate;
    short inicjatywa;
    public short INICJATYWA_BASE = (short)300;
    public short INICJATYWA_START = (short)200;
    public int time = 0;
    public int reflex = 200;
    public int timeToChange = 0;
    public byte newAkcja;
    public byte newStanAkcji;
    public boolean changeAkcja = false;
    byte[] kindOfAttack = new byte[5];
    byte[] probabilty = new byte[5];
    public byte indexOfKtoryAttak;
    public boolean actionFinish;
    public boolean actionInProgress;
    Point attackPoint;
    Point myPoint = new Point();
    public int petla = 0;
    public boolean canRun = false;
    public boolean canRotate = false;
    public boolean canGrab = true;
    public boolean canUppercut = true;
    public boolean canJump = false;
    public boolean canOnePunch = false;
    public boolean can2Punch = true;
    public boolean canContra = false;
    public boolean canStayDown = true;
    public boolean can2KickToStunt = true;
    public boolean wasSpinningCyclone = false;
    public boolean typPoruszania;
    public byte yGoOnBack = (byte)15;
    public Weapon weapon;
    public boolean jaBije = false;
    public static int COLLISION_DELTA_X = 2560;
    public static int COLLISION_DELTA_Y = 10240;
    static boolean raz = false;
    public byte numerOfHits = 0;
    public byte numerGoodKneeHit = 0;
    public long TIME_HIT_RESET = 3000L;
    public int d1;
    public byte PUNCH_RANGE;
    public byte KICK_RANGE;
    public static byte JUMP_KICK_RANGE;
    public static byte Y_RANGE;
    private Hero rhero;
    private Hero khero;
    private byte[] handPos;
    private boolean czyUdalSieKneeKick;
    private boolean czyUdalSieHypierUpperCut;
    public int KICK_DELTA = 4608;
    public byte kierunekUderzenia;
    public boolean haveWeapon = false;
    public boolean weGonaJump = false;
    public boolean wasDisappeart = false;
    public Point watingZone;
    public Point attackZone;
    public Point lastHeroPoz;
    public byte nextAttack;
    public byte lastAttack;
    public byte indexAttack = 1;
    public boolean jumpKick = false;
    public int heroFrameWidthFP = 2048;
    public int heroFrameHeightFP = 11264;
    private byte ilePunchow;
    public int score = 0;
    public int colX1;
    public int colX2;
    public int colY1;
    public int colY2;
    public int atakX1;
    public int atakX2;
    public int atakY1;
    public int atakY2;
    public byte[] damage;
    public byte typeAttackCount;
    public short immortalityTime = 0;
    public int TIME_ATTACK_GAP = 200;
    public String heroImage;
    public boolean jumpIntoWater;
    public static byte whoLastDecide;
    Weapon weaponOnGround = null;
    private static final Random RANDOM;
    public static final byte W_SRODKU = 0;
    public static final byte POZA = 1;
    public static final byte ZABLISKO = -1;
    public static final byte START = 1;
    public static final byte IN_PROGRESS = 0;
    public static final byte STOP = -1;
    public static final short ENEMY_TYPE_WILL = 1;
    public static final short ENEMY_TYPE_ROPER = 2;
    public static final short ENEMY_TYPE_LINDA = 4;
    public static final short ENEMY_TYPE_BURNOV = 8;
    public static final short ENEMY_TYPE_RIGHTARM = 16;
    public static final short ENEMY_TYPE_NINJA = 32;
    public static final short ENEMY_TYPE_BOLO = 64;
    public static final short ENEMY_TYPE_ABORE = 65;
    public static final short ENEMY_TYPE_CHINE = 66;
    public static final short ENEMY_TYPE_MEGA_BOSS = 67;
    public static final short ENEMY_TYPE_ILLUSION = 68;
    public static final short[] enemyTypesTable;
    public static boolean hasWeapoon;
    public static final byte STAN_NOTHING = 0;
    public static final byte STAN_MOVING = 1;
    public static final byte STAN_RUN = 2;
    public static final byte STAN_GOONBACK = 3;
    public static final byte STAN_ATTACK = 4;
    public static final byte STAN_WAITING = 5;
    public static final byte STAN_SZARZA = 6;
    public static final byte BRAK = -1;
    public static final byte POSTUJ = 0;
    public static final byte CZEKAJ = 1;
    public static final byte IDZ = 2;
    public static final byte BIEGNIJ = 3;
    public static final byte NATYL = 4;
    public static final byte PODCHODZE = 5;
    public static final byte ATAKUJE = 6;
    public static final byte DOSTALEM = 7;
    public static final byte DRABINA = 8;
    public static final byte DOSTALEM_POWERA = 9;
    public static final byte SKACZE = 10;
    public static final byte SPADAM = 11;
    public static final byte KOLOANKO_GRAB = 12;
    public static final byte FLY = 13;
    public static final byte DO_JUMP_KICK = 14;
    public static final byte SZARZA = 15;
    public static final byte KUCAM = 16;
    public static final byte DO_THROW_ITEM = 17;
    public static final byte RZUCAM = 18;
    public static final byte PO_HIT = 19;
    public static final byte KONTRA = 20;
    public static final byte NIE_MYSLE = 21;
    static Point[] heroWaiting;
    static Point[] heroAttack;
    static byte DISTANCE_PLAYER_IN_AIR;
    static short offset;
    static byte los;
    static byte wynik;
    static boolean fantomBall;
    static Hero gracz;
    static Hero komp;
    static Hero ten2;
    static byte ktoryAttack;
    static short placeWhenCanJump;
    static short placeWhenCanThorow;
    static int[] d;
    static int trueDelta;
    static byte whoDecide;
    static int pozx;
    static int pozy;
    static Point pp;

    public Hero(int heroX, int heroY, int sectorNumber, Level level, int ktoryWrog, int idd) {
        this.fp_heroX = heroX << 8;
        this.fp_heroY = heroY << 8;
        this.currentSector = sectorNumber;
        this.currentRegionX = 0;
        this.currentRegionY = 0;
        this.id = idd;
        this.visible = true;
        this.damage = new byte[5];
        this.jumpIntoWater = false;
        this.level = level;
        try {
            if (ktoryWrog == 0) {
                this.heroAnimation = new SpriteAnimationSet(new DataInputStream(this.getClass().getResourceAsStream("/billy.anim.frames")), new DataInputStream(this.getClass().getResourceAsStream("/billy.sas.dsc")), null);
                byte[] b = new byte[1];
                this.heroAnimation.tilesImage = new TilesImage(new DataInputStream(b.getClass().getResourceAsStream("/billy.tiles")));
                this.heroSprite = new AnimatedSprite(this.heroAnimation, -1, 65536);
                this.isComputer = false;
                this.life = (short)89;
                this.lives = (byte)3;
                this.stanAkcji = 0;
                this.PUNCH_RANGE = (byte)28;
                this.KICK_RANGE = (byte)33;
                JUMP_KICK_RANGE = (byte)35;
                byte[] hand = new byte[]{3, -27, -8, -41, -8, -51, 24, -36, 33, -17};
                this.handPos = hand;
            } else {
                String animation = null;
                this.life = (short)8;
                this.PUNCH_RANGE = (byte)30;
                this.KICK_RANGE = (byte)40;
                JUMP_KICK_RANGE = (byte)35;
                this.inicjatywa = (short)200;
                switch (ktoryWrog) {
                    case 1: {
                        this.enemyType = 1;
                        animation = "/bob";
                        byte[] hand = new byte[]{0, -19, -11, -35, -11, -45, 13, -17, 22, -17};
                        this.handPos = hand;
                        this.canRun = true;
                        this.canRotate = true;
                        this.can2KickToStunt = false;
                        if (GameAppState.levelNumber != 4) {
                            this.kindOfAttack[0] = 45;
                            this.kindOfAttack[1] = 44;
                            this.kindOfAttack[2] = 43;
                            this.kindOfAttack[3] = -1;
                            this.kindOfAttack[4] = -1;
                            this.probabilty[0] = 60;
                            this.probabilty[1] = 30;
                            this.probabilty[2] = 10;
                            this.probabilty[3] = 0;
                            this.probabilty[4] = 0;
                            this.typeAttackCount = (byte)3;
                        } else {
                            this.kindOfAttack[0] = 45;
                            this.kindOfAttack[1] = 44;
                            this.kindOfAttack[2] = -1;
                            this.kindOfAttack[3] = -1;
                            this.kindOfAttack[4] = -1;
                            this.probabilty[0] = 55;
                            this.probabilty[1] = 45;
                            this.probabilty[2] = 0;
                            this.probabilty[3] = 0;
                            this.probabilty[4] = 0;
                            this.typeAttackCount = (byte)2;
                        }
                        this.watingZone = new Point(46, 10);
                        this.attackZone = new Point(21, 4);
                        this.typeAttackCount = (byte)3;
                        break;
                    }
                    case 2: {
                        this.enemyType = (short)2;
                        animation = "/zielony";
                        byte[] hand2 = new byte[]{4, -20, -11, -45, -11, -55, 13, -17, 22, -17};
                        this.handPos = hand2;
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = 43;
                        this.kindOfAttack[2] = -1;
                        this.kindOfAttack[3] = -1;
                        this.kindOfAttack[4] = -1;
                        this.probabilty[0] = 80;
                        this.probabilty[1] = 20;
                        this.probabilty[2] = 0;
                        this.probabilty[3] = 0;
                        this.probabilty[4] = 0;
                        this.watingZone = new Point(46, 10);
                        this.attackZone = new Point(20, 4);
                        this.typeAttackCount = (byte)2;
                        this.can2KickToStunt = false;
                        break;
                    }
                    case 4: {
                        this.enemyType = (short)4;
                        animation = "/babka";
                        byte[] hand1 = new byte[]{-1, -20, -11, -35, -11, -45, 22, -33, 31, -17};
                        this.handPos = hand1;
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = 44;
                        this.kindOfAttack[2] = 29;
                        this.kindOfAttack[3] = -1;
                        this.kindOfAttack[4] = -1;
                        this.probabilty[0] = 50;
                        this.probabilty[1] = 20;
                        this.probabilty[2] = 30;
                        this.probabilty[3] = 0;
                        this.probabilty[4] = 0;
                        this.watingZone = new Point(50, 10);
                        this.attackZone = new Point(20, 4);
                        this.typeAttackCount = (byte)3;
                        this.can2KickToStunt = false;
                        break;
                    }
                    case 8: {
                        this.enemyType = (short)8;
                        this.PUNCH_RANGE = (byte)40;
                        animation = "/iron";
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = 18;
                        this.kindOfAttack[2] = -1;
                        this.kindOfAttack[3] = -1;
                        this.kindOfAttack[4] = -1;
                        this.probabilty[0] = 90;
                        this.probabilty[1] = 10;
                        this.probabilty[2] = 0;
                        this.probabilty[3] = 0;
                        this.probabilty[4] = 0;
                        this.canGrab = false;
                        this.can2Punch = false;
                        this.canUppercut = false;
                        this.canOnePunch = true;
                        this.PUNCH_RANGE = (byte)35;
                        this.watingZone = new Point(40, 10);
                        this.attackZone = new Point(35, 4);
                        this.typeAttackCount = (byte)2;
                        this.INICJATYWA_BASE = (short)350;
                        this.INICJATYWA_START = (short)100;
                        this.heroFrameWidthFP = 2304;
                        break;
                    }
                    case 32: {
                        this.enemyType = (short)32;
                        animation = "/ninja";
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = 29;
                        this.kindOfAttack[2] = 31;
                        this.kindOfAttack[3] = 37;
                        this.kindOfAttack[4] = 30;
                        this.probabilty[0] = 40;
                        this.probabilty[1] = 40;
                        this.probabilty[2] = 10;
                        this.probabilty[3] = 10;
                        this.probabilty[4] = 0;
                        this.canGrab = false;
                        this.watingZone = new Point(55, 10);
                        this.PUNCH_RANGE = (byte)35;
                        this.attackZone = new Point(30, 4);
                        this.canUppercut = false;
                        this.canJump = true;
                        this.canOnePunch = false;
                        this.can2Punch = false;
                        this.canStayDown = false;
                        this.moveSpeedJumpHero = 25344;
                        this.jumpVelocityBeginHero = -70400;
                        this.INICJATYWA_BASE = (short)200;
                        this.INICJATYWA_START = (short)100;
                        this.typeAttackCount = (byte)5;
                        this.heroFrameWidthFP = 2304;
                        break;
                    }
                    case 16: {
                        this.enemyType = (short)16;
                        animation = "/frank";
                        if (GameAppState.levelNumber != 4) {
                            this.kindOfAttack[0] = 45;
                            this.kindOfAttack[1] = 38;
                            this.kindOfAttack[2] = 29;
                            this.kindOfAttack[3] = 43;
                            this.kindOfAttack[4] = -1;
                            this.probabilty[0] = 15;
                            this.probabilty[1] = 40;
                            this.probabilty[2] = 30;
                            this.probabilty[3] = 15;
                            this.probabilty[4] = 0;
                            this.typeAttackCount = (byte)4;
                        } else {
                            this.kindOfAttack[0] = 45;
                            this.kindOfAttack[1] = 38;
                            this.kindOfAttack[2] = 29;
                            this.kindOfAttack[3] = -1;
                            this.kindOfAttack[4] = -1;
                            this.probabilty[0] = 35;
                            this.probabilty[1] = 30;
                            this.probabilty[2] = 35;
                            this.probabilty[3] = 0;
                            this.probabilty[4] = 0;
                            this.typeAttackCount = (byte)3;
                        }
                        this.watingZone = new Point(40, 10);
                        this.attackZone = new Point(28, 4);
                        this.PUNCH_RANGE = (byte)29;
                        this.KICK_RANGE = (byte)29;
                        this.canUppercut = false;
                        break;
                    }
                    case 65: {
                        this.enemyType = (short)65;
                        animation = "/bambo";
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = 29;
                        this.kindOfAttack[2] = 15;
                        this.kindOfAttack[3] = -1;
                        this.kindOfAttack[4] = -1;
                        this.probabilty[0] = 45;
                        this.probabilty[1] = 45;
                        this.probabilty[2] = 10;
                        this.probabilty[3] = 0;
                        this.probabilty[4] = 0;
                        this.watingZone = new Point(50, 10);
                        this.attackZone = new Point(33, 4);
                        this.PUNCH_RANGE = (byte)34;
                        this.KICK_RANGE = (byte)40;
                        this.canGrab = false;
                        this.canUppercut = false;
                        this.typeAttackCount = (byte)3;
                        this.INICJATYWA_BASE = (short)400;
                        this.INICJATYWA_START = (short)100;
                        this.heroFrameWidthFP = 2304;
                        this.canContra = true;
                        break;
                    }
                    case 64: {
                        this.enemyType = (short)64;
                        animation = "/yeti";
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = 29;
                        this.kindOfAttack[2] = 44;
                        this.kindOfAttack[3] = -1;
                        this.kindOfAttack[4] = -1;
                        this.probabilty[0] = 10;
                        this.probabilty[1] = 45;
                        this.probabilty[2] = 45;
                        this.probabilty[3] = 0;
                        this.probabilty[4] = 0;
                        this.watingZone = new Point(50, 10);
                        this.attackZone = new Point(33, 4);
                        this.PUNCH_RANGE = (byte)34;
                        this.KICK_RANGE = (byte)40;
                        this.canGrab = false;
                        this.can2Punch = false;
                        this.canUppercut = false;
                        this.typeAttackCount = (byte)3;
                        this.canStayDown = false;
                        this.INICJATYWA_BASE = (short)400;
                        this.INICJATYWA_START = (short)100;
                        this.heroFrameWidthFP = 2304;
                        this.canContra = true;
                        break;
                    }
                    case 67: {
                        this.enemyType = (short)67;
                        animation = "/boss";
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = 40;
                        this.kindOfAttack[2] = 39;
                        this.kindOfAttack[3] = 29;
                        this.kindOfAttack[4] = 27;
                        this.probabilty[0] = 20;
                        this.probabilty[1] = 20;
                        this.probabilty[2] = 15;
                        this.probabilty[3] = 15;
                        this.probabilty[4] = 30;
                        this.watingZone = new Point(60, 10);
                        this.attackZone = new Point(35, 4);
                        this.PUNCH_RANGE = (byte)35;
                        this.KICK_RANGE = (byte)40;
                        this.KICK_DELTA = 9216;
                        this.can2Punch = false;
                        this.canGrab = false;
                        this.canUppercut = false;
                        this.canOnePunch = true;
                        this.canStayDown = false;
                        this.typeAttackCount = (byte)5;
                        this.INICJATYWA_BASE = 0;
                        this.INICJATYWA_START = (short)200;
                        this.canContra = true;
                        break;
                    }
                    case 66: {
                        this.enemyType = (short)66;
                        animation = "/chine";
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = 43;
                        this.kindOfAttack[2] = 41;
                        this.kindOfAttack[3] = -1;
                        this.kindOfAttack[4] = -1;
                        this.probabilty[0] = 40;
                        this.probabilty[1] = 30;
                        this.probabilty[2] = 30;
                        this.probabilty[3] = 0;
                        this.probabilty[4] = 0;
                        this.jumpVelocityBeginHero = -70400;
                        this.watingZone = new Point(60, 10);
                        this.PUNCH_RANGE = (byte)33;
                        this.attackZone = new Point(32, 4);
                        this.canGrab = false;
                        this.canUppercut = false;
                        this.typeAttackCount = (byte)3;
                        this.INICJATYWA_BASE = (short)125;
                        break;
                    }
                    case 68: {
                        this.enemyType = (short)68;
                        animation = "/fantom";
                        this.kindOfAttack[0] = 29;
                        this.kindOfAttack[1] = 44;
                        this.kindOfAttack[2] = 38;
                        this.kindOfAttack[3] = 31;
                        this.kindOfAttack[4] = -1;
                        this.probabilty[0] = 30;
                        this.probabilty[1] = 30;
                        this.probabilty[2] = 20;
                        this.probabilty[3] = 20;
                        this.probabilty[4] = 0;
                        this.watingZone = new Point(50, 10);
                        this.attackZone = new Point(32, 4);
                        this.KICK_RANGE = (byte)36;
                        this.PUNCH_RANGE = (byte)33;
                        this.KICK_DELTA = 6144;
                        this.canGrab = false;
                        this.typeAttackCount = (byte)3;
                        this.INICJATYWA_BASE = (short)150;
                        this.INICJATYWA_START = (short)100;
                        break;
                    }
                    default: {
                        this.enemyType = 1;
                        animation = "/bob";
                        byte[] hand3 = new byte[]{-1, -20, -11, -35, -11, -55, 13, -17, 22, -17};
                        this.handPos = hand3;
                        this.kindOfAttack[0] = 45;
                        this.kindOfAttack[1] = -1;
                        this.kindOfAttack[2] = -1;
                        this.kindOfAttack[3] = -1;
                        this.kindOfAttack[4] = -1;
                        this.probabilty[0] = 100;
                        this.probabilty[1] = 0;
                        this.probabilty[2] = 0;
                        this.probabilty[3] = 0;
                        this.probabilty[4] = 0;
                        this.typeAttackCount = 1;
                    }
                }
                this.heroAnimation = new SpriteAnimationSet(new DataInputStream(this.getClass().getResourceAsStream(animation + ".anim.frames")), new DataInputStream(this.getClass().getResourceAsStream(animation + ".sas.dsc")), null);
                this.heroSprite = new AnimatedSprite(this.heroAnimation, -1, 65536);
                this.heroImage = animation + ".tiles";
                this.isComputer = true;
                this.stanAkcji = 0;
                this.akcja = 1;
                this.actionFinish = true;
                this.actionInProgress = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initialize();
    }

    public byte getAttack() {
        if (this.enemyType == 68 || this.enemyType == 67 || this.enemyType == 32) {
            if (this.indexAttack == 1) {
                byte p;
                this.nextAttack = p = this.losAttack(0);
                this.indexAttack = 0;
            }
            return this.nextAttack;
        }
        if (this.indexAttack == 1) {
            byte p;
            this.lastAttack = this.nextAttack;
            while ((p = this.losAttack(0)) == this.lastAttack) {
            }
            if (p == this.kindOfAttack[0]) {
                this.ilePunchow = this.enemyType == 8 ? (byte)(Hero.random(4) + 2) : (byte)(Hero.random(3) + 1);
            }
            this.nextAttack = p;
            this.indexAttack = 0;
        }
        if (this.weapon != null && (this.weapon.weaponType == 4 || this.weapon.weaponType == 6)) {
            this.indexOfKtoryAttak = 0;
            return 45;
        }
        if (this.nextAttack == this.kindOfAttack[0]) {
            this.indexOfKtoryAttak = 0;
            if (this.can2Punch) {
                return (byte)(45 + (this.ilePunchow & 1));
            }
            return 45;
        }
        this.indexOfKtoryAttak = this.indexAttack;
        return this.nextAttack;
    }

    private byte losAttack(int wej) {
        if (this.typeAttackCount <= 2) {
            wej = 0;
        }
        byte pro = (byte)Hero.random(100 - wej);
        for (int p = wej == 0 ? 0 : 1; p < this.probabilty.length; p = (int)((byte)(p + 1))) {
            if ((pro = (byte)(pro - this.probabilty[p])) >= 0) continue;
            return this.kindOfAttack[p];
        }
        return -1;
    }

    public void nextAttak() {
        if (this.nextAttack == this.kindOfAttack[0] && this.enemyType != 68) {
            this.ilePunchow = (byte)(this.ilePunchow - 1);
            if (this.ilePunchow <= 0) {
                this.indexAttack = (byte)(this.indexAttack + 1);
            }
        } else {
            this.indexAttack = (byte)(this.indexAttack + 1);
        }
    }

    public void initialize() {
        if (this.heroSprite != null) {
            this.heroSprite.setAnimation("stand", 0);
        }
        this.state = 1;
        this.orientation = 0;
        this.nextSectorFall = -1;
    }

    public void addWeapon(Weapon weapon) {
        this.weapon = weapon;
        this.haveWeapon = true;
    }

    private void update_init1(int deltaTime) {
        this.immortalityTime = this.immortalityTime > 0 ? (short)(this.immortalityTime - deltaTime) : (short)0;
        this.weaponOnGround = null;
        for (int i = 0; i < GameAppState.weaponsCount; ++i) {
            if (this.weapon != null || GameAppState.weapons[i].state != 2 || !GameAppState.weapons[i].canPickUpWeapon(this.fp_heroX, this.fp_heroY)) continue;
            this.weaponOnGround = GameAppState.weapons[i];
        }
    }

    private void update_init2(int deltaTime) {
        if (!this.isComputer) {
            this.stepRight = 0;
            this.stepDown = 0;
            this.jump = 0;
            this.diagonalJump = 0;
            this.attack[0] = 0;
            this.attack[1] = 0;
            this.stepRight = GameAppState.czasKlawisza[0] - GameAppState.czasKlawisza[1];
            this.stepDown = GameAppState.czasKlawisza[3] - GameAppState.czasKlawisza[2];
            this.jump = GameAppState.czasKlawisza[6];
            this.diagonalJump = GameAppState.czasKlawisza[7];
            this.attack[0] = GameAppState.czasKlawisza[4];
            this.attack[1] = GameAppState.czasKlawisza[5];
            if (GameAppState.czasKlawisza[8] != 0) {
                if (this.orientation == 0) {
                    this.attack[0] = GameAppState.czasKlawisza[8];
                } else {
                    this.attack[1] = GameAppState.czasKlawisza[8];
                }
            }
            for (int i = 4; i < 7; ++i) {
                if (GameAppState.czasKlawisza[i] == 0) continue;
                GameAppState.stanKlawisza[i] = 0;
            }
            raz = true;
        }
    }

    private void update_init3(int deltaTime) {
        if (this.isComputer) {
            if (GameAppState.levelNumber == 2 && this.level.currentRegion == 3 && this.currentSector == 11) {
                GameAppState.removeEnemy(this.id);
            }
            if (GameAppState.levelNumber == 5) {
                if (this.level.currentRegion == 0 && this.currentSector == 1) {
                    GameAppState.removeEnemy(this.id);
                }
                if (this.level.currentRegion == 4 && this.currentSector == 16) {
                    GameAppState.removeEnemy(this.id);
                }
            }
            if (raz && !this.inAir()) {
                Hero.decision(deltaTime);
                raz = false;
            }
            if (this.enemyType == 67) {
                if (this.visible && !this.fading) {
                    this.fTime += deltaTime;
                    if (this.fTime > this.VISIBLE_TIME) {
                        this.fTime -= this.VISIBLE_TIME;
                        this.fading = true;
                        this.visible = false;
                        this.FADING_VISIBLE_TIME = this.HALF_VISIBLE_TIME - this.INVISIBLE_TIME;
                    }
                } else if (!this.visible && !this.fading) {
                    this.fTime += deltaTime;
                    if (this.fTime > this.VISIBLE_TIME) {
                        this.fTime -= this.VISIBLE_TIME;
                        this.visible = true;
                    }
                } else {
                    this.fTime += deltaTime;
                    if (this.visible && this.fTime > this.FADING_VISIBLE_TIME) {
                        this.fTime -= this.FADING_VISIBLE_TIME;
                        this.FADING_VISIBLE_TIME -= this.INVISIBLE_TIME;
                        if (this.FADING_VISIBLE_TIME <= 100) {
                            this.fading = false;
                            this.visible = false;
                        }
                        this.visible = false;
                    }
                    if (!this.visible && this.fTime > this.INVISIBLE_TIME) {
                        this.fTime -= this.INVISIBLE_TIME;
                        this.visible = true;
                    }
                }
            }
        }
    }

    private void update_init4(int deltaTime) {
        if (GameAppState.doorOpened && GameAppState.levelNumber == 3) {
            int dx = this.fp_heroX - 48896;
            int dy = this.fp_heroY - 48896;
            if (dx > 0) {
                this.fp_heroX -= 256;
            }
            if (dx < 0) {
                this.fp_heroX += 256;
            }
            if (this.fp_heroY > 44544) {
                this.fp_heroY -= 256;
            }
            if (this.fp_heroX > 44800 && this.fp_heroX < 53248 && this.fp_heroY <= 44800) {
                if (this.isComputer) {
                    GameAppState.removeEnemy(this.id);
                } else if (!this.inAir() && this.state != 0) {
                    this.changeState((byte)8, 0);
                    GameAppState.drawHeroFirst = true;
                    if (this.lives == 0) {
                        this.onPlayerKilled();
                    }
                }
            }
        }
    }

    private void update_init5(int deltaTime) {
        if (GameAppState.levelNumber == 10 && this.fp_heroX >> 8 > 130 && GameAppState.levelRequested == -1) {
            GameAppState.levelRequested = (byte)(GameAppState.levelNumber + 1);
            GameAppState.fadeOutIn();
        }
        if (this.enemyType == 32) {
            if (this.orientation == 1) {
                this.colX1 = (this.fp_heroX - this.heroFrameWidthFP >> 8) + 2;
                this.colX2 = this.fp_heroX + this.heroFrameWidthFP >> 8;
            } else {
                this.colX1 = this.fp_heroX - this.heroFrameWidthFP >> 8;
                this.colX2 = (this.fp_heroX + this.heroFrameWidthFP >> 8) - 2;
            }
        } else {
            this.colX1 = this.fp_heroX - this.heroFrameWidthFP >> 8;
            this.colX2 = this.fp_heroX + this.heroFrameWidthFP >> 8;
        }
        this.colY1 = this.fp_heroY >> 8;
        this.colY2 = this.state != 9 ? this.fp_heroY - this.heroFrameHeightFP >> 8 : this.fp_heroY >> 8;
    }

    private void update_init6(int deltaTime) {
        if (this.orientation == 1) {
            this.atakX1 = this.fp_heroX - this.KICK_DELTA >> 8;
            this.atakX2 = this.fp_heroX - (this.KICK_DELTA >> 1) >> 8;
        } else {
            this.atakX1 = this.fp_heroX + (this.KICK_DELTA >> 1) >> 8;
            this.atakX2 = this.fp_heroX + this.KICK_DELTA >> 8;
        }
        if (this.state == 48) {
            if (GameAppState.heros[1] != null && GameAppState.heros[1].enemyType == 32) {
                this.atakX1 = (this.fp_heroX - this.KICK_DELTA >> 8) - 12;
                this.atakX2 = (this.fp_heroX + this.KICK_DELTA >> 8) + 12;
            } else {
                this.atakX1 = (this.fp_heroX - this.KICK_DELTA >> 8) - 5;
                this.atakX2 = (this.fp_heroX + this.KICK_DELTA >> 8) + 5;
            }
            this.atakY1 = (this.fp_heroY >> 8) + 12;
            this.atakY2 = this.fp_heroY - this.heroFrameHeightFP / 2 >> 8;
        } else if (this.state == 39 || this.state == 27) {
            this.atakX1 = this.fp_heroX - this.KICK_DELTA >> 8;
            this.atakX2 = this.fp_heroX + this.KICK_DELTA >> 8;
            this.atakY1 = (this.fp_heroY >> 8) + 15;
            this.atakY2 = this.fp_heroY - this.heroFrameHeightFP / 2 >> 8;
        } else if (this.state == 49) {
            if (GameAppState.heros[1] != null && (GameAppState.heros[1].enemyType == 8 || GameAppState.heros[1].enemyType == 67 || GameAppState.heros[1].enemyType == 64 || GameAppState.heros[1].enemyType == 65)) {
                if (this.orientation == 1) {
                    this.atakX1 = (this.fp_heroX - this.KICK_DELTA >> 8) - 4;
                    this.atakX2 = this.fp_heroX - (this.KICK_DELTA >> 1) >> 8;
                } else {
                    this.atakX1 = this.fp_heroX + (this.KICK_DELTA >> 1) >> 8;
                    this.atakX2 = (this.fp_heroX + this.KICK_DELTA >> 8) + 4;
                }
            }
            this.atakY1 = this.fp_heroY >> 8;
            this.atakY2 = this.fp_heroY - this.heroFrameHeightFP / 2 >> 8;
        } else {
            this.atakY1 = this.fp_heroY >> 8;
            this.atakY2 = this.fp_heroY - this.heroFrameHeightFP / 2 >> 8;
        }
        this.timeAfterHit += (long)deltaTime;
        if (this.timeAfterHit > this.TIME_HIT_RESET) {
            this.timeAfterHit -= this.TIME_HIT_RESET;
            this.numerOfHits = 0;
        }
    }

    private void update_move1(int deltaTime) {
        this.timeAfterPunch += deltaTime;
        if (this.level.sectorType[this.currentSector] == 3) {
            this.fp_heroX -= 512;
        }
        if (this.level.sectorType[this.currentSector] == 4) {
            this.fp_heroX += 512;
        }
        if (!(this.level.sectorType[this.currentSector] != 6 || GameAppState.levelNumber == 7 && this.currentSector == 9 && GameAppState.animations[1].state == 2 || GameAppState.levelNumber == 7 && this.currentSector == 10 && GameAppState.animations[2].state == 2 || GameAppState.levelNumber == 7 && this.currentSector == 14 && GameAppState.animations[3].state == 2)) {
            this.fp_heroX -= 256;
        }
        if (!(this.level.sectorType[this.currentSector] != 7 || GameAppState.levelNumber == 7 && this.currentSector == 7 && GameAppState.animations[0].state == 2 || GameAppState.levelNumber == 7 && this.currentSector == 17 && GameAppState.animations[4].state == 2)) {
            this.fp_heroX += 256;
        }
        if (this.attack[this.orientation] != 0) {
            this.continuePunch = true;
            this.continueKick = false;
        }
        if (this.attack[this.orientation + 1 & 1] != 0) {
            this.continuePunch = false;
            this.continueKick = true;
        }
        if (this.timeAfterPunch >= this.TIME_ATTACK_GAP) {
            this.timeAfterPunch = 0;
        }
    }

    private boolean update_move2(int deltaTime) {
        if (this.continuePunch && this.timeAfterPunch == 0) {
            this.continuePunch = false;
            if (this.weaponOnGround != null && !this.isComputer) {
                this.pickUpWeapon(this.weaponOnGround);
                this.changeState((byte)11, 0);
            } else if (this.weapon != null && !this.isComputer) {
                if (this.weapon.weaponType == 4) {
                    this.changeState((byte)33, 0);
                } else if (this.weapon.weaponType == 6) {
                    this.changeState((byte)34, 0);
                } else {
                    this.changeState((byte)31, 0);
                }
            } else if (this.weapon != null && this.isComputer && (this.weapon.weaponType == 4 || this.weapon.weaponType == 6)) {
                if (this.weapon.weaponType == 4) {
                    this.changeState((byte)33, 0);
                } else if (this.weapon.weaponType == 6) {
                    this.changeState((byte)34, 0);
                }
            } else if (this.canOnePunch) {
                this.changeState((byte)45, 0);
            } else {
                this.punchOrientation = (byte)(this.punchOrientation + 1);
                this.changeState((byte)(45 + (this.punchOrientation & 1)), 0);
            }
            return true;
        }
        if (this.continueKick && this.timeAfterPunch == 0) {
            this.continueKick = false;
            if (this.weapon != null && !this.isComputer) {
                if (this.weapon.weaponType == 4) {
                    this.changeState((byte)31, 0);
                }
            } else {
                this.changeState((byte)47, 0);
            }
            return true;
        }
        if (this.jump != 0) {
            this.changeState((byte)3, this.stepRight);
            return true;
        }
        if (this.diagonalJump != 0) {
            if (this.orientation == 0) {
                this.changeState((byte)3, 1);
            } else {
                this.changeState((byte)3, -1);
            }
            return true;
        }
        if (!this.isComputer && this.stepRight != 0 && this.checkHit(this.PUNCH_RANGE, false) != null) {
            Hero rhero = this.checkHit(this.PUNCH_RANGE, false);
            if (rhero.state == 25 && rhero.canGrab) {
                this.changeState((byte)12, 0);
                rhero.orientation = this.orientation == 1 ? (byte)0 : 1;
                rhero.changeState((byte)13, 0);
                this.khero = rhero;
            }
        }
        return false;
    }

    private boolean update_climb1(int deltaTime) {
        if (this.stepRight != 0 || this.stepDown != 0) {
            if (this.state == 1 && this.state != 10 && this.state != 26) {
                this.changeState((byte)2, this.stepRight);
            }
            if (!this.isComputer) {
                if (this.stepRight > 0) {
                    this.orientation = 0;
                }
                if (this.stepRight < 0) {
                    this.orientation = 1;
                }
            }
            if (!this.isComputer) {
                this.fp_heroX += this.stepRight * this.moveSpeedPerMS >> 10;
                this.fp_heroY += this.stepDown * this.moveSpeedPerMS >> 10;
            } else {
                this.fp_heroX += this.stepRight * this.moveSpeedEnemyPerMS >> 10;
                this.fp_heroY += this.stepDown * this.moveSpeedEnemyPerMS >> 10;
            }
            if (this.level.sectorType[this.currentSector] == 5 && this.stepRight != 0 && !this.isComputer) {
                this.fp_heroY += this.stepRight * this.moveSpeedPerMS >> 10;
            }
        } else {
            this.changeState((byte)1, this.stepRight);
        }
        this.checkSector();
        return false;
    }

    private boolean update_climb2(int deltaTime) {
        if (this.state == 2 || this.state == 5 || this.state == 1 || this.state == 10 || this.state == 26) {
            this.fp_lastX = this.fp_heroX;
            this.fp_lastY = this.fp_heroY;
            this.lastSector = this.currentSector;
            if (GameAppState.levelNumber == 1 && this.currentSector == 2) {
                this.fp_lastX = 164352;
                this.fp_lastY = 104960;
                this.lastSector = 2;
            }
            if (GameAppState.levelNumber == 3) {
                this.fp_lastX = 32000;
                this.fp_lastY = 50176;
                this.lastSector = 0;
            }
            if (GameAppState.levelNumber == 4 && this.level.currentRegion == 3) {
                this.fp_lastX = 315392;
                this.fp_lastY = 141312;
                this.lastSector = 2;
            }
            if (GameAppState.levelNumber == 6) {
                if (this.currentSector >= GameAppState.FIRST_PLATFORM2 && this.currentSector <= GameAppState.LAST_PLATFORM2) {
                    this.fp_lastX = 47360;
                    this.fp_lastY = 30720;
                    this.lastSector = 12;
                }
                if (this.currentSector >= 0 && this.currentSector <= GameAppState.LAST_PLATFORM1) {
                    this.fp_lastX = 157440;
                    this.fp_lastY = 26624;
                    this.lastSector = 19;
                }
            }
        }
        return false;
    }

    private boolean update_charge(int deltaTime) {
        this.fp_heroX += this.stepRight * this.moveSpeedEnemyPerMS >> 10;
        this.fp_heroY += this.stepDown * this.moveSpeedEnemyPerMS >> 10;
        this.checkSector();
        this.rhero = this.checkHit(this.PUNCH_RANGE, false);
        if (this.rhero != null && this.rhero.state != 16) {
            this.rhero.life = (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
            if (this.fp_heroX > this.rhero.fp_heroX) {
                this.rhero.kierunekUderzenia = (byte)-1;
                this.rhero.changeState((byte)16, -1);
            } else {
                this.rhero.kierunekUderzenia = 1;
                this.rhero.changeState((byte)16, 1);
            }
        }
        return false;
    }

    private boolean update_bosshit(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            GameAppState.heros[0].life = (short)(GameAppState.heros[0].life - this.damage[1]);
            this.numerGoodKneeHit = (byte)(this.numerGoodKneeHit + 1);
            if (this.numerGoodKneeHit <= 3) {
                this.changeState((byte)18, 0);
            } else {
                this.nextAttak();
                this.changeState((byte)1, 0);
                this.numerGoodKneeHit = 0;
                GameAppState.heros[0].changeState((byte)16, GameAppState.heros[0].kierunekUderzenia);
                GameAppState.heros[0].flySpeedX = 34496;
            }
        }
        return false;
    }

    private boolean update_kolanko1(int deltaTime) {
        this.khero.fp_heroX = this.orientation == 0 ? this.fp_heroX + 7680 : this.fp_heroX - 7680;
        this.timeAfterPunch += deltaTime;
        if (this.attack[this.orientation] != 0) {
            this.continuePunch = true;
            this.continueKick = false;
        }
        if (this.attack[this.orientation + 1 & 1] != 0) {
            this.continuePunch = false;
            this.continueKick = true;
        }
        if (this.timeAfterPunch >= this.TIME_ATTACK_GAP) {
            this.timeAfterPunch = 0;
        }
        return false;
    }

    private boolean update_kolanko2(int deltaTime) {
        if (this.continuePunch && this.timeAfterPunch == 0) {
            this.continuePunch = false;
            if (this.stepDown > 0) {
                this.changeState((byte)35, 0);
            } else if (this.stepDown < 0) {
                this.khero.life = (short)(this.khero.life - 1);
                this.changeState((byte)36, 0);
                if (this.orientation == 1) {
                    this.khero.kierunekUderzenia = (byte)(this.khero.kierunekUderzenia - 1);
                    this.khero.changeState((byte)16, -1);
                    this.khero.jumpVelocity = -57024;
                } else {
                    this.khero.kierunekUderzenia = 1;
                    this.khero.changeState((byte)16, 1);
                    this.khero.jumpVelocity = -57024;
                }
            } else {
                this.changeState((byte)32, 0);
            }
        } else if (this.continueKick && this.timeAfterPunch == 0) {
            this.khero.life = (short)(this.khero.life - 1);
            this.continueKick = false;
            this.changeState((byte)15, 0);
            if (this.orientation == 1) {
                this.khero.kierunekUderzenia = 1;
                this.khero.changeState((byte)14, -1);
                this.khero.jumpVelocity = -52800;
                this.khero.jumpBeginHeight = this.fp_heroY;
            } else {
                this.khero.kierunekUderzenia = (byte)-1;
                this.khero.changeState((byte)14, 1);
                this.khero.jumpVelocity = -52800;
                this.khero.jumpBeginHeight = this.fp_heroY;
            }
        }
        this.checkSector();
        return false;
    }

    private boolean update_kolankohit(int deltaTime) {
        this.khero.fp_heroX = this.orientation == 0 ? this.fp_heroX + 5120 : this.fp_heroX - 5120;
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.numerGoodKneeHit = (byte)(this.numerGoodKneeHit + 1);
            this.khero.life = (short)(this.khero.life - 1);
            if (!this.isComputer) {
                this.score += 10;
            }
            if (this.numerGoodKneeHit <= 5) {
                this.changeState((byte)12, 0);
                this.numerGoodKneeHit = (byte)(this.numerGoodKneeHit + 1);
            } else {
                this.changeState((byte)1, 0);
                this.numerGoodKneeHit = 0;
                if (this.khero.weapon != null) {
                    this.khero.dropWeapon();
                }
                if (this.khero.orientation == 1) {
                    this.khero.kierunekUderzenia = 1;
                    this.khero.changeState((byte)16, 1);
                } else {
                    this.khero.kierunekUderzenia = (byte)-1;
                    this.khero.changeState((byte)16, -1);
                }
            }
        }
        return false;
    }

    private boolean update_wykop(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * (this.heroSprite.currentSpriteAnimation.animationFramesCount - 1) && this.heroSprite.animationTime < this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount && this.isComputer) {
            GameAppState.heros[0].life = (short)(GameAppState.heros[0].life - this.damage[2]);
            if (this.orientation == 1) {
                GameAppState.heros[0].kierunekUderzenia = 1;
                GameAppState.heros[0].changeState((byte)16, 1);
                GameAppState.heros[0].jumpBeginHeight = this.fp_heroY;
                GameAppState.heros[0].jumpVelocity >>= 1;
                GameAppState.heros[0].flySpeedX = 34496;
            } else {
                GameAppState.heros[0].kierunekUderzenia = (byte)-1;
                GameAppState.heros[0].changeState((byte)16, -1);
                GameAppState.heros[0].jumpBeginHeight = this.fp_heroY;
                GameAppState.heros[0].jumpVelocity >>= 1;
                GameAppState.heros[0].flySpeedX = 34496;
            }
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            if (this.isComputer) {
                this.nextAttak();
            }
            this.changeState((byte)1, 0);
            this.timeAfterPunch = 0;
            this.continueKick = false;
            this.continuePunch = false;
        }
        return false;
    }

    private boolean update_jumpkick1(int deltaTime) {
        if (!this.shortJump) {
            this.fp_heroX += this.jumpDirection * deltaTime * this.moveSpeedJumpHero >> 10;
            this.fp_heroY += this.jumpVelocity * deltaTime >> 10;
            this.jumpVelocity += 140800 * deltaTime >> 10;
        } else {
            this.fp_heroX += this.jumpDirection * deltaTime * 17600 >> 10;
            this.fp_heroY += this.jumpVelocity * deltaTime >> 10;
            this.jumpVelocity += 140800 * deltaTime >> 10;
        }
        if (this.state == 43) {
            this.rhero = this.collisionJump();
            if (this.rhero != null) {
                this.rhero.life = !this.isComputer ? (short)(this.rhero.life - 2) : (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
                if (!this.isComputer) {
                    this.score += 100;
                }
                if (this.fp_heroX > this.rhero.fp_heroX) {
                    this.rhero.kierunekUderzenia = (byte)-1;
                    this.rhero.changeState((byte)16, -1);
                } else {
                    this.rhero.kierunekUderzenia = 1;
                    this.rhero.changeState((byte)16, 1);
                }
            }
        }
        return false;
    }

    private boolean update_jumpkick2(int deltaTime) {
        if (this.fp_heroY > this.jumpBeginHeight && this.jumpVelocity > 0) {
            this.fp_heroY = this.jumpBeginHeight;
            this.changeState((byte)7, 0);
            this.shortJump = false;
        }
        if (this.state == 3 && (this.attack[0] != 0 || this.attack[1] != 0)) {
            if (this.jumpVelocity > -8448 && this.jumpVelocity < 4224) {
                this.changeState((byte)48, 0);
            } else if (!this.wasSpinningCyclone) {
                this.changeState((byte)43, 0);
            }
        }
        int lastVel = this.jumpVelocity;
        this.checkSector();
        if (this.state == 4) {
            this.jumpVelocity = lastVel;
        }
        return false;
    }

    private boolean update_fall(int deltaTime) {
        this.fp_heroY += this.jumpVelocity * deltaTime >> 10;
        this.fp_heroX += this.jumpDirection * deltaTime * this.fallSpeedX >> 10;
        this.jumpVelocity += 140800 * deltaTime >> 10;
        if (!(this.nextSectorFall != -1 || this.jumpIntoWater || GameAppState.levelNumber != 5 || this.currentSector != 3 && this.currentSector != 4 && this.currentSector != 5 && this.currentSector != 6 && this.currentSector != 7 && this.currentSector != 8 && this.currentSector != 9 && this.currentSector != 10)) {
            this.jumpBeginHeight -= 19200;
            this.jumpIntoWater = true;
        }
        if (this.fp_heroY > this.jumpBeginHeight && this.jumpVelocity > 0) {
            if (this.nextSectorFall != -1) {
                this.currentSector = this.nextSectorFall;
                this.fp_heroY = this.jumpBeginHeight;
                this.nextSectorFall = -1;
            } else {
                if (this.jumpIntoWater) {
                    GameAppState.animations[7].setToStart();
                    GameAppState.animations[7].setState((byte)3);
                    GameAppState.animations[7].visible = true;
                    GameAppState.animPosX[7] = this.fp_heroX >> 8;
                    GameAppState.animPosY[7] = (this.fp_heroY >> 8) - 20;
                    this.jumpIntoWater = false;
                    if (!this.isComputer) {
                        this.changeState((byte)8, 0);
                        GameAppState.drawHeroFirst = true;
                    }
                }
                if (this.isComputer) {
                    GameAppState.removeEnemy(this.id);
                } else if (this.state == 4 && !this.isComputer) {
                    this.onPlayerKilled();
                }
            }
            if (this.state == 4) {
                if (this.life <= 0) {
                    this.changeState((byte)8, this.kierunekUderzenia);
                } else {
                    this.changeState((byte)1, 0);
                }
            }
        }
        return false;
    }

    private boolean update_spinningcyclone(int deltaTime) {
        this.rhero = this.collisionJump();
        if (this.rhero != null) {
            this.score += 100;
            this.rhero.life = (short)(this.rhero.life - 4);
            this.rhero.kierunekUderzenia = this.fp_heroX > this.rhero.fp_heroX ? (byte)-1 : (byte)1;
            this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
            this.rhero.fp_heroY -= Math.abs(this.rhero.fp_heroY - this.fp_heroY) >> 1;
        }
        if (this.heroSprite.animationTime > 900) {
            this.state = (byte)3;
            this.heroSprite.setAnimation("jump", 1000);
            this.jumpVelocity = 4224;
        }
        return false;
    }

    private boolean update_roundpunch(int deltaTime) {
        this.rhero = this.collisionJump();
        if (this.rhero != null) {
            this.rhero.life = (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
            this.rhero.kierunekUderzenia = this.fp_heroX > this.rhero.fp_heroX ? (byte)-1 : (byte)1;
            this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount * 3) {
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_bosskick(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * (this.heroSprite.currentSpriteAnimation.animationFramesCount - 3)) {
            this.rhero = this.checkHit(this.KICK_RANGE, false);
            if (this.rhero != null) {
                this.rhero.life = (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
                this.rhero.kierunekUderzenia = this.fp_heroX > this.rhero.fp_heroX ? (byte)-1 : (byte)1;
                this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
                this.rhero.jumpVelocity = -70400;
            }
        }
        this.fp_heroX = this.orientation == 1 ? (this.fp_heroX -= 128) : (this.fp_heroX += 128);
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_punch2(int deltaTime) {
        if (this.attack[this.orientation] != 0) {
            this.continuePunch = true;
            this.continueKick = false;
        }
        if (this.attack[this.orientation + 1 & 1] != 0) {
            this.continuePunch = false;
            this.continueKick = true;
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)1, 0);
            this.rhero = this.checkHit(this.PUNCH_RANGE, false);
            if (this.rhero != null) {
                this.rhero.numerOfHits = (byte)(this.rhero.numerOfHits + 1);
                if (this.rhero.numerOfHits == 1) {
                    this.timeAfterHit = 0L;
                }
                if (!this.isComputer) {
                    this.score += 10;
                    this.rhero.life = (short)(this.rhero.life - 1);
                } else {
                    this.rhero.life = (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
                }
                if (this.rhero.life <= 0) {
                    this.rhero.kierunekUderzenia = this.fp_heroX < this.rhero.fp_heroX ? (byte)1 : (byte)-1;
                    if (!this.isComputer) {
                        this.changeState((byte)44, 0);
                    }
                    this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
                } else if (this.rhero.numerOfHits <= 3) {
                    if (this.rhero.numerOfHits == 3) {
                        this.rhero.changeState((byte)25, 0);
                    } else {
                        this.rhero.changeState((byte)6, 0);
                    }
                }
            }
        }
        return false;
    }

    private boolean update_uppercut(int deltaTime) {
        if (this.attack[this.orientation] != 0) {
            this.continuePunch = true;
            this.continueKick = false;
        }
        if (this.attack[this.orientation + 1 & 1] != 0) {
            this.continuePunch = false;
            this.continueKick = true;
        }
        if (!this.isComputer && this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * (this.heroSprite.currentSpriteAnimation.animationFramesCount - 1)) {
            this.rhero = this.collisionJump();
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)1, 0);
            if (this.isComputer) {
                this.rhero = this.checkHit(this.PUNCH_RANGE, false);
            }
            if (this.rhero != null) {
                if (!this.isComputer) {
                    this.score += 100;
                    this.rhero.life = (short)(this.rhero.life - 1);
                } else {
                    this.rhero.life = (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
                }
                if (this.state == 49) {
                    if (this.fp_heroX > this.rhero.fp_heroX) {
                        this.rhero.kierunekUderzenia = (byte)-1;
                        this.rhero.changeState((byte)16, -1);
                        this.rhero.flySpeedX = 34496;
                    } else if (this.fp_heroX <= this.rhero.fp_heroX) {
                        this.rhero.kierunekUderzenia = 1;
                        this.rhero.changeState((byte)16, 1);
                        this.rhero.flySpeedX = 34496;
                    }
                } else if (this.fp_heroX > this.rhero.fp_heroX) {
                    this.rhero.kierunekUderzenia = (byte)-1;
                    this.rhero.changeState((byte)16, -1);
                } else if (this.fp_heroX <= this.rhero.fp_heroX) {
                    this.rhero.kierunekUderzenia = 1;
                    this.rhero.changeState((byte)16, 1);
                }
            }
        }
        return false;
    }

    private boolean update_kick(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)1, 0);
            this.rhero = this.checkHit(this.KICK_RANGE, true);
            if (this.rhero != null) {
                this.rhero.numerOfHits = (byte)(this.rhero.numerOfHits + 1);
                if (!this.isComputer) {
                    this.score += 10;
                }
                this.rhero.life = (short)(this.rhero.life - 1);
                if (this.rhero.state == 25) {
                    this.rhero.kierunekUderzenia = this.fp_heroX < this.rhero.fp_heroX ? (byte)1 : (byte)-1;
                    this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
                } else if (this.rhero.life <= 0) {
                    this.rhero.kierunekUderzenia = this.fp_heroX < this.rhero.fp_heroX ? (byte)1 : (byte)-1;
                    this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
                } else {
                    this.rhero.kierunekUderzenia = this.fp_heroX < this.rhero.fp_heroX ? (byte)1 : (byte)-1;
                    if (!this.rhero.can2KickToStunt) {
                        this.rhero.changeState((byte)25, 0);
                    } else {
                        this.rhero.numerGoodKneeHit = (byte)(this.rhero.numerGoodKneeHit + 1);
                        if (this.rhero.numerGoodKneeHit == 1) {
                            this.rhero.changeState((byte)6, 0);
                        } else if (this.rhero.numerGoodKneeHit >= 2) {
                            this.rhero.changeState((byte)25, 0);
                            this.rhero.numerGoodKneeHit = 0;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean update_lowkick(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * (this.heroSprite.currentSpriteAnimation.animationFramesCount - 2) && this.heroSprite.animationTime < this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.rhero = this.checkHit(this.KICK_RANGE, false);
            if (this.rhero != null) {
                this.rhero.life = (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
                this.rhero.kierunekUderzenia = this.fp_heroX > this.rhero.fp_heroX ? (byte)-1 : (byte)1;
                this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
            }
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_kickfront(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.rhero = this.checkHit(this.KICK_RANGE, false);
            if (this.rhero != null) {
                this.rhero.life = (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
                this.rhero.kierunekUderzenia = this.fp_heroX > this.rhero.fp_heroX ? (byte)-1 : (byte)1;
                this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
            }
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_powerfly(int deltaTime) {
        if (this.weapon != null) {
            this.dropWeapon();
        }
        this.fp_heroX += this.jumpDirection * deltaTime * this.flySpeedX >> 10;
        this.fp_heroY += this.jumpVelocity * deltaTime >> 10;
        this.jumpVelocity += 140800 * deltaTime >> 10;
        if (this.fp_heroY > this.jumpBeginHeight && this.jumpVelocity > 0) {
            this.fp_heroY = this.jumpBeginHeight;
            if (this.life <= 0) {
                if (this.isComputer && this.enemyType == 67 && GameAppState.levelNumber == 11) {
                    this.changeState((byte)23, this.kierunekUderzenia);
                } else {
                    this.changeState((byte)8, this.kierunekUderzenia);
                }
            } else {
                this.changeState((byte)17, this.kierunekUderzenia);
            }
        }
        int lastVel1 = this.jumpVelocity;
        this.checkSector();
        if (this.state == 4) {
            this.jumpVelocity = lastVel1;
            this.heroSprite.setAnimation("power_fly", 0);
        }
        return false;
    }

    private boolean update_bossrotatejump(int deltaTime) {
        this.fp_heroX += this.jumpDirection * deltaTime * 25344 >> 10;
        this.fp_heroY += this.jumpVelocity * deltaTime >> 10;
        this.jumpVelocity += 140800 * deltaTime >> 10;
        this.rhero = this.collisionJump();
        if (this.rhero != null) {
            this.rhero.life = !this.isComputer ? (short)(this.rhero.life - 2) : (short)(this.rhero.life - this.damage[this.indexOfKtoryAttak]);
            if (!this.isComputer) {
                this.score += 100;
            }
            if (this.fp_heroX > this.rhero.fp_heroX) {
                this.rhero.kierunekUderzenia = (byte)-1;
                this.rhero.changeState((byte)16, -1);
            } else {
                this.rhero.kierunekUderzenia = 1;
                this.rhero.changeState((byte)16, 1);
            }
        }
        if (this.fp_heroY > this.jumpBeginHeight && this.jumpVelocity > 0) {
            this.changeState((byte)1, 0);
            this.fp_heroY = this.jumpBeginHeight;
        }
        return false;
    }

    private boolean update_standup(int deltaTime) {
        if (this.attack[this.orientation] != 0 && !this.isComputer) {
            this.czyUdalSieHypierUpperCut = true;
        } else if (this.attack[this.orientation + 1 & 1] != 0 && !this.isComputer) {
            this.czyUdalSieKneeKick = true;
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            if (this.czyUdalSieKneeKick) {
                this.czyUdalSieKneeKick = false;
                if (this.orientation == 0) {
                    this.changeState((byte)28, 1);
                } else {
                    this.changeState((byte)28, -1);
                }
            } else if (this.czyUdalSieHypierUpperCut) {
                this.czyUdalSieHypierUpperCut = false;
                this.changeState((byte)49, 0);
            } else {
                if (this.kierunekUderzenia == -1) {
                    this.orientation = 0;
                } else if (this.kierunekUderzenia == 1) {
                    this.orientation = 1;
                }
                if (this.enemyType == 8) {
                    if (this.life < GameAppState.level.findEnemyParameters((int)8).startingLife >> 1 && !this.wasDisappeart) {
                        this.changeState((byte)20, 0);
                        this.wasDisappeart = true;
                    } else {
                        this.changeState((byte)1, 0);
                    }
                } else {
                    this.changeState((byte)1, 0);
                }
            }
        }
        return false;
    }

    private boolean update_kneekick(int deltaTime) {
        this.fp_heroX += this.jumpDirection * deltaTime * 25344 >> 10;
        this.fp_heroY += this.jumpVelocity * deltaTime >> 10;
        this.jumpVelocity += 140800 * deltaTime >> 10;
        this.rhero = this.collisionJump();
        if (this.rhero != null) {
            this.rhero.life = (short)(this.rhero.life - 4);
            if (!this.isComputer) {
                this.score += 100;
            }
            if (this.orientation == 0) {
                this.rhero.changeState((byte)16, 1);
                this.rhero.flySpeedX = 34496;
            }
            if (this.orientation == 1) {
                this.rhero.changeState((byte)16, -1);
                this.rhero.flySpeedX = 34496;
            }
        }
        if (this.fp_heroY > this.jumpBeginHeight && this.jumpVelocity > 0) {
            this.fp_heroY = this.jumpBeginHeight;
            this.changeState((byte)7, 0);
        }
        int lastVel = this.jumpVelocity;
        this.checkSector();
        if (this.state == 4) {
            this.jumpVelocity = lastVel;
        }
        return false;
    }

    private boolean update_dead(int deltaTime) {
        if (this.heroSprite.animationTime % 200 > 100 && this.visible) {
            this.visible = false;
        }
        if (this.heroSprite.animationTime % 200 <= 100 && !this.visible) {
            this.visible = true;
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            if (this.isComputer) {
                GameAppState.removeEnemy(this.id);
                return true;
            }
            this.onPlayerKilled();
        }
        return false;
    }

    private boolean update_inelevator(int deltaTime) {
        GameAppState.drawHeroFirst = this.fp_heroY >> 8 <= 289 || this.fp_heroY >> 8 >= 434;
        this.fp_heroY += this.jumpVelocity * deltaTime >> 10;
        if (this.fp_heroY > this.jumpBeginHeight - 5120) {
            GameAppState.animations[1].setState((byte)5);
        }
        if (this.fp_heroY > this.jumpBeginHeight && this.jumpVelocity > 0) {
            this.fp_heroY = this.jumpBeginHeight;
            this.changeState((byte)1, 0);
            GameAppState.drawHeroFirst = false;
            GameAppState.winda = null;
            GameAppState.platforma = null;
        }
        return false;
    }

    private boolean update_pickup(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_throwitem(int deltaTime) {
        if (this.weapon != null && this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * (this.heroSprite.currentSpriteAnimation.animationFramesCount - 1)) {
            this.throwWeapon();
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_fadein(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_shadowattack(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.changeState((byte)21, 0);
            this.fp_heroX = this.lastHeroPoz.x << 8;
            this.fp_heroY = this.lastHeroPoz.y << 8;
            GameAppState.heros[0].kierunekUderzenia = GameAppState.heros[0].orientation == 1 ? (byte)1 : (byte)-1;
            GameAppState.heros[0].life = (short)(GameAppState.heros[0].life - 2);
            GameAppState.heros[0].changeState((byte)16, GameAppState.heros[0].kierunekUderzenia);
        }
        return false;
    }

    private boolean update_fadeout(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.visible = false;
        }
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount * 6) {
            GameAppState.heros[0].changeState((byte)0, 0);
            this.lastHeroPoz = new Point(this.fp_heroX >> 8, this.fp_heroY >> 8);
            this.fp_heroX = GameAppState.heros[0].fp_heroX;
            this.fp_heroY = GameAppState.heros[0].fp_heroY;
            this.changeState((byte)42, 0);
            this.orientation = GameAppState.heros[0].orientation;
            this.visible = true;
        }
        return false;
    }

    private boolean update_pipehit(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.rhero = this.checkHit(40, false);
            if (this.rhero != null) {
                if (!this.isComputer) {
                    this.score += 100;
                }
                this.rhero.life = (short)(this.rhero.life - this.weapon.damage);
                if (this.fp_heroX > this.rhero.fp_heroX) {
                    this.rhero.kierunekUderzenia = (byte)-1;
                    this.rhero.changeState((byte)16, -1);
                } else {
                    this.rhero.kierunekUderzenia = 1;
                    this.rhero.changeState((byte)16, 1);
                }
            }
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_chainhit(int deltaTime) {
        if (this.heroSprite.animationTime > this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) {
            this.rhero = this.checkHit(60, false);
            if (this.rhero != null) {
                if (!this.isComputer) {
                    this.score += 100;
                }
                this.rhero.life = (short)(this.rhero.life - this.weapon.damage);
                if (this.fp_heroX > this.rhero.fp_heroX) {
                    this.rhero.kierunekUderzenia = (byte)-1;
                    this.rhero.changeState((byte)16, -1);
                } else {
                    this.rhero.kierunekUderzenia = 1;
                    this.rhero.changeState((byte)16, 1);
                }
            }
            this.changeState((byte)1, 0);
        }
        return false;
    }

    private boolean update_runaway(int deltaTime) {
        this.visible = true;
        this.orientation = 0;
        this.fp_heroX += deltaTime * this.moveSpeedEnemyPerMS >> 9;
        if (this.fp_heroX >> 8 > GameAppState.scaleUpValue(this.level.tiledLayer.layerWidth)) {
            GameAppState.removeEnemy(this.id);
        }
        return false;
    }

    private boolean update_end(int deltaTime) {
        if (this.state != 4 && this.state != 23) {
            if (this.fp_heroX < 3840) {
                this.fp_heroX = 3840;
            }
            if (this.fp_heroX + 3840 > GameAppState.scaleUpValue(this.level.tiledLayer.layerWidth) << 8) {
                this.fp_heroX = (GameAppState.scaleUpValue(this.level.tiledLayer.layerWidth) << 8) - 3840;
            }
            if (this.fp_heroY > GameAppState.scaleUpValue(this.level.tiledLayer.layerHeight) - 4 << 8) {
                this.fp_heroY = GameAppState.scaleUpValue(this.level.tiledLayer.layerHeight) - 4 << 8;
            }
        }
        this.updateAnimation(deltaTime);
        return false;
    }

    public void update(int deltaTime) {
        try {
            this.update_init1(deltaTime);
            this.update_init2(deltaTime);
            this.update_init3(deltaTime);
            this.update_init4(deltaTime);
            this.update_init5(deltaTime);
            this.update_init6(deltaTime);
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 10: 
                case 26: {
                    this.update_move1(deltaTime);
                    if (this.update_move2(deltaTime)) break;
                }
                case 5: {
                    this.update_climb1(deltaTime);
                    this.update_climb2(deltaTime);
                    break;
                }
                case 30: {
                    this.update_charge(deltaTime);
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    this.update_bosshit(deltaTime);
                    break;
                }
                case 12: {
                    this.update_kolanko1(deltaTime);
                    this.update_kolanko2(deltaTime);
                    break;
                }
                case 13: {
                    if (GameAppState.hero.state != 16 && GameAppState.hero.state != 4) break;
                    this.changeState((byte)1, 0);
                    break;
                }
                case 32: 
                case 35: {
                    this.update_kolankohit(deltaTime);
                    break;
                }
                case 15: 
                case 36: {
                    this.update_wykop(deltaTime);
                    break;
                }
                case 37: {
                    if (this.isComputer && this.jumpVelocity > 0) {
                        int x = GameAppState.heros[0].fp_heroX - this.fp_heroX << 1;
                        int y = GameAppState.heros[0].fp_heroY - this.fp_heroY << 1;
                        GameAppState.addBullet(this.fp_heroX, this.fp_heroY, x, y, this.jumpBeginHeight, 7);
                        this.state = (byte)3;
                    }
                }
                case 3: {
                    if (this.isComputer && this.jumpVelocity > 0 && this.jumpKick) {
                        this.jumpKick = false;
                        this.changeState((byte)43, this.jumpDirection);
                    }
                }
                case 43: {
                    this.update_jumpkick1(deltaTime);
                    this.update_jumpkick2(deltaTime);
                    break;
                }
                case 4: {
                    this.update_fall(deltaTime);
                    break;
                }
                case 48: {
                    this.update_spinningcyclone(deltaTime);
                    break;
                }
                case 39: {
                    this.update_roundpunch(deltaTime);
                    break;
                }
                case 40: {
                    this.update_bosskick(deltaTime);
                    break;
                }
                case 24: {
                    this.fp_heroX = this.orientation == 1 ? (this.fp_heroX += 512) : (this.fp_heroX -= 512);
                    if (this.heroSprite.animationTime <= this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) break;
                    this.changeState((byte)1, 0);
                    break;
                }
                case 45: 
                case 46: {
                    this.update_punch2(deltaTime);
                    break;
                }
                case 44: 
                case 49: {
                    this.update_uppercut(deltaTime);
                    break;
                }
                case 47: {
                    this.update_kick(deltaTime);
                    break;
                }
                case 41: {
                    this.update_lowkick(deltaTime);
                    break;
                }
                case 29: 
                case 38: {
                    this.update_kickfront(deltaTime);
                    break;
                }
                case 14: 
                case 16: {
                    this.update_powerfly(deltaTime);
                    break;
                }
                case 27: {
                    this.update_bossrotatejump(deltaTime);
                    break;
                }
                case 25: {
                    if (this.heroSprite.animationTime <= this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) break;
                    this.changeState((byte)1, 0);
                    break;
                }
                case 6: {
                    if (this.heroSprite.animationTime <= this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) break;
                    if (this.life <= 0) {
                        this.changeState((byte)16, this.kierunekUderzenia);
                    }
                    this.changeState((byte)1, 0);
                    break;
                }
                case 17: {
                    if (this.heroSprite.animationTime <= this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) break;
                    if (this.kierunekUderzenia == -1) {
                        this.orientation = 0;
                    } else if (this.kierunekUderzenia == 1) {
                        this.orientation = 1;
                    }
                    this.changeState((byte)7, 0);
                    break;
                }
                case 7: {
                    this.update_standup(deltaTime);
                    break;
                }
                case 28: {
                    this.update_kneekick(deltaTime);
                    break;
                }
                case 8: {
                    if (!this.update_dead(deltaTime)) break;
                    return;
                }
                case 20: {
                    if (this.heroSprite.animationTime <= this.heroSprite.currentSpriteAnimation.frameTime * this.heroSprite.currentSpriteAnimation.animationFramesCount) break;
                    this.changeState((byte)1, 0);
                    break;
                }
                case 100: {
                    this.update_inelevator(deltaTime);
                    break;
                }
                case 11: {
                    this.update_pickup(deltaTime);
                    break;
                }
                case 31: {
                    this.update_throwitem(deltaTime);
                    break;
                }
                case 21: {
                    this.update_fadein(deltaTime);
                    break;
                }
                case 42: {
                    this.update_shadowattack(deltaTime);
                    break;
                }
                case 22: {
                    this.update_fadeout(deltaTime);
                    break;
                }
                case 33: {
                    this.update_pipehit(deltaTime);
                    break;
                }
                case 34: {
                    this.update_chainhit(deltaTime);
                    break;
                }
                case 23: {
                    this.update_runaway(deltaTime);
                }
            }
            this.update_end(deltaTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkSector() {
        block207: {
            try {
                byte nextSectorType;
                int nextSector;
                int i;
                int y;
                int x;
                if (!this.inAir()) {
                    x = this.fp_heroX >> 8;
                    y = this.fp_heroY >> 8;
                } else {
                    x = this.fp_heroX >> 8;
                    y = this.jumpBeginHeight >> 8;
                }
                SectorEdge sectorEdgeTop = this.level.sectorEdgeTop[this.currentSector];
                SectorEdge sectorEdgeBottom = this.level.sectorEdgeBottom[this.currentSector];
                if (this.level.sectorType[this.currentSector] == 2) {
                    if (!this.inAir()) {
                        if (this.state != 5) {
                            this.changeState((byte)5, 0);
                        }
                        this.fp_heroX = sectorEdgeTop.xPoint[0] + sectorEdgeTop.xPoint[1] << 7;
                        if (y < sectorEdgeTop.yPoint[0]) {
                            this.currentSector = sectorEdgeTop.edgeType[0];
                            this.checkSector();
                            this.changeState((byte)1, 0);
                        }
                        if (y > sectorEdgeBottom.yPoint[0]) {
                            this.currentSector = sectorEdgeBottom.edgeType[0];
                            this.checkSector();
                            this.changeState((byte)1, 0);
                        }
                    }
                    return;
                }
                if (this.level.sectorType[this.currentSector] == 1 || this.level.sectorType[this.currentSector] == 6 || this.level.sectorType[this.currentSector] == 7) {
                    int nextSector2;
                    int i2;
                    int wallTop = 0;
                    int wallBottom = 0;
                    if (GameAppState.levelNumber == 4 && this.currentSector == 1 && this.inAir() && this.fp_heroY >> 8 < 580 && this.jumpVelocity < 0 && (this.fp_heroX >> 8 > 924 || this.fp_heroX >> 8 < 879)) {
                        this.life = this.isComputer ? (short)(this.life - 2) : (short)(this.life - 8);
                        this.changeState((byte)16, this.orientation);
                        this.jumpVelocity = 0;
                        this.jumpDirection = 0;
                    }
                    if (GameAppState.levelNumber == 6 && (GameAppState.enabledPlatform != this.currentSector && this.currentSector >= GameAppState.FIRST_PLATFORM2 && this.currentSector <= GameAppState.LAST_PLATFORM2 || GameAppState.enabledPlatform1 != this.currentSector && this.currentSector >= GameAppState.FIRST_PLATFORM1 && this.currentSector <= GameAppState.LAST_PLATFORM1) && !this.inAir()) {
                        if (this.orientation == 1) {
                            this.changeState((byte)4, -1);
                        } else {
                            this.changeState((byte)4, 1);
                        }
                        this.nextSectorFall = this.level.sectorEdgeBottom[this.currentSector].edgeType[0];
                        this.jumpBeginHeight = this.nextSectorFall == -1 ? this.fp_heroY + 43008 : this.fp_heroY + (this.level.sectorEdgeBottom[this.currentSector].nextSectorDeltaY[0] << 8);
                        return;
                    }
                    if (x < sectorEdgeTop.xPoint[0]) {
                        int nextSector3 = sectorEdgeTop.edgeType[0];
                        if (sectorEdgeTop.edgeType[0] == -100) {
                            if (!this.inAir()) {
                                if (this.isComputer && this.state == 2) {
                                    this.fp_heroX = sectorEdgeTop.xPoint[0] << 8;
                                    if (!this.inAir()) {
                                        this.fp_heroY = sectorEdgeTop.yPoint[0] << 8;
                                    }
                                } else {
                                    if (this.orientation == 1) {
                                        this.changeState((byte)4, -1);
                                    } else {
                                        this.changeState((byte)4, 1);
                                    }
                                    this.jumpBeginHeight = this.fp_heroY + 21504;
                                }
                            }
                        } else if (sectorEdgeTop.edgeType[0] == -1) {
                            this.fp_heroX = sectorEdgeTop.xPoint[0] << 8;
                            if (!this.inAir()) {
                                this.fp_heroY = sectorEdgeTop.yPoint[0] << 8;
                            }
                        } else {
                            byte nextSectorType2 = this.level.sectorType[nextSector3];
                            if (nextSectorType2 == 1 || nextSectorType2 == 6 || nextSectorType2 == 7) {
                                if (sectorEdgeTop.nextSectorDeltaX[0] == 0 && sectorEdgeTop.nextSectorDeltaY[0] == 0) {
                                    this.currentSector = nextSector3;
                                    this.checkSector();
                                } else if (!this.inAir()) {
                                    if (sectorEdgeTop.nextSectorDeltaY[0] > 0 && sectorEdgeTop.nextSectorDeltaX[0] == 0) {
                                        if (this.orientation == 1) {
                                            this.changeState((byte)4, -1);
                                        } else {
                                            this.changeState((byte)4, 1);
                                        }
                                        this.nextSectorFall = nextSector3;
                                        this.jumpBeginHeight = this.fp_heroY + (sectorEdgeTop.nextSectorDeltaY[0] << 8);
                                    } else if (sectorEdgeTop.nextSectorDeltaX[0] != 0) {
                                        if (this.orientation == 1) {
                                            this.changeState((byte)4, -1);
                                        } else {
                                            this.changeState((byte)4, 1);
                                        }
                                        this.jumpBeginHeight = this.fp_heroY + 21504;
                                    } else if (this.level.sectorType[this.currentSector] == 6) {
                                        this.changeState((byte)4, -1);
                                        this.jumpBeginHeight = this.fp_heroY + 21504;
                                    } else {
                                        this.fp_heroX = sectorEdgeTop.xPoint[0] << 8;
                                        this.fp_heroY = sectorEdgeTop.yPoint[0] << 8;
                                    }
                                } else if (x <= sectorEdgeTop.xPoint[0] + sectorEdgeTop.nextSectorDeltaX[0]) {
                                    if (this.fp_heroY >> 8 <= sectorEdgeTop.yPoint[0] + sectorEdgeTop.nextSectorDeltaY[0]) {
                                        this.currentSector = nextSector3;
                                        this.jumpBeginHeight += sectorEdgeTop.nextSectorDeltaY[0] << 8;
                                    } else {
                                        this.jumpDirection = 0;
                                    }
                                }
                            }
                        }
                        return;
                    }
                    int last = sectorEdgeTop.pointsNumber - 2;
                    if (x > sectorEdgeTop.xPoint[last]) {
                        int nextSector4 = sectorEdgeTop.edgeType[last];
                        if (nextSector4 == -100) {
                            if (this.isComputer && this.state == 2) {
                                this.fp_heroX = sectorEdgeTop.xPoint[last] << 8;
                                if (!this.inAir()) {
                                    this.fp_heroY = sectorEdgeTop.yPoint[last] << 8;
                                }
                            } else {
                                if (this.orientation == 1) {
                                    this.changeState((byte)4, -1);
                                } else {
                                    this.changeState((byte)4, 1);
                                }
                                this.jumpBeginHeight = this.fp_heroY + 21504;
                            }
                        } else if (nextSector4 == -1) {
                            this.fp_heroX = sectorEdgeTop.xPoint[last] << 8;
                            if (!this.inAir()) {
                                this.fp_heroY = sectorEdgeTop.yPoint[last] << 8;
                            }
                        } else {
                            byte nextSectorType3 = this.level.sectorType[nextSector4];
                            if (nextSectorType3 == 1 || nextSectorType3 == 6 || nextSectorType3 == 7) {
                                if (sectorEdgeTop.nextSectorDeltaX[last] == 0 && sectorEdgeTop.nextSectorDeltaY[last] == 0) {
                                    this.currentSector = nextSector4;
                                    this.checkSector();
                                } else if (!this.inAir()) {
                                    if (sectorEdgeTop.nextSectorDeltaY[last] > 0 && sectorEdgeTop.nextSectorDeltaX[last] == 0) {
                                        if (this.orientation == 1) {
                                            this.changeState((byte)4, -1);
                                        } else {
                                            this.changeState((byte)4, 1);
                                        }
                                        this.nextSectorFall = nextSector4;
                                        this.jumpBeginHeight = this.fp_heroY + (sectorEdgeTop.nextSectorDeltaY[last] << 8);
                                    } else if (sectorEdgeTop.nextSectorDeltaX[last] != 0) {
                                        if (this.orientation == 1) {
                                            this.changeState((byte)4, -1);
                                        } else {
                                            this.changeState((byte)4, 1);
                                        }
                                        this.jumpBeginHeight = this.fp_heroY + 21504;
                                    } else {
                                        this.fp_heroX = sectorEdgeTop.xPoint[last] << 8;
                                        this.fp_heroY = sectorEdgeTop.yPoint[last] << 8;
                                    }
                                } else if (x >= sectorEdgeTop.xPoint[last] + sectorEdgeTop.nextSectorDeltaX[last]) {
                                    if (this.fp_heroY >> 8 <= sectorEdgeTop.yPoint[last] + sectorEdgeTop.nextSectorDeltaY[last]) {
                                        this.currentSector = nextSector4;
                                        this.jumpBeginHeight += sectorEdgeTop.nextSectorDeltaY[last] << 8;
                                    } else {
                                        this.jumpDirection = 0;
                                    }
                                }
                            }
                        }
                        return;
                    }
                    for (i2 = 1; i2 < sectorEdgeTop.pointsNumber; ++i2) {
                        wallTop = i2 - 1;
                        if (x < sectorEdgeTop.xPoint[i2]) break;
                    }
                    for (i2 = 1; i2 < sectorEdgeBottom.pointsNumber; ++i2) {
                        wallBottom = i2 - 1;
                        if (x < sectorEdgeBottom.xPoint[i2]) break;
                    }
                    short platformY = sectorEdgeTop.yPoint[wallTop];
                    if (sectorEdgeBottom.edgeType[wallBottom] == -100 && !this.inAir()) {
                        if (this.orientation == 1) {
                            this.changeState((byte)4, -1);
                        } else {
                            this.changeState((byte)4, 1);
                        }
                        this.jumpBeginHeight = this.fp_heroY + 21504;
                    }
                    if (GameAppState.levelNumber == 4) {
                        nextSector2 = sectorEdgeTop.edgeType[wallTop];
                        if (nextSector2 == -11 && GameAppState.zgniatarkaEnabled && this.state != 16) {
                            this.life = (short)(this.life - 8);
                            if (this.orientation == 1) {
                                this.changeState((byte)16, 1);
                            } else {
                                this.changeState((byte)16, -1);
                            }
                        }
                        if (nextSector2 == -12 && !GameAppState.zgniatarkaEnabled && this.state != 16) {
                            this.life = (short)(this.life - 8);
                            if (this.orientation == 1) {
                                this.changeState((byte)16, 1);
                            } else {
                                this.changeState((byte)16, -1);
                            }
                        }
                    }
                    if (y < platformY || this.inAir() && this.fp_heroY >> 8 < platformY) {
                        int destY;
                        byte nextSectorType4;
                        nextSector2 = sectorEdgeTop.edgeType[wallTop];
                        if (!this.inAir()) {
                            if (nextSector2 == -1 || nextSector2 == -12 || nextSector2 == -11) {
                                if (platformY - y > 10) {
                                    this.changeState((byte)4, 1);
                                    this.jumpBeginHeight = platformY << 8;
                                    this.nextSectorFall = this.currentSector;
                                } else {
                                    this.fp_heroY = platformY << 8;
                                }
                            } else if (nextSector2 == -20) {
                                if (GameAppState.ileWrogow == 0) {
                                    this.fp_heroX = 315392;
                                    this.fp_heroY = 141312;
                                    this.level.currentRegion = (byte)(this.level.currentRegion + 1);
                                    this.currentRegionX = this.level.currentRegion;
                                    this.currentRegionY = this.level.currentRegion;
                                    GameAppState.checkCameraPosition();
                                    GameAppState.animations[4].setToStart();
                                    GameAppState.animations[4].setState((byte)3);
                                    GameAppState.animations[3].setToEnd();
                                    GameAppState.animations[3].setState((byte)4);
                                    GameAppState.handTime = 0;
                                    this.currentSector = 2;
                                } else {
                                    this.fp_heroY = platformY << 8;
                                }
                            } else if (nextSector2 == -21) {
                                this.fp_heroX = 79616;
                                this.fp_heroY = 32000;
                                this.level.currentRegion = (byte)(this.level.currentRegion + 1);
                                this.currentRegionX = this.level.currentRegion;
                                this.currentRegionY = this.level.currentRegion;
                                GameAppState.checkCameraPosition();
                                GameAppState.animations[5].setState((byte)4);
                                this.currentSector = 5;
                            } else if (nextSector2 == -22) {
                                if (GameAppState.ileWrogow == 0) {
                                    this.fp_heroX = 143616;
                                    this.fp_heroY = 40704;
                                    this.level.currentRegion = (byte)(this.level.currentRegion + 1);
                                    this.currentRegionX = this.level.currentRegion;
                                    this.currentRegionY = this.level.currentRegion;
                                    GameAppState.checkCameraPosition();
                                    GameAppState.animations[6].setState((byte)4);
                                    this.currentSector = 6;
                                } else {
                                    this.fp_heroY = platformY << 8;
                                }
                            } else if (nextSector2 == -23) {
                                this.fp_heroX = 216064;
                                this.fp_heroY = 32000;
                                this.level.currentRegion = (byte)(this.level.currentRegion + 1);
                                this.currentRegionX = this.level.currentRegion;
                                this.currentRegionY = this.level.currentRegion;
                                GameAppState.checkCameraPosition();
                                GameAppState.animations[7].setState((byte)4);
                                this.currentSector = 19;
                            } else if (nextSector2 == -24) {
                                if (GameAppState.ileWrogow == 0) {
                                    this.fp_heroX = 277760;
                                    this.fp_heroY = 39168;
                                    this.level.currentRegion = (byte)(this.level.currentRegion + 1);
                                    this.currentRegionX = this.level.currentRegion;
                                    this.currentRegionY = this.level.currentRegion;
                                    GameAppState.checkCameraPosition();
                                    GameAppState.animations[8].setState((byte)4);
                                    this.currentSector = 20;
                                } else {
                                    this.fp_heroY = platformY << 8;
                                }
                            } else if (nextSector2 == -26) {
                                if (GameAppState.levelRequested == -1) {
                                    this.visible = false;
                                    GameAppState.levelRequested = (byte)(GameAppState.levelNumber + 1);
                                    GameAppState.fadeOutIn();
                                }
                            } else {
                                byte nextSectorType5 = this.level.sectorType[nextSector2];
                                if (nextSectorType5 == 2) {
                                    this.currentSector = nextSector2;
                                    this.checkSector();
                                    this.changeState((byte)5, 0);
                                    return;
                                }
                                this.fp_heroY = platformY << 8;
                            }
                        } else if (!(nextSector2 < 0 || (nextSectorType4 = this.level.sectorType[nextSector2]) != 1 && nextSectorType4 != 6 && nextSectorType4 != 7 || this.fp_heroY > (destY = platformY + sectorEdgeTop.nextSectorDeltaY[wallTop] << 8) || GameAppState.levelNumber == 6 && (GameAppState.enabledPlatform != nextSector2 && nextSector2 >= GameAppState.FIRST_PLATFORM2 && nextSector2 <= GameAppState.LAST_PLATFORM2 || GameAppState.enabledPlatform1 != nextSector2 && nextSector2 >= GameAppState.FIRST_PLATFORM1 && nextSector2 <= GameAppState.LAST_PLATFORM1))) {
                            this.currentSector = nextSector2;
                            this.jumpBeginHeight = destY;
                        }
                    } else if (y > platformY) {
                        nextSector2 = sectorEdgeBottom.edgeType[wallBottom];
                        if (nextSector2 == -1) {
                            this.fp_heroY = platformY << 8;
                        } else if (nextSector2 >= 0) {
                            byte nextSectorType6 = this.level.sectorType[nextSector2];
                            if (nextSectorType6 == 2 && this.enemyType != 65) {
                                this.currentSector = nextSector2;
                                this.checkSector();
                                this.changeState((byte)5, 0);
                                return;
                            }
                            if (nextSectorType6 == 1 || nextSectorType6 == 6 || nextSectorType6 == 7) {
                                if (this.orientation == 1) {
                                    this.changeState((byte)4, -1);
                                } else {
                                    this.changeState((byte)4, 1);
                                }
                                this.jumpBeginHeight = this.level.sectorEdgeTop[nextSector2].yPoint[0] - 1 << 8;
                                this.nextSectorFall = nextSector2;
                                return;
                            }
                        }
                    }
                    return;
                }
                if (this.level.sectorType[this.currentSector] != 0 && this.level.sectorType[this.currentSector] != 3 && this.level.sectorType[this.currentSector] != 4 && this.level.sectorType[this.currentSector] != 5) break block207;
                int wallTop = 0;
                int wallBottom = 0;
                for (i = 1; i < sectorEdgeTop.pointsNumber; ++i) {
                    wallTop = i - 1;
                    if (x <= sectorEdgeTop.xPoint[i]) break;
                }
                for (i = 1; i < sectorEdgeBottom.pointsNumber; ++i) {
                    wallBottom = i - 1;
                    if (x <= sectorEdgeBottom.xPoint[i]) break;
                }
                int yMaxTop = Math.max(sectorEdgeTop.yPoint[wallTop], sectorEdgeTop.yPoint[wallTop + 1]);
                int yMinBottom = Math.min(sectorEdgeBottom.yPoint[wallBottom], sectorEdgeBottom.yPoint[wallBottom + 1]);
                if (x < sectorEdgeBottom.xPoint[wallBottom]) {
                    nextSector = sectorEdgeBottom.edgeType[wallBottom];
                    if (nextSector == -1) {
                        x = sectorEdgeBottom.xPoint[wallBottom];
                        this.fp_heroX = x << 8;
                        ++wallBottom;
                    } else if (nextSector == -100) {
                        this.changeState((byte)4, -1);
                        this.jumpBeginHeight = this.fp_heroY + 21504;
                    } else if (sectorEdgeBottom.nextSectorDeltaY[wallBottom] == 0 && ((nextSectorType = this.level.sectorType[nextSector]) == 0 || nextSectorType == 3 || nextSectorType == 4 || nextSectorType == 5)) {
                        if (sectorEdgeBottom.nextSectorDeltaX[wallBottom] == 0) {
                            this.currentSector = nextSector;
                            this.checkSector();
                            return;
                        }
                        if (!this.inAir()) {
                            this.changeState((byte)4, -1);
                            this.jumpBeginHeight = this.fp_heroY + 21504;
                        } else if (x <= sectorEdgeBottom.xPoint[wallBottom] + sectorEdgeBottom.nextSectorDeltaX[wallBottom]) {
                            this.currentSector = nextSector;
                            this.checkSector();
                            return;
                        }
                    }
                }
                if (x > sectorEdgeTop.xPoint[wallTop + 1]) {
                    nextSector = sectorEdgeTop.edgeType[wallTop];
                    if (nextSector == -1) {
                        x = sectorEdgeTop.xPoint[wallTop + 1];
                        this.fp_heroX = x << 8;
                        --wallTop;
                    } else if (nextSector == -100) {
                        this.changeState((byte)4, 1);
                        this.jumpBeginHeight = this.fp_heroY + 21504;
                    } else if (sectorEdgeTop.nextSectorDeltaY[wallTop] == 0 && ((nextSectorType = this.level.sectorType[nextSector]) == 0 || nextSectorType == 3 || nextSectorType == 4 || nextSectorType == 5)) {
                        if (sectorEdgeTop.nextSectorDeltaX[wallTop] == 0) {
                            this.currentSector = nextSector;
                            this.checkSector();
                            return;
                        }
                        if (!this.inAir()) {
                            this.changeState((byte)4, 1);
                            this.jumpBeginHeight = this.fp_heroY + 21504;
                        } else if (x >= sectorEdgeTop.xPoint[wallTop] + sectorEdgeTop.nextSectorDeltaX[wallTop]) {
                            this.currentSector = nextSector;
                            this.checkSector();
                            return;
                        }
                    }
                }
                if (y < yMaxTop) {
                    if (sectorEdgeTop.xPoint[wallTop] != sectorEdgeTop.xPoint[wallTop + 1]) {
                        nextSector = sectorEdgeTop.edgeType[wallTop];
                        if (nextSector == -1 || nextSector == -100) {
                            y = sectorEdgeTop.yPoint[wallTop] + (x - sectorEdgeTop.xPoint[wallTop]) * (sectorEdgeTop.yPoint[wallTop + 1] - sectorEdgeTop.yPoint[wallTop]) / (sectorEdgeTop.xPoint[wallTop + 1] - sectorEdgeTop.xPoint[wallTop]);
                            if (!this.inAir()) {
                                if (this.fp_heroY < y << 8) {
                                    if (nextSector == -100 && !this.isComputer) {
                                        if (this.orientation == 1) {
                                            this.changeState((byte)4, -1);
                                        } else {
                                            this.changeState((byte)4, 1);
                                        }
                                        this.jumpBeginHeight = this.fp_heroY + 21504;
                                        return;
                                    }
                                    this.fp_heroY = y << 8;
                                }
                            } else if (this.jumpBeginHeight < y << 8) {
                                if (nextSector == -100) {
                                    if (this.orientation == 1) {
                                        this.changeState((byte)4, -100);
                                    } else {
                                        this.changeState((byte)4, -100);
                                    }
                                    this.jumpBeginHeight += 21504;
                                    return;
                                }
                                this.jumpDirection = 0;
                            }
                        } else if (nextSector == -10) {
                            if (!this.inAir()) {
                                if (GameAppState.ileWrogow == 0) {
                                    this.changeState((byte)100, 617);
                                    GameAppState.animations[0].setState((byte)4);
                                    this.currentSector = 1;
                                    this.fp_heroX = sectorEdgeTop.xPoint[wallTop] + sectorEdgeTop.xPoint[wallTop + 1] << 7;
                                } else {
                                    this.fp_heroY = sectorEdgeTop.yPoint[wallTop] << 8;
                                }
                            }
                        } else if (nextSector == -25) {
                            this.fp_heroY = sectorEdgeTop.yPoint[wallTop] << 8;
                            if (GameAppState.levelRequested == -1) {
                                this.visible = false;
                                GameAppState.levelRequested = (byte)(GameAppState.levelNumber + 1);
                                GameAppState.fadeOutIn();
                            }
                        } else {
                            nextSectorType = this.level.sectorType[nextSector];
                            if (nextSectorType == 2 && this.enemyType != 66 && this.enemyType != 32 && this.enemyType != 64 && this.enemyType != 65) {
                                this.currentSector = nextSector;
                                this.checkSector();
                                this.changeState((byte)5, 0);
                                return;
                            }
                            if (nextSectorType == 0 || nextSectorType == 3 || nextSectorType == 4 || nextSectorType == 5) {
                                y = sectorEdgeTop.yPoint[wallTop] + (x - sectorEdgeTop.xPoint[wallTop]) * (sectorEdgeTop.yPoint[wallTop + 1] - sectorEdgeTop.yPoint[wallTop]) / (sectorEdgeTop.xPoint[wallTop + 1] - sectorEdgeTop.xPoint[wallTop]);
                                if (this.fp_heroY < y << 8) {
                                    if (sectorEdgeTop.nextSectorDeltaY[wallTop] > 0) {
                                        if (this.inAir()) {
                                            this.currentSector = nextSector;
                                            this.jumpBeginHeight += sectorEdgeTop.nextSectorDeltaY[wallTop] << 8;
                                        } else {
                                            if (this.orientation == 1) {
                                                this.changeState((byte)4, -1);
                                            } else {
                                                this.changeState((byte)4, 1);
                                            }
                                            this.jumpBeginHeight = this.fp_heroY + (sectorEdgeTop.nextSectorDeltaY[wallTop] << 8);
                                            this.nextSectorFall = nextSector;
                                        }
                                    } else if (sectorEdgeTop.nextSectorDeltaY[wallTop] < 0) {
                                        if (this.inAir()) {
                                            this.currentSector = nextSector;
                                            this.jumpBeginHeight += sectorEdgeTop.nextSectorDeltaY[wallTop] << 8;
                                        } else {
                                            y = sectorEdgeTop.yPoint[wallTop] + (x - sectorEdgeTop.xPoint[wallTop]) * (sectorEdgeTop.yPoint[wallTop + 1] - sectorEdgeTop.yPoint[wallTop]) / (sectorEdgeTop.xPoint[wallTop + 1] - sectorEdgeTop.xPoint[wallTop]);
                                            if (this.inAir()) {
                                                this.jumpVelocity = 0;
                                                this.jumpDirection = 0;
                                            }
                                            this.fp_heroY = y << 8;
                                        }
                                    } else {
                                        this.currentSector = nextSector;
                                    }
                                    return;
                                }
                            } else {
                                y = sectorEdgeTop.yPoint[wallTop] + (x - sectorEdgeTop.xPoint[wallTop]) * (sectorEdgeTop.yPoint[wallTop + 1] - sectorEdgeTop.yPoint[wallTop]) / (sectorEdgeTop.xPoint[wallTop + 1] - sectorEdgeTop.xPoint[wallTop]);
                                if (this.fp_heroY < y << 8) {
                                    this.fp_heroY = y << 8;
                                    this.changeState((byte)1, 0);
                                }
                            }
                        }
                    }
                    break block207;
                }
                if (y <= yMinBottom) {
                    return;
                }
                if (sectorEdgeBottom.xPoint[wallBottom] == sectorEdgeBottom.xPoint[wallBottom + 1]) break block207;
                nextSector = sectorEdgeBottom.edgeType[wallBottom];
                if (nextSector == -1 || nextSector == -100) {
                    y = sectorEdgeBottom.yPoint[wallBottom] + (x - sectorEdgeBottom.xPoint[wallBottom]) * (sectorEdgeBottom.yPoint[wallBottom + 1] - sectorEdgeBottom.yPoint[wallBottom]) / (sectorEdgeBottom.xPoint[wallBottom + 1] - sectorEdgeBottom.xPoint[wallBottom]);
                    if (!this.inAir()) {
                        if (this.fp_heroY > y << 8) {
                            if (nextSector == -100 && !this.isComputer) {
                                if (this.orientation == 1) {
                                    this.changeState((byte)4, -1);
                                } else {
                                    this.changeState((byte)4, 1);
                                }
                                this.jumpBeginHeight = this.fp_heroY + 21504;
                                return;
                            }
                            this.fp_heroY = y << 8;
                            return;
                        }
                    } else if (this.jumpBeginHeight > y << 8) {
                        if (nextSector == -100) {
                            if (this.orientation == 1) {
                                this.changeState((byte)4, -100);
                            } else {
                                this.changeState((byte)4, -100);
                            }
                            this.jumpBeginHeight += 21504;
                            return;
                        }
                        this.jumpDirection = 0;
                        return;
                    }
                    break block207;
                }
                nextSectorType = this.level.sectorType[nextSector];
                if (nextSectorType == 2) {
                    this.currentSector = nextSector;
                    this.checkSector();
                    this.changeState((byte)5, 0);
                    return;
                }
                if (nextSectorType == 0 || nextSectorType == 3 || nextSectorType == 4 || nextSectorType == 5) {
                    y = sectorEdgeBottom.yPoint[wallBottom] + (x - sectorEdgeBottom.xPoint[wallBottom]) * (sectorEdgeBottom.yPoint[wallBottom + 1] - sectorEdgeBottom.yPoint[wallBottom]) / (sectorEdgeBottom.xPoint[wallBottom + 1] - sectorEdgeBottom.xPoint[wallBottom]);
                    if (this.fp_heroY > y << 8) {
                        int lastPoint = this.level.sectorEdgeTop[nextSector].pointsNumber - 2;
                        if (sectorEdgeBottom.nextSectorDeltaY[wallBottom] > 0) {
                            if (this.inAir()) {
                                this.currentSector = nextSector;
                                this.jumpBeginHeight += sectorEdgeBottom.nextSectorDeltaY[wallBottom] << 8;
                            } else {
                                if (this.orientation == 1) {
                                    this.changeState((byte)4, -1);
                                } else {
                                    this.changeState((byte)4, 1);
                                }
                                this.jumpBeginHeight = this.fp_heroY + (sectorEdgeBottom.nextSectorDeltaY[wallBottom] << 8);
                                this.nextSectorFall = nextSector;
                            }
                        } else if (sectorEdgeBottom.nextSectorDeltaY[wallBottom] < 0) {
                            if (this.inAir() && this.fp_heroY < this.jumpBeginHeight + (sectorEdgeBottom.nextSectorDeltaY[wallBottom] << 8)) {
                                this.currentSector = nextSector;
                                this.jumpBeginHeight += sectorEdgeBottom.nextSectorDeltaY[wallBottom] << 8;
                            } else {
                                y = sectorEdgeBottom.yPoint[wallBottom] + (x - sectorEdgeBottom.xPoint[wallBottom]) * (sectorEdgeBottom.yPoint[wallBottom + 1] - sectorEdgeBottom.yPoint[wallBottom]) / (sectorEdgeBottom.xPoint[wallBottom + 1] - sectorEdgeBottom.xPoint[wallBottom]);
                                if (this.inAir()) {
                                    this.jumpVelocity = 0;
                                    this.jumpDirection = 0;
                                }
                                this.fp_heroY = y << 8;
                            }
                        } else {
                            this.currentSector = nextSector;
                        }
                        return;
                    }
                    break block207;
                }
                y = sectorEdgeBottom.yPoint[wallBottom] + (x - sectorEdgeBottom.xPoint[wallBottom]) * (sectorEdgeBottom.yPoint[wallBottom + 1] - sectorEdgeBottom.yPoint[wallBottom]) / (sectorEdgeBottom.xPoint[wallBottom + 1] - sectorEdgeBottom.xPoint[wallBottom]);
                if (this.fp_heroY > y << 8) {
                    this.fp_heroY = y << 8;
                    this.changeState((byte)1, 0);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateAnimation(int deltaTime) {
        if (this.isComputer) {
            // empty if block
        }
        if (this.state == 5) {
            int climbFrame = Math.abs(((this.fp_heroY >> 8) - this.level.sectorEdgeBottom[this.currentSector].yPoint[0]) / 15 % this.heroSprite.currentSpriteAnimation.animationFramesCount);
            this.heroSprite.setAnimationFrame(climbFrame);
        } else {
            this.heroSprite.updateAnimation(deltaTime);
        }
    }

    public void changeState(byte newState, int stepRight) {
        block88: {
            try {
                if (this.state == newState || this.state == 8 && newState != 1 && newState != 4) break block88;
                this.nieKucam = false;
                if (newState > 26) {
                    this.nextAttak();
                }
                switch (newState) {
                    case 0: {
                        break;
                    }
                    case 2: 
                    case 23: {
                        this.heroSprite.setAnimation("move", 0);
                        break;
                    }
                    case 1: {
                        this.kierunekUderzenia = 0;
                        this.heroSprite.setAnimation("stand", 0);
                        break;
                    }
                    case 12: {
                        this.heroSprite.setAnimation("kolanko", 0);
                        break;
                    }
                    case 32: {
                        this.heroSprite.setAnimation("kolanko_hit", 0);
                        break;
                    }
                    case 13: {
                        this.heroSprite.setAnimation("kolanko_grab", 0);
                        break;
                    }
                    case 17: {
                        this.heroSprite.setAnimation("leze", 0);
                        break;
                    }
                    case 10: {
                        this.heroSprite.setAnimation("run", 0);
                        break;
                    }
                    case 24: {
                        this.heroSprite.setAnimation("boss_jump", 0);
                        break;
                    }
                    case 26: {
                        this.heroSprite.setAnimation("rotate", 0);
                        break;
                    }
                    case 3: 
                    case 37: {
                        this.jumpBeginHeight = this.fp_heroY;
                        this.jumpVelocity = !this.shortJump ? this.jumpVelocityBeginHero : -51040;
                        if (stepRight > 0) {
                            this.orientation = 0;
                            this.jumpDirection = 1;
                        } else if (stepRight < 0) {
                            this.orientation = 1;
                            this.jumpDirection = -1;
                        } else {
                            this.jumpDirection = 0;
                        }
                        this.heroSprite.setAnimation("jump", 0);
                        break;
                    }
                    case 27: {
                        this.jumpBeginHeight = this.fp_heroY;
                        this.jumpVelocity = -51040;
                        if (stepRight == 1) {
                            this.orientation = 0;
                            this.jumpDirection = 1;
                        } else if (stepRight == -1) {
                            this.orientation = 1;
                            this.jumpDirection = -1;
                        }
                        this.heroSprite.setAnimation("round_punch", 0);
                        break;
                    }
                    case 28: {
                        this.jumpBeginHeight = this.fp_heroY;
                        this.jumpVelocity = -35200;
                        if (stepRight > 0) {
                            this.orientation = 0;
                            this.jumpDirection = 1;
                        } else if (stepRight < 0) {
                            this.orientation = 1;
                            this.jumpDirection = -1;
                        } else {
                            this.jumpDirection = 0;
                        }
                        this.heroSprite.setAnimation("knee_kick", 0);
                        break;
                    }
                    case 4: {
                        if (!this.inAir()) {
                            this.fallSpeedX = 4224;
                            if (stepRight != -100) {
                                this.jumpVelocity = this.jumpVelocityBeginHero >> 3;
                            }
                            if (stepRight == 1) {
                                this.orientation = 0;
                                this.jumpDirection = 1;
                            } else if (stepRight == -1) {
                                this.orientation = 1;
                                this.jumpDirection = -1;
                            } else if (stepRight == 0) {
                                this.jumpDirection = 0;
                            }
                            this.heroSprite.setAnimation("jump", 1000);
                            break;
                        }
                        this.fallSpeedX = this.moveSpeedJumpHero;
                        break;
                    }
                    case 45: {
                        this.rhero = this.checkHit(this.PUNCH_RANGE, false);
                        if (!(this.rhero == null || this.isComputer || this.rhero.state != 25 && this.rhero.life >= 2)) {
                            this.rhero.life = (short)(this.rhero.life - 1);
                            this.heroSprite.setAnimation("uppercate", 0);
                            this.rhero.kierunekUderzenia = this.fp_heroX > this.rhero.fp_heroX ? (byte)-1 : (byte)1;
                            this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
                            break;
                        }
                        this.heroSprite.setAnimation("punch_1", 0);
                        this.continuePunch = false;
                        break;
                    }
                    case 46: {
                        this.rhero = this.checkHit(this.PUNCH_RANGE, false);
                        if (this.rhero != null && this.rhero.state == 25 && !this.isComputer) {
                            this.heroSprite.setAnimation("uppercate", 0);
                            this.rhero.kierunekUderzenia = this.fp_heroX > this.rhero.fp_heroX ? (byte)-1 : (byte)1;
                            this.rhero.changeState((byte)16, this.rhero.kierunekUderzenia);
                            break;
                        }
                        this.heroSprite.setAnimation("punch_2", 0);
                        this.continuePunch = false;
                        break;
                    }
                    case 44: 
                    case 49: {
                        this.heroSprite.setAnimation("uppercate", 0);
                        this.continuePunch = false;
                        break;
                    }
                    case 47: {
                        this.heroSprite.setAnimation("kick", 0);
                        break;
                    }
                    case 40: {
                        this.heroSprite.setAnimation("boss_kick", 0);
                        break;
                    }
                    case 43: {
                        this.heroSprite.setAnimation("jump_kick", 0);
                        break;
                    }
                    case 48: {
                        this.wasSpinningCyclone = true;
                        this.heroSprite.setAnimation("rotate_jump_kick", 0);
                        break;
                    }
                    case 5: {
                        this.heroSprite.setAnimation("climb", 0);
                        break;
                    }
                    case 6: {
                        if (this.state == 5) {
                            this.changeState((byte)16, this.fp_heroX - GameAppState.hero.fp_heroX);
                            return;
                        }
                        if (this.state == 3 || this.state == 43) {
                            int tempH = this.jumpBeginHeight;
                            this.changeState((byte)16, stepRight);
                            this.jumpBeginHeight = tempH;
                            break;
                        }
                        this.heroSprite.setAnimation("hit", 0);
                        break;
                    }
                    case 8: {
                        this.heroSprite.setAnimation("dead", 0);
                        break;
                    }
                    case 7: {
                        this.wasSpinningCyclone = false;
                        this.heroSprite.setAnimation("stand_up", 0);
                        break;
                    }
                    case 9: {
                        this.heroSprite.setAnimation("stay_down", 0);
                        break;
                    }
                    case 29: {
                        this.heroSprite.setAnimation("kick_front", 0);
                        break;
                    }
                    case 35: {
                        this.heroSprite.setAnimation("elbow_punch", 0);
                        break;
                    }
                    case 30: {
                        this.heroSprite.setAnimation("charge", 0);
                        break;
                    }
                    case 41: {
                        this.heroSprite.setAnimation("low_kick", 0);
                        break;
                    }
                    case 36: {
                        this.heroSprite.setAnimation("wykop", 0);
                        break;
                    }
                    case 15: {
                        this.heroSprite.setAnimation("enemy_throw", 0);
                        break;
                    }
                    case 21: {
                        this.heroSprite.setAnimation("fade_in", 0);
                        break;
                    }
                    case 22: {
                        this.heroSprite.setAnimation("fade_out", 0);
                        break;
                    }
                    case 42: {
                        this.heroSprite.setAnimation("shadow_attack", 0);
                        break;
                    }
                    case 25: {
                        if (this.state == 5) {
                            this.changeState((byte)16, stepRight);
                            return;
                        }
                        if (this.state == 3 || this.state == 43) {
                            int tempH = this.jumpBeginHeight;
                            this.changeState((byte)16, stepRight);
                            this.jumpBeginHeight = tempH;
                            break;
                        }
                        this.heroSprite.setAnimation("stunt", 0);
                        break;
                    }
                    case 19: {
                        this.heroSprite.setAnimation("boss_hit", 0);
                        break;
                    }
                    case 18: {
                        this.heroSprite.setAnimation("boss_grab", 0);
                        break;
                    }
                    case 20: {
                        this.heroSprite.setAnimation("disappeart", 0);
                        break;
                    }
                    case 16: {
                        this.numerOfHits = 0;
                        this.jumpBeginHeight = this.state == 3 || this.state == 43 || this.state == 48 ? this.jumpBeginHeight : this.fp_heroY;
                        this.jumpVelocity = -45056;
                        this.flySpeedX = this.moveSpeedJumpHero;
                        if (this.level.sectorType[this.currentSector] == 2 && this.isComputer) {
                            this.jumpBeginHeight = this.level.sectorEdgeBottom[this.currentSector].yPoint[0] + 3 << 8;
                            this.currentSector = this.level.sectorEdgeBottom[this.currentSector].edgeType[0];
                        }
                        if (stepRight > 0) {
                            this.orientation = 0;
                            this.jumpDirection = 1;
                        } else if (stepRight < 0) {
                            this.orientation = 1;
                            this.jumpDirection = -1;
                        }
                        this.heroSprite.setAnimation("power_fly", 0);
                        break;
                    }
                    case 14: {
                        this.numerOfHits = 0;
                        this.jumpBeginHeight = this.fp_heroY;
                        this.jumpVelocity = -90112;
                        this.flySpeedX = this.moveSpeedJumpHero << 1;
                        if (this.level.sectorType[this.currentSector] == 2) {
                            this.jumpBeginHeight = this.level.sectorEdgeBottom[this.currentSector].yPoint[0] + 3 << 8;
                            this.currentSector = this.level.sectorEdgeBottom[this.currentSector].edgeType[0];
                        }
                        if (stepRight < 0) {
                            this.orientation = 0;
                            this.jumpDirection = 1;
                        } else if (stepRight > 0) {
                            this.orientation = 1;
                            this.jumpDirection = -1;
                        }
                        this.heroSprite.setAnimation("enemy_fly", 0);
                        break;
                    }
                    case 100: {
                        try {
                            GameAppState.winda = Image.createImage((String)"/winda.png");
                            GameAppState.platforma = Image.createImage((String)"/platforma.png");
                            GameAppState.drawHeroFirst = true;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        this.jumpBeginHeight = stepRight << 8;
                        this.jumpVelocity = 10240;
                        this.heroSprite.setAnimation("stand", 0);
                        break;
                    }
                    case 11: {
                        this.heroSprite.setAnimation("pick_up", 0);
                        break;
                    }
                    case 31: {
                        if (this.weapon.weaponType == 4) {
                            this.heroSprite.setAnimation("pala_hit", 0);
                            break;
                        }
                        this.heroSprite.setAnimation("item_throw", 0);
                        break;
                    }
                    case 33: {
                        this.heroSprite.setAnimation("pala_hit", 0);
                        break;
                    }
                    case 38: {
                        this.heroSprite.setAnimation("round_kick", 0);
                        break;
                    }
                    case 39: {
                        this.heroSprite.setAnimation("round_punch", 0);
                        break;
                    }
                    case 34: {
                        this.heroSprite.setAnimation("mace_hit", 0);
                    }
                }
                this.state = newState;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics g) {
        try {
            if (this.state != 0 && this.visible && (this.immortalityTime == 0 || this.immortalityTime % 200 > 100) && this.heroSprite != null) {
                boolean animationMirrored = this.heroSprite.currentSpriteAnimation.imagesMirrored;
                if (!animationMirrored && this.orientation == 0 || animationMirrored && this.orientation == 1) {
                    if (this.isComputer) {
                        this.heroSprite.draw(g, GameAppState.scaleValue((this.fp_heroX >> 8) - GameAppState.cameraX), GameAppState.scaleValue((this.fp_heroY >> 8) - GameAppState.cameraY), 0, GameAppState.currentEnemyImage);
                    } else {
                        this.heroSprite.draw(g, GameAppState.scaleValue((this.fp_heroX >> 8) - GameAppState.cameraX), GameAppState.scaleValue((this.fp_heroY >> 8) - GameAppState.cameraY), 0);
                    }
                } else if (this.isComputer) {
                    this.heroSprite.draw(g, GameAppState.scaleValue((this.fp_heroX >> 8) - GameAppState.cameraX), GameAppState.scaleValue((this.fp_heroY >> 8) - GameAppState.cameraY), 2, GameAppState.currentEnemyImage);
                } else {
                    this.heroSprite.draw(g, GameAppState.scaleValue((this.fp_heroX >> 8) - GameAppState.cameraX), GameAppState.scaleValue((this.fp_heroY >> 8) - GameAppState.cameraY), 2);
                }
                if (this.weapon != null && this.handPos != null && this.state != 11 && this.state != 5 && this.state != 13 && this.state != 48) {
                    if (this.weapon.weaponType == 6 && this.state == 34) {
                        if (this.orientation == 0) {
                            if (this.heroSprite.currentFrame == 0) {
                                this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[2], this.handPos[3], 0, this.orientation);
                            } else if (this.heroSprite.currentFrame == 1) {
                                this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[4], this.handPos[5], 0, this.orientation);
                            } else if (this.heroSprite.currentFrame == 2) {
                                this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[6], this.handPos[7], 1, this.orientation);
                            } else if (this.heroSprite.currentFrame == 3) {
                                this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[8], this.handPos[9], 1, this.orientation);
                            }
                        } else if (this.heroSprite.currentFrame == 0) {
                            this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[2], this.handPos[3], 0, this.orientation);
                        } else if (this.heroSprite.currentFrame == 1) {
                            this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[4], this.handPos[5], 0, this.orientation);
                        } else if (this.heroSprite.currentFrame == 2) {
                            this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[6], this.handPos[7], 1, this.orientation);
                        } else if (this.heroSprite.currentFrame == 3) {
                            this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[8], this.handPos[9], 1, this.orientation);
                        }
                    } else if (this.state == 31) {
                        if (this.weapon.weaponType != 4 && this.heroSprite.currentFrame == 0) {
                            this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[2], this.handPos[3], 0, this.orientation);
                        }
                    } else if (this.state != 33 && (!this.isComputer || this.weapon.weaponType != 3 && this.weapon.weaponType != 1 && this.weapon.weaponType != 2)) {
                        this.weapon.paintInHands(g, this.fp_heroX, this.fp_heroY, this.handPos[0], this.handPos[1], 0, this.orientation);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean inAir() {
        return this.state == 37 || this.state == 3 || this.state == 43 || this.state == 16 || this.state == 14 || this.state == 28 || this.state == 48;
    }

    public Hero checkHit(int delta, boolean kick) {
        byte ile;
        byte skad;
        int orient = this.orientation;
        if (kick) {
            orient = this.orientation + 1 & 1;
        }
        if (this.isComputer) {
            skad = 0;
            ile = 0;
        } else {
            skad = 1;
            ile = GameAppState.ileWrogow;
        }
        for (byte i = skad; i <= ile; i = (byte)(i + 1)) {
            int dyUp = Y_RANGE;
            if (GameAppState.heros[i].state == 5) {
                dyUp = Y_RANGE << 2;
            }
            if (!(orient == 0 ? GameAppState.heros[i].fp_heroX >> 8 <= (this.fp_heroX >> 8) + delta && GameAppState.heros[i].fp_heroX >> 8 >= this.fp_heroX >> 8 && GameAppState.heros[i].fp_heroY >> 8 >= (this.fp_heroY >> 8) - dyUp && GameAppState.heros[i].fp_heroY >> 8 <= (this.fp_heroY >> 8) + Y_RANGE && GameAppState.heros[i].state != 8 && GameAppState.heros[i].state != 21 && GameAppState.heros[i].state != 22 && GameAppState.heros[i].state != 6 && GameAppState.heros[i].state != 16 && GameAppState.heros[i].state != 7 && GameAppState.heros[i].state != 17 && GameAppState.heros[i].state != 20 && GameAppState.heros[i].immortalityTime == 0 : orient == 1 && GameAppState.heros[i].fp_heroX >> 8 >= (this.fp_heroX >> 8) - delta && GameAppState.heros[i].fp_heroX >> 8 < this.fp_heroX >> 8 && GameAppState.heros[i].fp_heroY >> 8 >= (this.fp_heroY >> 8) - dyUp && GameAppState.heros[i].fp_heroY >> 8 <= (this.fp_heroY >> 8) + Y_RANGE && GameAppState.heros[i].state != 8 && GameAppState.heros[i].state != 21 && GameAppState.heros[i].state != 22 && GameAppState.heros[i].state != 6 && GameAppState.heros[i].state != 16 && GameAppState.heros[i].state != 7 && GameAppState.heros[i].state != 17 && GameAppState.heros[i].state != 20 && GameAppState.heros[i].immortalityTime == 0)) continue;
            return GameAppState.heros[i];
        }
        return null;
    }

    public Hero collisionJump() {
        byte ile;
        byte skad;
        if (this.isComputer) {
            skad = 0;
            ile = 0;
        } else {
            skad = 1;
            ile = GameAppState.ileWrogow;
        }
        for (byte i = skad; i <= ile; i = (byte)(i + 1)) {
            Hero komp = GameAppState.heros[i];
            int dyUp = Y_RANGE;
            if (komp.state == 5) {
                dyUp = Y_RANGE << 2;
            }
            if (komp.state == 6 || komp.state == 25 || komp.state == 16 || komp.state == 14 || komp.state == 7 || komp.state == 20 || komp.state == 17 || komp.state == 8 || komp.state == 9 || komp.state == 21 || komp.state == 22 || komp.state == 20 || komp.state == 42 || komp.immortalityTime != 0 || this.atakX1 < komp.colX1 && this.atakX2 < komp.colX1 || this.atakX1 > komp.colX2 && this.atakX2 > komp.colX2 || (this.atakY1 <= komp.colY2 || this.atakY1 >= komp.colY1) && (this.atakY2 <= komp.colY2 || this.atakY2 >= komp.colY1)) continue;
            if (komp.state != 5 && (this.jumpBeginHeight >> 8) - Y_RANGE * 3 < komp.colY1 && (this.jumpBeginHeight >> 8) + Y_RANGE * 3 > komp.colY1) {
                return komp;
            }
            if (komp.state == 5) {
                return komp;
            }
            if (komp.state != 3 && komp.state != 43) continue;
            return komp;
        }
        return null;
    }

    public boolean collision(int x, int y) {
        return x > this.fp_heroX - this.heroFrameWidthFP && x < this.fp_heroX + this.heroFrameWidthFP && y < this.fp_heroY && y > this.fp_heroY - this.heroFrameHeightFP;
    }

    public void pickUpWeapon(Weapon w) {
        w.state = (byte)3;
        this.weapon = w;
        GameAppState.removeWeapon(w.id);
    }

    public void throwWeapon() {
        if (this.weapon != null) {
            boolean bl = this.weapon.thrownByPlayer = !this.isComputer;
            if (this.orientation == 1) {
                this.weapon.throwWeapon(this.orientation, this.fp_heroX - 3840, this.fp_heroY - 6400, this.fp_heroY);
            } else {
                this.weapon.throwWeapon(this.orientation, this.fp_heroX + 3840, this.fp_heroY - 6400, this.fp_heroY);
            }
            this.weapon.sector = this.currentSector;
            if (this.weapon.weaponType != 10 && this.weapon.weaponType != 11) {
                this.weapon = null;
            }
        }
    }

    public void dropWeapon() {
        if (this.weapon.weaponType != 10 && this.weapon.weaponType != 11 && this.weapon.weaponType != 5) {
            this.weapon.state = 1;
            this.weapon.fp_X = this.fp_heroX;
            this.weapon.fp_Y = this.fp_heroY - 3840;
            this.weapon.fp_velX = 0;
            this.weapon.fp_velY = 0;
            this.weapon.granadeBounces = 0;
            this.weapon.beginHeight = this.jumpBeginHeight;
            if (this.weapon.weaponType == 2 || this.weapon.weaponType == 1) {
                this.weapon.granadeBounces = 0;
                this.weapon.timeToExplode = 2500;
                this.weapon.liveGranade = true;
            }
            GameAppState.addWeapon(this.weapon);
            this.weapon = null;
        }
    }

    public boolean wasHit() {
        return this.state == 16 || this.state == 4 || this.state == 8;
    }

    public void onPlayerKilled() {
        this.lives = (byte)(this.lives - 1);
        if (this.lives < 0) {
            this.visible = false;
            GameAppState.paused = true;
            GameAppState.menuIdRequested = (byte)104;
            GameAppState.fadeOutIn();
        } else {
            this.visible = true;
            GameAppState.drawHeroFirst = false;
            if (GameAppState.levelNumber == 7) {
                if (this.currentSector == 1 || this.currentSector == 2 || this.currentSector == 3) {
                    this.fp_lastX = 7680;
                    this.fp_lastY = 15616;
                    this.lastSector = 0;
                }
                if (this.level.currentRegion == 2) {
                    this.fp_lastX = 143360;
                    this.fp_lastY = 40704;
                    this.lastSector = 6;
                }
                if (this.level.currentRegion == 1) {
                    this.fp_lastX = this.level.sectorEdgeTop[5].xPoint[0] + 16 << 8;
                    this.fp_lastY = 32000;
                    this.lastSector = 5;
                }
                if (this.level.currentRegion == 3) {
                    this.fp_lastX = this.level.sectorEdgeTop[19].xPoint[0] + 16 << 8;
                    this.fp_lastY = 32000;
                    this.lastSector = 19;
                }
            }
            this.fp_heroY = this.fp_lastY;
            this.fp_heroX = this.fp_lastX;
            this.currentSector = this.lastSector;
            this.life = (short)80;
            this.changeState((byte)1, 0);
            this.immortalityTime = (short)2000;
        }
    }

    public void Serialize(DataOutputStream out) {
        try {
            out.writeByte(this.state);
            out.writeUTF(this.heroSprite.currentSpriteAnimation.animationName);
            out.writeInt(this.heroSprite.animationTime);
            out.writeInt(this.heroSprite.currentFrame);
            out.writeByte(this.orientation);
            out.writeInt(this.fp_heroX);
            out.writeInt(this.fp_heroY);
            out.writeByte(this.currentSector);
            out.writeInt(this.fp_lastX);
            out.writeInt(this.fp_lastY);
            out.writeByte(this.lastSector);
            out.writeByte(this.currentRegionX);
            out.writeByte(this.currentRegionY);
            out.writeShort(this.life);
            out.writeByte(this.lives);
            out.writeInt(this.score);
            out.writeInt(this.stepDown);
            out.writeInt(this.stepRight);
            out.writeInt(this.jumpBeginHeight);
            out.writeInt(this.jumpDirection);
            out.writeInt(this.jumpVelocity);
            out.writeInt(this.jump);
            out.writeBoolean(this.jumpKick);
            out.writeInt(this.nextSectorFall);
            out.writeLong(this.timeAfterHit);
            out.writeByte(this.stanAkcji);
            out.writeByte(this.akcja);
            out.writeByte(this.backUpakcja);
            out.writeByte(this.backUpstate);
            out.writeShort(this.inicjatywa);
            out.writeInt(this.time);
            out.writeInt(this.reflex);
            out.writeInt(this.timeToChange);
            out.writeByte(this.newAkcja);
            out.writeByte(this.newStanAkcji);
            out.writeBoolean(this.changeAkcja);
            out.writeBoolean(this.typPoruszania);
            out.writeByte(this.yGoOnBack);
            out.writeBoolean(this.jaBije);
            out.writeByte(this.doNotHitMe);
            out.writeBoolean(this.continueKick);
            out.writeBoolean(this.continuePunch);
            out.writeByte(this.numerOfHits);
            out.writeByte(this.numerGoodKneeHit);
            if (this.rhero == null) {
                out.writeByte(-1);
            } else {
                out.writeByte(this.rhero.id);
            }
            if (this.khero == null) {
                out.writeByte(-1);
            } else {
                out.writeByte(this.khero.id);
            }
            out.writeBoolean(this.czyUdalSieKneeKick);
            out.writeBoolean(this.czyUdalSieHypierUpperCut);
            out.writeByte(this.kierunekUderzenia);
            out.writeBoolean(this.haveWeapon);
            out.writeBoolean(this.weGonaJump);
            out.writeBoolean(this.wasDisappeart);
            this.SerializePoint(this.watingZone, out);
            this.SerializePoint(this.attackZone, out);
            this.SerializePoint(this.lastHeroPoz, out);
            this.SerializePoint(this.attackPoint, out);
            this.SerializePoint(this.myPoint, out);
            out.writeByte(this.nextAttack);
            out.writeByte(this.lastAttack);
            out.writeByte(this.indexAttack);
            out.writeBoolean(this.jumpKick);
            out.writeByte(this.ilePunchow);
            out.writeBoolean(this.visible);
            out.writeBoolean(this.fading);
            out.writeInt(this.FADING_VISIBLE_TIME);
            out.writeInt(this.fTime);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void SerializePoint(Point p, DataOutputStream out) {
        try {
            if (p != null) {
                out.writeShort(p.x);
                out.writeShort(p.y);
                out.writeByte(p.passingType);
            } else {
                out.writeShort(-1);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Point DeSerializePoint(DataInputStream in) {
        try {
            short x = in.readShort();
            if (x != -1) {
                Point p = new Point();
                p.x = x;
                p.y = in.readShort();
                p.passingType = in.readByte();
                return p;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void DeSerialize(DataInputStream in) {
        try {
            this.state = in.readByte();
            if (this.state == 100) {
                try {
                    GameAppState.winda = Image.createImage((String)"/winda.png");
                    GameAppState.platforma = Image.createImage((String)"/platforma.png");
                    GameAppState.drawHeroFirst = true;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            this.heroSprite.setAnimation(in.readUTF(), in.readInt());
            this.heroSprite.currentFrame = in.readInt();
            this.orientation = in.readByte();
            this.fp_heroX = in.readInt();
            this.fp_heroY = in.readInt();
            this.currentSector = in.readByte();
            this.fp_lastX = in.readInt();
            this.fp_lastY = in.readInt();
            this.lastSector = in.readByte();
            this.currentRegionX = in.readByte();
            this.currentRegionY = in.readByte();
            this.life = in.readShort();
            this.lives = in.readByte();
            this.score = in.readInt();
            this.stepDown = in.readInt();
            this.stepRight = in.readInt();
            this.jumpBeginHeight = in.readInt();
            this.jumpDirection = in.readInt();
            this.jumpVelocity = in.readInt();
            this.jump = in.readInt();
            this.jumpKick = in.readBoolean();
            this.nextSectorFall = in.readInt();
            this.timeAfterHit = in.readLong();
            this.stanAkcji = in.readByte();
            this.akcja = in.readByte();
            this.backUpakcja = in.readByte();
            this.backUpstate = in.readByte();
            this.inicjatywa = in.readShort();
            this.time = in.readInt();
            this.reflex = in.readInt();
            this.timeToChange = in.readInt();
            this.newAkcja = in.readByte();
            this.newStanAkcji = in.readByte();
            this.changeAkcja = in.readBoolean();
            this.typPoruszania = in.readBoolean();
            this.yGoOnBack = in.readByte();
            this.jaBije = in.readBoolean();
            this.doNotHitMe = in.readByte();
            this.continueKick = in.readBoolean();
            this.continuePunch = in.readBoolean();
            this.numerOfHits = in.readByte();
            this.numerGoodKneeHit = in.readByte();
            byte id = in.readByte();
            if (id != -1) {
                this.rhero = GameAppState.heros[id];
            }
            if ((id = in.readByte()) != -1) {
                this.khero = GameAppState.heros[id];
            }
            this.czyUdalSieKneeKick = in.readBoolean();
            this.czyUdalSieHypierUpperCut = in.readBoolean();
            this.kierunekUderzenia = in.readByte();
            this.haveWeapon = in.readBoolean();
            this.weGonaJump = in.readBoolean();
            this.wasDisappeart = in.readBoolean();
            this.watingZone = this.DeSerializePoint(in);
            this.attackZone = this.DeSerializePoint(in);
            this.lastHeroPoz = this.DeSerializePoint(in);
            this.attackPoint = this.DeSerializePoint(in);
            this.myPoint = this.DeSerializePoint(in);
            this.nextAttack = in.readByte();
            this.lastAttack = in.readByte();
            this.indexAttack = in.readByte();
            this.jumpKick = in.readBoolean();
            this.ilePunchow = in.readByte();
            this.visible = in.readBoolean();
            this.fading = in.readBoolean();
            this.FADING_VISIBLE_TIME = in.readInt();
            this.fTime = in.readInt();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void clear() {
        if (this.heroAnimation != null) {
            if (!this.isComputer && this.heroAnimation.tilesImage != null) {
                this.heroAnimation.tilesImage.clear();
            }
            this.heroAnimation.tilesImage = null;
            this.heroAnimation.clear();
            this.heroAnimation = null;
        }
        if (this.heroSprite != null) {
            this.heroSprite.clear();
            this.heroSprite = null;
        }
    }

    public static int random(int scale) {
        if (scale == 0) {
            return 0;
        }
        return (RANDOM.nextInt() << 1 >>> 1) % scale;
    }

    public static int randomWithMinus(int scale) {
        if (scale == 0) {
            return 0;
        }
        return (RANDOM.nextInt() >>> 1 << 1) % (scale << 1) >> 1;
    }

    private static boolean decision_init1(int deltaTime) {
        trueDelta = deltaTime;
        deltaTime = (deltaTime >> 2) + (deltaTime >> 1);
        gracz = GameAppState.heros[0];
        if (gracz == null) {
            return true;
        }
        if (GameAppState.heros[1] == null) {
            return true;
        }
        pozx = (short)(Hero.gracz.fp_heroX >> 8);
        if (gracz.inAir()) {
            pozy = (short)(Hero.gracz.jumpBeginHeight >> 8);
        } else {
            pozy = (short)(Hero.gracz.fp_heroY >> 8);
            Hero.heroWaiting[1].x = (short)(pozx + GameAppState.heros[1].watingZone.x);
            Hero.heroWaiting[1].y = (short)pozy;
            pp = GameAppState.level.checkPoint(Hero.heroWaiting[1].x, Hero.heroWaiting[1].y, Hero.gracz.currentSector);
            if (pp != null) {
                Hero.heroWaiting[1].x = Hero.pp.x;
            }
            Hero.heroWaiting[0].x = (short)(pozx - GameAppState.heros[1].watingZone.x);
            Hero.heroWaiting[0].y = (short)pozy;
            pp = GameAppState.level.checkPoint(Hero.heroWaiting[0].x, Hero.heroWaiting[0].y, Hero.gracz.currentSector);
            if (pp != null) {
                Hero.heroWaiting[0].x = Hero.pp.x;
            }
        }
        Hero.heroAttack[0].x = (short)(pozx - GameAppState.heros[1].attackZone.x);
        Hero.heroAttack[0].y = (short)pozy;
        pp = GameAppState.level.checkPoint(Hero.heroAttack[0].x, Hero.heroAttack[0].y, Hero.gracz.currentSector);
        if (pp != null) {
            Hero.heroAttack[0].x = Hero.pp.x;
        }
        Hero.heroAttack[1].x = (short)(pozx + GameAppState.heros[1].attackZone.x);
        Hero.heroAttack[1].y = (short)pozy;
        pp = GameAppState.level.checkPoint(Hero.heroAttack[1].x, Hero.heroAttack[1].y, GameAppState.heros[0].currentSector);
        if (pp != null) {
            Hero.heroAttack[1].x = Hero.pp.x;
        }
        Hero.gracz.myPoint.x = (short)pozx;
        Hero.gracz.myPoint.y = (short)pozy;
        GameAppState.heros[1].d1 = -1;
        if (GameAppState.ileWrogow > 1) {
            GameAppState.heros[2].d1 = -1;
        }
        for (byte i = 1; i <= GameAppState.ileWrogow; i = (byte)(i + 1)) {
            komp = GameAppState.heros[i];
            if (Hero.komp.state == 1 || Hero.komp.state == 2) {
                Hero.komp.orientation = Hero.komp.fp_heroX < Hero.gracz.fp_heroX ? (byte)0 : 1;
            }
            Hero.komp.stepRight = 0;
            Hero.komp.stepDown = 0;
            Hero.komp.jump = 0;
            Hero.komp.attack[0] = 0;
            Hero.komp.attack[1] = 0;
            Hero.komp.myPoint.x = (short)(Hero.komp.fp_heroX >> 8);
            Hero.komp.myPoint.y = (short)(Hero.komp.fp_heroY >> 8);
            Hero.komp.d1 = Math.abs(Hero.komp.myPoint.x - Hero.gracz.myPoint.x) + (Hero.komp.myPoint.y - Hero.gracz.myPoint.y) * (Hero.komp.myPoint.y - Hero.gracz.myPoint.y);
        }
        return false;
    }

    private static boolean decision_init2(int deltaTime) {
        for (byte i = 1; i <= GameAppState.ileWrogow; i = (byte)(i + 1)) {
            komp = GameAppState.heros[i];
            if (Hero.komp.state == 4 || Hero.komp.state == 6 || Hero.komp.state == 17 || Hero.komp.state == 7 || Hero.komp.state == 13 || Hero.komp.state == 8 || Hero.komp.state == 20 || Hero.komp.state == 22 || Hero.komp.state == 21 || Hero.komp.state == 23 || Hero.komp.state == 42 || Hero.komp.state == 39 || Hero.komp.state == 40 || Hero.komp.state == 23) {
                Hero.komp.stanAkcji = 0;
                Hero.komp.akcja = (byte)21;
                continue;
            }
            if (Hero.komp.state == 3 || Hero.komp.state == 43 || Hero.komp.state == 16 || Hero.komp.state == 14 || Hero.komp.state == 27 || Hero.komp.state == 37) {
                Hero.komp.stanAkcji = 0;
                Hero.komp.akcja = (byte)10;
                continue;
            }
            if (Hero.gracz.currentSector != Hero.komp.currentSector) {
                Hero.komp.akcja = (byte)8;
                Hero.komp.stanAkcji = 0;
                komp.changeState((byte)2, 0);
                Point p = Hero.komp.level.getExitFromSector(Hero.komp.currentSector, Hero.gracz.currentSector);
                if (p == null) continue;
                if (p.y < Hero.komp.myPoint.y) {
                    Hero.komp.stepDown = -deltaTime;
                } else if (p.y > Hero.komp.myPoint.y) {
                    Hero.komp.stepDown = deltaTime;
                }
                if (p.x > Hero.komp.myPoint.x) {
                    Hero.komp.stepRight = deltaTime;
                } else if (p.x < Hero.komp.myPoint.x) {
                    Hero.komp.stepRight = -deltaTime;
                }
                if (p.passingType == 0 || Hero.komp.stepDown != 0 || Hero.komp.stepRight != 0) continue;
                if (p.passingType == 1) {
                    komp.changeState((byte)3, -1);
                    Hero.komp.akcja = (byte)10;
                    Hero.komp.stanAkcji = 0;
                    continue;
                }
                komp.changeState((byte)3, 1);
                Hero.komp.akcja = (byte)10;
                Hero.komp.stanAkcji = 0;
                continue;
            }
            if (Hero.gracz.state != 3 && Hero.gracz.state != 43 && Hero.gracz.state != 48 || Math.abs(Hero.komp.myPoint.x - Hero.gracz.myPoint.x) > DISTANCE_PLAYER_IN_AIR || Hero.komp.akcja == 16 || Hero.komp.akcja == -1 || Hero.komp.nieKucam) continue;
            if (Hero.komp.enemyType == 32) {
                komp.changeState((byte)29, 0);
                Hero.komp.akcja = (byte)16;
                Hero.komp.stanAkcji = 0;
                continue;
            }
            if (Hero.komp.enemyType == 67) {
                komp.changeState((byte)39, 0);
                Hero.komp.akcja = (byte)16;
                Hero.komp.stanAkcji = 0;
                continue;
            }
            if (Hero.komp.enemyType == 8) {
                if (komp.getAttack() == 18 && Hero.gracz.immortalityTime == 0) {
                    komp.changeState((byte)18, 0);
                    Hero.gracz.kierunekUderzenia = Hero.komp.orientation == 1 ? (byte)-1 : (byte)1;
                    Hero.gracz.fp_heroY = Hero.komp.fp_heroY;
                    Hero.gracz.fp_heroX = Hero.komp.fp_heroX + Hero.gracz.kierunekUderzenia * (Hero.gracz.heroFrameWidthFP << 1);
                    gracz.changeState((byte)0, Hero.gracz.kierunekUderzenia);
                    Hero.komp.numerGoodKneeHit = 0;
                    Hero.komp.stanAkcji = (byte)4;
                    Hero.komp.akcja = (byte)-1;
                    continue;
                }
                komp.changeState((byte)9, 0);
                Hero.komp.akcja = (byte)16;
                Hero.komp.stanAkcji = 0;
                continue;
            }
            if (Hero.komp.enemyType == 68) {
                Hero.komp.nieKucam = true;
                if (Hero.random(100) >= 85) continue;
                komp.changeState((byte)9, 0);
                Hero.komp.akcja = (byte)16;
                Hero.komp.stanAkcji = 0;
                continue;
            }
            Hero.komp.nieKucam = true;
            if (Hero.random(100) >= 15) continue;
            komp.changeState((byte)9, 0);
            Hero.komp.akcja = (byte)16;
            Hero.komp.stanAkcji = 0;
        }
        return false;
    }

    private static boolean decision_brak(int deltaTime) {
        if (Hero.komp.state == 1) {
            Hero.komp.stanAkcji = 0;
            Hero.komp.akcja = 1;
            komp.changeState((byte)1, 0);
        }
        return false;
    }

    private static boolean decision_drabina(int deltaTime) {
        if (Hero.gracz.currentSector == Hero.komp.currentSector) {
            komp.changeState((byte)1, 0);
            Hero.komp.akcja = 1;
            Hero.komp.stanAkcji = 0;
        }
        return false;
    }

    private static boolean decision_kucam(int deltaTime) {
        if (Hero.gracz.state != 3 && Hero.gracz.state != 43 && Hero.gracz.state != 48) {
            komp.changeState((byte)1, 0);
            Hero.komp.akcja = 1;
            Hero.komp.stanAkcji = 0;
        }
        return false;
    }

    private static boolean decision_rzucam(int deltaTime) {
        if (Hero.komp.state == 1) {
            Hero.komp.akcja = 1;
            Hero.komp.stanAkcji = 0;
        }
        return false;
    }

    private static boolean decision_niemysle(int deltaTime) {
        if (Hero.komp.state != 4 && Hero.komp.state != 6 && Hero.komp.state != 17 && Hero.komp.state != 7 && Hero.komp.state != 13 && Hero.komp.state != 8 && Hero.komp.state != 20 && Hero.komp.state != 22 && Hero.komp.state != 21 && Hero.komp.state != 23 && Hero.komp.state != 42) {
            Hero.komp.akcja = 1;
            Hero.komp.stanAkcji = 0;
        }
        return false;
    }

    private static boolean decision_skacze(int deltaTime) {
        if (Hero.komp.state == 7 || Hero.komp.state == 1) {
            Hero.komp.stanAkcji = 0;
            Hero.komp.akcja = 1;
        }
        return false;
    }

    private static boolean decision_czekaj(int deltaTime) {
        Hero.komp.stanAkcji = 0;
        Hero.komp.attackPoint = (Hero.komp.myPoint.x - Hero.heroAttack[Hero.komp.orientation].x) * (Hero.komp.myPoint.x - Hero.heroAttack[Hero.komp.orientation].x) + (Hero.komp.myPoint.y - Hero.heroAttack[Hero.komp.orientation].y) * (Hero.komp.myPoint.y - Hero.heroAttack[Hero.komp.orientation].y) <= (Hero.komp.myPoint.x - Hero.heroWaiting[Hero.komp.orientation].x) * (Hero.komp.myPoint.x - Hero.heroWaiting[Hero.komp.orientation].x) + (Hero.komp.myPoint.y - Hero.heroWaiting[Hero.komp.orientation].y) * (Hero.komp.myPoint.y - Hero.heroWaiting[Hero.komp.orientation].y) ? heroAttack[Hero.komp.orientation] : heroWaiting[Hero.komp.orientation];
        wynik = Hero.komp.attackPoint.checkObszar(Hero.komp.myPoint, 2, 4);
        if (wynik == 1) {
            if (Hero.komp.d1 > 120 && Hero.komp.canRun) {
                komp.changeState((byte)10, 0);
                Hero.komp.akcja = (byte)3;
                Hero.komp.stanAkcji = (byte)2;
            } else {
                los = (byte)Hero.random(6);
                komp.changeState((byte)2, 0);
                Hero.komp.akcja = (byte)2;
                Hero.komp.stanAkcji = 1;
            }
        } else if (wynik == 0) {
            if (GameAppState.ileWrogow == 1) {
                Hero.komp.jaBije = true;
                Hero.komp.attackPoint = heroAttack[Hero.komp.orientation];
                if (komp.getAttack() == 43) {
                    if (Hero.komp.enemyType != 67) {
                        Hero.komp.jumpKick = true;
                        Hero.komp.stanAkcji = 0;
                        if (Hero.komp.orientation == 1) {
                            komp.changeState((byte)3, -1);
                        } else {
                            komp.changeState((byte)3, 1);
                        }
                    } else {
                        Hero.komp.stanAkcji = 0;
                        if (Hero.komp.orientation == 1) {
                            komp.changeState((byte)27, -1);
                        } else {
                            komp.changeState((byte)27, 1);
                        }
                    }
                } else {
                    Hero.komp.akcja = (byte)5;
                    Hero.komp.stanAkcji = 1;
                }
            } else if (!GameAppState.heros[1].jaBije && !GameAppState.heros[2].jaBije) {
                Hero.komp.jaBije = true;
                if (komp.getAttack() == 43) {
                    Hero.komp.jumpKick = true;
                    Hero.komp.stanAkcji = 0;
                    if (Hero.komp.orientation == 1) {
                        komp.changeState((byte)3, -1);
                    } else {
                        komp.changeState((byte)3, 1);
                    }
                } else {
                    Hero.komp.attackPoint = heroAttack[Hero.komp.orientation];
                    Hero.komp.akcja = (byte)5;
                    Hero.komp.stanAkcji = 1;
                }
            } else {
                Hero.komp.jaBije = false;
                los = (byte)Hero.random(2);
                if (los == 0 && GameAppState.level.currentRegion == 0) {
                    Point p2;
                    Hero.komp.attackPoint = new Point(heroWaiting[Hero.komp.orientation + 1 & 1]);
                    Hero.komp.lastHeroPoz = new Point(Hero.gracz.myPoint);
                    Point p1 = GameAppState.level.checkPoint(Hero.gracz.myPoint.x, Hero.gracz.myPoint.y + 15, Hero.komp.currentSector);
                    if (p1 != null) {
                        Hero.komp.yGoOnBack = (byte)Math.abs(Hero.gracz.myPoint.y - p1.y);
                    }
                    if ((p2 = GameAppState.level.checkPoint(Hero.gracz.myPoint.x, Hero.gracz.myPoint.y - 15, Hero.komp.currentSector)) != null) {
                        Hero.komp.yGoOnBack = (byte)Math.abs(Hero.gracz.myPoint.y - p2.y);
                    }
                    Hero.komp.akcja = (byte)4;
                    komp.changeState((byte)2, 0);
                    Hero.komp.stanAkcji = 1;
                    if (Hero.komp.canRotate) {
                        los = (byte)Hero.random(3);
                        if (los == 0) {
                            komp.changeState((byte)26, 0);
                        } else if (los == 1) {
                            komp.changeState((byte)10, 0);
                        }
                    } else if (Hero.komp.canJump) {
                        Hero.komp.akcja = (byte)10;
                        if (Hero.komp.orientation == 1) {
                            komp.changeState((byte)3, -1);
                        } else {
                            komp.changeState((byte)3, 1);
                        }
                        Hero.komp.stanAkcji = 0;
                    }
                } else {
                    Hero.komp.akcja = 0;
                    Hero.komp.stanAkcji = 0;
                }
            }
        }
        return false;
    }

    private static boolean decision_postuj(int deltaTime) {
        Hero.komp.stanAkcji = 0;
        Hero.komp.attackPoint = heroWaiting[Hero.komp.orientation];
        if (GameAppState.ileWrogow == 1) {
            Hero.komp.jaBije = true;
            Hero.komp.attackPoint = heroAttack[Hero.komp.orientation];
            Hero.komp.akcja = (byte)5;
            Hero.komp.stanAkcji = 1;
        } else if (Hero.komp.d1 < Hero.ten2.d1 && Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 0) {
            Hero.komp.akcja = (byte)6;
            Hero.komp.stanAkcji = (byte)4;
            Hero.komp.jaBije = true;
            los = (byte)Hero.random(6);
            Hero.ten2.jaBije = false;
            Hero.ten2.attackPoint = heroWaiting[Hero.ten2.orientation];
            if (Hero.ten2.akcja != 7 && Hero.ten2.akcja != 10 && Hero.ten2.akcja != 11 && Hero.ten2.akcja != 13 && Hero.ten2.akcja != 9 && Hero.ten2.akcja != 8) {
                ten2.changeState((byte)2, 0);
                Hero.ten2.akcja = (byte)2;
                Hero.ten2.stanAkcji = 1;
            }
        } else if (Hero.komp.attackPoint.checkObszar(Hero.komp.myPoint, 2, 4) == 1) {
            Hero.komp.stanAkcji = 1;
            Hero.komp.akcja = (byte)2;
        } else if (!GameAppState.heros[1].jaBije && !GameAppState.heros[2].jaBije) {
            Hero.komp.jaBije = true;
            Hero.komp.attackPoint = heroAttack[Hero.komp.orientation];
            Hero.komp.akcja = (byte)5;
            Hero.komp.stanAkcji = 1;
        }
        return false;
    }

    private static boolean decision_idz(int deltaTime) {
        Hero.komp.stanAkcji = 1;
        Hero.komp.attackPoint = heroWaiting[Hero.komp.orientation];
        wynik = Hero.komp.attackPoint.checkObszar(Hero.komp.myPoint, 2, 4);
        if (GameAppState.ileWrogow > 1 && Hero.komp.d1 < Hero.ten2.d1 && Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 0) {
            Hero.komp.akcja = (byte)6;
            Hero.komp.stanAkcji = (byte)4;
            Hero.komp.jaBije = true;
            Hero.ten2.jaBije = false;
            Hero.ten2.attackPoint = heroWaiting[Hero.ten2.orientation];
            if (Hero.ten2.akcja != 7 && Hero.ten2.akcja != 10 && Hero.ten2.akcja != 11 && Hero.ten2.akcja != 13 && Hero.ten2.akcja != 9 && Hero.ten2.akcja != 8) {
                ten2.changeState((byte)2, 0);
                Hero.ten2.akcja = (byte)2;
                Hero.ten2.stanAkcji = 1;
            }
            return true;
        }
        if (wynik == 0) {
            Hero.komp.akcja = 1;
            Hero.komp.stanAkcji = 0;
        } else if (wynik == 1) {
            if (Hero.komp.d1 > 120 && Hero.komp.canRun) {
                Hero.komp.akcja = (byte)3;
                Hero.komp.stanAkcji = (byte)2;
                komp.changeState((byte)10, 0);
            } else {
                Hero.komp.akcja = (byte)2;
                Hero.komp.stanAkcji = 1;
            }
        }
        return false;
    }

    private static boolean decision_biegnij(int deltaTime) {
        Hero.komp.stanAkcji = (byte)2;
        wynik = Hero.komp.attackPoint.checkObszar(Hero.komp.myPoint, 2, 4);
        if (GameAppState.ileWrogow > 1 && Hero.komp.d1 < Hero.ten2.d1 && Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 0) {
            Hero.komp.akcja = (byte)6;
            Hero.komp.stanAkcji = (byte)4;
            Hero.komp.jaBije = true;
            los = (byte)Hero.random(6);
            Hero.ten2.jaBije = false;
            Hero.ten2.attackPoint = heroWaiting[Hero.ten2.orientation];
            if (Hero.ten2.akcja != 7 && Hero.ten2.akcja != 10 && Hero.ten2.akcja != 11 && Hero.ten2.akcja != 13 && Hero.ten2.akcja != 9 && Hero.ten2.akcja != 8) {
                ten2.changeState((byte)2, 0);
                Hero.ten2.akcja = (byte)2;
                Hero.ten2.stanAkcji = 1;
            }
        }
        if (wynik == 0) {
            Hero.komp.akcja = 1;
            Hero.komp.stanAkcji = 0;
        }
        return false;
    }

    private static boolean decision_podchodze(int deltaTime) {
        Hero.komp.stanAkcji = 1;
        Hero.komp.attackPoint = heroAttack[Hero.komp.orientation];
        if (Hero.komp.enemyType == 32 && Hero.random(20) == 0 && !fantomBall) {
            fantomBall = true;
            Hero.komp.jaBije = true;
            komp.changeState((byte)30, 0);
            Hero.komp.attackPoint = new Point(heroAttack[Hero.komp.orientation + 1 & 1]);
            Hero.komp.akcja = (byte)15;
            Hero.komp.stanAkcji = (byte)6;
        } else if (Hero.komp.enemyType == 68 && Hero.random(100) == 0 && !fantomBall) {
            fantomBall = true;
            if (Hero.random(2) == 0) {
                komp.changeState((byte)31, 0);
                Hero.komp.stanAkcji = 0;
                Hero.komp.akcja = (byte)18;
            } else {
                komp.changeState((byte)22, 0);
            }
        } else if (komp.getAttack() == 43 && !Hero.ten2.jaBije) {
            if (Hero.komp.enemyType != 67) {
                Hero.komp.jumpKick = true;
                Hero.komp.stanAkcji = 0;
                if (Hero.komp.orientation == 1) {
                    komp.changeState((byte)3, -1);
                } else {
                    komp.changeState((byte)3, 1);
                }
            } else {
                Hero.komp.stanAkcji = 0;
                if (Hero.komp.orientation == 1) {
                    komp.changeState((byte)27, -1);
                } else {
                    komp.changeState((byte)27, 1);
                }
            }
        } else if (komp.getAttack() == 31 && Hero.komp.weapon != null) {
            if (GameAppState.ileWrogow > 1 && !Hero.ten2.jaBije || GameAppState.ileWrogow == 1) {
                komp.changeState((byte)31, 0);
                Hero.komp.stanAkcji = 0;
                Hero.komp.akcja = (byte)18;
            }
        } else if (GameAppState.ileWrogow == 1) {
            if (Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 0) {
                Hero.komp.akcja = (byte)6;
                Hero.komp.stanAkcji = (byte)4;
                Hero.komp.inicjatywa = Hero.komp.INICJATYWA_START;
            }
        } else if (Hero.komp.d1 < Hero.ten2.d1 && Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 0) {
            Hero.komp.akcja = (byte)6;
            Hero.komp.stanAkcji = (byte)4;
            if (Hero.ten2.akcja == 6 || Hero.ten2.akcja == 5) {
                Hero.ten2.attackPoint = heroWaiting[Hero.ten2.orientation];
                ten2.changeState((byte)2, 0);
                Hero.ten2.akcja = (byte)2;
                Hero.ten2.stanAkcji = 1;
                Hero.ten2.jaBije = false;
            }
        }
        return false;
    }

    private static boolean decision_natyl(int deltaTime) {
        Hero.komp.stanAkcji = (byte)3;
        wynik = Hero.komp.attackPoint.checkObszar(Hero.komp.myPoint, 2, 4);
        if (GameAppState.ileWrogow == 1) {
            Hero.komp.jaBije = true;
            Hero.komp.attackPoint = heroAttack[Hero.komp.orientation];
            Hero.komp.akcja = (byte)5;
            Hero.komp.stanAkcji = 1;
        } else {
            if (Hero.komp.heroSprite.animationTime > Hero.komp.heroSprite.currentSpriteAnimation.frameTime * Hero.komp.heroSprite.currentSpriteAnimation.animationFramesCount && wynik == 0) {
                Hero.komp.akcja = 0;
                Hero.komp.stanAkcji = 0;
            }
            if (Hero.komp.d1 < Hero.ten2.d1 && Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 0) {
                Hero.komp.akcja = (byte)6;
                Hero.komp.stanAkcji = (byte)4;
                Hero.komp.jaBije = true;
                if (Hero.ten2.akcja == 6 || Hero.ten2.akcja == 5) {
                    los = (byte)Hero.random(6);
                    Hero.ten2.attackPoint = heroWaiting[Hero.ten2.orientation];
                    ten2.changeState((byte)2, 0);
                    Hero.ten2.akcja = (byte)2;
                    Hero.ten2.stanAkcji = 1;
                    Hero.ten2.jaBije = false;
                }
            }
        }
        return false;
    }

    private static boolean decision_atakuje(int deltaTime) {
        fantomBall = false;
        Hero.komp.stanAkcji = Hero.gracz.state != 17 && Hero.gracz.state != 7 && Hero.gracz.state != 8 ? (byte)4 : (byte)0;
        if (GameAppState.ileWrogow == 1) {
            if (Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 0) {
                Hero.komp.jaBije = true;
                Hero.komp.akcja = (byte)6;
                Hero.komp.stanAkcji = (byte)4;
            } else if (Hero.komp.myPoint.x <= Hero.gracz.myPoint.x + Hero.komp.attackZone.x && Hero.komp.myPoint.x >= Hero.gracz.myPoint.x - Hero.komp.attackZone.x) {
                Hero.komp.stanAkcji = 1;
                Hero.komp.attackPoint = new Point(Hero.komp.myPoint.x, Hero.gracz.myPoint.y);
            } else {
                Hero.komp.jaBije = false;
                Hero.komp.akcja = 1;
                Hero.komp.stanAkcji = 0;
            }
        } else if (GameAppState.ileWrogow == 2) {
            if (Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 0) {
                if (Hero.komp.d1 < Hero.ten2.d1) {
                    Hero.komp.akcja = (byte)6;
                    Hero.komp.stanAkcji = (byte)4;
                    Hero.komp.jaBije = true;
                } else {
                    Hero.komp.jaBije = false;
                    Hero.komp.akcja = 1;
                    Hero.komp.stanAkcji = 0;
                }
            } else if (Hero.gracz.myPoint.checkObszar(Hero.komp.myPoint, Hero.komp.attackZone.x, Hero.komp.attackZone.y) == 1) {
                if (Hero.komp.myPoint.x <= Hero.gracz.myPoint.x + Hero.komp.attackZone.x && Hero.komp.myPoint.x >= Hero.gracz.myPoint.x - Hero.komp.attackZone.x) {
                    Hero.komp.stanAkcji = 1;
                    Hero.komp.attackPoint = new Point(Hero.komp.myPoint.x, Hero.gracz.myPoint.y);
                } else if (Hero.komp.jaBije) {
                    Hero.komp.akcja = (byte)5;
                    Hero.komp.stanAkcji = 0;
                } else {
                    Hero.komp.jaBije = false;
                    Hero.komp.akcja = 1;
                    Hero.komp.stanAkcji = 0;
                }
            }
        }
        return false;
    }

    private static boolean decision_dojumpkick(int deltaTime) {
        Hero.komp.stanAkcji = 1;
        if (Hero.komp.attackPoint.checkObszar(Hero.komp.myPoint, 5, 5) == 0) {
            if (Hero.komp.enemyType != 67) {
                Hero.komp.jumpKick = true;
                Hero.komp.stanAkcji = 0;
                if (Hero.komp.orientation == 1) {
                    komp.changeState((byte)3, -1);
                } else {
                    komp.changeState((byte)3, 1);
                }
            } else {
                Hero.komp.stanAkcji = 0;
                Hero.komp.akcja = (byte)10;
                if (Hero.komp.orientation == 1) {
                    komp.changeState((byte)27, -1);
                } else {
                    komp.changeState((byte)27, 1);
                }
            }
        }
        return false;
    }

    private static boolean decision_dothrowitem(int deltaTime) {
        Hero.komp.stanAkcji = 1;
        if (Hero.komp.attackPoint.checkObszar(Hero.komp.myPoint, 4, 5) == 0) {
            komp.changeState((byte)31, 0);
            Hero.komp.stanAkcji = 0;
            Hero.komp.akcja = (byte)18;
        }
        return false;
    }

    private static boolean decision_szarza(int deltaTime) {
        Hero.komp.stanAkcji = 1;
        if (Hero.komp.enemyType == 32) {
            deltaTime <<= 1;
        }
        if (Hero.komp.attackPoint.checkObszar(Hero.komp.myPoint, 5, 5) == 0) {
            Hero.komp.akcja = 1;
            Hero.komp.stanAkcji = 0;
        }
        return false;
    }

    private static boolean decision_finish(int deltaTime) {
        for (byte i = 1; i <= GameAppState.ileWrogow; i = (byte)(i + 1)) {
            komp = GameAppState.heros[i];
            if (Hero.komp.stanAkcji == 1) {
                if (Hero.komp.enemyType == 32) {
                    deltaTime <<= 1;
                }
                if (Hero.komp.enemyType == 67) {
                    deltaTime = trueDelta;
                }
                if (Hero.komp.attackPoint.x > Hero.komp.myPoint.x) {
                    Hero.komp.stepRight = deltaTime;
                } else if (Hero.komp.attackPoint.x < Hero.komp.myPoint.x) {
                    Hero.komp.stepRight = -deltaTime;
                }
                if (Hero.komp.attackPoint.y + 4 < Hero.komp.myPoint.y) {
                    Hero.komp.stepDown = -deltaTime;
                } else if (Hero.komp.attackPoint.y - 4 > Hero.komp.myPoint.y) {
                    Hero.komp.stepDown = deltaTime;
                }
                if (Hero.komp.enemyType == 32) {
                    if ((Hero.komp.stepRight >= 0 || Hero.komp.orientation != 0) && (Hero.komp.stepRight <= 0 || Hero.komp.orientation != 1)) continue;
                    los = (byte)Hero.random(100);
                    if (los < 50) {
                        Hero.komp.jaBije = false;
                        Hero.komp.akcja = (byte)10;
                        Hero.komp.shortJump = true;
                        komp.changeState((byte)3, Hero.komp.stepRight);
                        Hero.komp.stanAkcji = 0;
                        continue;
                    }
                    if (los >= 50 && los < 75) {
                        Hero.komp.jaBije = true;
                        Hero.komp.shortJump = false;
                        if (Hero.komp.orientation == 1) {
                            komp.changeState((byte)37, -1);
                            continue;
                        }
                        komp.changeState((byte)37, 1);
                        continue;
                    }
                    Hero.komp.jaBije = true;
                    komp.changeState((byte)31, 0);
                    Hero.komp.stanAkcji = 0;
                    Hero.komp.akcja = (byte)18;
                    continue;
                }
                if (Hero.komp.enemyType != 67 || Hero.komp.akcja == 14 || (Hero.komp.stepRight >= 0 || Hero.komp.orientation != 0) && (Hero.komp.stepRight <= 0 || Hero.komp.orientation != 1)) continue;
                komp.changeState((byte)24, Hero.komp.stepRight);
                Hero.komp.stanAkcji = 0;
                continue;
            }
            if (Hero.komp.stanAkcji == 2) {
                if (Hero.komp.attackPoint.x > Hero.komp.myPoint.x) {
                    Hero.komp.stepRight = deltaTime * 2;
                } else if (Hero.komp.attackPoint.x < Hero.komp.myPoint.x) {
                    Hero.komp.stepRight = -deltaTime * 2;
                }
                if (Hero.komp.attackPoint.y + 3 < Hero.komp.myPoint.y) {
                    Hero.komp.stepDown = -deltaTime * 2;
                    continue;
                }
                if (Hero.komp.attackPoint.y - 3 <= Hero.komp.myPoint.y) continue;
                Hero.komp.stepDown = deltaTime * 2;
                continue;
            }
            if (Hero.komp.stanAkcji == 6) {
                if (Hero.komp.attackPoint.x > Hero.komp.myPoint.x) {
                    Hero.komp.stepRight = deltaTime;
                    continue;
                }
                if (Hero.komp.attackPoint.x >= Hero.komp.myPoint.x) continue;
                Hero.komp.stepRight = -deltaTime;
                continue;
            }
            if (Hero.komp.stanAkcji == 4) {
                if (Hero.gracz.state == 17 || Hero.gracz.state == 7 || Hero.komp.state != 1 && Hero.komp.state != 18) continue;
                Hero.komp.time += trueDelta;
                if (Hero.komp.time <= Hero.komp.inicjatywa) continue;
                ktoryAttack = komp.getAttack();
                Hero.komp.time -= Hero.komp.inicjatywa;
                Hero.komp.inicjatywa = (short)(Hero.komp.INICJATYWA_BASE + Hero.random(4) * 25);
                if (Hero.komp.state == 18) {
                    if (Hero.gracz.immortalityTime == 0) {
                        komp.changeState((byte)19, 0);
                        continue;
                    }
                    komp.changeState((byte)45, 0);
                    continue;
                }
                if (ktoryAttack == 45 && Hero.komp.weapon != null) {
                    if (Hero.komp.weapon.weaponType == 4) {
                        komp.changeState((byte)33, 0);
                        continue;
                    }
                    if (Hero.komp.weapon.weaponType == 6) {
                        komp.changeState((byte)34, 0);
                        continue;
                    }
                    Hero.komp.akcja = (byte)17;
                    Hero.komp.stanAkcji = 1;
                    Hero.komp.attackPoint = new Point(Hero.gracz.myPoint);
                    Hero.komp.attackPoint.x = Hero.komp.orientation == 1 ? (short)(Hero.komp.attackPoint.x + placeWhenCanThorow) : (short)(Hero.komp.attackPoint.x - placeWhenCanThorow);
                    if (GameAppState.level.checkPoint(Hero.komp.attackPoint.x, Hero.komp.attackPoint.y, Hero.komp.currentSector) == null) continue;
                    Hero.komp.attackPoint = GameAppState.level.checkPoint(Hero.komp.attackPoint.x, Hero.komp.attackPoint.y, Hero.komp.currentSector);
                    continue;
                }
                if (ktoryAttack == 45) {
                    komp.changeState((byte)45, 0);
                    continue;
                }
                if (ktoryAttack == 46) {
                    komp.changeState((byte)46, 0);
                    continue;
                }
                if (ktoryAttack == 44) {
                    komp.changeState((byte)44, 0);
                    continue;
                }
                if (ktoryAttack == 38) {
                    komp.changeState((byte)38, 0);
                    continue;
                }
                if (ktoryAttack == 39) {
                    komp.changeState((byte)39, 0);
                    continue;
                }
                if (ktoryAttack == 27) {
                    if (Hero.komp.orientation == 1) {
                        komp.changeState((byte)27, -1);
                        continue;
                    }
                    komp.changeState((byte)27, 1);
                    continue;
                }
                if (ktoryAttack == 40) {
                    komp.changeState((byte)40, 0);
                    continue;
                }
                if (ktoryAttack == 29) {
                    komp.changeState((byte)29, 0);
                    continue;
                }
                if (ktoryAttack == 41) {
                    komp.changeState((byte)41, 0);
                    continue;
                }
                if (ktoryAttack == 15) {
                    gracz.changeState((byte)0, 0);
                    Hero.gracz.fp_heroX = Hero.komp.fp_heroX;
                    Hero.gracz.fp_heroY = Hero.komp.fp_heroY - Hero.komp.heroFrameHeightFP;
                    komp.changeState((byte)15, 0);
                    continue;
                }
                if (ktoryAttack == 37) {
                    Hero.komp.shortJump = false;
                    if (Hero.komp.orientation == 1) {
                        komp.changeState((byte)37, -1);
                        continue;
                    }
                    komp.changeState((byte)37, 1);
                    continue;
                }
                if (ktoryAttack == 31 && Hero.komp.weapon != null && Hero.komp.weapon.state == 3) {
                    Hero.komp.akcja = (byte)17;
                    Hero.komp.stanAkcji = 1;
                    Hero.komp.attackPoint = new Point(Hero.gracz.myPoint);
                    Hero.komp.attackPoint.x = Hero.komp.orientation == 1 ? (short)(Hero.komp.attackPoint.x + placeWhenCanThorow) : (short)(Hero.komp.attackPoint.x - placeWhenCanThorow);
                    if (GameAppState.level.checkPoint(Hero.komp.attackPoint.x, Hero.komp.attackPoint.y, Hero.komp.currentSector) == null) continue;
                    Hero.komp.attackPoint = GameAppState.level.checkPoint(Hero.komp.attackPoint.x, Hero.komp.attackPoint.y, Hero.komp.currentSector);
                    continue;
                }
                if (ktoryAttack == 18) {
                    komp.changeState((byte)18, 0);
                    GameAppState.heros[0].kierunekUderzenia = Hero.komp.orientation == 1 ? (byte)-1 : (byte)1;
                    GameAppState.heros[0].fp_heroY = Hero.komp.fp_heroY;
                    GameAppState.heros[0].fp_heroX = Hero.komp.fp_heroX + GameAppState.heros[0].kierunekUderzenia * (GameAppState.heros[0].heroFrameWidthFP << 1);
                    GameAppState.heros[0].changeState((byte)0, GameAppState.heros[0].kierunekUderzenia);
                    Hero.komp.numerGoodKneeHit = 0;
                    continue;
                }
                if (ktoryAttack != 43) continue;
                Point p = Hero.komp.orientation == 1 ? GameAppState.level.checkPoint(Hero.komp.myPoint.x - 50, Hero.komp.myPoint.y, Hero.komp.currentSector) : GameAppState.level.checkPoint(Hero.komp.myPoint.x + 50, Hero.komp.myPoint.y, Hero.komp.currentSector);
                if (p == null) {
                    Hero.komp.akcja = (byte)14;
                    Hero.komp.stanAkcji = 1;
                    Hero.komp.attackPoint = new Point(Hero.gracz.myPoint);
                    Hero.komp.attackPoint.x = Hero.komp.orientation == 1 ? (short)(Hero.komp.attackPoint.x + placeWhenCanJump) : (short)(Hero.komp.attackPoint.x - placeWhenCanJump);
                    if (GameAppState.level.checkPoint(Hero.komp.attackPoint.x, Hero.komp.attackPoint.y, Hero.komp.currentSector) == null) continue;
                    Hero.komp.attackPoint = GameAppState.level.checkPoint(Hero.komp.attackPoint.x, Hero.komp.attackPoint.y, Hero.komp.currentSector);
                    continue;
                }
                komp.nextAttak();
                continue;
            }
            if (Hero.komp.stanAkcji != 3) continue;
            if (Hero.komp.attackPoint.x <= Hero.komp.myPoint.x + 1 && Hero.komp.attackPoint.x >= Hero.komp.myPoint.x - 1) {
                Hero.komp.stepDown = Hero.gracz.fp_heroY < Hero.komp.fp_heroY ? -deltaTime : deltaTime;
                komp.changeState((byte)2, 0);
                if (Hero.komp.fp_heroX >> 8 < Hero.gracz.fp_heroX >> 8) {
                    Hero.komp.orientation = 0;
                    continue;
                }
                Hero.komp.orientation = 1;
                continue;
            }
            if (Hero.komp.fp_lastY - Hero.komp.fp_heroY == 0) {
                Hero.komp.yGoOnBack = (byte)(Hero.komp.lastHeroPoz.y - Hero.komp.myPoint.y);
            }
            if (Hero.komp.lastHeroPoz.y - Hero.komp.myPoint.y < 0 && Hero.komp.lastHeroPoz.y - Hero.komp.myPoint.y >= -Hero.komp.yGoOnBack) {
                Hero.komp.stepDown = deltaTime * 2;
                continue;
            }
            if (Hero.komp.lastHeroPoz.y - Hero.komp.myPoint.y > 0 && Hero.komp.lastHeroPoz.y - Hero.komp.myPoint.y < Hero.komp.yGoOnBack) {
                Hero.komp.stepDown = -deltaTime * 2;
                continue;
            }
            if (Hero.komp.fp_lastX - Hero.komp.fp_heroX == 0) {
                Hero.komp.attackPoint.x = (short)(Hero.komp.fp_heroX >> 8);
            }
            if (Hero.komp.attackPoint.x >= Hero.komp.myPoint.x) {
                Hero.komp.stepRight = deltaTime * 2;
            }
            if (Hero.komp.attackPoint.x > Hero.komp.myPoint.x) continue;
            Hero.komp.stepRight = -deltaTime * 2;
        }
        return false;
    }

    public static void decision(int deltaTime) {
        if (Hero.decision_init1(deltaTime)) {
            return;
        }
        Hero.decision_init2(deltaTime);
        block18: for (byte i = 1; i <= GameAppState.ileWrogow; i = (byte)(i + 1)) {
            komp = GameAppState.heros[i];
            if (GameAppState.ileWrogow > 1) {
                ten2 = i == 1 ? GameAppState.heros[2] : GameAppState.heros[1];
            }
            switch (Hero.komp.akcja) {
                case -1: {
                    Hero.decision_brak(deltaTime);
                    continue block18;
                }
                case 8: {
                    Hero.decision_drabina(deltaTime);
                    continue block18;
                }
                case 16: {
                    Hero.decision_kucam(deltaTime);
                    continue block18;
                }
                case 18: {
                    Hero.decision_rzucam(deltaTime);
                    continue block18;
                }
                case 21: {
                    Hero.decision_niemysle(deltaTime);
                    continue block18;
                }
                case 10: {
                    Hero.decision_skacze(deltaTime);
                    continue block18;
                }
                case 1: {
                    Hero.decision_czekaj(deltaTime);
                    continue block18;
                }
                case 0: {
                    Hero.decision_postuj(deltaTime);
                    continue block18;
                }
                case 2: {
                    Hero.decision_idz(deltaTime);
                    continue block18;
                }
                case 3: {
                    Hero.decision_biegnij(deltaTime);
                    continue block18;
                }
                case 5: {
                    Hero.decision_podchodze(deltaTime);
                    continue block18;
                }
                case 4: {
                    Hero.decision_natyl(deltaTime);
                    continue block18;
                }
                case 6: {
                    Hero.decision_atakuje(deltaTime);
                    continue block18;
                }
                case 14: {
                    Hero.decision_dojumpkick(deltaTime);
                    continue block18;
                }
                case 17: {
                    Hero.decision_dothrowitem(deltaTime);
                    continue block18;
                }
                case 15: {
                    Hero.decision_szarza(deltaTime);
                }
            }
        }
        Hero.decision_finish(deltaTime);
    }

    private void timerState(Hero k, int deltaTime) {
        k.timeToChange += deltaTime;
        if (k.timeToChange > k.reflex) {
            k.akcja = k.newAkcja;
            k.stanAkcji = k.newStanAkcji;
            k.changeAkcja = false;
        }
    }

    private void changeState(Hero k, byte nAkcja, byte nStanAkcji) {
        if (k.akcja != nAkcja) {
            k.changeAkcja = true;
            k.newAkcja = nAkcja;
            k.newStanAkcji = nStanAkcji;
        }
    }

    static {
        Y_RANGE = (byte)5;
        whoLastDecide = 0;
        RANDOM = new Random(System.currentTimeMillis());
        enemyTypesTable = new short[]{1, 2, 4, 8, 16, 32, 64, 65, 66, 67, 68};
        heroWaiting = new Point[]{new Point(), new Point()};
        heroAttack = new Point[]{new Point(), new Point()};
        DISTANCE_PLAYER_IN_AIR = (byte)40;
        offset = 0;
        fantomBall = false;
        placeWhenCanJump = (short)45;
        placeWhenCanThorow = (short)70;
        d = new int[2];
    }
}

