/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class M3GParser {
    private static final int SIGNATURE_SIZE = 12;
    public static final int TYPE_ANYTHING = -1;
    public static final int TYPE_HEADER_OBJECT = 0;
    public static final int TYPE_ANIMATION_CONTROLLER = 1;
    public static final int TYPE_ANIMATION_TRACK = 2;
    public static final int TYPE_APPEARANCE = 3;
    public static final int TYPE_BACKGROUND = 4;
    public static final int TYPE_CAMERA = 5;
    public static final int TYPE_COMPOSITING_MODE = 6;
    public static final int TYPE_FOG = 7;
    public static final int TYPE_POLYGON_MODE = 8;
    public static final int TYPE_GROUP = 9;
    public static final int TYPE_IMAGE_2D = 10;
    public static final int TYPE_TRIANGLE_STRIP_ARRAY = 11;
    public static final int TYPE_LIGHT = 12;
    public static final int TYPE_MATERIAL = 13;
    public static final int TYPE_MESH = 14;
    public static final int TYPE_MORPHING_MESH = 15;
    public static final int TYPE_SKINNED_MESH = 16;
    public static final int TYPE_TEXTURE_2D = 17;
    public static final int TYPE_SPRITE = 18;
    public static final int TYPE_KEYFRAME_SEQUENCE = 19;
    public static final int TYPE_VERTEX_ARRAY = 20;
    public static final int TYPE_VERTEX_BUFFER = 21;
    public static final int TYPE_WORLD = 22;
    public static final int TYPE_EXTERNAL_REFERENCE = 255;

    public static int[] getSectionOffsets(byte[] byArray) {
        int[] nArray = new int[]{};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.available();
            dataInputStream.skip(12L);
            while (dataInputStream.available() > 0) {
                int n2;
                int[] nArray2 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = new int[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray[nArray2.length] = n - dataInputStream.available();
                dataInputStream.skip(1L);
                dataInputStream.skip(4L);
                int n3 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24);
                int n4 = 0;
                do {
                    dataInputStream.skip(1L);
                    n2 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24);
                    dataInputStream.skip(n2);
                } while ((n4 += 5 + n2) < n3);
                dataInputStream.skip(4L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public static int[] getChunkOffsets(byte[] byArray, int n, int n2) {
        int[] nArray = new int[]{};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n3 = dataInputStream.available();
            dataInputStream.skip(n);
            if (dataInputStream.available() > 0) {
                int n4;
                dataInputStream.skip(1L);
                dataInputStream.skip(4L);
                int n5 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24);
                int n6 = 0;
                do {
                    int n7;
                    if ((n7 = dataInputStream.read()) == n2) {
                        int[] nArray2 = new int[nArray.length];
                        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                        nArray = new int[nArray2.length + 1];
                        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                        nArray[nArray2.length] = n3 - dataInputStream.available() - 1;
                    }
                    n4 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24);
                    dataInputStream.skip(n4);
                } while ((n6 += 5 + n4) < n5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public static int getOffset(byte[] byArray, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n3 = dataInputStream.available();
            dataInputStream.skip(12L);
            while (dataInputStream.available() > 0) {
                int n4;
                dataInputStream.skip(1L);
                dataInputStream.skip(4L);
                int n5 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24);
                int n6 = 0;
                do {
                    int n7;
                    if ((n7 = dataInputStream.read()) == n) {
                        return n3 - dataInputStream.available();
                    }
                    n4 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24);
                    dataInputStream.skip(n4);
                } while ((n6 += 5 + n4) < n5);
                dataInputStream.skip(4L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static String getExternalRefName(byte[] byArray, int n) {
        int n2 = M3GParser.getOffset(byArray, 255, n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        if (n2 > 0) {
            try {
                dataInputStream.skip(n2);
                int n3 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24);
                return new String(byArray, n2 + 4, n3 - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int[] getUVs(byte[] byArray, int n) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            dataInputStream.skip(n);
            if (dataInputStream.available() > 0) {
                int n2;
                dataInputStream.skip(1L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                int n3 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24);
                for (n2 = 0; n2 < n3; ++n2) {
                    dataInputStream.skip(4L);
                    dataInputStream.skip(1L);
                }
                n2 = dataInputStream.read();
                int n4 = dataInputStream.read();
                if (n4 != 2) {
                    return null;
                }
                int n5 = dataInputStream.read();
                int n6 = dataInputStream.read() + (dataInputStream.read() << 8) << 1;
                int[] nArray = new int[n6];
                if (n5 == 0) {
                    if (n2 == 1) {
                        for (int i = 0; i < n6; ++i) {
                            nArray[i] = dataInputStream.read();
                        }
                    } else {
                        for (int i = 0; i < n6; ++i) {
                            nArray[i] = dataInputStream.read() + (dataInputStream.read() << 8);
                        }
                    }
                } else {
                    System.out.println("!!! delta encoding");
                }
                return nArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static float[] getUVBias(byte[] byArray, int n) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            dataInputStream.skip(n);
            if (dataInputStream.available() > 0) {
                dataInputStream.skip(1L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                dataInputStream.skip(12L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                dataInputStream.skip(4L);
                int n2 = dataInputStream.read() + (dataInputStream.read() << 8) + (dataInputStream.read() << 16) + (dataInputStream.read() << 24) << 2;
                float[] fArray = new float[n2];
                int n3 = 0;
                while (n3 < n2) {
                    dataInputStream.skip(4L);
                    fArray[n3++] = dataInputStream.readFloat();
                    fArray[n3++] = dataInputStream.readFloat();
                    fArray[n3++] = dataInputStream.readFloat();
                    fArray[n3++] = dataInputStream.readFloat();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

