/*
 * Decompiled with CFR 0.152.
 */
package pok;

import main.Common;
import pok.Card;
import pok.GameHandling;
import pok.PokerPlayer;
import pok.ScreenGamePok;

public class Game {
    public static int game_mode;
    public static final int GAME_START = 0;
    public static final int GAME_FLOP = 1;
    public static final int GAME_TURN = 2;
    public static final int GAME_RIVER = 3;
    public static final int GAME_END_ROUND = 4;
    public static boolean bEvaluated;
    public static boolean bWinByFold;
    public static int iRaise;
    public static int iBlind;
    public static int iWinnerId;
    public static boolean bRaise;
    public static int iRiseTimes;
    private static int iShownCardsCount;
    public static Card[] tableCards;
    public static PokerPlayer[] players;
    private static Card[] sortedCards;
    private static Card[] sortedTableCards;
    private static int iPossibleTableComb;
    public static int iPot;
    public static int iBetPerPlayer;
    public static int iRoundNr;

    public static void addToPot(int p) {
        iPot += p;
    }

    public Game(int bblind) {
        iRaise = bblind;
        iBlind = bblind;
    }

    public Game() {
    }

    public static void nextRound() {
        ++iRoundNr;
        bEvaluated = false;
        bWinByFold = false;
        bRaise = true;
        iBetPerPlayer = iBlind;
        iPot = 0;
        iRaise = iBlind;
        game_mode = 0;
        iRiseTimes = 0;
        for (int i = 0; i < 5; ++i) {
            Game.players[i].iActualBet = 0;
            Game.players[i].fold = false;
            Game.players[i].active = false;
            Game.players[i].bAllIn = false;
            Game.players[i].bWin = false;
            Game.players[i].iHandValue = 0;
            Game.players[i].iLastBet = 0;
            Game.players[i].iHighestCard = 0;
            Game.players[i].iRoundReward = 0;
            Game.players[i].iRaise = 0;
            if (Game.players[i].iChips != 0) continue;
            Game.players[i].playing = false;
        }
        System.out.println("____________________________________________\nROUND NUMBER " + iRoundNr + ":");
    }

    public static void nextGameMode() {
        Game.checkPlayersHands();
        iRaise = 0;
        bRaise = false;
        iRiseTimes = 0;
        for (int i = 0; i < 5; ++i) {
            Game.players[i].iPlayerAction = 0;
        }
        iPossibleTableComb = 0;
        Game.checkTable();
    }

    public static boolean compareBets() {
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].iActualBet == iBetPerPlayer || Game.players[i].fold || Game.players[i].bAllIn || !Game.players[i].playing) continue;
            bRaise = true;
            return false;
        }
        bRaise = false;
        iRaise = 0;
        return true;
    }

    public static void checkPlayersHands() {
        for (int i = 0; i < 5; ++i) {
            Game.players[i].iHandValue = 0;
            Game.players[i].iHighestCard = 0;
            if (!Game.players[i].playing) continue;
            System.out.println("\n\n________________________________________________\nplayer: " + i);
            Game.createSortedArray(players[i]);
            Game.checkStraight(players[i]);
            Game.checkDuplicates(players[i]);
            Game.checkFlush(players[i]);
            System.out.println(Game.players[i].sHand);
        }
    }

    public static void checkTable() {
        Game.createSortedTableArray();
        Game.checkTableStraight();
        Game.checkTableDuplicates();
        Game.checkTableFlush();
        System.out.println("possible table combination: " + iPossibleTableComb);
    }

    public static void createSortedTableArray() {
        int i;
        iShownCardsCount = 0;
        if (game_mode == 1) {
            iShownCardsCount = 3;
        }
        if (game_mode == 2) {
            iShownCardsCount = 4;
        }
        if (game_mode == 3) {
            iShownCardsCount = 5;
        }
        if (game_mode == 4) {
            iShownCardsCount = 5;
        }
        for (i = 0; i < iShownCardsCount; ++i) {
            Game.sortedTableCards[i] = tableCards[i];
        }
        Card switchCard = null;
        for (i = 1; i < iShownCardsCount; ++i) {
            switchCard = sortedTableCards[i];
            for (int j = i; j > 0 && sortedTableCards[j - 1].getValue() > switchCard.getValue(); --j) {
                Game.sortedTableCards[j] = sortedTableCards[j - 1];
            }
            Game.sortedTableCards[j] = switchCard;
        }
    }

    private static void checkTableDuplicates() {
        int[] sameCardsCount = new int[]{1, 1, 1};
        int[] sameCardsValue = new int[]{-1, -1, -1};
        int pairNr = 0;
        for (int i = 0; i < iShownCardsCount; ++i) {
            for (int j = i + 1; j < iShownCardsCount; ++j) {
                if (sortedTableCards[i].getValueAceModif() != sortedTableCards[j].getValueAceModif()) continue;
                if (sameCardsValue[0] == -1 || sortedTableCards[i].getValueAceModif() == sameCardsValue[0]) {
                    sameCardsValue[0] = sortedTableCards[i].getValueAceModif();
                    sameCardsCount[0] = sameCardsCount[0] + 1;
                    ++i;
                    pairNr = 1;
                    continue;
                }
                if (sameCardsValue[1] == -1 || sortedTableCards[i].getValueAceModif() == sameCardsValue[1]) {
                    sameCardsValue[1] = sortedTableCards[i].getValueAceModif();
                    sameCardsCount[1] = sameCardsCount[1] + 1;
                    ++i;
                    pairNr = 2;
                    continue;
                }
                if (sameCardsValue[2] != -1 && sortedTableCards[i].getValueAceModif() != sameCardsValue[2]) continue;
                sameCardsValue[2] = sortedTableCards[i].getValueAceModif();
                sameCardsCount[2] = sameCardsCount[2] + 1;
                ++i;
                pairNr = 3;
            }
        }
        if (pairNr == 1) {
            if (sameCardsCount[0] == 2 && iPossibleTableComb != 4) {
                iPossibleTableComb = 3;
            }
            if (sameCardsCount[0] == 3 && iPossibleTableComb != 4) {
                iPossibleTableComb = 7;
            }
            if (sameCardsCount[0] == 4) {
                iPossibleTableComb = 7;
            }
        }
        if (pairNr == 2) {
            if (sameCardsCount[0] == 2 && sameCardsCount[1] == 2 && iPossibleTableComb != 4) {
                iPossibleTableComb = 6;
            }
            if (sameCardsCount[0] == 4 || sameCardsCount[1] == 4) {
                iPossibleTableComb = 7;
            }
            if (sameCardsCount[0] == 2 && sameCardsCount[1] == 3 || sameCardsCount[0] == 3 && sameCardsCount[1] == 2) {
                iPossibleTableComb = 7;
            }
        }
    }

    private static void checkTableStraight() {
        int iStraightCards = 1;
        boolean Ace = false;
        for (int i = 0; i < iShownCardsCount - 1; ++i) {
            if (sortedTableCards[i].getValue() == 1) {
                Ace = true;
            }
            if (sortedTableCards[i].getValue() == sortedTableCards[i + 1].getValue() - 1) {
                ++iStraightCards;
            }
            if (sortedTableCards[i].getValue() >= sortedTableCards[i + 1].getValue() - 1 || iStraightCards >= 3) continue;
            iStraightCards = 1;
        }
        if (Ace && sortedTableCards[iShownCardsCount - 1].getValue() == 13 && iStraightCards >= 2) {
            ++iStraightCards;
        }
        iPossibleTableComb = 0;
        if (iStraightCards >= 3) {
            iPossibleTableComb = 4;
        }
    }

    private static void checkTableFlush() {
        int iColH = 0;
        int iColD = 0;
        int iColC = 0;
        int iColS = 0;
        for (int i = 0; i < iShownCardsCount; ++i) {
            if (sortedTableCards[i].getColNr() == 0) {
                ++iColH;
            }
            if (sortedTableCards[i].getColNr() == 1) {
                ++iColD;
            }
            if (sortedTableCards[i].getColNr() == 2) {
                ++iColC;
            }
            if (sortedTableCards[i].getColNr() != 3) continue;
            ++iColS;
        }
        if ((iColH >= 3 || iColD >= 3 || iColC >= 3 || iColS >= 3) && iPossibleTableComb < 4) {
            iPossibleTableComb = 5;
        }
        if ((iColH >= 3 || iColD >= 3 || iColC >= 3 || iColS >= 3) && iPossibleTableComb == 4) {
            iPossibleTableComb = 8;
        }
    }

    public static void createSortedArray(PokerPlayer player) {
        int i;
        iShownCardsCount = 0;
        if (game_mode == 1) {
            iShownCardsCount = 3;
        }
        if (game_mode == 2) {
            iShownCardsCount = 4;
        }
        if (game_mode == 3) {
            iShownCardsCount = 5;
        }
        if (game_mode == 4) {
            iShownCardsCount = 5;
        }
        iShownCardsCount += 2;
        for (i = 0; i < 2; ++i) {
            Game.sortedCards[i] = player.cards[i];
        }
        for (i = 2; i < iShownCardsCount; ++i) {
            Game.sortedCards[i] = tableCards[i - 2];
        }
        System.out.print(iShownCardsCount + " cards: ");
        Card switchCard = null;
        for (i = 1; i < iShownCardsCount; ++i) {
            switchCard = sortedCards[i];
            for (int j = i; j > 0 && sortedCards[j - 1].getValue() > switchCard.getValue(); --j) {
                Game.sortedCards[j] = sortedCards[j - 1];
            }
            Game.sortedCards[j] = switchCard;
        }
        for (i = 0; i < iShownCardsCount; ++i) {
            System.out.print(sortedCards[i].getCardString() + ", ");
        }
    }

    private static void checkDuplicates(PokerPlayer player) {
        int[] sameCardsCount = new int[]{1, 1, 1};
        int[] sameCardsValue = new int[]{-1, -1, -1};
        int pairNr = 0;
        System.out.println();
        for (int i = 0; i < iShownCardsCount; ++i) {
            for (int j = i + 1; j < iShownCardsCount; ++j) {
                if (sortedCards[i].getValueAceModif() != sortedCards[j].getValueAceModif()) continue;
                if (sameCardsValue[0] == -1 || sortedCards[i].getValueAceModif() == sameCardsValue[0]) {
                    sameCardsValue[0] = sortedCards[i].getValueAceModif();
                    sameCardsCount[0] = sameCardsCount[0] + 1;
                    ++i;
                    pairNr = 1;
                    continue;
                }
                if (sameCardsValue[1] == -1 || sortedCards[i].getValueAceModif() == sameCardsValue[1]) {
                    sameCardsValue[1] = sortedCards[i].getValueAceModif();
                    sameCardsCount[1] = sameCardsCount[1] + 1;
                    ++i;
                    pairNr = 2;
                    continue;
                }
                if (sameCardsValue[2] != -1 && sortedCards[i].getValueAceModif() != sameCardsValue[2]) continue;
                sameCardsValue[2] = sortedCards[i].getValueAceModif();
                sameCardsCount[2] = sameCardsCount[2] + 1;
                ++i;
                pairNr = 3;
            }
        }
        if (pairNr == 1) {
            if (sameCardsCount[0] == 2 && player.iHandValue != 4) {
                player.iHandValue = 1;
                player.sameCards1 = sameCardsValue[0];
                player.sHand = "ONE_PAIR_" + sameCardsValue[0];
            }
            if (sameCardsCount[0] == 3 && player.iHandValue != 4) {
                player.iHandValue = 3;
                player.sameCards1 = sameCardsValue[0];
                player.sHand = "THREE_OF_A_KIND_" + sameCardsValue[0];
            }
            if (sameCardsCount[0] == 4) {
                player.iHandValue = 7;
                player.sameCards1 = sameCardsValue[0];
                player.sHand = "FOUR_OF_A_KIND_" + sameCardsValue[0];
            }
        }
        if (pairNr == 2) {
            if (sameCardsCount[0] == 2 && sameCardsCount[1] == 2 && player.iHandValue != 4) {
                player.iHandValue = 2;
                if (sameCardsValue[0] > sameCardsValue[1]) {
                    player.sameCards1 = sameCardsValue[0];
                    player.sameCards2 = sameCardsValue[1];
                } else {
                    player.sameCards1 = sameCardsValue[1];
                    player.sameCards2 = sameCardsValue[0];
                }
                player.sHand = "TWO_PAIRS_" + player.sameCards1 + "_" + player.sameCards2;
            }
            if (sameCardsCount[0] == 4 || sameCardsCount[1] == 4) {
                player.iHandValue = 7;
                player.sHand = sameCardsCount[0] == 4 ? "FOUR_OF_A_KIND_" + sameCardsValue[0] : "FOUR_OF_A_KIND_" + sameCardsValue[1];
            }
            if (sameCardsCount[0] == 2 && sameCardsCount[1] == 3 || sameCardsCount[0] == 3 && sameCardsCount[1] == 2) {
                player.iHandValue = 6;
                if (sameCardsCount[0] == 3) {
                    player.sameCards1 = sameCardsValue[0];
                    player.sameCards2 = sameCardsValue[1];
                } else {
                    player.sameCards2 = sameCardsValue[0];
                    player.sameCards1 = sameCardsValue[1];
                }
                player.sHand = "FULL_HOUSE_" + sameCardsValue[0] + "_" + sameCardsValue[1];
            }
            if (sameCardsCount[0] == 3 && sameCardsCount[1] == 3) {
                player.iHandValue = 6;
                if (sameCardsValue[0] > sameCardsValue[1]) {
                    player.sameCards1 = sameCardsValue[0];
                    player.sameCards2 = sameCardsValue[1];
                } else {
                    player.sameCards2 = sameCardsValue[0];
                    player.sameCards1 = sameCardsValue[1];
                }
                player.sHand = "FULL_HOUSE_" + sameCardsValue[0] + "_" + sameCardsValue[1];
            }
        }
        if (pairNr == 3) {
            player.iHandValue = 2;
            int tmp1 = 0;
            int tmp2 = 0;
            if (sameCardsValue[0] >= sameCardsValue[1] && sameCardsValue[0] >= sameCardsValue[2]) {
                tmp1 = sameCardsValue[0];
                tmp2 = sameCardsValue[1] >= sameCardsValue[2] ? sameCardsValue[1] : sameCardsValue[2];
            } else if (sameCardsValue[1] >= sameCardsValue[0] && sameCardsValue[1] >= sameCardsValue[2]) {
                tmp1 = sameCardsValue[1];
                tmp2 = sameCardsValue[0] >= sameCardsValue[2] ? sameCardsValue[0] : sameCardsValue[2];
            } else if (sameCardsValue[2] >= sameCardsValue[0] && sameCardsValue[2] >= sameCardsValue[1]) {
                tmp1 = sameCardsValue[2];
                tmp2 = sameCardsValue[0] >= sameCardsValue[1] ? sameCardsValue[0] : sameCardsValue[1];
            }
            player.sHand = "TWO_PAIRS_" + tmp1 + "_" + tmp2;
            player.sameCards1 = tmp1;
            player.sameCards2 = tmp2;
        }
    }

    private static void checkStraight(PokerPlayer player) {
        int iHighestValue = 0;
        int iStraightCards = 1;
        boolean Ace = false;
        for (int i = 0; i < iShownCardsCount - 1; ++i) {
            if (sortedCards[i].getValue() == 1) {
                Ace = true;
            }
            if (sortedCards[i].getValue() == sortedCards[i + 1].getValue() - 1 && sortedCards[i].getValue() == sortedCards[i + 1].getValue() - 1 && ++iStraightCards > 3) {
                iHighestValue = sortedCards[i + 1].getValue();
            }
            if (sortedCards[i].getValue() < sortedCards[i + 1].getValue() - 1 && iStraightCards < 5) {
                iStraightCards = 1;
            }
            if (sortedCards[i].getValue() >= sortedCards[i + 1].getValue() - 1 || iStraightCards < 5) continue;
            i = 10;
        }
        if (Ace) {
            if (sortedCards[iShownCardsCount - 1].getValue() == 13 && iStraightCards >= 4) {
                ++iStraightCards;
            }
            player.iHighestCard = 14;
            if (iHighestValue == 13) {
                iHighestValue = 14;
            }
        } else {
            player.iHighestCard = sortedCards[iShownCardsCount - 1].getValue();
        }
        player.sHand = "HIGH_CARD_" + player.iHighestCard;
        if (iStraightCards >= 5) {
            player.iHandValue = 4;
            player.iHighestCard = iHighestValue;
            player.sHand = "STRAIGHT_" + iHighestValue;
        }
    }

    private static void checkFlush(PokerPlayer player) {
        int iColH = 0;
        int iColD = 0;
        int iColC = 0;
        int iColS = 0;
        for (int i = 0; i < iShownCardsCount; ++i) {
            if (sortedCards[i].getColNr() == 0) {
                ++iColH;
            }
            if (sortedCards[i].getColNr() == 1) {
                ++iColD;
            }
            if (sortedCards[i].getColNr() == 2) {
                ++iColC;
            }
            if (sortedCards[i].getColNr() != 3) continue;
            ++iColS;
        }
        if (iColH >= 5) {
            player.sameColorIndx = 0;
        }
        if (iColD >= 5) {
            player.sameColorIndx = 1;
        }
        if (iColC >= 5) {
            player.sameColorIndx = 2;
        }
        if (iColS >= 5) {
            player.sameColorIndx = 3;
        }
        if ((iColH >= 5 || iColD >= 5 || iColC >= 5 || iColS >= 5) && player.iHandValue < 4) {
            player.iHandValue = 5;
            player.sHand = "FLUSH_" + player.iHighestCard;
        }
        if ((iColH >= 5 || iColD >= 5 || iColC >= 5 || iColS >= 5) && player.iHandValue == 4) {
            if (player.iHighestCard != 14) {
                player.iHandValue = 8;
                player.sHand = "STRAIGHT_FLUSH_" + player.iHighestCard;
            } else {
                player.iHandValue = 9;
                player.sHand = "ROYAL_FLUSH_" + player.iHighestCard;
            }
        }
    }

    public static void checkOrCall(int pl) {
        if (iBetPerPlayer > Game.players[pl].iActualBet) {
            if (iBetPerPlayer - Game.players[pl].iActualBet >= Game.players[pl].iChips) {
                Game.AllIn(pl);
                return;
            }
            int chps = iBetPerPlayer - Game.players[pl].iActualBet;
            System.out.println("call :" + chps);
            players[pl].removeChips(chps);
            Game.addToPot(chps);
            players[pl].addBet(chps);
            Game.players[pl].iPlayerAction = 4;
        } else {
            Game.players[pl].iPlayerAction = 3;
        }
        int iFold = 0;
        int iAllIn = 0;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].fold || !Game.players[i].playing) {
                ++iFold;
            }
            if (!Game.players[i].bAllIn) continue;
            ++iAllIn;
        }
        if (iFold >= 4 || iAllIn >= 5 || iFold + iAllIn >= 5 || iFold + iAllIn >= 4 && Game.compareBets()) {
            game_mode = 4;
            if (iFold >= 4) {
                bWinByFold = true;
            }
        }
    }

    public static void betOrRaise(int pl, int minVal, int maxVal) {
        if (iRiseTimes >= 2) {
            Game.checkOrCall(pl);
            return;
        }
        int chps = 0;
        chps = minVal != maxVal ? (minVal < maxVal ? Common.getRandomUInt(maxVal - minVal) + minVal : Common.getRandomUInt(minVal - maxVal) + maxVal) : minVal;
        while (chps % 10 != 0) {
            --chps;
        }
        if (iBetPerPlayer > Game.players[pl].iActualBet) {
            if (chps < iRaise) {
                chps = iRaise;
            }
            if (iBetPerPlayer - Game.players[pl].iActualBet + chps >= Game.players[pl].iChips) {
                Game.AllIn(pl);
                return;
            }
            System.out.println("call: " + (iBetPerPlayer - Game.players[pl].iActualBet) + " + raise:" + chps);
            players[pl].removeChips(iBetPerPlayer - Game.players[pl].iActualBet + chps);
            Game.addToPot(iBetPerPlayer - Game.players[pl].iActualBet + chps);
            Game.players[pl].iRaise = chps;
            Game.players[pl].iPlayerAction = 2;
            players[pl].addBet(iBetPerPlayer - Game.players[pl].iActualBet + chps);
            iBetPerPlayer += chps;
            iRaise = chps;
        } else {
            if (chps >= Game.players[pl].iChips) {
                Game.AllIn(pl);
                return;
            }
            System.out.println("bet :" + chps);
            players[pl].removeChips(chps);
            iBetPerPlayer += chps;
            Game.players[pl].iPlayerAction = 1;
            players[pl].addBet(chps);
            Game.addToPot(chps);
            iRaise = chps;
        }
        ++iRiseTimes;
        bRaise = true;
        ScreenGamePok.step = 1;
        int iFold = 0;
        int iAllIn = 0;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].fold || !Game.players[i].playing) {
                ++iFold;
            }
            if (!Game.players[i].bAllIn) continue;
            ++iAllIn;
        }
        if (iFold >= 4 || iAllIn >= 5 || iFold + iAllIn >= 5 || iFold + iAllIn >= 4 && Game.compareBets()) {
            game_mode = 4;
            if (iFold >= 4) {
                bWinByFold = true;
            }
        }
    }

    public static void AllIn(int pl) {
        System.out.println("All In " + Game.players[pl].iChips + "bet per pl " + iBetPerPlayer + "actual :" + Game.players[pl].iActualBet);
        Game.players[pl].bAllIn = true;
        int iFold = 0;
        int iAllIn = 0;
        Game.players[pl].iPlayerAction = 6;
        if (iBetPerPlayer > Game.players[pl].iActualBet) {
            if (Game.players[pl].iChips >= iBetPerPlayer - Game.players[pl].iActualBet) {
                Game.players[pl].iRaise = Game.players[pl].iChips - (iBetPerPlayer - Game.players[pl].iActualBet);
                Game.addToPot(Game.players[pl].iChips);
                if (Game.players[pl].iChips > iBetPerPlayer - Game.players[pl].iActualBet) {
                    bRaise = true;
                    ScreenGamePok.step = 1;
                }
                iBetPerPlayer = Game.players[pl].iChips + Game.players[pl].iActualBet;
                players[pl].addBet(Game.players[pl].iChips);
                ++iRiseTimes;
                iRaise = Game.players[pl].iChips;
            } else {
                Game.addToPot(Game.players[pl].iChips);
                players[pl].addBet(Game.players[pl].iChips);
            }
        } else {
            Game.addToPot(Game.players[pl].iChips);
            iBetPerPlayer = Game.players[pl].iChips + iBetPerPlayer;
            players[pl].addBet(Game.players[pl].iChips);
            bRaise = true;
            ScreenGamePok.step = 1;
        }
        Game.players[pl].iChips = 0;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].fold || !Game.players[i].playing) {
                ++iFold;
            }
            if (!Game.players[i].bAllIn) continue;
            ++iAllIn;
        }
        if (iFold >= 4 || iAllIn >= 5 || iFold + iAllIn >= 5 || iFold + iAllIn >= 4 && Game.compareBets()) {
            game_mode = 4;
            if (iFold >= 4) {
                bWinByFold = true;
            }
        }
    }

    public static void fold(int pl) {
        System.out.println("fold");
        Game.players[pl].fold = true;
        Game.players[pl].iPlayerAction = 5;
        int iFold = 0;
        int iAllIn = 0;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].fold || !Game.players[i].playing) {
                ++iFold;
            }
            if (!Game.players[i].bAllIn) continue;
            ++iAllIn;
        }
        if (iFold >= 4 || iAllIn >= 5 || iFold + iAllIn >= 5 || iFold + iAllIn >= 4 && Game.compareBets()) {
            game_mode = 4;
            if (iFold >= 4) {
                bWinByFold = true;
            }
        }
    }

    public static void evaluation() {
        int rest;
        int j;
        int i;
        int i2;
        if (bEvaluated) {
            return;
        }
        System.out.println("vyhodnotenie: ");
        int[] SortedPlayingPlayersByBet = new int[5];
        int playingPlayers = 0;
        int iAllInPlayersCount = 0;
        for (i2 = 0; i2 < 5; ++i2) {
            Game.players[i2].iRoundReward = 0 - Game.players[i2].iActualBet;
            if (Game.players[i2].fold || !Game.players[i2].playing) continue;
            System.out.println("player " + i2 + " bet: " + Game.players[i2].iActualBet + " bet per player: " + iBetPerPlayer);
            if (Game.players[i2].bAllIn) {
                ++iAllInPlayersCount;
            }
            SortedPlayingPlayersByBet[playingPlayers] = i2;
            ++playingPlayers;
        }
        System.out.println("playing players = " + playingPlayers);
        if (iAllInPlayersCount == 0 || playingPlayers == 1) {
            for (i2 = 0; i2 < 5; ++i2) {
                Game.players[i2].bAllIn = false;
            }
            Game.findWinner();
            Game.selectWinCards();
            bEvaluated = true;
            return;
        }
        int switchIndex = 0;
        for (i = 1; i < playingPlayers; ++i) {
            switchIndex = SortedPlayingPlayersByBet[i];
            for (j = i; j > 0 && Game.players[SortedPlayingPlayersByBet[j - 1]].iActualBet > Game.players[switchIndex].iActualBet; --j) {
                SortedPlayingPlayersByBet[j] = SortedPlayingPlayersByBet[j - 1];
            }
            SortedPlayingPlayersByBet[j] = switchIndex;
        }
        System.out.println("all in players: " + iAllInPlayersCount + " playing players: " + playingPlayers);
        if (iAllInPlayersCount == playingPlayers) {
            --iAllInPlayersCount;
            rest = Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].iActualBet - Game.players[SortedPlayingPlayersByBet[playingPlayers - 2]].iActualBet;
            Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].iActualBet -= rest;
            Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].iRoundReward = 0 - Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].iActualBet;
            iPot -= rest;
            players[SortedPlayingPlayersByBet[playingPlayers - 1]].addChips(rest);
            Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].bAllIn = false;
        } else if (iAllInPlayersCount == playingPlayers - 1) {
            rest = Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].iActualBet - Game.players[SortedPlayingPlayersByBet[playingPlayers - 2]].iActualBet;
            Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].iActualBet -= rest;
            Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].iRoundReward = 0 - Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].iActualBet;
            iPot -= rest;
            players[SortedPlayingPlayersByBet[playingPlayers - 1]].addChips(rest);
            Game.players[SortedPlayingPlayersByBet[playingPlayers - 1]].bAllIn = false;
        }
        for (i = 0; i < 5; ++i) {
            if (!Game.players[i].bAllIn || Game.players[i].iActualBet != iBetPerPlayer) continue;
            Game.players[i].bAllIn = false;
            --iAllInPlayersCount;
        }
        if (iAllInPlayersCount == 0) {
            Game.findWinner();
            Game.selectWinCards();
            bEvaluated = true;
            return;
        }
        int cycle = iAllInPlayersCount;
        for (i = 0; i < cycle + 1; ++i) {
            System.out.println("pocet all in hracov: " + iAllInPlayersCount);
            if (iAllInPlayersCount == 0) {
                iPot = Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount]].iActualBet * (playingPlayers - iAllInPlayersCount);
                for (j = 0; j < 5; ++j) {
                    if (Game.players[j].fold && Game.players[j].playing && Game.players[j].iActualBet >= Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount]].iActualBet) {
                        iPot += Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount]].iActualBet;
                        continue;
                    }
                    if (!Game.players[j].fold || !Game.players[j].playing || Game.players[j].iActualBet >= Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount]].iActualBet) continue;
                    iPot += Game.players[j].iActualBet;
                }
            } else {
                iPot = (Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount]].iActualBet - Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount - 1]].iActualBet) * (playingPlayers - iAllInPlayersCount);
                for (j = 0; j < 5; ++j) {
                    if (!Game.players[j].fold || !Game.players[j].playing || Game.players[j].iActualBet < Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount - 1]].iActualBet) continue;
                    iPot += Game.players[j].iActualBet - Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount - 1]].iActualBet;
                }
            }
            Game.findWinner();
            if (--iAllInPlayersCount >= 0) {
                Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount]].bAllIn = false;
            }
            if (iAllInPlayersCount > 0) {
                while (iAllInPlayersCount != 0 && Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount]].iActualBet == Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount - 1]].iActualBet) {
                    ++i;
                    if (--iAllInPlayersCount < 0) continue;
                    Game.players[SortedPlayingPlayersByBet[iAllInPlayersCount]].bAllIn = false;
                }
            }
            System.out.println("pocet all in hracov v dalsom kole: " + iAllInPlayersCount);
        }
        iPot = 0;
        Game.selectWinCards();
        bEvaluated = true;
    }

    public static int playersWithBiggerBet(int bet) {
        int result = 1;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].iActualBet <= bet) continue;
            ++result;
        }
        return result;
    }

    public static void selectWinCards() {
        for (int i = 0; i < 5; ++i) {
            if (!Game.players[i].bWin) continue;
            Game.makePlayerCardValues(players[i]);
            for (int j = 0; j < 5; ++j) {
                if (Game.players[i].iHandValue != 5) {
                    if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[0]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[1]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[2]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[3]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[4]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (Game.players[i].cardValues[j] == Game.players[i].cards[0].getValueAceModif()) {
                        Game.players[i].cards[0].bWinCard = true;
                    }
                    if (Game.players[i].cardValues[j] == Game.players[i].cards[1].getValueAceModif()) {
                        Game.players[i].cards[1].bWinCard = true;
                    }
                    if (tableCards[j].getValue() == Game.players[i].cardValues[0]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (tableCards[j].getValue() == Game.players[i].cardValues[1]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (tableCards[j].getValue() == Game.players[i].cardValues[2]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (tableCards[j].getValue() == Game.players[i].cardValues[3]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (tableCards[j].getValue() == Game.players[i].cardValues[4]) {
                        Game.tableCards[j].bWinCard = true;
                    }
                    if (Game.players[i].cardValues[j] == Game.players[i].cards[0].getValue()) {
                        Game.players[i].cards[0].bWinCard = true;
                    }
                    if (Game.players[i].cardValues[j] != Game.players[i].cards[1].getValue()) continue;
                    Game.players[i].cards[1].bWinCard = true;
                    continue;
                }
                if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[0] && tableCards[j].getColNr() == Game.players[i].sameColorIndx) {
                    Game.tableCards[j].bWinCard = true;
                }
                if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[1] && tableCards[j].getColNr() == Game.players[i].sameColorIndx) {
                    Game.tableCards[j].bWinCard = true;
                }
                if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[2] && tableCards[j].getColNr() == Game.players[i].sameColorIndx) {
                    Game.tableCards[j].bWinCard = true;
                }
                if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[3] && tableCards[j].getColNr() == Game.players[i].sameColorIndx) {
                    Game.tableCards[j].bWinCard = true;
                }
                if (tableCards[j].getValueAceModif() == Game.players[i].cardValues[4] && tableCards[j].getColNr() == Game.players[i].sameColorIndx) {
                    Game.tableCards[j].bWinCard = true;
                }
                if (Game.players[i].cardValues[j] == Game.players[i].cards[0].getValueAceModif()) {
                    Game.players[i].cards[0].bWinCard = true;
                }
                if (Game.players[i].cardValues[j] != Game.players[i].cards[1].getValueAceModif()) continue;
                Game.players[i].cards[1].bWinCard = true;
            }
        }
    }

    public static void firstPlayingPlayer() {
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].fold || !Game.players[i].playing || Game.players[i].bAllIn) continue;
            iWinnerId = i;
            Game.players[Game.iWinnerId].bWin = true;
            System.out.println("First playing player: " + i);
            return;
        }
    }

    public static void findWinner() {
        System.out.println("aktualny pot o ktory sa hra: " + iPot);
        Game.firstPlayingPlayer();
        int iPlayingPlayers = 0;
        int i = iWinnerId + 1;
        while (i < 5) {
            Game.players[i].bWin = false;
            if (!Game.players[i].fold && Game.players[i].playing && !Game.players[i].bAllIn) {
                ++iPlayingPlayers;
                if (Game.players[i].iHandValue > Game.players[Game.iWinnerId].iHandValue) {
                    for (int j = i - 1; j >= 0; --j) {
                        Game.players[j].bWin = false;
                    }
                    iWinnerId = i;
                    Game.players[Game.iWinnerId].bWin = true;
                } else if (Game.players[i].iHandValue == Game.players[Game.iWinnerId].iHandValue) {
                    Game.comparePlayers(i);
                }
            }
            ++i;
        }
        int iWinnerCount = 0;
        System.out.println("----------------------------------------------------------\nwinners: ");
        for (int i2 = 0; i2 < 5; ++i2) {
            if (!Game.players[i2].bWin || !Game.players[i2].playing) continue;
            ++iWinnerCount;
            System.out.println("winner: " + i2);
        }
        int rest = 0;
        while (iPot % iWinnerCount != 0 || iPot % iWinnerCount % 10 != 0) {
            rest += 10;
            iPot -= 10;
        }
        players[ScreenGamePok.iSBIndex].addChips(rest);
        Game.players[ScreenGamePok.iSBIndex].iRoundReward += rest;
        for (int i3 = 0; i3 < 5; ++i3) {
            if (!Game.players[i3].bWin) continue;
            players[i3].addChips(iPot / iWinnerCount);
            Game.players[i3].iRoundReward += iPot / iWinnerCount;
        }
    }

    public static void comparePlayers(int play) {
        Game.makePlayerCardValues(players[play]);
        Game.makePlayerCardValues(players[iWinnerId]);
        for (int i = 0; i < 5; ++i) {
            if (Game.players[play].cardValues[i] > Game.players[Game.iWinnerId].cardValues[i]) {
                for (int j = play; j >= 0; --j) {
                    Game.players[j].bWin = false;
                }
                iWinnerId = play;
                Game.players[Game.iWinnerId].bWin = true;
                return;
            }
            if (Game.players[play].cardValues[i] >= Game.players[Game.iWinnerId].cardValues[i]) continue;
            return;
        }
        Game.players[play].bWin = true;
    }

    public static void makePlayerCardValues(PokerPlayer player) {
        int i;
        iShownCardsCount = 7;
        for (i = 0; i < 2; ++i) {
            Game.sortedCards[i] = player.cards[i];
        }
        for (i = 2; i < iShownCardsCount; ++i) {
            Game.sortedCards[i] = tableCards[i - 2];
        }
        Card switchCard = null;
        for (i = 1; i < iShownCardsCount; ++i) {
            switchCard = sortedCards[i];
            for (int j = i; j > 0 && sortedCards[j - 1].getValueAceModif() > switchCard.getValueAceModif(); --j) {
                Game.sortedCards[j] = sortedCards[j - 1];
            }
            Game.sortedCards[j] = switchCard;
        }
        int sortedIndex = 6;
        switch (player.iHandValue) {
            case 0: {
                for (i = 0; i < 5; ++i) {
                    player.cardValues[i] = sortedCards[6 - i].getValueAceModif();
                }
                break;
            }
            case 1: {
                player.cardValues[0] = player.sameCards1;
                player.cardValues[1] = player.sameCards1;
                for (i = 2; i < 5; ++i) {
                    while (sortedCards[sortedIndex].getValueAceModif() == player.sameCards1) {
                        --sortedIndex;
                    }
                    player.cardValues[i] = sortedCards[sortedIndex].getValueAceModif();
                    --sortedIndex;
                }
                break;
            }
            case 2: {
                player.cardValues[0] = player.sameCards1;
                player.cardValues[1] = player.sameCards1;
                player.cardValues[2] = player.sameCards2;
                player.cardValues[3] = player.sameCards2;
                while (sortedCards[sortedIndex].getValueAceModif() == player.sameCards1 || sortedCards[sortedIndex].getValueAceModif() == player.sameCards2) {
                    --sortedIndex;
                }
                player.cardValues[4] = sortedCards[sortedIndex].getValueAceModif();
                break;
            }
            case 3: {
                player.cardValues[0] = player.sameCards1;
                player.cardValues[1] = player.sameCards1;
                player.cardValues[2] = player.sameCards1;
                for (i = 3; i < 5; ++i) {
                    while (sortedCards[sortedIndex].getValueAceModif() == player.sameCards1) {
                        --sortedIndex;
                    }
                    player.cardValues[i] = sortedCards[sortedIndex].getValueAceModif();
                    --sortedIndex;
                }
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                player.cardValues[0] = player.iHighestCard;
                player.cardValues[1] = player.iHighestCard - 1;
                player.cardValues[2] = player.iHighestCard - 2;
                player.cardValues[3] = player.iHighestCard - 3;
                player.cardValues[4] = player.iHighestCard - 4;
                break;
            }
            case 5: {
                for (i = 0; i < 5; ++i) {
                    while (sortedCards[sortedIndex].getColNr() != player.sameColorIndx) {
                        --sortedIndex;
                    }
                    player.cardValues[i] = sortedCards[sortedIndex].getValueAceModif();
                    --sortedIndex;
                }
                break;
            }
            case 6: {
                player.cardValues[0] = player.sameCards1;
                player.cardValues[1] = player.sameCards1;
                player.cardValues[2] = player.sameCards1;
                player.cardValues[3] = player.sameCards2;
                player.cardValues[4] = player.sameCards2;
                break;
            }
            case 7: {
                player.cardValues[0] = player.sameCards1;
                player.cardValues[1] = player.sameCards1;
                player.cardValues[2] = player.sameCards1;
                player.cardValues[3] = player.sameCards1;
                while (sortedCards[sortedIndex].getValueAceModif() == player.sameCards1) {
                    --sortedIndex;
                }
                player.cardValues[4] = sortedCards[sortedIndex].getValueAceModif();
            }
        }
        System.out.println("player Card Values: ");
        for (i = 0; i < 5; ++i) {
            System.out.print(player.cardValues[i] + ", ");
        }
        System.out.println("\n..........");
    }

    public static void calculatePlayerMove(int pl) {
        System.out.println("player: " + pl + " playing Style: " + Game.players[pl].iPlayingStyle);
        int cards = 0;
        if (game_mode == 0) {
            if (Game.players[pl].cards[0].getValueAceModif() > 9 && Game.players[pl].cards[1].getValueAceModif() > 9) {
                cards = 1;
            }
            if (Game.players[pl].cards[0].getColNr() == Game.players[pl].cards[1].getColNr()) {
                cards = 2;
            }
            if (Game.players[pl].cards[0].getValueAceModif() > 9 && Game.players[pl].cards[0] == Game.players[pl].cards[1]) {
                cards = 5;
            }
            if (Game.players[pl].cards[0].getValueAceModif() <= 9 && Game.players[pl].cards[0].getValueAceModif() >= 5 && Game.players[pl].cards[0] == Game.players[pl].cards[1]) {
                cards = 4;
            }
            if (Game.players[pl].cards[0].getValueAceModif() < 5 && Game.players[pl].cards[0] == Game.players[pl].cards[1]) {
                cards = 3;
            }
        } else {
            cards = Game.players[pl].iHandValue;
        }
        int raise = 0;
        if (iRaise > 3 * iBlind && iRaise <= 15 * iBlind) {
            raise = 1;
        }
        if (iRaise > 15 * iBlind) {
            raise = 2;
        }
        if (iRaise == 0 && ScreenGamePok.step < 3) {
            raise = 3;
        }
        if (iRaise == 0 && ScreenGamePok.step >= 3) {
            raise = 4;
        }
        boolean bBestComb = false;
        int highestHand = 0;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].iHandValue >= highestHand) continue;
            highestHand = Game.players[i].iHandValue;
        }
        if (Game.players[pl].iHandValue == highestHand) {
            bBestComb = true;
        }
        if (Game.players[pl].iPlayingStyle == 0) {
            Game.moveLooser(pl, cards, raise, bBestComb);
        }
        if (Game.players[pl].iPlayingStyle == 1) {
            Game.moveSakal(pl, cards, raise, bBestComb);
        }
        if (Game.players[pl].iPlayingStyle == 2) {
            Game.moveAgresivny(pl, cards, raise, bBestComb);
        }
        if (Game.players[pl].iPlayingStyle == 3) {
            Game.moveOpatrny(pl, cards, raise, bBestComb);
        }
        if (Game.players[pl].iPlayingStyle == 4) {
            Game.moveBojko(pl, cards, raise, bBestComb);
        }
        if (Game.players[pl].iPlayingStyle == 5) {
            if (Common.getRandomUInt(10) < 5) {
                Game.moveAgresivny(pl, cards, raise, bBestComb);
            } else {
                Game.moveOpatrny(pl, cards, raise, bBestComb);
            }
        }
    }

    public static void moveLooser(int pl, int cards, int raise, boolean bBestComb) {
        raise = 0;
        if (iRaise > 5 * iBlind && iRaise <= 20 * iBlind) {
            raise = 1;
        }
        if (iRaise > 20 * iBlind) {
            raise = 2;
        }
        if (iRaise == 0 && ScreenGamePok.step < 3) {
            raise = 3;
        }
        if (iRaise == 0 && ScreenGamePok.step >= 3) {
            raise = 4;
        }
        int parameter = GameHandling.iLevel;
        int chipsToCall = iBetPerPlayer - Game.players[pl].iActualBet;
        int playingPlayers = 0;
        for (int i = 0; i < 5; ++i) {
            if (!Game.players[i].playing || Game.players[i].fold || Game.players[i].bAllIn) continue;
            ++playingPlayers;
        }
        if (game_mode != 0) {
            if (cards == 0) {
                cards = 0;
            }
            if (cards == 1) {
                cards = 1;
            }
            if (cards == 2 || cards == 3) {
                cards = 2;
            }
            if (cards == 4) {
                cards = 3;
            }
            if (cards == 5) {
                cards = 4;
            }
            if (cards >= 6) {
                cards = 5;
            }
        }
        int random = Common.getRandomUInt(10);
        System.out.println("cards: " + cards + ", raise: " + raise);
        if (game_mode == 0) {
            if (cards == 0) {
                if (raise == 0) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (chipsToCall > 3 * (Game.players[pl].iChips / 4)) {
                            if (random < 3) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.fold(pl);
                            return;
                        }
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 2);
                    return;
                }
            }
            if (cards == 1) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.fold(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise * 2);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.fold(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.betOrRaise(pl, iBlind, iBlind * 3);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
            }
            if (cards == 2 || cards == 3) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.fold(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.fold(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.betOrRaise(pl, iBlind, iBlind * 3);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 2);
                    return;
                }
            }
            if (cards == 4 || cards == 5) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.betOrRaise(pl, iRaise, iRaise);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise * 2);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 8) {
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise * 2);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 7) {
                            Game.fold(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 6) {
                            Game.fold(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.betOrRaise(pl, iBlind, iBlind * 3);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 2);
                    return;
                }
            }
        }
        if (game_mode == 1 || game_mode == 2 || game_mode == 3) {
            if (cards == 0) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (random < 2) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 2) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (random < 8) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
            }
            if (cards == 1) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 7) {
                            Game.betOrRaise(pl, iRaise, iRaise * 2);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (game_mode == 1) {
                        if (Game.players[pl].cards[0].getValueAceModif() > 9) {
                            if (random < 5) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            if (random < 8) {
                                Game.betOrRaise(pl, iRaise, iRaise);
                                return;
                            }
                            Game.fold(pl);
                            return;
                        }
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (Game.players[pl].cards[0].getValueAceModif() > 9) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.betOrRaise(pl, iRaise * 2, iRaise * 3);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 1) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.betOrRaise(pl, iRaise, iRaise);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 1) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (game_mode == 1) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 1) {
                        if (game_mode == 1) {
                            if (random < 6) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.betOrRaise(pl, iBlind, iBlind);
                            return;
                        }
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind * 2, iBlind * 4);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 3);
                    return;
                }
            }
            if (cards == 2) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (game_mode == 1) {
                            if (random < 6) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.betOrRaise(pl, iRaise, iRaise);
                            return;
                        }
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 7) {
                            Game.betOrRaise(pl, iRaise, iRaise * 2);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 4);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise * 3);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 9) {
                        Game.betOrRaise(pl, iRaise, iRaise * 2);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 1) {
                        if (game_mode == 1) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 5);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 7) {
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 5);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 2);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (game_mode == 1) {
                            if (random < 4) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.betOrRaise(pl, iBlind, iBlind * 3);
                            return;
                        }
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind * 3, iBlind * 4);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind * 2, iBlind * 3);
                    return;
                }
            }
            if (cards == 3 || cards == 4 || cards == 5) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (game_mode == 1) {
                            if (random < 3) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.betOrRaise(pl, iRaise, iRaise * 3);
                            return;
                        }
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 7) {
                            Game.betOrRaise(pl, iRaise, iRaise * 2);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 4);
                        return;
                    }
                    if (game_mode == 1) {
                        Game.betOrRaise(pl, iRaise, iRaise * 2);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise * 3);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (game_mode == 1) {
                            if (random < 5) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.betOrRaise(pl, iRaise, iRaise);
                            return;
                        }
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.betOrRaise(pl, iRaise, iRaise * 2);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 3);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise * 3);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (game_mode == 1) {
                            if (random < 6) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            if (random < 8) {
                                Game.betOrRaise(pl, iRaise, iRaise);
                                return;
                            }
                            Game.betOrRaise(pl, iRaise, iRaise * 4);
                            return;
                        }
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 8) {
                            Game.betOrRaise(pl, iRaise, iRaise * 2);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 3);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 3) {
                        Game.betOrRaise(pl, iRaise, iRaise * 2);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind * 2, iBlind * 3);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 3);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 8) {
                            Game.betOrRaise(pl, iBlind, iBlind * 3);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 5) {
                        Game.betOrRaise(pl, iBlind, iBlind * 3);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
            }
        }
        Game.checkOrCall(pl);
    }

    public static void moveBojko(int pl, int cards, int raise, boolean bBestComb) {
        raise = 0;
        if (iRaise > 3 * iBlind && iRaise <= 10 * iBlind) {
            raise = 1;
        }
        if (iRaise > 10 * iBlind) {
            raise = 2;
        }
        if (iRaise == 0 && ScreenGamePok.step < 3) {
            raise = 3;
        }
        if (iRaise == 0 && ScreenGamePok.step >= 3) {
            raise = 4;
        }
        int parameter = GameHandling.iLevel;
        int chipsToCall = iBetPerPlayer - Game.players[pl].iActualBet;
        int playingPlayers = 0;
        for (int i = 0; i < 5; ++i) {
            if (!Game.players[i].playing || Game.players[i].fold || Game.players[i].bAllIn) continue;
            ++playingPlayers;
        }
        if (game_mode != 0) {
            if (cards == 0) {
                cards = 0;
            }
            if (cards == 1) {
                cards = 1;
            }
            if (cards == 2 || cards == 3) {
                cards = 2;
            }
            if (cards == 4) {
                cards = 3;
            }
            if (cards == 5) {
                cards = 4;
            }
            if (cards >= 6) {
                cards = 5;
            }
        }
        int random = Common.getRandomUInt(10);
        System.out.println("cards: " + cards + ", raise: " + raise);
        if (game_mode == 0) {
            if (cards == 0) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        Game.fold(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 1) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 9) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (chipsToCall < Game.players[pl].iChips / 4) {
                            if (random < 7) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.fold(pl);
                            return;
                        }
                        if (chipsToCall < Game.players[pl].iChips / 2) {
                            if (random < 6) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.fold(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 4) {
                        if (random < 9) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 4) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 8) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
            }
            if (cards == 2 || cards == 3) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 4) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        Game.fold(pl);
                        return;
                    }
                    if (random < 7) {
                        Game.fold(pl);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                } else {
                    if (random < 8) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
            }
            if (cards == 4 || cards == 5) {
                if (raise == 0) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (chipsToCall < Game.players[pl].iChips / 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (random < 3) {
                            Game.fold(pl);
                            return;
                        }
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 4) {
                            Game.fold(pl);
                            return;
                        }
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 5) {
                        Game.fold(pl);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                } else {
                    if (random < 8) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
            }
        }
        if (game_mode == 1 || game_mode == 2) {
            if (cards == 0) {
                if (raise == 0) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 1) {
                if (raise == 0) {
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 2) {
                if (raise == 0) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 1) {
                    if (random < 8) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 1) {
                        Game.fold(pl);
                        return;
                    }
                } else {
                    if (game_mode == 1) {
                        if (random < 2) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
            }
            if (raise == 3) {
                if (parameter < 1) {
                    if (random < 8) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (random < 6) {
                    Game.checkOrCall(pl);
                    return;
                }
                Game.betOrRaise(pl, iBlind, iBlind);
                return;
            }
            if (raise == 4) {
                if (parameter < 2) {
                    if (game_mode == 1) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (game_mode == 1) {
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 2);
                    return;
                }
                if (random < 4) {
                    Game.checkOrCall(pl);
                    return;
                }
                Game.betOrRaise(pl, iBlind * 2, iBlind * 3);
                return;
            }
            if (cards == 3 || cards == 4 || cards == 5) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    if (game_mode == 1) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 8) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (Game.players[pl].iHandValue == 4) {
                            if (random < 8) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.fold(pl);
                            return;
                        }
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (game_mode == 1) {
                        if (Game.players[pl].iHandValue == 4) {
                            if (random < 9) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.fold(pl);
                            return;
                        }
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (Game.players[pl].iHandValue == 4) {
                        if (random < 9) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 3) {
                        Game.betOrRaise(pl, iRaise, iRaise);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 6) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 2);
                    return;
                }
                if (raise == 4) {
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (random < 3) {
                    Game.checkOrCall(pl);
                    return;
                }
                Game.betOrRaise(pl, iBlind, iBlind * 2);
                return;
            }
        }
        if (game_mode == 3) {
            if (cards == 0) {
                if (raise == 0) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 1) {
                if (raise == 0) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 2) {
                if (raise == 0) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 8) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 1) {
                        Game.fold(pl);
                        return;
                    }
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 1) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 3);
                    return;
                }
            }
            if (cards == 3 || cards == 4 || cards == 5) {
                if (raise == 0) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise);
                    return;
                }
                if (raise == 2 && parameter < 1) {
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 1) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    if (random < 6) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.betOrRaise(pl, iBlind * 2, iBlind * 3);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind, iBlind * 3);
                    return;
                }
            }
        }
        if (iRaise == 0) {
            Game.checkOrCall(pl);
        } else {
            Game.fold(pl);
        }
    }

    public static void moveSakal(int pl, int cards, int raise, boolean bBestComb) {
        raise = 0;
        if (iRaise > 3 * iBlind && iRaise <= 10 * iBlind) {
            raise = 1;
        }
        if (iRaise > 10 * iBlind) {
            raise = 2;
        }
        if (iRaise == 0 && ScreenGamePok.step < 3) {
            raise = 3;
        }
        if (iRaise == 0 && ScreenGamePok.step >= 3) {
            raise = 4;
        }
        int parameter = GameHandling.iLevel;
        int chipsToCall = iBetPerPlayer - Game.players[pl].iActualBet;
        int playingPlayers = 0;
        int highestHand = 0;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].playing && !Game.players[i].fold && !Game.players[i].bAllIn) {
                ++playingPlayers;
            }
            if (Game.players[i].iHandValue <= highestHand) continue;
            highestHand = Game.players[i].iHandValue;
        }
        if (game_mode != 0) {
            if (cards == 0) {
                cards = 0;
            }
            if (cards == 1) {
                cards = 1;
            }
            if (cards == 2 || cards == 3) {
                cards = 2;
            }
            if (cards == 4) {
                cards = 3;
            }
            if (cards == 5) {
                cards = 4;
            }
            if (cards >= 6) {
                cards = 5;
            }
        }
        int random = Common.getRandomUInt(10);
        System.out.println("sakal:  cards: " + cards + ", raise: " + raise);
        if (game_mode == 0) {
            if (cards == 0) {
                if (raise == 0) {
                    if (parameter < 2) {
                        Game.fold(pl);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        Game.fold(pl);
                        return;
                    }
                } else {
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 1) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (chipsToCall < Game.players[pl].iChips / 4) {
                            if (random < 7) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.fold(pl);
                            return;
                        }
                        if (chipsToCall < Game.players[pl].iChips / 2) {
                            if (random < 5) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.fold(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 4) {
                        if (random < 8) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 4) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind * 2, iBlind * 3);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 2) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind * 4, iBlind * 10);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind * 15, iBlind * 25);
                    return;
                }
            }
            if (cards == 2 || cards == 3) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 3) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 2) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 4) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (chipsToCall < Game.players[pl].iChips / 3) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (random < 2) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.fold(pl);
                        return;
                    }
                    if (random < 8) {
                        Game.fold(pl);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind, iBlind * 5);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind * 4, iBlind * 8);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind * 3, iBlind * 10);
                        return;
                    }
                    if (random < 4) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind * 4, iBlind * 12);
                    return;
                }
            }
            if (cards == 4 || cards == 5) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise * 3);
                        return;
                    }
                    if (highestHand == Game.players[pl].iHighestCard) {
                        Game.betOrRaise(pl, iRaise * 5, iRaise * 10);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise * 3);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise * 3);
                        return;
                    }
                    if (highestHand == Game.players[pl].iHighestCard) {
                        Game.betOrRaise(pl, iRaise * 5, iRaise * 10);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise * 3);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 2) {
                        if (random < 7) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise * 3);
                        return;
                    }
                    if (highestHand == Game.players[pl].iHighestCard) {
                        Game.betOrRaise(pl, iRaise * 4, iRaise * 5);
                        return;
                    }
                    if (random < 7) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise, iRaise * 2);
                    return;
                }
                if (raise == 3) {
                    if (parameter < 2) {
                        if (random < 2) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind * 5, iBlind * 10);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind * 6, iBlind * 15);
                    return;
                }
                if (raise == 4) {
                    if (parameter < 2) {
                        if (random < 2) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iBlind * 5, iBlind * 20);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind * 12, iBlind * 25);
                    return;
                }
            }
        }
        if (game_mode == 1 || game_mode == 2 || game_mode == 3) {
            if (cards == 0 || cards == 1) {
                if (raise == 0) {
                    if (highestHand == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iRaise * 12, iRaise * 25);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (highestHand == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iRaise * 12, iRaise * 25);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 5);
                        return;
                    }
                    if (random < 5) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iBlind * 2, iBlind * 3);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 2) {
                if (raise == 0) {
                    if (parameter < 2) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                            Game.betOrRaise(pl, iRaise * 5, iRaise * 10);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 3);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 4) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                            Game.betOrRaise(pl, iRaise * 5, iRaise * 10);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 3);
                        return;
                    }
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iRaise * 5, iRaise * 15);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 1) {
                    if (parameter < 1) {
                        if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                            Game.betOrRaise(pl, iRaise * 5, iRaise * 10);
                            return;
                        }
                        if (random < 2) {
                            Game.fold(pl);
                            return;
                        }
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iRaise * 5, iRaise * 10);
                        return;
                    }
                    if (random < 2) {
                        Game.fold(pl);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 2) {
                    if (parameter < 1) {
                        if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                            if (random < 5) {
                                Game.checkOrCall(pl);
                                return;
                            }
                            Game.betOrRaise(pl, iRaise, iRaise * 3);
                            return;
                        }
                        if (random < 2) {
                            Game.fold(pl);
                            return;
                        }
                        Game.checkOrCall(pl);
                        return;
                    }
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        if (random < 5) {
                            Game.checkOrCall(pl);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise, iRaise * 3);
                        return;
                    }
                    if (random < 4) {
                        Game.fold(pl);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 3) {
                    Game.betOrRaise(pl, iBlind, iBlind * 3);
                    return;
                }
                if (raise == 4) {
                    Game.betOrRaise(pl, iBlind * 2, iBlind * 4);
                    return;
                }
            }
            if (cards == 3 || cards == 4 || cards == 5) {
                if (raise == 0 || raise == 1 || raise == 2) {
                    if (parameter < 2) {
                        Game.betOrRaise(pl, iRaise, iRaise * 4);
                        return;
                    }
                    if (game_mode == 1) {
                        if (random < 6) {
                            Game.betOrRaise(pl, iRaise, iRaise * 4);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 5, iRaise * 10);
                        return;
                    }
                    if (random < 6) {
                        Game.betOrRaise(pl, iRaise * 3, iRaise * 8);
                        return;
                    }
                    Game.betOrRaise(pl, iRaise * 5, iRaise * 10);
                    return;
                }
                if (raise == 3 || raise == 4) {
                    if (parameter < 2) {
                        Game.betOrRaise(pl, iBlind * 3, iBlind * 7);
                        return;
                    }
                    if (random < 7) {
                        Game.betOrRaise(pl, iBlind * 3, iBlind * 7);
                        return;
                    }
                    Game.betOrRaise(pl, iBlind * 5, iBlind * 10);
                    return;
                }
            }
        }
        if (iRaise == 0) {
            Game.betOrRaise(pl, iBlind, iBlind * 3);
            return;
        }
        Game.betOrRaise(pl, iRaise, iRaise * 3);
    }

    public static void moveAgresivny(int pl, int cards, int raise, boolean bBestComb) {
        raise = 0;
        if (iRaise > 3 * iBlind && iRaise <= 10 * iBlind) {
            raise = 1;
        }
        if (iRaise > 10 * iBlind) {
            raise = 2;
        }
        if (iRaise == 0 && ScreenGamePok.step < 3) {
            raise = 3;
        }
        if (iRaise == 0 && ScreenGamePok.step >= 3) {
            raise = 4;
        }
        int parameter = GameHandling.iLevel;
        int chipsToCall = iBetPerPlayer - Game.players[pl].iActualBet;
        int playingPlayers = 0;
        int highestHand = 0;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].playing && !Game.players[i].fold && !Game.players[i].bAllIn) {
                ++playingPlayers;
            }
            if (Game.players[i].iHandValue <= highestHand) continue;
            highestHand = Game.players[i].iHandValue;
        }
        if (game_mode != 0) {
            if (cards == 0) {
                cards = 0;
            }
            if (cards == 1) {
                cards = 1;
            }
            if (cards == 2 || cards == 3) {
                cards = 2;
            }
            if (cards == 4) {
                cards = 3;
            }
            if (cards == 5) {
                cards = 4;
            }
            if (cards >= 6) {
                cards = 5;
            }
        }
        int random = Common.getRandomUInt(10);
        System.out.println("agresivny:  cards: " + cards + ", raise: " + raise);
        if (game_mode == 0) {
            if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                if (random < 3) {
                    Game.checkOrCall(pl);
                    return;
                }
                if (iRaise == 0) {
                    Game.betOrRaise(pl, iBlind, iBlind * 3);
                    return;
                }
                Game.betOrRaise(pl, iRaise, iRaise * 3);
                return;
            }
            if (random < 3) {
                Game.checkOrCall(pl);
                return;
            }
            Game.fold(pl);
            return;
        }
        if (game_mode == 1 || game_mode == 2 || game_mode == 3) {
            if (cards == 0 || cards == 1) {
                if (raise == 0) {
                    if (highestHand == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iRaise * 12, iRaise * 25);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 1) {
                    if (highestHand == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iRaise * 12, iRaise * 25);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 2) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iRaise * 2, iRaise * 5);
                        return;
                    }
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iBlind, iBlind * 2);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iBlind * 2, iBlind * 3);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 2 || cards == 3 || cards == 4 || cards == 5) {
                if (raise == 0 || raise == 1 || raise == 2) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        if (random < 3) {
                            Game.betOrRaise(pl, iRaise * 3, iRaise * 10);
                            return;
                        }
                        if (random < 6) {
                            Game.betOrRaise(pl, iRaise * 4, iRaise * 13);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 8, iRaise * 20);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (!(raise != 3 && raise != 4 || highestHand != Game.players[pl].iHandValue && highestHand - 1 != Game.players[pl].iHandValue)) {
                    if (random < 3) {
                        Game.betOrRaise(pl, iRaise * 3, iRaise * 10);
                        return;
                    }
                    if (random < 6) {
                        Game.betOrRaise(pl, iRaise * 4, iRaise * 13);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
            }
        }
        if (iRaise == 0) {
            Game.betOrRaise(pl, iBlind, iBlind * 3);
            return;
        }
        Game.betOrRaise(pl, iRaise, iRaise * 3);
    }

    public static void moveOpatrny(int pl, int cards, int raise, boolean bBestComb) {
        raise = 0;
        if (iRaise > 3 * iBlind && iRaise <= 10 * iBlind) {
            raise = 1;
        }
        if (iRaise > 10 * iBlind) {
            raise = 2;
        }
        if (iRaise == 0 && ScreenGamePok.step < 3) {
            raise = 3;
        }
        if (iRaise == 0 && ScreenGamePok.step >= 3) {
            raise = 4;
        }
        int parameter = GameHandling.iLevel;
        int chipsToCall = iBetPerPlayer - Game.players[pl].iActualBet;
        int playingPlayers = 0;
        int highestHand = 0;
        for (int i = 0; i < 5; ++i) {
            if (Game.players[i].playing && !Game.players[i].fold && !Game.players[i].bAllIn) {
                ++playingPlayers;
            }
            if (Game.players[i].iHandValue <= highestHand) continue;
            highestHand = Game.players[i].iHandValue;
        }
        if (game_mode != 0) {
            if (cards == 0) {
                cards = 0;
            }
            if (cards == 1) {
                cards = 1;
            }
            if (cards == 2 || cards == 3) {
                cards = 2;
            }
            if (cards == 4) {
                cards = 3;
            }
            if (cards == 5) {
                cards = 4;
            }
            if (cards >= 6) {
                cards = 5;
            }
        }
        int random = Common.getRandomUInt(10);
        System.out.println("opatrny:  cards: " + cards + ", raise: " + raise);
        if (game_mode == 0) {
            if (highestHand == Game.players[pl].iHandValue) {
                Game.checkOrCall(pl);
                return;
            }
            if (random < 5) {
                Game.checkOrCall(pl);
                return;
            }
            Game.fold(pl);
            return;
        }
        if (game_mode == 1 || game_mode == 2 || game_mode == 3) {
            if (cards == 0 || cards == 1) {
                if (raise == 0 || raise == 1 || raise == 2) {
                    if (random < 2) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (raise == 3) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
                if (raise == 4) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        Game.betOrRaise(pl, iBlind, iBlind);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
            }
            if (cards == 2 || cards == 3 || cards == 4 || cards == 5) {
                if (raise == 0 || raise == 1 || raise == 2) {
                    if (highestHand == Game.players[pl].iHandValue || highestHand - 1 == Game.players[pl].iHandValue) {
                        if (random < 3) {
                            Game.betOrRaise(pl, iRaise, iRaise);
                            return;
                        }
                        if (random < 6) {
                            Game.betOrRaise(pl, iRaise, iRaise * 2);
                            return;
                        }
                        Game.betOrRaise(pl, iRaise * 3, iRaise * 4);
                        return;
                    }
                    if (random < 3) {
                        Game.checkOrCall(pl);
                        return;
                    }
                    Game.fold(pl);
                    return;
                }
                if (!(raise != 3 && raise != 4 || highestHand != Game.players[pl].iHandValue && highestHand - 1 != Game.players[pl].iHandValue)) {
                    if (random < 3) {
                        Game.betOrRaise(pl, iRaise * 3, iRaise * 5);
                        return;
                    }
                    if (random < 6) {
                        Game.betOrRaise(pl, iRaise * 4, iRaise * 13);
                        return;
                    }
                    Game.checkOrCall(pl);
                    return;
                }
            }
        }
        if (iRaise == 0) {
            Game.checkOrCall(pl);
        } else {
            Game.fold(pl);
        }
    }

    static {
        bEvaluated = false;
        bWinByFold = false;
        iRaise = 0;
        iBlind = 0;
        bRaise = false;
        iShownCardsCount = 0;
        tableCards = new Card[5];
        players = new PokerPlayer[5];
        sortedCards = new Card[7];
        sortedTableCards = new Card[5];
        iPot = 0;
        iRoundNr = 0;
    }
}

