/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import main.Common;
import main.Defines;
import main.Fonts;
import main.IScreen;
import main.Keys;
import main.MainCanvas;
import main.Resources;
import main.ScreenMenu;
import main.Settings;
import main.Texts;
import main.X;

public class ScreenSplash
implements IScreen {
    static final int MODE_LANG_SETUP = 0;
    static final int MODE_SOUNDS_SETUP = 1;
    static final int MODE_COMPANY_LOGO = 2;
    static final int MODE_TEQ = 5;
    static final int MODE_SPLASH = 3;
    static final int MODE_TEST = 4;
    Canvas canvas;
    int mode;
    long modeDelay;
    String sMusic;
    int testicek = 0;
    int iSelectedItem = -1;
    public String[] menuStrings;

    ScreenSplash(Canvas canvas) {
        this.canvas = canvas;
        this.mode = 0;
        System.out.println("screenSplash");
        Resources.loadMenuResources();
        this.loadStrings();
    }

    public void loadStrings() {
        this.menuStrings = new String[]{"ENGLISH", "ESPA\u00d1OL", "DEUTSCH", "ITALIANO", "FRAN\u00c7AIS", "PORTUGU\u00caS", "T\u00dcRK\u0130YE"};
    }

    public int getActualMode() {
        return this.mode;
    }

    public String getActualModeName() {
        return "Screen splash";
    }

    public void invokeGameMenu() {
    }

    public void update(long tick) {
        tick = 50L;
        switch (this.mode) {
            case 2: 
            case 3: {
                if (this.modeDelay > 0L) {
                    this.modeDelay -= tick;
                    return;
                }
                this.nextMode();
            }
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void keyReleased(int keyCode) {
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void setMusic() {
        try {
            if (Settings.bMusic) {
                X.soundManager.Stop();
                X.soundManager.SetSoundOn(true);
                X.soundManager.Play(X.MUSIC_MENU_ID, -1);
            } else {
                X.soundManager.SetSoundOn(false);
                X.soundManager.Stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void nextMode() {
        switch (this.mode) {
            case 0: {
                this.mode = 1;
                this.sMusic = X.texts.getHashedString("MUSIC").toUpperCase();
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 1: {
                Settings.saveSettings();
                Resources.imgBackground = Common.createImage("/inl.png");
                this.modeDelay = 3000L;
                this.mode = 2;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 2: {
                this.modeDelay = 0L;
                this.mode = 3;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 3: {
                MainCanvas.scrMenu = new ScreenMenu(this.canvas);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrSplash = null;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
            }
        }
    }

    public void keyPressed(int keyCode) {
        this.canvas.repaint();
        this.canvas.serviceRepaints();
        switch (this.mode) {
            case 0: {
                if (Keys.key_right || Keys.key_down || Keys.key_num6 || Keys.key_num8) {
                    ++this.iSelectedItem;
                    if (this.iSelectedItem > 6) {
                        this.iSelectedItem = 0;
                    }
                }
                if (Keys.key_left || Keys.key_up || Keys.key_num4 || Keys.key_num2) {
                    --this.iSelectedItem;
                    if (this.iSelectedItem < 0) {
                        this.iSelectedItem = 6;
                    }
                }
                if (!Keys.key_fire && !Keys.key_num5) break;
                switch (this.iSelectedItem) {
                    case 0: {
                        Texts.STRING_BIN = "/lang/en/text.csr";
                        Defines.bSystemFont = false;
                        break;
                    }
                    case 1: {
                        Texts.STRING_BIN = "/lang/es/text.csr";
                        Defines.bSystemFont = false;
                        break;
                    }
                    case 2: {
                        Texts.STRING_BIN = "/lang/de/text.csr";
                        Defines.bSystemFont = false;
                        break;
                    }
                    case 3: {
                        Texts.STRING_BIN = "/lang/it/text.csr";
                        Defines.bSystemFont = false;
                        break;
                    }
                    case 4: {
                        Texts.STRING_BIN = "/lang/fr/text.csr";
                        Defines.bSystemFont = false;
                        break;
                    }
                    case 5: {
                        Texts.STRING_BIN = "/lang/pt/text.csr";
                        Defines.bSystemFont = false;
                        break;
                    }
                    case 6: {
                        Texts.STRING_BIN = "/lang/tu/text.csr";
                        Defines.bSystemFont = false;
                    }
                }
                this.nextMode();
                break;
            }
            case 1: {
                if (Keys.key_fn1) {
                    Settings.bMusic = true;
                    Settings.saveSettings();
                    X.soundManager.SetSoundOn(true);
                    this.nextMode();
                    break;
                }
                if (!Keys.key_fn2) break;
                Settings.bMusic = false;
                Settings.saveSettings();
                X.soundManager.SetSoundOn(false);
                this.nextMode();
                break;
            }
            case 2: 
            case 3: {
                if (!Keys.key_fire) break;
                this.nextMode();
            }
        }
    }

    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.paintBackground(g);
                this.paintMenu(g);
                break;
            }
            case 4: {
                g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                g.setColor(0xFF0000);
                g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
                break;
            }
            case 1: {
                g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.paintSplash(g);
                Resources.paintControls(g, 0);
                this.sMusic = X.texts.getHashedString("MUSIC").toUpperCase();
                Fonts.drawStr(this.sMusic, (Defines.WIDTH - Fonts.strWidth(this.sMusic)) / 2, Defines.HEIGHT - Resources.STATUSBAR_STRING, g);
                break;
            }
            case 2: 
            case 3: {
                g.setColor(0);
                g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.paintBackground(g);
            }
        }
    }

    public void paintMenu(Graphics g) {
        int iPosX = 0;
        int iPosY = 0;
        int x = (Defines.WIDTH - Resources.iMenuButtonOffW * 8) / 2;
        int buttons = 7;
        int MENU_POS_Y = (Defines.HEIGHT - 7 * (Resources.iMenuButtonOffH + Resources.MENU_BUTTONS_OFFSET)) / 2;
        for (int i = 0; i < buttons; ++i) {
            if (i == this.iSelectedItem) {
                Resources.paintBorder(1, true, 8, x, MENU_POS_Y + i * (Resources.iMenuButtonOffH + Resources.MENU_BUTTONS_OFFSET), g);
            } else {
                Resources.paintBorder(1, false, 8, x, MENU_POS_Y + i * (Resources.iMenuButtonOffH + Resources.MENU_BUTTONS_OFFSET), g);
            }
            iPosY = MENU_POS_Y + i * (Resources.iMenuButtonOffH + Resources.MENU_BUTTONS_OFFSET) + (Resources.iMenuButtonOffH - Resources.iFont1H) / 2;
            iPosX = (Defines.WIDTH - Fonts.strWidth(this.menuStrings[i])) / 2;
            Fonts.drawStr(this.menuStrings[i], iPosX, iPosY, g, true);
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        this.iSelectedItem = Resources.whichLanguageButton(x, y);
        System.out.println("sel item: " + this.iSelectedItem);
        if (this.mode == 0 && this.iSelectedItem != -1) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
        }
    }

    public void pointerReleased(int x, int y) {
        System.out.println("pustame tlacitko");
        switch (this.mode) {
            case 1: {
                if (Resources.isInLeftButton(x, y)) {
                    Keys.key_fn1 = true;
                    this.keyPressed(Keys.iLeftKey);
                    Keys.key_fn1 = false;
                }
                if (!Resources.isInRightButton(x, y)) break;
                Keys.key_fn2 = true;
                this.keyPressed(Keys.iRightKey);
                Keys.key_fn2 = false;
                break;
            }
            case 2: 
            case 3: {
                Keys.key_fire = true;
                this.keyPressed(8);
                Keys.key_fire = false;
            }
        }
    }
}

