/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.BmpFont;
import main.Common;
import main.Defines;
import main.FontDef;
import main.MainCanvas;

public class Fonts {
    static Font font = null;
    static Font fontLarge = null;
    static Font fontMedium = null;
    static Font fontSmall = null;
    static BmpFont fontGraphic = null;
    static int iFontHeight;
    static boolean bUseGraphicFont;

    static final void initFont() {
        fontLarge = Font.getFont((int)0, (int)0, (int)16);
        fontMedium = Font.getFont((int)0, (int)0, (int)0);
        fontSmall = Font.getFont((int)0, (int)0, (int)8);
        if (!Defines.bSystemFont) {
            Image imgFont = Common.createImage("/fnt.png");
            if (MainCanvas.iFontSizeIndex == 0) {
                fontGraphic = new BmpFont(imgFont, FontDef.caFontChar, FontDef.iaFontCharXPosSmall, FontDef.iaFontCharWidthSmall, 1, false);
            }
            if (MainCanvas.iFontSizeIndex == 1) {
                fontGraphic = new BmpFont(imgFont, FontDef.caFontChar, FontDef.iaFontCharXPos0, FontDef.iaFontCharWidth0, 1, false);
            }
            if (MainCanvas.iFontSizeIndex == 2) {
                fontGraphic = new BmpFont(imgFont, FontDef.caFontChar, FontDef.iaFontCharXPos1, FontDef.iaFontCharWidth1, 0, false);
            }
            if (MainCanvas.iFontSizeIndex == 3) {
                fontGraphic = new BmpFont(imgFont, FontDef.caFontChar, FontDef.iaFontCharXPos2, FontDef.iaFontCharWidth2, 0, false);
            }
            if (MainCanvas.iFontSizeIndex == 4) {
                fontGraphic = new BmpFont(imgFont, FontDef.caFontChar, FontDef.iaFontCharXPos3, FontDef.iaFontCharWidth3, 0, false);
            }
            if (MainCanvas.iFontSizeIndex == 5) {
                fontGraphic = new BmpFont(imgFont, FontDef.caFontChar, FontDef.iaFontCharXPos4, FontDef.iaFontCharWidth4, 0, false);
            }
            Fonts.setFontSize(8);
        }
    }

    static final void useGraphicFont() {
        if (!Defines.bSystemFont) {
            bUseGraphicFont = true;
            iFontHeight = Fonts.fontGraphic.iHeight;
        } else {
            iFontHeight = font.getHeight();
        }
    }

    static final void setFontSize(int size) {
        bUseGraphicFont = false;
        switch (size) {
            case 8: {
                font = fontSmall;
                break;
            }
            case 0: {
                font = fontMedium;
                break;
            }
            case 16: {
                font = fontLarge;
            }
        }
        iFontHeight = font.getHeight();
    }

    public static final int strWidth(String str) {
        if (bUseGraphicFont) {
            return fontGraphic.GetTextWidth(str);
        }
        return font.stringWidth(str);
    }

    public static final int strWidth(String str, boolean graph) {
        if (graph) {
            return fontGraphic.GetTextWidth(str);
        }
        return font.stringWidth(str);
    }

    public static final void drawStr(String str, int posx, int posy, Graphics graphics) {
        if (!Defines.bSystemFont) {
            fontGraphic.DrawText(graphics, posx, posy, str);
            return;
        }
        graphics.setFont(font);
        graphics.setColor(255, 255, 255);
        graphics.drawString(str, posx, posy, 0);
    }

    public static final void drawStr(String str, int posx, int posy, Graphics graphics, boolean sysFont) {
        if (sysFont) {
            fontGraphic.DrawText(graphics, posx, posy, str);
            return;
        }
        graphics.setFont(font);
        graphics.setColor(255, 255, 255);
        graphics.drawString(str, posx, posy, 0);
    }

    static final void drawStr(Graphics graphics, int posx, int posy, String str) {
        Fonts.drawStr(str, posx, posy, graphics);
    }

    static final void drawCenterString(String s, int y, Graphics g, Canvas c) {
        int x = g.getClipX() + (g.getClipWidth() - Fonts.strWidth(s)) / 2;
        Fonts.drawStr(s, x, y, g);
    }

    static final void drawCenterString2(String s, int y, Graphics g, Canvas c) {
        int x = (g.getClipX() + c.getWidth() - Fonts.strWidth(s)) / 2;
        Fonts.drawStr(s, x, y, g);
    }

    static final void drawLeftString(String s, int y, Graphics g, Canvas c) {
        Fonts.drawStr(s, g.getClipX() + 3, y, g);
    }

    static final void drawLeftButton(String s, Graphics g, Canvas c) {
        Fonts.drawLeftString(s, Defines.HEIGHT - iFontHeight - 1, g, c);
    }

    static final void drawRightString(String s, int y, Graphics g, Canvas c) {
        int x = g.getClipX() + (g.getClipWidth() - Fonts.strWidth(s) - 3);
        Fonts.drawStr(s, x, y, g);
    }

    static final void drawRightButton(String s, Graphics g, Canvas c) {
        Fonts.drawRightString(s, Defines.HEIGHT - iFontHeight - 1, g, c);
    }
}

