/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.rms.RecordStore;
import main.Debug;
import main.MainCanvas;

public class Common {
    static final Random randGenerator = new Random();
    public static int iClipX;
    public static int iClipY;
    public static int iClipW;
    public static int iClipH;
    public static StringBuffer sbPath;

    static final int barValue(int value, int maxValue, int stretchVal) {
        return (value << 8 << 8) / (maxValue << 8) * (stretchVal << 8) >> 8 >> 8;
    }

    static final int getRandomInt(int max) {
        return randGenerator.nextInt() % max;
    }

    public static final int getRandomUInt(int max) {
        if (max == 1) {
            return 0;
        }
        return Math.abs(randGenerator.nextInt() % max);
    }

    static final byte getRandomByte(int max) {
        return (byte)Math.abs(Common.getRandomInt(max));
    }

    static final void saveClipState(Graphics g) {
        iClipX = g.getClipX();
        iClipY = g.getClipY();
        iClipW = g.getClipWidth();
        iClipH = g.getClipHeight();
    }

    static final void restoreClipState(Graphics g) {
        g.setClip(iClipX, iClipY, iClipW, iClipH);
    }

    static final Image createImage(String imageName) {
        sbPath.setLength(0);
        sbPath.append(MainCanvas.strPrefix).append(imageName);
        Image RetVal = null;
        try {
            RetVal = Image.createImage((String)sbPath.toString());
        }
        catch (Throwable t) {
            Debug.trace("Common.createImage(" + imageName + ") exception : " + t.getMessage());
        }
        System.gc();
        return RetVal;
    }

    static final Sprite createSprite(String fname, int slicesX, int slicesY) {
        Sprite RetVal = null;
        Image resImage = null;
        try {
            resImage = Common.createImage(fname);
            int sprWidth = resImage.getWidth() / slicesX;
            int sprHeight = resImage.getHeight() / slicesY;
            RetVal = new Sprite(resImage, sprWidth, sprHeight);
        }
        catch (Throwable t) {
            Debug.trace("Common.createSprite(" + fname + ", " + slicesX + ", " + slicesY + ") exception : " + t.getMessage());
            RetVal = null;
        }
        resImage = null;
        System.gc();
        return RetVal;
    }

    static final Sprite createSprite(Image resImage, int slicesX, int slicesY) {
        Sprite RetVal = null;
        try {
            int sprWidth = resImage.getWidth() / slicesX;
            int sprHeight = resImage.getHeight() / slicesY;
            RetVal = new Sprite(resImage, sprWidth, sprHeight);
        }
        catch (Throwable t) {
            RetVal = null;
        }
        return RetVal;
    }

    static final void deleteRecordStore(String rstoreName) {
        Debug.traceIn("> Common.deleteRecordStore(" + rstoreName + ")");
        try {
            RecordStore.deleteRecordStore((String)rstoreName);
        }
        catch (Exception e) {
            Debug.trace(e.getMessage());
        }
        Debug.traceOut("< Common.deleteRecordStore()");
    }

    static final boolean recordStoreExists(String rstoreName) {
        Debug.traceIn("> Common.recordStoreExists(" + rstoreName + ")");
        boolean bRetVal = true;
        try {
            RecordStore rsobj = RecordStore.openRecordStore((String)rstoreName, (boolean)false);
            rsobj.closeRecordStore();
        }
        catch (Exception e) {
            Debug.trace(e.getMessage());
            bRetVal = false;
        }
        Debug.traceOut("< Common.recordStoreExists() = " + bRetVal);
        return bRetVal;
    }

    static {
        sbPath = new StringBuffer();
    }
}

