/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import net.sf.zipme.Adler32;
import net.sf.zipme.DeflaterConstants;
import net.sf.zipme.DeflaterHuffman;
import net.sf.zipme.DeflaterPending;

class DeflaterEngine
implements DeflaterConstants {
    private static final int TOO_FAR = 4096;
    private int ins_h;
    private short[] head;
    private short[] prev;
    private int matchStart;
    private int matchLen;
    private boolean prevAvailable;
    private int blockStart;
    private int strstart;
    private int lookahead;
    private byte[] window;
    private int strategy;
    private int max_chain;
    private int max_lazy;
    private int niceLength;
    private int goodLength;
    private int comprFunc;
    private byte[] inputBuf;
    private long totalIn;
    private int inputOff;
    private int inputEnd;
    private DeflaterPending pending;
    private DeflaterHuffman huffman;
    private Adler32 adler;

    DeflaterEngine(DeflaterPending pending) {
        this.pending = pending;
        this.huffman = new DeflaterHuffman(pending);
        this.adler = new Adler32();
        this.window = new byte[65536];
        this.head = new short[32768];
        this.prev = new short[32768];
        this.strstart = 1;
        this.blockStart = 1;
    }

    public void reset() {
        int i2;
        this.huffman.reset();
        this.adler.reset();
        this.strstart = 1;
        this.blockStart = 1;
        this.lookahead = 0;
        this.totalIn = 0L;
        this.prevAvailable = false;
        this.matchLen = 2;
        for (i2 = 0; i2 < 32768; ++i2) {
            this.head[i2] = 0;
        }
        for (i2 = 0; i2 < 32768; ++i2) {
            this.prev[i2] = 0;
        }
    }

    public final void resetAdler() {
        this.adler.reset();
    }

    public final int getAdler() {
        int chksum = (int)this.adler.getValue();
        return chksum;
    }

    public final long getTotalIn() {
        return this.totalIn;
    }

    public final void setStrategy(int strat) {
        this.strategy = strat;
    }

    public void setLevel(int lvl) {
        this.goodLength = DeflaterConstants.GOOD_LENGTH[lvl];
        this.max_lazy = DeflaterConstants.MAX_LAZY[lvl];
        this.niceLength = DeflaterConstants.NICE_LENGTH[lvl];
        this.max_chain = DeflaterConstants.MAX_CHAIN[lvl];
        if (DeflaterConstants.COMPR_FUNC[lvl] != this.comprFunc) {
            switch (this.comprFunc) {
                case 0: {
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushStoredBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.updateHash();
                    break;
                }
                case 1: {
                    if (this.strstart <= this.blockStart) break;
                    this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                    this.blockStart = this.strstart;
                    break;
                }
                case 2: {
                    if (this.prevAvailable) {
                        this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                    }
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.prevAvailable = false;
                    this.matchLen = 2;
                }
            }
            this.comprFunc = DeflaterConstants.COMPR_FUNC[lvl];
        }
    }

    private void updateHash() {
        this.ins_h = this.window[this.strstart] << 5 ^ this.window[this.strstart + 1];
    }

    private int insertString() {
        short match;
        int hash = (this.ins_h << 5 ^ this.window[this.strstart + 2]) & Short.MAX_VALUE;
        this.prev[this.strstart & Short.MAX_VALUE] = match = this.head[hash];
        this.head[hash] = (short)this.strstart;
        this.ins_h = hash;
        return match & 0xFFFF;
    }

    private void slideWindow() {
        int m2;
        int i2;
        System.arraycopy(this.window, 32768, this.window, 0, 32768);
        this.matchStart -= 32768;
        this.strstart -= 32768;
        this.blockStart -= 32768;
        for (i2 = 0; i2 < 32768; ++i2) {
            m2 = this.head[i2] & 0xFFFF;
            this.head[i2] = m2 >= 32768 ? (short)(m2 - 32768) : (short)0;
        }
        for (i2 = 0; i2 < 32768; ++i2) {
            m2 = this.prev[i2] & 0xFFFF;
            this.prev[i2] = m2 >= 32768 ? (short)(m2 - 32768) : (short)0;
        }
    }

    private void fillWindow() {
        if (this.strstart >= 65274) {
            this.slideWindow();
        }
        while (this.lookahead < 262 && this.inputOff < this.inputEnd) {
            int more = 65536 - this.lookahead - this.strstart;
            if (more > this.inputEnd - this.inputOff) {
                more = this.inputEnd - this.inputOff;
            }
            System.arraycopy(this.inputBuf, this.inputOff, this.window, this.strstart + this.lookahead, more);
            this.adler.update(this.inputBuf, this.inputOff, more);
            this.inputOff += more;
            this.totalIn += (long)more;
            this.lookahead += more;
        }
        if (this.lookahead >= 3) {
            this.updateHash();
        }
    }

    private boolean findLongestMatch(int curMatch) {
        int chainLength = this.max_chain;
        int niceLength = this.niceLength;
        short[] prev = this.prev;
        int scan = this.strstart;
        int best_end = this.strstart + this.matchLen;
        int best_len = Math.max(this.matchLen, 2);
        int limit = Math.max(this.strstart - 32506, 0);
        int strend = scan + 258 - 1;
        byte scan_end1 = this.window[best_end - 1];
        byte scan_end = this.window[best_end];
        if (best_len >= this.goodLength) {
            chainLength >>= 2;
        }
        if (niceLength > this.lookahead) {
            niceLength = this.lookahead;
        }
        do {
            if (this.window[curMatch + best_len] != scan_end || this.window[curMatch + best_len - 1] != scan_end1 || this.window[curMatch] != this.window[scan] || this.window[curMatch + 1] != this.window[scan + 1]) continue;
            int match = curMatch + 2;
            scan += 2;
            while (this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && scan < strend) {
            }
            if (scan > best_end) {
                this.matchStart = curMatch;
                best_end = scan;
                best_len = scan - this.strstart;
                if (best_len >= niceLength) break;
                scan_end1 = this.window[best_end - 1];
                scan_end = this.window[best_end];
            }
            scan = this.strstart;
        } while ((curMatch = prev[curMatch & Short.MAX_VALUE] & 0xFFFF) > limit && --chainLength != 0);
        this.matchLen = Math.min(best_len, this.lookahead);
        return this.matchLen >= 3;
    }

    void setDictionary(byte[] buffer, int offset, int length) {
        this.adler.update(buffer, offset, length);
        if (length < 3) {
            return;
        }
        if (length > 32506) {
            offset += length - 32506;
            length = 32506;
        }
        System.arraycopy(buffer, offset, this.window, this.strstart, length);
        this.updateHash();
        --length;
        while (--length > 0) {
            this.insertString();
            ++this.strstart;
        }
        this.strstart += 2;
        this.blockStart = this.strstart;
    }

    private boolean deflateStored(boolean flush, boolean finish) {
        if (!flush && this.lookahead == 0) {
            return false;
        }
        this.strstart += this.lookahead;
        this.lookahead = 0;
        int storedLen = this.strstart - this.blockStart;
        if (storedLen >= DeflaterConstants.MAX_BLOCK_SIZE || this.blockStart < 32768 && storedLen >= 32506 || flush) {
            boolean lastBlock = finish;
            if (storedLen > DeflaterConstants.MAX_BLOCK_SIZE) {
                storedLen = DeflaterConstants.MAX_BLOCK_SIZE;
                lastBlock = false;
            }
            this.huffman.flushStoredBlock(this.window, this.blockStart, storedLen, lastBlock);
            this.blockStart += storedLen;
            return !lastBlock;
        }
        return true;
    }

    private boolean deflateFast(boolean flush, boolean finish) {
        if (this.lookahead < 262 && !flush) {
            return false;
        }
        while (this.lookahead >= 262 || flush) {
            int hashHead;
            if (this.lookahead == 0) {
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, finish);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart > 65274) {
                this.slideWindow();
            }
            if (this.lookahead >= 3 && (hashHead = this.insertString()) != 0 && this.strategy != 2 && this.strstart - hashHead <= 32506 && this.findLongestMatch(hashHead)) {
                boolean full = this.huffman.tallyDist(this.strstart - this.matchStart, this.matchLen);
                this.lookahead -= this.matchLen;
                if (this.matchLen <= this.max_lazy && this.lookahead >= 3) {
                    while (--this.matchLen > 0) {
                        ++this.strstart;
                        this.insertString();
                    }
                    ++this.strstart;
                } else {
                    this.strstart += this.matchLen;
                    if (this.lookahead >= 2) {
                        this.updateHash();
                    }
                }
                this.matchLen = 2;
                if (!full) {
                    continue;
                }
            } else {
                this.huffman.tallyLit(this.window[this.strstart] & 0xFF);
                ++this.strstart;
                --this.lookahead;
            }
            if (!this.huffman.isFull()) continue;
            boolean lastBlock = finish && this.lookahead == 0;
            this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, lastBlock);
            this.blockStart = this.strstart;
            return !lastBlock;
        }
        return true;
    }

    private boolean deflateSlow(boolean flush, boolean finish) {
        if (this.lookahead < 262 && !flush) {
            return false;
        }
        while (this.lookahead >= 262 || flush) {
            if (this.lookahead == 0) {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                }
                this.prevAvailable = false;
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, finish);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart >= 65274) {
                this.slideWindow();
            }
            int prevMatch = this.matchStart;
            int prevLen = this.matchLen;
            if (this.lookahead >= 3) {
                int hashHead = this.insertString();
                if (this.strategy != 2 && hashHead != 0 && this.strstart - hashHead <= 32506 && this.findLongestMatch(hashHead) && this.matchLen <= 5 && (this.strategy == 1 || this.matchLen == 3 && this.strstart - this.matchStart > 4096)) {
                    this.matchLen = 2;
                }
            }
            if (prevLen >= 3 && this.matchLen <= prevLen) {
                this.huffman.tallyDist(this.strstart - 1 - prevMatch, prevLen);
                prevLen -= 2;
                do {
                    ++this.strstart;
                    --this.lookahead;
                    if (this.lookahead < 3) continue;
                    this.insertString();
                } while (--prevLen > 0);
                ++this.strstart;
                --this.lookahead;
                this.prevAvailable = false;
                this.matchLen = 2;
            } else {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                }
                this.prevAvailable = true;
                ++this.strstart;
                --this.lookahead;
            }
            if (!this.huffman.isFull()) continue;
            int len = this.strstart - this.blockStart;
            if (this.prevAvailable) {
                --len;
            }
            boolean lastBlock = finish && this.lookahead == 0 && !this.prevAvailable;
            this.huffman.flushBlock(this.window, this.blockStart, len, lastBlock);
            this.blockStart += len;
            return !lastBlock;
        }
        return true;
    }

    public boolean deflate(boolean flush, boolean finish) {
        boolean progress;
        do {
            this.fillWindow();
            boolean canFlush = flush && this.inputOff == this.inputEnd;
            switch (this.comprFunc) {
                case 0: {
                    progress = this.deflateStored(canFlush, finish);
                    break;
                }
                case 1: {
                    progress = this.deflateFast(canFlush, finish);
                    break;
                }
                case 2: {
                    progress = this.deflateSlow(canFlush, finish);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        } while (this.pending.isFlushed() && progress);
        return progress;
    }

    public void setInput(byte[] buf, int off, int len) {
        if (this.inputOff < this.inputEnd) {
            throw new IllegalStateException("Old input was not completely processed");
        }
        int end = off + len;
        if (0 > off || off > end || end > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inputBuf = buf;
        this.inputOff = off;
        this.inputEnd = end;
    }

    public final boolean needsInput() {
        return this.inputEnd == this.inputOff;
    }
}

