/*
 * Decompiled with CFR 0.152.
 */
package com.movilenio.game;

import com.movilenio.game.GameSection;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Kernel
extends Canvas
implements Runnable {
    public static Kernel instance;
    public Thread thread;
    private boolean bExitApp;
    private MIDlet midlet;
    private boolean bStop;
    public boolean bPause;
    public boolean bVisible;
    public byte[] keyMap;
    public short keyStatus;
    public static final byte K_UP = 0;
    public static final byte K_DOWN = 1;
    public static final byte K_LEFT = 2;
    public static final byte K_RIGHT = 3;
    public static final byte K_A = 4;
    public static final byte K_B = 5;
    public static final byte K_C = 6;
    public static final byte K_D = 7;
    public static final byte K_CUP = 8;
    public static final byte K_CDOWN = 9;
    public static final byte K_CLEFT = 10;
    public static final byte K_CRIGHT = 11;
    public static final byte K_CFIRE = 12;
    public static final byte K_SK_LEFT = 13;
    public static final byte K_SK_RIGHT = 14;
    public static final byte K_OK = 13;
    public static final byte K_CANCEL = 14;
    public static final byte K_UP_LEFT = 15;
    public static final byte K_UP_RIGHT = 16;
    public static final byte K_DOWN_LEFT = 17;
    public static final byte K_DOWN_RIGHT = 18;
    public static final byte SND_LOOP = 1;
    public long frameTicks;
    public GameSection gameSection;
    private boolean gsResourcesLoaded;
    private Image backBuffer;
    private Graphics backBuffer_g;

    private Kernel(MIDlet midlet) {
        this.midlet = midlet;
        this.bExitApp = true;
        this.bStop = false;
        this.bPause = false;
        this.bVisible = true;
        this.keyStatus = 0;
        this.frameTicks = 66L;
        this.setFullScreenMode(true);
        this.keyMap = this.loadResource("/keymap.bin");
    }

    public static Kernel createInstance(MIDlet midlet) {
        instance = new Kernel(midlet);
        Display.getDisplay((MIDlet)midlet).setCurrent((Displayable)instance);
        Kernel.instance.thread = new Thread(instance);
        Kernel.instance.thread.start();
        return instance;
    }

    protected void paint(Graphics g) {
        if (this.bVisible && this.gameSection != null) {
            if (this.isDoubleBuffered()) {
                this.gameSection.paint(g);
            } else {
                if (this.backBuffer == null) {
                    this.backBuffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
                    this.backBuffer_g = this.backBuffer.getGraphics();
                }
                this.gameSection.paint(this.backBuffer_g);
                g.drawImage(this.backBuffer, 0, 0, 0);
            }
        }
    }

    public void run() {
        while (!this.bStop) {
            if (this.bVisible) {
                long tmr = System.currentTimeMillis();
                if (!this.bPause && this.gameSection != null) {
                    try {
                        this.gameSection.doFrame();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.repaint();
                this.serviceRepaints();
                tmr = System.currentTimeMillis() - tmr;
                if (tmr >= this.frameTicks) continue;
                try {
                    Thread.sleep(this.frameTicks - tmr);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.bPause = false;
        this.bStop = false;
        this.setGameSection(null);
        instance = null;
        if (this.bExitApp) {
            this.midlet.notifyDestroyed();
        }
    }

    public final synchronized void stop(boolean exitApp) {
        this.bExitApp = exitApp;
        this.bStop = true;
    }

    public final synchronized void stop() {
        this.stop(true);
    }

    public synchronized void setGameSection(GameSection gameSection) {
        if (this.gameSection != null) {
            this.gameSection.endSection();
            if (!this.gsResourcesLoaded) {
                this.gameSection.freeResources();
            }
            this.gameSection = null;
        }
        if (gameSection != null) {
            this.gsResourcesLoaded = gameSection.resourcesLoaded;
            if (!this.gsResourcesLoaded) {
                gameSection.loadResources();
            }
            if (gameSection.initSection()) {
                if (!this.bVisible) {
                    gameSection.show(false);
                }
                this.gameSection = gameSection;
            }
        }
    }

    protected void keyPressed(int keyCode) {
        boolean kOk = false;
        for (int i = 14; i >= 0; --i) {
            if (keyCode != this.keyMap[i]) continue;
            this.keyStatus = (short)(this.keyStatus | 1 << i);
            kOk = true;
            break;
        }
        if (!kOk) {
            if (keyCode == this.keyMap[15]) {
                this.keyStatus = (short)(this.keyStatus | 5);
            } else if (keyCode == this.keyMap[16]) {
                this.keyStatus = (short)(this.keyStatus | 9);
            } else if (keyCode == this.keyMap[17]) {
                this.keyStatus = (short)(this.keyStatus | 6);
            } else if (keyCode == this.keyMap[18]) {
                this.keyStatus = (short)(this.keyStatus | 0xA);
            }
        }
        if (this.bVisible && this.gameSection != null) {
            this.gameSection.keyPressed(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        boolean kOk = false;
        for (int i = 14; i >= 0; --i) {
            if (keyCode != this.keyMap[i]) continue;
            this.keyStatus = (short)(this.keyStatus & ~(1 << i));
            kOk = true;
            break;
        }
        if (!kOk) {
            if (keyCode == this.keyMap[15]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFFA);
            } else if (keyCode == this.keyMap[16]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF6);
            } else if (keyCode == this.keyMap[17]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF9);
            } else if (keyCode == this.keyMap[18]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF5);
            }
        }
        if (this.bVisible && this.gameSection != null) {
            this.gameSection.keyReleased(keyCode);
        }
    }

    public final boolean getKeyPressedStatus(int keyID) {
        return (this.keyStatus & 1 << keyID) != 0;
    }

    public final void setKeyPressedStatus(int keyID, boolean pressed) {
        this.keyStatus = pressed ? (short)(this.keyStatus | 1 << keyID) : (short)(this.keyStatus & ~(1 << keyID));
    }

    public synchronized void pause(boolean bPause) {
        this.bPause = bPause;
    }

    protected void hideNotify() {
        this.bVisible = false;
        this.bPause = true;
        if (this.gameSection != null) {
            this.gameSection.show(false);
        }
    }

    protected void showNotify() {
        this.bVisible = true;
        if (this.gameSection != null) {
            this.gameSection.show(true);
        } else {
            this.bPause = false;
        }
    }

    public Object openSound(String soundName, String type) {
        Player sound = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(soundName);
            if (is != null) {
                sound = Manager.createPlayer((InputStream)is, (String)type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sound;
    }

    public void closeSound(Object sound) {
        if (sound != null) {
            ((Player)sound).close();
        }
    }

    public void playSound(Object sound, int flags) {
        if (sound == null) {
            return;
        }
        try {
            if ((flags & 1) != 0) {
                ((Player)sound).setLoopCount(-1);
            }
            ((Player)sound).prefetch();
            ((Player)sound).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopSound(Object sound) {
        if (sound != null) {
            try {
                ((Player)sound).stop();
                ((Player)sound).deallocate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object openMusic(String musicName, String type) {
        return this.openSound(musicName, type);
    }

    public void closeMusic(Object music) {
        this.closeSound(music);
    }

    public void playMusic(Object music, int flags) {
        this.playSound(music, flags);
    }

    public void stopMusic(Object music) {
        this.stopSound(music);
    }

    public void playTone(int note, int duration, int volume) {
        try {
            Manager.playTone((int)note, (int)duration, (int)volume);
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void vibrate(int duration) {
        Display.getDisplay((MIDlet)this.midlet).vibrate(duration);
    }

    public static void writeInt(int value, byte[] b, int offset) {
        b[offset] = (byte)(value >>> 24);
        b[offset + 1] = (byte)(value >>> 16);
        b[offset + 2] = (byte)(value >>> 8);
        b[offset + 3] = (byte)value;
    }

    public static int readInt(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public static byte[][] loadRMS(String name, int offset) {
        Object data = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)false);
            int n = rs.getNumRecords();
            data = new byte[n][];
            for (int i = 0; i < n; ++i) {
                data[i] = rs.getRecord(i + 1);
            }
        }
        catch (Exception e) {
            System.out.println("Error: loadRMS()");
            e.printStackTrace();
        }
        return data;
    }

    public static void saveRMS(String name, byte[][] data, int offset) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
            for (int i = 0; i < data.length; ++i) {
                if (rs.getNumRecords() < i + 1) {
                    rs.addRecord(data[i], 0, data[i].length);
                    continue;
                }
                rs.setRecord(i + 1, data[i], 0, data[i].length);
            }
        }
        catch (Exception e) {
            System.out.println("Error: saveRMS()");
            e.printStackTrace();
        }
    }

    public static final void readStreamData(InputStream is, byte[] b, int offset, int length) throws IOException {
        while (length > 0) {
            int read = is.read(b, offset, length);
            offset += read;
            length -= read;
        }
    }

    public byte[] loadResource(String resourceName) {
        byte[] b = null;
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        if (is != null) {
            try {
                int bytesRead;
                byte[] buf = new byte[1024];
                while ((bytesRead = is.read(buf)) != -1) {
                    int bl = b != null ? b.length : 0;
                    byte[] aux = new byte[bl + bytesRead];
                    if (b != null) {
                        System.arraycopy(b, 0, aux, 0, b.length);
                    }
                    System.arraycopy(buf, 0, aux, bl, bytesRead);
                    b = aux;
                    if (bytesRead >= buf.length) continue;
                    break;
                }
                buf = null;
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    public Image loadImage(String imageName) {
        Image image = null;
        try {
            image = Image.createImage((String)imageName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }
}

