/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;

public class SegmentFactory {
    private static final long DESCRIPTOR_TYPE = 0x100000000000L;
    private static final long SEGMENT_TYPE = 0xF0000000000L;
    public static final Segment NULL_SEGMENT = new NullSegment();

    public static Segment createRealModeSegment(Memory memory, int n) {
        if (memory == null) {
            throw new NullPointerException("Null reference to memory");
        }
        return new RealModeSegment(memory, n);
    }

    public static Segment createDescriptorTableSegment(Memory memory, int n, int n2) {
        if (memory == null) {
            throw new NullPointerException("Null reference to memory");
        }
        return new DescriptorTableSegment(memory, n, n2);
    }

    public static Segment createProtectedModeSegment(Memory memory, int n, long l) {
        switch ((int)((l & 0x1F0000000000L) >>> 40)) {
            default: {
                System.out.println(Integer.toHexString(n) + "  " + Long.toString(l, 16));
                throw new IllegalStateException("Attempted To Construct Reserved Segment Type");
            }
            case 1: {
                return new TaskStateSegmentAvailable16Bit(memory, n, l);
            }
            case 2: {
                return new LDT(memory, n, l);
            }
            case 3: {
                return new TaskStateSegmentBusy16Bit(memory, n, l);
            }
            case 4: {
                return new CallGate16Bit(memory, n, l);
            }
            case 5: {
                return new TaskGate(memory, n, l);
            }
            case 6: {
                return new InterruptGate16Bit(memory, n, l);
            }
            case 7: {
                return new TrapGate16Bit(memory, n, l);
            }
            case 9: {
                return new Available32BitTSS(memory, n, l);
            }
            case 11: {
                return new Busy32BitTSS(memory, n, l);
            }
            case 12: {
                return new CallGate32Bit(memory, n, l);
            }
            case 14: {
                return new InterruptGate32Bit(memory, n, l);
            }
            case 15: {
                return new TrapGate32Bit(memory, n, l);
            }
            case 16: {
                return new ReadOnlyDataSegment(memory, n, l);
            }
            case 17: {
                throw new IllegalStateException("Unimplemented Data Segment: Read-Only, Accessed");
            }
            case 18: {
                return new ReadWriteDataSegment(memory, n, l);
            }
            case 19: {
                return new ReadWriteAccessedDataSegment(memory, n, l);
            }
            case 20: {
                throw new IllegalStateException("Unimplemented Data Segment: Read-Only, Expand-Down");
            }
            case 21: {
                throw new IllegalStateException("Unimplemented Data Segment: Read-Only, Expand-Down, Accessed");
            }
            case 22: {
                throw new IllegalStateException("Unimplemented Data Segment: Read/Write, Expand-Down");
            }
            case 23: {
                throw new IllegalStateException("Unimplemented Data Segment: Read/Write, Expand-Down, Accessed");
            }
            case 24: {
                throw new IllegalStateException("Unimplemented Code Segment: Execute-Only");
            }
            case 25: {
                throw new IllegalStateException("Unimplemented Code Segment: Execute-Only, Accessed");
            }
            case 26: {
                return new ExecuteReadCodeSegment(memory, n, l);
            }
            case 27: {
                return new ExecuteReadAccessedCodeSegment(memory, n, l);
            }
            case 28: {
                throw new IllegalStateException("Unimplemented Code Segment: Execute-Only, Conforming");
            }
            case 29: {
                return new ExecuteOnlyConformingAccessedCodeSegment(memory, n, l);
            }
            case 30: {
                return new ExecuteReadConformingCodeSegment(memory, n, l);
            }
            case 31: 
        }
        return new ExecuteReadConformingAccessedCodeSegment(memory, n, l);
    }

    static final class NullSegment
    extends DefaultSegment {
        public NullSegment() {
            super(null);
        }

        public int getType() {
            throw new ProcessorException(13, 0, true);
        }

        public int getSelector() {
            return 0;
        }

        public void checkAddress(int n) {
            throw new ProcessorException(13, 0, true);
        }

        public int translateAddressRead(int n) {
            throw new ProcessorException(13, 0, true);
        }

        public int translateAddressWrite(int n) {
            throw new ProcessorException(13, 0, true);
        }

        public void invalidateAddress(int n) {
            throw new ProcessorException(13, 0, true);
        }
    }

    static final class TaskStateSegmentBusy16Bit
    extends DefaultProtectedModeSegment {
        public TaskStateSegmentBusy16Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 3;
        }
    }

    static final class TaskStateSegmentAvailable16Bit
    extends DefaultProtectedModeSegment {
        public TaskStateSegmentAvailable16Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 1;
        }
    }

    public static final class CallGate16Bit
    extends GateSegment {
        private int parameterCount;

        public CallGate16Bit(Memory memory, int n, long l) {
            super(memory, n, l);
            this.parameterCount = (int)(l >> 32 & 0xFL);
        }

        public int getType() {
            return 4;
        }

        public final int getParameterCount() {
            return this.parameterCount;
        }
    }

    public static final class CallGate32Bit
    extends GateSegment {
        private int parameterCount;

        public CallGate32Bit(Memory memory, int n, long l) {
            super(memory, n, l);
            this.parameterCount = (int)(l >> 32 & 0xFL);
        }

        public int getType() {
            return 12;
        }

        public final int getParameterCount() {
            return this.parameterCount;
        }
    }

    static final class TrapGate16Bit
    extends GateSegment {
        public TrapGate16Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 7;
        }
    }

    static final class TrapGate32Bit
    extends GateSegment {
        public TrapGate32Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 15;
        }
    }

    static final class InterruptGate16Bit
    extends GateSegment {
        public InterruptGate16Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 6;
        }
    }

    static final class InterruptGate32Bit
    extends GateSegment {
        public InterruptGate32Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 14;
        }
    }

    static final class TaskGate
    extends GateSegment {
        public TaskGate(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public final int getTargetOffset() {
            throw new IllegalStateException();
        }

        public int getType() {
            return 5;
        }
    }

    public static class GateSegment
    extends ReadOnlyProtectedModeSegment {
        private int targetSegment;
        private int targetOffset;

        public GateSegment(Memory memory, int n, long l) {
            super(memory, n, l);
            this.targetSegment = (int)(l >> 16 & 0xFFFFL);
            this.targetOffset = (int)(l & 0xFFFFL | l >>> 32 & 0xFFFFFFFFFFFF0000L);
        }

        public int getTargetSegment() {
            return this.targetSegment;
        }

        public int getTargetOffset() {
            return this.targetOffset;
        }
    }

    static final class LDT
    extends ReadOnlyProtectedModeSegment {
        public LDT(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 2;
        }
    }

    static final class Busy32BitTSS
    extends ReadOnlyProtectedModeSegment {
        public Busy32BitTSS(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 11;
        }
    }

    static final class Available32BitTSS
    extends ReadOnlyProtectedModeSegment {
        public Available32BitTSS(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 9;
        }
    }

    static final class ExecuteReadConformingCodeSegment
    extends ReadOnlyProtectedModeSegment {
        public ExecuteReadConformingCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 30;
        }
    }

    static final class ExecuteReadConformingAccessedCodeSegment
    extends ReadOnlyProtectedModeSegment {
        public ExecuteReadConformingAccessedCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 31;
        }
    }

    static final class ExecuteOnlyConformingAccessedCodeSegment
    extends ReadOnlyProtectedModeSegment {
        public ExecuteOnlyConformingAccessedCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 29;
        }

        public byte getByte(int n) {
            throw new IllegalStateException();
        }

        public short getWord(int n) {
            throw new IllegalStateException();
        }

        public int getDoubleWord(int n) {
            throw new IllegalStateException();
        }

        public long getQuadWord(int n) {
            throw new IllegalStateException();
        }
    }

    static final class ExecuteReadCodeSegment
    extends ReadOnlyProtectedModeSegment {
        public ExecuteReadCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 26;
        }
    }

    static final class ExecuteReadAccessedCodeSegment
    extends ReadOnlyProtectedModeSegment {
        public ExecuteReadAccessedCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 27;
        }
    }

    static final class ReadWriteAccessedDataSegment
    extends DefaultProtectedModeSegment {
        public ReadWriteAccessedDataSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 19;
        }
    }

    static final class ReadWriteDataSegment
    extends DefaultProtectedModeSegment {
        public ReadWriteDataSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 18;
        }
    }

    static final class ReadOnlyDataSegment
    extends ReadOnlyProtectedModeSegment {
        public ReadOnlyDataSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public int getType() {
            return 16;
        }

        void writeAttempted() {
            throw new ProcessorException(13, 0, true);
        }
    }

    static abstract class ReadOnlyProtectedModeSegment
    extends DefaultProtectedModeSegment {
        public ReadOnlyProtectedModeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        void writeAttempted() {
            throw new IllegalStateException();
        }

        public void setByte(int n, byte by) {
            this.writeAttempted();
        }

        public void setWord(int n, short s) {
            this.writeAttempted();
        }

        public void setDoubleWord(int n, int n2) {
            this.writeAttempted();
        }

        public void setQuadWord(int n, long l) {
            this.writeAttempted();
        }
    }

    static abstract class DefaultProtectedModeSegment
    extends DefaultSegment {
        private boolean defaultSize;
        private boolean granularity;
        private boolean present;
        private int selector;
        private int limit;
        private int base;
        private int rpl;
        private int dpl;
        private long longLimit;
        private long descriptor;

        public DefaultProtectedModeSegment(Memory memory, int n, long l) {
            super(memory);
            this.selector = n;
            this.descriptor = l;
            this.granularity = (l & 0x80000000000000L) != 0L;
            this.limit = (int)(l & 0xFFFFL | l >>> 32 & 0xF0000L);
            if (this.granularity) {
                this.limit = this.limit << 12 | 0xFFF;
            }
            this.longLimit = 0xFFFFFFFFL & (long)this.limit;
            this.base = (int)(0xFFFFFFL & l >> 16 | l >> 32 & 0xFFFFFFFFFF000000L);
            this.rpl = n & 3;
            this.dpl = (int)(l >> 45 & 3L);
            this.defaultSize = (l & 0x40000000000000L) != 0L;
            this.present = (l & 0x800000000000L) != 0L;
        }

        public boolean isPresent() {
            return this.present;
        }

        public final int translateAddressRead(int n) {
            this.checkAddress(n);
            return this.base + n;
        }

        public final int translateAddressWrite(int n) {
            this.checkAddress(n);
            return this.base + n;
        }

        public final void checkAddress(int n) {
            if ((0xFFFFFFFFL & (long)n) > this.longLimit) {
                System.err.println("Segment limit exceeded: " + Integer.toHexString(n) + " > " + Integer.toHexString((int)this.longLimit));
                throw new ProcessorException(13, 0, true);
            }
        }

        public boolean getDefaultSizeFlag() {
            return this.defaultSize;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getBase() {
            return this.base;
        }

        public int getSelector() {
            return this.selector;
        }

        public int getRPL() {
            return this.rpl;
        }

        public int getDPL() {
            return this.dpl;
        }

        public void setRPL(int n) {
            this.rpl = n;
        }
    }

    static final class DescriptorTableSegment
    extends DefaultSegment {
        private int base;
        private long limit;

        public DescriptorTableSegment(Memory memory, int n, int n2) {
            super(memory);
            this.base = n;
            this.limit = 0xFFFFFFFFL & (long)n2;
        }

        public int getLimit() {
            return (int)this.limit;
        }

        public int getBase() {
            return this.base;
        }

        public int getSelector() {
            throw new IllegalStateException("No selector for a descriptor table segment");
        }

        public boolean setSelector(int n) {
            throw new IllegalStateException("Cannot set a selector for a descriptor table segment");
        }

        public void checkAddress(int n) {
            if ((0xFFFFFFFFL & (long)n) > this.limit) {
                throw new ProcessorException(13, n, true);
            }
        }

        public int translateAddressRead(int n) {
            return this.base + n;
        }

        public int translateAddressWrite(int n) {
            return this.base + n;
        }
    }

    static final class RealModeSegment
    extends DefaultSegment {
        private int selector;
        private int base;
        private int limit;

        public RealModeSegment(Memory memory, int n) {
            super(memory);
            this.selector = n;
            this.base = n << 4;
            this.limit = 65535;
        }

        public boolean getDefaultSizeFlag() {
            return false;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getBase() {
            return this.base;
        }

        public int getSelector() {
            return this.selector;
        }

        public boolean setSelector(int n) {
            this.selector = n;
            this.base = n << 4;
            return true;
        }

        public void checkAddress(int n) {
        }

        public int translateAddressRead(int n) {
            return this.base + n;
        }

        public int translateAddressWrite(int n) {
            return this.base + n;
        }

        public int getRPL() {
            return 0;
        }
    }

    static abstract class DefaultSegment
    implements Segment {
        Memory memory;

        public DefaultSegment(Memory memory) {
            this.memory = memory;
        }

        public void setAddressSpace(AddressSpace addressSpace) {
            this.memory = addressSpace;
        }

        public boolean isPresent() {
            return true;
        }

        public void invalidateAddress(int n) {
        }

        public int getType() {
            throw new IllegalStateException(this.getClass().toString());
        }

        public boolean getDefaultSizeFlag() {
            throw new IllegalStateException(this.getClass().toString());
        }

        public int getLimit() {
            throw new IllegalStateException(this.getClass().toString());
        }

        public int getBase() {
            throw new IllegalStateException(this.getClass().toString());
        }

        public int getSelector() {
            throw new IllegalStateException(this.getClass().toString());
        }

        public boolean setSelector(int n) {
            throw new IllegalStateException(this.getClass().toString());
        }

        public int getRPL() {
            throw new IllegalStateException(this.getClass().toString());
        }

        public void setRPL(int n) {
            throw new IllegalStateException(this.getClass().toString());
        }

        public int getDPL() {
            throw new IllegalStateException(this.getClass().toString());
        }

        public abstract void checkAddress(int var1);

        public abstract int translateAddressRead(int var1);

        public abstract int translateAddressWrite(int var1);

        public byte getByte(int n) {
            return this.memory.getByte(this.translateAddressRead(n));
        }

        public short getWord(int n) {
            return this.memory.getWord(this.translateAddressRead(n));
        }

        public int getDoubleWord(int n) {
            return this.memory.getDoubleWord(this.translateAddressRead(n));
        }

        public long getQuadWord(int n) {
            int n2 = this.translateAddressRead(n);
            long l = 0xFFFFFFFFL & (long)this.memory.getDoubleWord(n2);
            n2 = this.translateAddressRead(n + 4);
            return l |= (long)this.memory.getDoubleWord(n2) << 32;
        }

        public void setByte(int n, byte by) {
            this.memory.setByte(this.translateAddressWrite(n), by);
        }

        public void setWord(int n, short s) {
            this.memory.setWord(this.translateAddressWrite(n), s);
        }

        public void setDoubleWord(int n, int n2) {
            this.memory.setDoubleWord(this.translateAddressWrite(n), n2);
        }

        public void setQuadWord(int n, long l) {
            int n2 = this.translateAddressWrite(n);
            this.memory.setDoubleWord(n2, (int)l);
            n2 = this.translateAddressWrite(n + 4);
            this.memory.setDoubleWord(n2, (int)(l >>> 32));
        }
    }
}

