/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.codeblock.ByteSource;
import org.jpc.emulator.memory.codeblock.ByteSourceWrappedMemory;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.CombiningRealCodeBlock;
import org.jpc.emulator.memory.codeblock.InstructionSource;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.optimised.RealModeUDecoder;

public class CodeBlockCombiner {
    private CodeBlockFactory factory;
    private RealModeUDecoder decoder = new RealModeUDecoder();
    private ByteSourceWrappedMemory source = new ByteSourceWrappedMemory();
    private int depth;

    public CodeBlockCombiner(CodeBlockFactory codeBlockFactory) {
        this.factory = codeBlockFactory;
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(Memory memory, int n) {
        this.source.set(memory, n & 0xFFF);
        RealModeCodeBlock realModeCodeBlock = null;
        this.depth = 0;
        try {
            realModeCodeBlock = this.combineCodeBlocks(this.source);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return realModeCodeBlock;
    }

    private RealModeCodeBlock combineCodeBlocks(ByteSourceWrappedMemory byteSourceWrappedMemory) {
        RealModeCodeBlock realModeCodeBlock;
        RealModeCodeBlock realModeCodeBlock2;
        RealModeCodeBlock realModeCodeBlock3;
        int n;
        int n2 = byteSourceWrappedMemory.getOffset();
        InstructionSource instructionSource = this.decoder.decodeReal(byteSourceWrappedMemory);
        int[] nArray = new int[15];
        int n3 = 0;
        try {
            while (instructionSource.getNext()) {
                int n4 = instructionSource.getLength();
                for (n = 0; n < n4; ++n) {
                    if (n3 == nArray.length) {
                        int[] nArray2 = new int[nArray.length + 20];
                        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                        nArray = nArray2;
                    }
                    nArray[n3] = instructionSource.getMicrocode();
                    ++n3;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        byteSourceWrappedMemory.reset();
        n = n2 - byteSourceWrappedMemory.getOffset();
        byteSourceWrappedMemory.skip(n);
        try {
            realModeCodeBlock3 = this.factory.getRealModeCodeBlock(byteSourceWrappedMemory);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        if (n3 < 5) {
            return realModeCodeBlock3;
        }
        if (nArray[n3 - 3] != 8) {
            return realModeCodeBlock3;
        }
        int n5 = nArray[n3 - 1];
        int n6 = nArray[n3 - 2];
        if (n5 != 45 && n5 != 23 && n5 != 70 && n5 != 28) {
            return realModeCodeBlock3;
        }
        if (n6 + instructionSource.getLength() < 0) {
            return realModeCodeBlock3;
        }
        if (n6 > 255) {
            return realModeCodeBlock3;
        }
        try {
            ++this.depth;
            if (this.depth < 5) {
                realModeCodeBlock2 = this.combineCodeBlocks(byteSourceWrappedMemory);
                byteSourceWrappedMemory.reset();
                byteSourceWrappedMemory.skip(n + realModeCodeBlock3.getX86Length() + n6);
                realModeCodeBlock = this.combineCodeBlocks(byteSourceWrappedMemory);
            } else {
                realModeCodeBlock2 = this.factory.getRealModeCodeBlock(byteSourceWrappedMemory);
                byteSourceWrappedMemory.reset();
                byteSourceWrappedMemory.skip(n + realModeCodeBlock3.getX86Length() + n6);
                realModeCodeBlock = this.factory.getRealModeCodeBlock(byteSourceWrappedMemory);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return realModeCodeBlock3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return realModeCodeBlock3;
        }
        if (realModeCodeBlock2 == null || realModeCodeBlock == null) {
            return realModeCodeBlock3;
        }
        if (n2 + realModeCodeBlock3.getX86Length() + realModeCodeBlock2.getX86Length() > 4095 || n2 + realModeCodeBlock3.getX86Length() + n6 + realModeCodeBlock.getX86Length() > 4095) {
            return realModeCodeBlock3;
        }
        CombiningRealCodeBlock combiningRealCodeBlock = new CombiningRealCodeBlock(realModeCodeBlock3, realModeCodeBlock2, realModeCodeBlock, n2, n6);
        return combiningRealCodeBlock;
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlock(ByteSource byteSource, boolean bl) {
        return this.factory.getProtectedModeCodeBlock(byteSource, bl);
    }
}

