/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Vector;

public class Routines {
    String lowCase = "abcdefghijklmnopqrstuvwxyz";
    String upCase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String allCase = this.lowCase + this.upCase;

    String lowCase(String s) {
        for (int i = 0; i < this.lowCase.length(); ++i) {
            s = s.replace(this.upCase.charAt(i), this.lowCase.charAt(i));
        }
        return s;
    }

    boolean startsWith(String s, String subs) {
        try {
            int j = 0;
            for (int i = 0; i < subs.length(); ++i) {
                while (j < s.length() && this.allCase.indexOf(s.charAt(j)) == -1) {
                    ++j;
                }
                if (j >= s.length() || s.charAt(j) != subs.charAt(i)) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    StringBuffer readLine(DataInputStream dis) {
        StringBuffer sb = new StringBuffer();
        try {
            int ch = dis.read();
            if (ch == -1) {
                return null;
            }
            while (ch != 10 && ch != -1) {
                if (ch != 13) {
                    sb.append((char)(ch == 184 ? 235 : (ch >= 192 && ch <= 255 ? ch + 848 : ch)));
                }
                ch = dis.read();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return sb;
    }

    DataInputStream openFile(String name) {
        return new DataInputStream(this.getClass().getResourceAsStream(name));
    }

    String getAbbrDef(String abbr) {
        try {
            StringBuffer cur;
            DataInputStream dis = this.openFile("dict/abbrs.txt");
            while (!(cur = this.readLine(dis)).toString().equals(abbr) && cur != null) {
            }
            cur = this.readLine(dis);
            dis.close();
            if (cur != null) {
                return cur.toString();
            }
            return "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "\u041e\u0448\u0438\u0431\u043a\u0430";
        }
    }

    private Vector getIndexes(String s) {
        StringBuffer sb;
        int p1 = this.lowCase.indexOf(s.charAt(0)) + 1;
        int p2 = this.lowCase.indexOf(s.charAt(1)) + 1;
        int p = p1 * 100 + p2;
        Vector<Card> indexes = new Vector<Card>();
        DataInputStream dis = this.openFile("dict/index/" + p + ".txt");
        while ((sb = this.readLine(dis)) != null && !this.startsWith(sb.toString(), s)) {
        }
        while (sb != null && this.startsWith(sb.toString(), s) && indexes.size() < 20) {
            int pos = sb.toString().indexOf(124);
            int num = Integer.parseInt(sb.toString().substring(pos + 1));
            sb.delete(pos, sb.length());
            Card card = new Card();
            card.fileNum = num;
            card.word = sb.toString();
            indexes.addElement(card);
            sb = this.readLine(dis);
        }
        return indexes;
    }

    String getArticle(Card card) {
        StringBuffer sb;
        StringBuffer article = new StringBuffer();
        DataInputStream dis = this.openFile("dict/data/" + card.fileNum + ".txt");
        while ((sb = this.readLine(dis)) != null && !card.word.equals(sb.toString())) {
        }
        sb = new StringBuffer(" ");
        while (sb != null && !sb.toString().equals("\n")) {
            article.append((Object)sb);
            sb = this.readLine(dis);
            sb.append('\n');
        }
        return article.toString();
    }

    Vector getArticles(String word) {
        Vector v = this.getIndexes(word);
        for (int i = 0; i < v.size(); ++i) {
            ((Card)v.elementAt((int)i)).article = this.getArticle((Card)v.elementAt(i));
        }
        return v;
    }
}

