/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen;

import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.list.DefaultListModel;
import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionaryCache;
import com.wordsteps.ui.common.Constants;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.common.commands.BackCommand;
import com.wordsteps.ui.screen.DictionaryListScreenForm;
import com.wordsteps.ui.screen.LanguagePair;
import com.wordsteps.ui.screen.LanuagePairListCellRenderer;
import com.wordsteps.ui.screen.NullLanguagePair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CustomDictionaryListForm
extends DictionaryListScreenForm {
    private ComboBox lngFilter;
    private LanguagePair allLng = new NullLanguagePair();
    private LanguagePair selectedLngPair;
    private Hashtable lngPairToDict = new Hashtable();

    public CustomDictionaryListForm(Form form) {
        super(form);
        this.lngPairToDict.put(this.allLng, new Vector(10));
    }

    public String getName() {
        return "dictionaries.title";
    }

    protected void createComponents() {
        this.lngFilter = new ComboBox();
        this.lngFilter.getSelectedStyle().setBgColor(14608594);
        UIProfile.applyFont(this.lngFilter.getSelectedStyle(), "dictionaries.filter.font");
        UIProfile.applyFont(this.lngFilter.getUnselectedStyle(), "dictionaries.filter.font");
        this.lngFilter.setListCellRenderer(new LanuagePairListCellRenderer());
        this.lngFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LanguagePair pair = (LanguagePair)((ComboBox)ae.getSource()).getSelectedItem();
                CustomDictionaryListForm.this.setLanguageFilter(pair);
            }
        });
        this.lngFilter.addFocusListener(new FocusListener(){

            public void focusGained(Component cmp) {
                CustomDictionaryListForm.this.removeAllCommands();
                CustomDictionaryListForm.this.addCommand(new BackCommand(CustomDictionaryListForm.this.getPreviousScreenForm()), 0);
                CustomDictionaryListForm.this.addCommand(Constants.NULL_COMMAND_0, 1);
            }

            public void focusLost(Component cmp) {
                CustomDictionaryListForm.this.updateCommands();
            }
        });
        Container filterContainer = new Container(new BorderLayout());
        TransparentLabel filterLabel = new TransparentLabel("dictionaries.filter");
        UIProfile.applyFont(filterLabel.getStyle(), "dictionaries.filter.font");
        filterContainer.addComponent("West", (Component)filterLabel);
        filterContainer.addComponent("Center", (Component)this.lngFilter);
        this.addComponent(filterContainer);
    }

    private LanguagePair[] getLanguageFilterModel() {
        LanguagePair[] pairs = new LanguagePair[this.lngPairToDict.size()];
        Enumeration e = this.lngPairToDict.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            pairs[i++] = (LanguagePair)e.nextElement();
        }
        return pairs;
    }

    public void initState() {
        DictionaryCache cache = DictionaryCache.getInstance();
        int dicsCount = cache.getDictionariesCount();
        if (dicsCount > this.allLng.count()) {
            this.allLng.setCount(dicsCount);
            this.groupDictionariesByLng(cache.getDictionaries());
            this.updateLanguageFilterModel();
            this.setLanguageFilter(this.allLng);
        }
        super.initState();
        this.updateCommands();
    }

    public void setDictionaries(Dictionary[] dictionaries) {
    }

    private void setLanguageFilter(LanguagePair pair) {
        this.selectedLngPair = pair;
        this.lngFilter.setSelectedItem(this.selectedLngPair);
        this.updateModel(this.selectedLngPair);
    }

    private void updateModel(LanguagePair pair) {
        this.dictionaryList.setModel(new DefaultListModel((Vector)this.lngPairToDict.get(pair)));
        this.repaint();
    }

    private void updateLanguageFilterModel() {
        this.lngFilter.setModel(new DefaultListModel(this.getLanguageFilterModel()));
    }

    private final void groupDictionariesByLng(Dictionary[] d) {
        Vector allDics = (Vector)this.lngPairToDict.get(this.allLng);
        for (int i = 0; i < d.length; ++i) {
            Vector dics;
            Dictionary dic = d[i];
            LanguagePair dictLngPair = this.getDictionaryLanguagePair(dic);
            boolean isFound = false;
            Enumeration e = this.lngPairToDict.keys();
            while (e.hasMoreElements()) {
                LanguagePair lngPair = (LanguagePair)e.nextElement();
                if (!lngPair.equals(dictLngPair)) continue;
                dics = (Vector)this.lngPairToDict.get(dictLngPair);
                if (!dics.contains(dic)) {
                    dics.addElement(dic);
                    lngPair.countPlus();
                    allDics.addElement(dic);
                }
                isFound = true;
                break;
            }
            if (!isFound) {
                dics = new Vector(5);
                dics.addElement(dic);
                dictLngPair.countPlus();
                this.lngPairToDict.put(dictLngPair, dics);
                allDics.addElement(dic);
            }
            this.allLng.setCount(allDics.size());
            this.lngPairToDict.put(this.allLng, allDics);
        }
    }

    public void dictionaryDeleted(Dictionary dic) {
        LanguagePair dictLngPair = this.getDictionaryLanguagePair(dic);
        Vector dics = (Vector)this.lngPairToDict.remove(dictLngPair);
        dics.removeElement(dic);
        this.allLng.countMinus();
        ((Vector)this.lngPairToDict.get(this.allLng)).removeElement(dic);
        if (dics.size() == 0) {
            this.updateLanguageFilterModel();
            this.setLanguageFilter(this.allLng);
        } else {
            dictLngPair.setCount(dics.size());
            this.lngPairToDict.put(dictLngPair, dics);
            this.updateLanguageFilterModel();
            this.setLanguageFilter(this.selectedLngPair);
        }
        this.updateCommands();
    }

    private LanguagePair getDictionaryLanguagePair(Dictionary dic) {
        return new LanguagePair(dic.getInfo().getSourceLanguage(), dic.getInfo().getTargetLanguage());
    }
}

